/***************************************************************
 File:	Dut_Managment.c
 Module:	Dut
 Purpose: 	A short description of the class purpose.
 Description: A detailed description of the class, its attributes and whatever 
	             information the user & maintainer might find 
 	             valuable.
***************************************************************/
//---------------------------------------------------------------------------------
//						Includes									
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "stringLibApi.h"
#include "queue_utility.h"
#include "init_ifmsg.h"
#include "mhi_dut.h"
#include "Dut.h"
#include "Dut_Api.h"
#include "shram_man_msgs.h"
#include "bss_manage_task.h"
//#include "mt_eeprom.h"
#include "mib_ms.h"
#include "shram_man_msgs.h"
#include "loggerAPI.h"
#include "PhyDriver_API.h"
#include "CalibrationDefs.h"
#include "CalibrationManager.h"
#include "Hdk_Api.h"
#include "Utils_Api.h"
#include "ErrorHandler_Api.h"
#include "CoC_Api.h"
#include "VapDatabase_Api.h"
#include "TpcClbrHndlr.h"
#include "CalibrationManager.h"
#include "Hdk_Api.h"
#include "RficDriver_API.h"
#include "mhi_hdk.h"
#include "PSD.h"
#include "RssiPathClbrHndlr.h"

#define LOG_LOCAL_GID   GLOBAL_GID_DUT
#define LOG_LOCAL_FID 2

// Allows Special Compilation for Dut
//---------------------------------------------------------------------------------
//						Defines									
//---------------------------------------------------------------------------------
#define DUT_TBTT_INDICATION_ADVANTAGE	1000
#define DUT_BEACON_INTERVAL				976    /* about 1s which */

#define DUT_AUTO_SELECT_CALIBRATION_MASK	0xFFFF
#define DUT_DEFAULT_OFFLINE_CALIBRATION_MASK (SUPPORTED_OFFLINE_CALIBRATION_MASK & ~CLBR_PROC_BIT_TPC)
#define DUT_DEFAULT_ONLINE_CALIBRATION_MASK	(SUPPORTED_ONLINE_CALIBRATION_MASK)
#define DUT_GET_FUNC                    0
#define DUT_SET_FUNC                    1

//---------------------------------------------------------------------------------
//						Data Type Definition									
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition									
//---------------------------------------------------------------------------------
 
//---------------------------------------------------------------------------------
//						Static Function Declaration									
//---------------------------------------------;------------------------------------
static bool DUT_StartCalibration(IN dutStartCalibrationParams_t *calibrationParams_p);
void dutSetTxPower(dutPowerOutVecParams_t *dutPowerOutVecParams_p, bool validForAllParams);
void dutSetRate(dutSetRate_t *dutSetRate_p);
void dutReadChipVersion(dutChipVersion_t* dutChipVersion_p);
void dutGetInfo(dutGetFwInfo_t *dutGetFwInfo_p);
void dutHandleRiscModeReq(riscModeParams_t *riscModeParams_p);
#ifdef ENET_INC_ARCH_WAVE600
void dutGetRateReq(OUT dutGetRate_t *dutGetRate_p);
#endif

//---------------------------------------------------------------------------------
//						Static Variables									
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Debug Section									
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Functions Definitions									
//---------------------------------------------------------------------------------
void DutMngmnt_Dispatcher(dutMessage_t *dutMessage)
{
	uint8 returnMessage = TRUE; // Flag which indicates whether we send the message to driver immediately or wait for a response from other SW modules before sending it to the driver

	dutMessage->status = DUT_STATUS_PASS;

	switch (dutMessage->msgId)
	{	
	case DUT_READ_MEMORY_REQ:
		dutHwAccessReadMemory(((dutMemoryAccessParams_t *)dutMessage->data));
		break;
	case DUT_WRITE_MEMORY_REQ:
		dutHwAccessWriteMemory((dutMemoryAccessParams_t *)dutMessage->data);
		break;
	
	case DUT_READ_GENRISC_VERSION_REQ:
		dutHwAccessReadRiscVersion((PhyVersion_t *)dutMessage->data);
//==========================XTAL====================================
	case DUT_TX_TONE_REQ:
		dutHwAccessTransmitTone((dutTxToneParams_t *)dutMessage->data);
		break;
	case DUT_GET_XTAL_VALUE_REQ:
		dutHwAccessGetXtalValue((dutXtalParams_t *)dutMessage->data);
		break;
	case DUT_SET_XTAL_VALUE_REQ:
		dutHwAccessSetXtalValue((dutXtalParams_t *)dutMessage->data);
		break;
		
	case DUT_START_CALIBRATION_REQ:
		returnMessage = DUT_StartCalibration((dutStartCalibrationParams_t *)dutMessage->data);
		break;	
	case DUT_GET_RX_EVM_REQ:
		dutHwAccessGetRxEvm((dutGetRxEvm_t *)dutMessage->data);
		break;	
//************ TX  

//==========================RX====================================


	case DUT_START_RSSI_CALIBRATION_REQ:
		PhyCalDrv_bypassForRssiCalibration();
		break;
	case DUT_END_RSSI_CALIBRATION_REQ:
		PhyCalDrv_RestoreOperationalRx();
		break;
		
	//-1-&&&&  Mid Gain  -2-&&&&& Mid Gain Step 
	case DUT_SET_RSSI_GAIN_BLOCK_REQ:
		{
			RssiGainBlock_t *rssiGainBlock_p = (RssiGainBlock_t *)dutMessage->data; 	
#ifdef DUT_LOGS_ON
			SLOG0(0, 0, RssiGainBlock_t, rssiGainBlock_p);
#endif
			SetRxGainsForRssi((AntennaBitmaps_e)(rssiGainBlock_p->antMask), (HdkLnaIndex_e)(rssiGainBlock_p->lnaIndex), rssiGainBlock_p->pgc1, rssiGainBlock_p->pgc2, rssiGainBlock_p->pgc3);
		}
		break;
	case DUT_SET_LNA_MID_GAIN_REQ:
		{
#if (!defined ENET_INC_HW_FPGA)
			dutLnaMidGain_t *dutLnaMidGainValues_p = (dutLnaMidGain_t *)dutMessage->data;
						
#ifdef DUT_LOGS_ON
			SLOG0(0, 0, dutLnaMidGain_t, dutLnaMidGainValues_p);
#endif
			RssiPath_setLnaMidGain(dutLnaMidGainValues_p->lnaMidGainValue);
#endif
		}
		break;

	case DUT_GET_CW_POWER_REQ:
		{
			RssiCwPower_t *rssiCwPower_p = (RssiCwPower_t *)dutMessage->data;
			Measure_AdcPower(rssiCwPower_p->corrResults, rssiCwPower_p->antMask, rssiCwPower_p->NOS);
#ifdef DUT_LOGS_ON
			SLOG0(0, 0, RssiCwPower_t, rssiCwPower_p);
#endif
		}
		break;
		
	//-3-&&&& S2D
	
	case DUT_SET_RSSI_S2D_GAIN_AND_OFFSET_REQ:
		{
			//PHYTBD: open after merge with CDB and API lignment
#if (!defined ENET_INC_HW_FPGA)
			S2dParams_t *s2dParams_p = (S2dParams_t *)dutMessage->data;
#ifdef DUT_LOGS_ON
			SLOG0(0, 0, S2dParams_t, s2dParams_p);
#endif
			setS2dGainAndOffset(s2dParams_p->iOffset, s2dParams_p->gain, (uint32)(s2dParams_p->antMask), s2dParams_p->regionIndex);
#endif
		}
		break;
		
	case DUT_GET_AUX_ADC_RSSI_REQ:		
		{
#if (!defined ENET_INC_HW_FPGA)
			DutRssiOffsetGain_t *dutRssiOffsetGain_p = (DutRssiOffsetGain_t *)dutMessage->data; 			
			RssiPath_measureRssi(dutRssiOffsetGain_p->NOS, dutRssiOffsetGain_p->rssiResult,dutRssiOffsetGain_p->antMask);
#ifdef DUT_LOGS_ON
			SLOG0(0, 0, DutRssiOffsetGain_t, dutRssiOffsetGain_p);
#endif
#endif
		}
		break;
//=================================================================
	case DUT_GET_TX_POWER_FEEDBACK_REQ:
		returnMessage = FALSE; // Don't set the message ID to CFM - Wait for the Feed-Back module to send the CFM
		dutHwAccessGetTxPowerFeedbackReq((dutTpcFeedbackparams_t *)dutMessage->data);
		break;
	case DUT_GET_RX_GAINS_REQ:
		dutHwAccessGetRxGains((dutRficRxGainsParams_t *)dutMessage->data);
		break;
	case DUT_GET_LNA_PARAMS_REQ:
		dutHwAccessGetLnaParams((dutLnaParam_t *)dutMessage->data);
		break;
	case DUT_SET_LNA_PARAMS_REQ:
		dutHwAccessSetLnaParams((dutLnaParam_t *)dutMessage->data);
		break;
	case DUT_SET_S2D_GAIN_AND_OFFSET_REQ:
		TPC_configureS2DGainAndOffset((tpcS2dParams_t *)dutMessage->data);
		break;
	case DUT_GET_RSSI_DB_REQ:
#if (!defined ENET_INC_ARCH_WAVE600 && !defined ENET_INC_HW_FPGA)	
		RssiPath_getDB((RssiDBPower_t *)dutMessage->data);
#endif
		break;
	case DUT_GET_CLIPPING_REQ:
		{
#if !defined ENET_INC_ARCH_WAVE600
		Clipping_trigger_t *clipping_p = (Clipping_trigger_t *)dutMessage->data;
		
		PhyCalDrv_Write_Register_Clipping((uint32)clipping_p->clipping_trigger);

#else// WAVE600 - we dont have clipping option in GEN6 
		ASSERT(0);
#endif
		}
		break;
	case DUT_SET_RISC_MODE_REQ:				
		dutHandleRiscModeReq((riscModeParams_t *)dutMessage->data);
		break;
	case DUT_SHIFT_POWER_OUT_VECTOR_REQ:
		{
		dutPowerOutVecParams_t *dutPowerOutVecParams_p = (dutPowerOutVecParams_t *)dutMessage->data;
		TPC_shiftPowerOutVector(dutPowerOutVecParams_p->ant, dutPowerOutVecParams_p->bandwidth, dutPowerOutVecParams_p->powerVectorIndex, dutPowerOutVecParams_p->powerVectorWord);
		}
		break;						
	case DUT_SET_RX_BAND_REQ:
		{
			dutSetRxBand_t *dutsetRxBand_p = (dutSetRxBand_t *)dutMessage->data;
			RficDriver_SetRxBand(dutsetRxBand_p->rxBand);
		}
		break;
	case DUT_SET_RX_BAND_LUT_REQ:
		{
			dutSetRxBandLUT_t *dutsetRxBandLUT_p = (dutSetRxBandLUT_t *)dutMessage->data;
			RficDriver_SetRxBandLUT(dutsetRxBandLUT_p->rxBandLUT[0]);
		}
		break;

	case DUT_GET_RSSI_REQ:
		dutHwAccessGetRssi((dutRssiParams_t *)dutMessage->data);
		break;

	case DUT_READ_PACKET_COUNTERS_REQ:
		dutHwAccessReadPacketsCounters((packetCountersParams_t *)dutMessage->data);
		break;
/************************************/

	case DUT_SET_RX_COUNTER_REQ:
		DUT_setRxCount((dutRxCount *)dutMessage->data);
		break;
	case DUT_GET_RX_COUNTER_REQ:
		returnMessage = FALSE;
		DUT_getRxCountReq();		
		break;
	case DUT_READ_CHIP_VERSION_REQ: 
		dutReadChipVersion((dutChipVersion_t *)dutMessage->data);
		break;
	case DUT_ENABLE_TX_ANTENNA_REQ:
		returnMessage = FALSE;
		dutHwAccessEnableTxAntenna((dutSetAntennaParams_t *)dutMessage->data);
		break;
	case DUT_ENABLE_RX_ANTENNA_REQ:
		dutHwAccessEnableRxAntenna((dutSetAntennaParams_t *)dutMessage->data);
		break;	
	case DUT_TX_SPACELESS_REQ:
		dutHwAccessSetSpacelessTransmission((dutTxSpacelessParams_t *)dutMessage->data);
		break;
	case DUT_SET_SCRAMBLER_MODE_REQ:
		dutHwAccessSetScramblerMode((dutScramblerParams_t *)dutMessage->data);
		break;
	case DUT_SET_IFS_REQ:
		returnMessage = FALSE; // Don't send CFM - Wait for the Feed-Back module to send the CFM
		dutSetIfsValue((dutIfsParams_t *)dutMessage->data);
		break;
	case DUT_SET_DEFAULT_ANTENNA_SET_REQ:
		dutHwAccessSetDefaultAntenaSet((antSelectionParams_t *)dutMessage->data);
		break;		
	case DUT_SET_POWER_OUT_VEC_REQ:
		returnMessage = FALSE;
		dutSetTxPower((dutPowerOutVecParams_t *)dutMessage->data, FALSE);
		break;
	case DUT_GET_POWER_OUT_VEC_REQ:
		{
		dutPowerOutVecParams_t *dutPowerOutVecParams_p = (dutPowerOutVecParams_t *)dutMessage->data;
#ifdef DUT_LOGS_ON
		SLOG0(0, 0, dutPowerOutVecParams_t, dutPowerOutVecParams_p);
#endif
		dutPowerOutVecParams_p->powerVectorWord	= TPC_getPowerIndexValue(dutPowerOutVecParams_p->powerVectorIndex, (Antenna_e)dutPowerOutVecParams_p->ant, (Bandwidth_e)dutPowerOutVecParams_p->bandwidth);
		}
		break;
	//-------- General -------------//	
	case DUT_SET_RATE_REQ:
		returnMessage = FALSE;
		dutSetRate((dutSetRate_t *)dutMessage->data);
		break;		
	case DUT_GET_FW_INFO_REQ:
		dutGetInfo((dutGetFwInfo_t *)dutMessage->data);
		break;					
	case DUT_SET_POWER_AND_PACKET_LENGTH_REQ:
		returnMessage = FALSE;
		dutSetPowerAndLength((dutPowerAndPacketLength_t *)dutMessage->data);
		break;	
	case DUT_GET_TX_GAINS_REQ:		
		dutReadRfGainsFromPhy((dutRficTxGainsParams_t *)dutMessage->data);
		break;
	case DUT_GET_RATE_REQ:
#ifdef ENET_INC_ARCH_WAVE600
		returnMessage = FALSE;
		dutGetRateReq((dutGetRate_t *)dutMessage->data);
#endif
		break;
	 case DUT_GET_POUT_TABLE_OFFSET_REQ:
	 	dutHwAccessTPCtableOffset((dutPoutTableOffsetParams_t*)dutMessage->data,(uint8)DUT_GET_FUNC);	 	
	 	break;
     case DUT_SET_POUT_TABLE_OFFSET_REQ:	 	
	 	dutHwAccessTPCtableOffset((dutPoutTableOffsetParams_t*)dutMessage->data,(uint8)DUT_SET_FUNC);	 	
	 	break;
	case DUT_ENABLE_RX_AGGREGATE_REQ:
		dutHwAccessRxEnableAggregate((dutRxEnableAggregate_t*)dutMessage->data);	 	
	 	break;
	case DUT_SET_TX_BAND_REQ:
	{
		dutSetTxBand_t *dutsetTxBand_p = (dutSetTxBand_t *)dutMessage->data;
		RficDriver_SetTxBand(dutsetTxBand_p->txBand);
	}
		break;
	case DUT_SET_TX_BAND_LUT_REQ:
	{
		dutSetTxBandLUT_t *dutsetTxBandLUT_p = (dutSetTxBandLUT_t *)dutMessage->data;
		RficDriver_SetTxBandLUT(dutsetTxBandLUT_p->txBandLUT[0]);
	}
		break;	
	case DUT_GET_BBIC_CDD_REQ:
	{
		dutGetBbicCdd_t * dutGetBbicCdd_p = (dutGetBbicCdd_t *) dutMessage->data;
		PhyCalDrv_GetBbicCdd(dutGetBbicCdd_p);
	}
		break;
	case DUT_SET_BBIC_CDD_REQ:
	{
		dutSetBbicCdd_t * dutSetBbicCdd_p = (dutSetBbicCdd_t *) dutMessage->data;
		PhyCalDrv_SetBbicCdd(dutSetBbicCdd_p);
	}
		break;
	default:
		DEBUG_ASSERT(0);
		return;
	}
	SET_MSG_ID_TO_CFM(dutMessage->msgId);
	if(returnMessage == TRUE)
	{
		Dut_MsgCallBack(PNULL);
	}
}

//---------------------------------------------------------------------------------
//						Static Functions Definitions									
//---------------------------------------------------------------------------------

void dutSetPowerAndLength(dutPowerAndPacketLength_t *dutPowerAndPacketLength_p)
{
	dutDB_t *dutDb_p = Dut_getDB();
	trafficParams_t *dutTrafficParams_p = &(dutDb_p->m_DutTrafficParams);
	dutPowerOutVecParams_t dutPowerOutVecParams;

	dutTrafficParams_p->packetLength = dutPowerAndPacketLength_p->packetLength;
	if (dutTrafficParams_p->trafficState == DUT_TX_STATE_TRANSMITTING)
	{
		dutDb_p->m_DutTrafficParams.modifyParamsOnTheFly = TRUE;
	}
	dutPowerOutVecParams.ant = ANTENNA_0;
	dutPowerOutVecParams.bandwidth = BANDWIDTH_TWENTY;
	dutPowerOutVecParams.powerVectorIndex = dutPowerAndPacketLength_p->txPower;
	dutPowerOutVecParams.powerVectorWord = dutPowerAndPacketLength_p->txPower;
	dutSetTxPower(&dutPowerOutVecParams, TRUE);
}

/*********************************************************************************
Method:			dutSetCalibrationMask
Description:  
Parameter:    	dutCalibrationType_e calibrationType, dutCalibrationMaskType_e maskType, uint32 mask
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutSetCalibrationMask(dutCalibrationType_e calibrationType, dutCalibrationMaskType_e maskType, uint32 mask)
{
#if !defined HDK_INTERMEDIATE_UNTIL_API_MERGE
	clbrHndlrResetConf_t calResetConf;
	UNUSED_PARAM(calibrationType);
	if (maskType == DUT_CALIBRATION_MASK_TYPE_DEFAULT)
	{
		// If calibration mask value is 0xFFFF use the default calibration mask
		calResetConf.offlineCalMask = 	DUT_DEFAULT_OFFLINE_CALIBRATION_MASK;
		calResetConf.onlineCalMask = 	DUT_DEFAULT_ONLINE_CALIBRATION_MASK;
	}
	else // DUT_CALIBRATION_MASK_TYPE_CONFIGURABLE
	{
		calResetConf.offlineCalMask = 	mask & SUPPORTED_OFFLINE_CALIBRATION_MASK;
		calResetConf.onlineCalMask = 	mask & SUPPORTED_ONLINE_CALIBRATION_MASK;
	}
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, clbrHndlrResetConf_t, &calResetConf);
#endif	
	ClbrMngr_Reset(&calResetConf);//PHYTBD: open after merge with CDB and API lignment
#else
	UNUSED_PARAM(calibrationType);	
	UNUSED_PARAM(maskType);	
	UNUSED_PARAM(mask);	
#endif
}

/*********************************************************************************
Method:			DUT_StartCalibration
Description:  
Parameter:    	IN dutStartCalibrationParams_t * calibrationParams_p
Returns:      	bool True = send Confirm to Host
Remarks:		None
*********************************************************************************/
static bool DUT_StartCalibration(IN dutStartCalibrationParams_t *calibrationParams_p)
{
	dutDB_t *dutDB_p = Dut_getDB();
	bool sendCfm = FALSE;
	
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutStartCalibrationParams_t, calibrationParams_p);
	SLOG0(0, 0, dutDB_t, dutDB_p);
#endif
	if (dutDB_p->isChannelSet == FALSE)
	{
		calibrationParams_p->status = CALIBRATION_RETURN_STATUS_CHANNEL_NOT_SET;
		sendCfm = TRUE;
	}
	else if (dutDB_p->calibrationInProcess == TRUE)
	{
#ifdef DUT_LOGS_ON
		ILOG0_D("dutStartCalibration, abort request, calibration in process: %d", dutDB_p->calibrationReq);
#endif		
		calibrationParams_p->status = CALIBRATION_RETURN_STATUS_CALIBRATION_IN_PROCESS;
		sendCfm = TRUE;
	}
	else
	{
		calibrationParams_p->status = CALIBRATION_RETURN_STATUS_OK;
		dutDB_p->calibrationResults = 0;
		dutSetCalibrationMask((dutCalibrationType_e)calibrationParams_p->type, (dutCalibrationMaskType_e)calibrationParams_p->maskType, calibrationParams_p->mask);
		dutDB_p->calibrationReq = (dutCalibrationType_e)calibrationParams_p->type;
		dutDB_p->calibrationInProcess = TRUE;
		switch(dutDB_p->calibrationReq)
		{
			case DUT_CALIBRATION_TYPE_ONLINE:
			{
				dutDB_p->onlineCalibrationCount = 1;
#ifdef DUT_LOGS_ON
				ILOG0_V("dutStartCalibration, start DUT_CALIBRATION_TYPE_ONLINE");
#endif
				ClbrMngr_EnableDisableOnlineCal(ENABLED, FALSE);

				break;
			}			
			case DUT_CALIBRATION_TYPE_OFFLINE:
			{
#ifdef DUT_LOGS_ON
				ILOG0_V("dutStartCalibration, start DUT_CALIBRATION_TYPE_OFFLINE");
#endif
				//FATAL("DUT BROKEN");
				break;
			}
			default:
				DEBUG_ASSERT(0);
				break;
		}
	}
	return (sendCfm);
}

/*********************************************************************************
Method:			Dut_UpdateCalibrationCounter
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void Dut_UpdateCalibrationCounter()
{
	dutDB_t *dutDB_p = Dut_getDB();

	if (((OPERATION_MODE_DUT == (dutDB_p->operationMode)) || (OPERATION_MODE_SNIFFER == (dutDB_p->operationMode))) && (dutDB_p->savedDutMsgId == DUT_START_CALIBRATION_REQ) && (dutDB_p->calibrationReq == DUT_CALIBRATION_TYPE_ONLINE))
	{
		DEBUG_ASSERT(dutDB_p->onlineCalibrationCount > 0);
		dutDB_p->onlineCalibrationCount--;
		if (dutDB_p->onlineCalibrationCount == 0)
		{
			DUT_HandleCalibDone();
		}
	}
}

/*********************************************************************************
Method:			DUT_UpdateMsgWithCalibResults
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_UpdateMsgWithCalibResults(void)
{
	dutDB_t *dutDB_p = Dut_getDB();
	dutMessage_t *dutMessage_p = (dutMessage_t *)pK_MSG_DATA(dutDB_p->savedDutMsg_p);
	dutStartCalibrationParams_t *startCalibrationParams_p = (dutStartCalibrationParams_t *)(dutMessage_p->data);

	DEBUG_ASSERT(dutDB_p->savedDutMsgId == DUT_START_CALIBRATION_REQ);
	startCalibrationParams_p->results = dutDB_p->calibrationResults;
}

/*********************************************************************************
Method:			DUT_HandleCalibDone
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_HandleCalibDone(void)
{
	dutDB_t *dutDB_p = Dut_getDB();

	dutDB_p->isChannelSet = TRUE;
	if ((OPERATION_MODE_DUT == (UmiOperationMode_e)dutDB_p->operationMode) && (dutDB_p->savedDutMsgId == DUT_START_CALIBRATION_REQ))
	{
#ifdef DUT_LOGS_ON
		ILOG0_D("DUT_HandleCalibDone, calibration type: %d ended", dutDB_p->calibrationReq);
#endif
		DUT_UpdateMsgWithCalibResults();
		dutDB_p->calibrationInProcess = FALSE;
		Dut_MsgCallBack(PNULL);
	}
}

/*********************************************************************************
Method:			Dut_updateCalibResults
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void Dut_updateCalibResults(uint32 statusResults)
{
	Dut_getDB()->calibrationResults |= statusResults;
}


/*********************************************************************************
Method:			DUT_setRxCount
Description:  
Parameter:    	IN dutRxCount *rxCount_p
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_setRxCount(IN dutRxCount *rxCount_p)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(dutRxCountParams_t));
	dutRxCountParams_t *dutRxCountParams = (dutRxCountParams_t *)pK_MSG_DATA(kMsg_p);
	uint8 vapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());

	dutRxCountParams->rxCount = rxCount_p->val;
	/*no need cfm from RX manager*/

	OSAL_SEND_MESSAGE(RX_MANAGER_SET_DUT_RX_COUNT_REQ,TASK_RX_MANAGER,kMsg_p,vapId);
}

/*********************************************************************************
Method:			DUT_getRxCountReq
Description:  
Parameter:    	OUT dutRxCount *rxCount_p
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_getRxCountReq(void)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(dutRxCountParams_t));
	dutRxCountParams_t *dutRxCountParams = (dutRxCountParams_t *)pK_MSG_DATA(kMsg_p);
	uint8 vapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());

	dutRxCountParams->retMsg = DUT_GET_RX_COUNT_CFM;
	dutRxCountParams->retTask = TASK_DUT;
	
	OSAL_SEND_MESSAGE(RX_MANAGER_GET_DUT_RX_COUNT_REQ, TASK_RX_MANAGER,kMsg_p,vapId);

}
/*********************************************************************************
Method:			DUT_getRxCountCfm
Description:  
Parameter:    	OUT dutRxCount *rxCount_p
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_getRxCountCfm(K_MSG* pDutRxCountMsgCfm)
{
	dutRxCountParams_t *dutRxCountParams = (dutRxCountParams_t *)pK_MSG_DATA(pDutRxCountMsgCfm);
	dutMessage_t* pDutMessage = (dutMessage_t*)pK_MSG_DATA(Dut_getDB()->savedDutMsg_p);
	dutRxCount* pDutRxCount = (dutRxCount*)pDutMessage->data;
	
	pDutRxCount->val = dutRxCountParams->rxCount;

	Dut_MsgCallBack(PNULL);
}

/*********************************************************************************
Method:			dutSetTxPower
Description:  
Parameter:    	dutPowerOutVecParams_t *dutPowerOutVecParams_p, bool validForAllParams
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutSetTxPower(dutPowerOutVecParams_t *dutPowerOutVecParams_p, bool validForAllParams)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(LaFixedPowerParams_t));
	LaFixedPowerParams_t *laFixedPowerParams_p = (LaFixedPowerParams_t *)pK_MSG_DATA(kMsg_p);
	dutDB_t *dutDB_p = Dut_getDB();
	trafficParams_t *dutTrafficParams_p = &(dutDB_p->m_DutTrafficParams);
	UNUSED_PARAM(validForAllParams);	
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutPowerOutVecParams_t, dutPowerOutVecParams_p);
#endif

	dutTrafficParams_p->powerVectorWord = dutPowerOutVecParams_p->powerVectorWord;

	memset(laFixedPowerParams_p, 0, sizeof(LaFixedPowerParams_t));
	laFixedPowerParams_p->stationId = INVALID_STA_INDEX;
	laFixedPowerParams_p->powerVal	= dutPowerOutVecParams_p->powerVectorIndex;
	laFixedPowerParams_p->vapId 	= dutDB_p->vapIndex;
	laFixedPowerParams_p->changeType = LA_PACKET_TYPE_DATA_MANAGEMENT;
	laFixedPowerParams_p->retTask	= TASK_DUT;
	laFixedPowerParams_p->retMsg 	= DUT_SET_TX_POWER_CFM;
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_FIXED_POWER, TASK_LINK_ADAPTATION, kMsg_p, laFixedPowerParams_p->vapId);
}

/*********************************************************************************
Method:			dutSetRate
Description:  
Parameter:    	dutSetRate_t *dutSetRate_p
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutSetRate(dutSetRate_t *dutSetRate_p)
{
	dutDB_t *dutDb_p = Dut_getDB();	
	trafficParams_t *trafficParams_p = &(dutDb_p->m_DutTrafficParams);
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(LaFixedRateParams_t));
	LaFixedRateParams_t *laFixedRateParams_p = (LaFixedRateParams_t *)pK_MSG_DATA(kMsg_p);

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutSetRate_t, dutSetRate_p);
#endif
	// update dut DB
	trafficParams_p->txRate 			= dutSetRate_p->txRate;
	trafficParams_p->phyMode			= (PhyMode_e)dutSetRate_p->phyMode;
	trafficParams_p->cpMode 			= dutSetRate_p->cpMode;

	memset(laFixedRateParams_p, 0, sizeof(LaFixedRateParams_t));

	laFixedRateParams_p->vapId				= dutDb_p->vapIndex;
	laFixedRateParams_p->fixedRateType 		= FIXED_RATE_FOR_VAP;
	laFixedRateParams_p->stationIndex		= INVALID_STA_INDEX;
	laFixedRateParams_p->rate				= trafficParams_p->txRate;
	laFixedRateParams_p->phyMode			= (PhyMode_e)trafficParams_p->phyMode;
	laFixedRateParams_p->bandwidth			= (Bandwidth_e)dutSetRate_p->signalBw;
	laFixedRateParams_p->cpMode				= (CyclicPrefixMode_e)trafficParams_p->cpMode;
	laFixedRateParams_p->changeType 		= LA_PACKET_TYPE_DATA_MANAGEMENT;
	laFixedRateParams_p->backToAutoRate 	= FALSE;
	laFixedRateParams_p->disableTimers		= FALSE;
	laFixedRateParams_p->retTask			= TASK_DUT;
	laFixedRateParams_p->retMsg 			= DUT_SET_FIXED_RATE_CFM;
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, LaFixedRateParams_t, laFixedRateParams_p);
#endif
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_FIXED_RATE, TASK_LINK_ADAPTATION, kMsg_p, dutDb_p->vapIndex);	

}

#ifdef ENET_INC_ARCH_WAVE600
/*********************************************************************************
Method:			dutGetRate_t
Description:  
Parameter:    	dutGetRate_t *dutGetRate_p
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutGetRateReq(OUT dutGetRate_t *dutGetRate_p)
{
	dutDB_t *dutDb_p = Dut_getDB();	//for vapIndex
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(LaGetPhyRateParams_t));//create new msg to lower MAC
	LaGetPhyRateParams_t *laGetRateParams_p = (LaGetPhyRateParams_t *)pK_MSG_DATA(kMsg_p);

#ifdef DUT_LOGS_ON
	ILOG0_D("GET RATE %d ", dutGetRate_p->rate);
	SLOG0(0, 0, dutGetRate_t, dutGetRate_p);
#endif
	memset(laGetRateParams_p, 0, sizeof(LaGetPhyRateParams_t));

	laGetRateParams_p->phyMode = dutGetRate_p->phyMode;
	laGetRateParams_p->nss = dutGetRate_p->nss;
	laGetRateParams_p->mcs = dutGetRate_p->mcs;
	laGetRateParams_p->cp  = dutGetRate_p->gi;
	laGetRateParams_p->bw  = dutGetRate_p->signalBw;
#ifdef DUT_LOGS_ON

	SLOG0(0, 0, LaGetPhyRateParams_t, laGetRateParams_p);
#endif
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_GET_PHY_RATE, TASK_LINK_ADAPTATION, kMsg_p, dutDb_p->vapIndex); 
}

/*********************************************************************************
Method:			DUT_getPhyRateCfm
Description:  
Parameter:    
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_getRateCfm(K_MSG* pLaGetPhyRate)
{
	LaGetPhyRateParams_t *pLaGetPhyRateParams = (LaGetPhyRateParams_t *)pK_MSG_DATA(pLaGetPhyRate);
	dutMessage_t* pDutMessage = (dutMessage_t*)pK_MSG_DATA(Dut_getDB()->savedDutMsg_p);
	dutGetRate_t* pDutGetRate = (dutGetRate_t*)pDutMessage->data;
	
	pDutGetRate->rate = pLaGetPhyRateParams->phyRate;
#ifdef DUT_LOGS_ON
	ILOG0_DD("DUT_getRateCfm pLaGetPhyRateParams= %d ,pDutGetRate->rate = %d", pLaGetPhyRateParams->phyRate, pDutGetRate->rate);
#endif	
	pDutMessage->msgId = DUT_GET_RATE_CFM;
	Dut_MsgCallBack(PNULL);
}

#endif //ENET_INC_ARCH_WAVE600




void dutReadChipVersion(dutChipVersion_t* dutChipVersion_p)
{
	dutChipVersion_p->bbChipId = Hdk_GetBbChipId();
	dutChipVersion_p->rfChipId = Hdk_GetRfChipId();
	ILOG0_DD("rfchip:%x,bbchipId:%x",dutChipVersion_p->rfChipId, dutChipVersion_p->bbChipId);
}

void dutGetInfo(dutGetFwInfo_t *dutGetFwInfo_p)
{
	dutDB_t *dutDb_p = Dut_getDB();

	dutGetFwInfo_p->operationMode = dutDb_p->operationMode;	
	
	if (dutDb_p->vapCount > 0)
	{
		dutGetFwInfo_p->operationMode = dutDb_p->operationMode;
	}
	else
	{
		dutGetFwInfo_p->operationMode = OPERATION_MODE_INVALID;
	}
	
	if ((dutGetFwInfo_p->operationMode == OPERATION_MODE_DUT) || (dutGetFwInfo_p->operationMode == OPERATION_MODE_SNIFFER))
	{
		dutGetFwInfo_p->vapId = dutDb_p->vapIndex;
		dutGetFwInfo_p->riscMode = (uint8)dutDb_p->riscMode;
//		dutGetFwInfo_p->spectrumMode = sMIB_Objects.u8SpectrumMode;
//		dutGetFwInfo_p->primaryChannel = ActiveChannel.u16Channel;
//		dutGetFwInfo_p->phyMode = u8LMphyType;
	}
	dutGetFwInfo_p->operationalTxAntMask = Hdk_GetTxAntMask();
	dutGetFwInfo_p->operationalRxAntMask = Hdk_GetRxAntMask();
	dutGetFwInfo_p->zwdfsAntMask = Hdk_GetZwdfsAntMask();
	dutGetFwInfo_p->isZwdfsEn = ConfigurationManager_GetIsDualBandZWDFS();
	dutGetFwInfo_p->supportedBandsPsd = Hdk_GetSupportedBand();
	dutGetFwInfo_p->currentRfBandPsd = HDK_getBand();
	dutGetFwInfo_p->psdMaxTxAntMask = Hdk_GetMaxTxAntMask();
	dutGetFwInfo_p->psdMaxRxAntMask = Hdk_GetMaxRxAntMask();
	
	/* verification - common antenna between bands is singular and part of the availble antenna's*/
	if (TRUE == ConfigurationManager_GetIsDualBandZWDFS())
	{
		ASSERT(1 == Utils_GetNumAntsFromMask((dutGetFwInfo_p->zwdfsAntMask)));
		ASSERT(dutGetFwInfo_p->psdMaxTxAntMask & dutGetFwInfo_p->zwdfsAntMask);
	}

	
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutGetFwInfo_t, dutGetFwInfo_p);
#endif
	
}

void dutHandleRiscModeReq(riscModeParams_t *riscModeParams_p)
{
	dutDB_t *dutDB_p = Dut_getDB();

	dutDB_p->riscMode = riscModeParams_p->riscMode;
	
	switch (riscModeParams_p->riscMode)
	{
		case DUT_RISC_STOP:
			PhyDrv_ResetBB();
			break;
		case DUT_RISC_START:
			PhyDrv_ReActivateBB();
			break;
		default:
			DEBUG_ASSERT(0); //klocwork ignore, UNREACH.GEN..... All the cases in the ENUM is handled, klockwork sees this assert as unreachable code.
			break;
	}
}

