/***************************************************************
 File:	Dut_Tx.c
 Module:	Dut
 Purpose: 	A short description of the class purpose.
 Description: A detailed description of the class, its attributes and whatever 
	             information the user & maintainer might find 
 	             valuable.
***************************************************************/
//---------------------------------------------------------------------------------
//						Includes									
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "stringLibApi.h"
#include "queue_utility.h"
#include "init_ifmsg.h"
#include "OSAL_Api.h"
#include "mhi_dut.h"
#include "Dut_Api.h"
#include "Dut.h"
#include "loggerAPI.h"
#include "fsdu_resource.h"
#include "ErrorHandler_Api.h"
#include "PhyDriver_API.h"
#include "mib_id.h"
#include "mib_ms.h"
#include "SharedDbTypes.h"
#include "PacketDescriptor.h"
#include "ResourceManager_API.h"
#include "TxPacketsClassifier_API.h"
#include "shramTxDesc.h"
#include "System_Timers.h"
#include "CalibrationHandlerUtils.h"
#include "LinkAdaptation.h"

#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_DUT
#define LOG_LOCAL_FID 3


// Allows Special Compilation for Dut

//---------------------------------------------------------------------------------
//						Defines									
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Data Type Definition									
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition									
//---------------------------------------------------------------------------------
 

 //---------------------------------------------------------------------------------
//						Public Variables									
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Static Variables									
//---------------------------------------------------------------------------------

dutSetTransmitPowerVector_t *pTransmitPowerVector;

measuredVoltagePowerVector_t *measuredVoltagePowerVector;
extern ClbrStoreChanData_t ShramClbrDataBufferStoreChanData;
uint32 isTxPowerVectorOn =0 ;
uint32 PVpowerToTransmitIndex=0;
uint32 PVnumberOfPacketsTransmited;
uint32 packetSizeToadd = 0;
uint32 PVchangedPowerFlag = 0;
TxPd_t *pDescForPowerChange;
uint8 isDataLongTransmitted = FALSE;

//---------------------------------------------------------------------------------
//						Static Function Declaration									
//---------------------------------------------------------------------------------
static void dutTxFillTrafficParams(IN dutTxParams_t *txParams_p, OUT trafficParams_t *dutTrafficParams_p);
static void dutTxStartPowerVectorTransmision(dutSetTransmitPowerVector_t *pTransmitPowerVectorInput);
static void dutTxGetPowerVectorPerAnt(dutGetTransmitPowerVectorAntenna_t *pMeasuredVoltagePowerVector);
static void Dut_SendToTxPacketClassifier(TxPd_t *pDesc, bool toRelease);



static void dutTxStopTransmision(IN dutTxParams_t *txParam_ps);
void dutHandleCbInStoppingState(TxPd_t *pDesc);

//---------------------------------------------------------------------------------
//						Debug Section									
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Functions Definitions									
//---------------------------------------------------------------------------------
void DutTx_Init(void)
{
	uint32 payloadByteOffset = 0;
	uint32 descriptorIndex = 0;
    uint32 frameHeadersize = 0;
	dutDB_t *dutDB_p = Dut_getDB();

	dutDB_p->m_DutTrafficParams.packetsProcessed = 0;
	dutDB_p->m_DutTrafficParams.trafficState = DUT_TX_STATE_IDLE;
	dutDB_p->m_DutTrafficParams.packetsTransmitted = 0;
	dutDB_p->m_DutTrafficParams.numOfPacketToTransmit = 0;
	dutDB_p->m_DutTrafficParams.isTxEndless = FALSE;
	dutDB_p->m_DutTrafficParams.cpMode = 0;
	dutDB_p->m_DutTrafficParams.phyMode = PHY_MODE_LAST;
	dutDB_p->m_DutTrafficParams.modifyParamsOnTheFly = FALSE;
	dutDB_p->m_DutTrafficParams.powerVectorWord = 0;
	dutDB_p->m_DutTrafficParams.packetLength = 0;
	dutDB_p->m_DutTrafficParams.txPacketIsOngoing = FALSE;
    frameHeadersize = frame_sizeOfNewManagementFrameHeader(FALSE);
	// Fill the FSDU payload with constant values( Required for 2ss tests) 
	for (descriptorIndex = 0; descriptorIndex < NUM_OF_MANAGEMENT_DESCRIPTORS; descriptorIndex++)
	{
		for (payloadByteOffset = 0; payloadByteOffset < MANAGEMENT_PACKET_PAYLOAD_SIZE; payloadByteOffset++)
		{
			ManPkts[descriptorIndex].manPacket[frameHeadersize + payloadByteOffset] = 
				((payloadByteOffset + 1 - (sizeof( IEEE_ADDR ) + BUFFER_PAYLOAD_ALIGNMENT)) & UBYTE_MASK_VALUE);
		}
	}
}

void DutTx_Dispatcher(IN dutMessage_t *dutMessage_p)
{
	dutTxParams_t *txParams_p = (dutTxParams_t *)dutMessage_p->data;
	dutGetTransmitPowerVectorAntenna_t *pGetAntennaPower = (dutGetTransmitPowerVectorAntenna_t *)dutMessage_p->data;
	pTransmitPowerVector = (dutSetTransmitPowerVector_t *)dutMessage_p->data;
	ILOG0_D("packetLength:%d",txParams_p->packetLength);
	switch (dutMessage_p->msgId)
	{
	case DUT_START_TX_REQ:	
		dutTxStartTransmision(txParams_p);
		break;
	case DUT_STOP_TX_REQ:
		dutTxStopTransmision(txParams_p);
		break;
	case DUT_START_TX_VECTOR_REQ:
		dutTxStartPowerVectorTransmision(pTransmitPowerVector);
		break;	
	case DUT_GET_TX_VECTOR_ANT_REQ:
		dutTxGetPowerVectorPerAnt(pGetAntennaPower);
		break;	
	default:
		DEBUG_ASSERT(0);
		break;
	}
}


void dutTxSetState(dutTxStates_e dutTxNewState)
{
	trafficParams_t *dutTrafficParams_p = &(Dut_getDB()->m_DutTrafficParams);
#ifdef DUT_LOGS_ON
	ILOG0_DD("dutTxSetState, old state:%d, new state:%d", dutTrafficParams_p->trafficState, dutTxNewState);
#endif
	dutTrafficParams_p->trafficState = dutTxNewState;

}

dutTxStates_e dutTxGetState()
{
	trafficParams_t *dutTrafficParams_p = &(Dut_getDB()->m_DutTrafficParams);

	return (dutTrafficParams_p->trafficState);

}

//---------------------------------------------------------------------------------
//						Static Functions Definitions									
//---------------------------------------------------------------------------------


/*********************************************************************************
Method:			dutTxStartTransmision
Description:  
Parameter:    	dutTxParams * txParams
Returns:      	void
Remarks:		None
*********************************************************************************/


uint32  dutGetTxPowerVectorStatus(void)
{
	return isTxPowerVectorOn; 
}
uint32  dutGetChangePowerVectorStatus(void)
{
	return PVchangedPowerFlag;
}
uint32  dutGetTransmitPowerVectorStartingLength(void)
{
	return pTransmitPowerVector->startingPacketLength;;
}
TxPd_t*  dutGetTransmitPowerPacketDesc(void)
{
	return pDescForPowerChange;;
}



static void dutTxGetPowerVectorPerAnt(dutGetTransmitPowerVectorAntenna_t *pMeasuredVoltagePowerVector)
{
	uint32 ant = pMeasuredVoltagePowerVector->antennaIndex;
	uint32 index;
	MEMCPY(pMeasuredVoltagePowerVector->measuredVoltagePerPower,measuredVoltagePowerVector->measuredVector[ant], sizeof(uint16)*MAX_NUM_OF_POWER_VECTOR_INDEX);
	for( index = 0;index<MAX_NUM_OF_POWER_VECTOR_INDEX;index++)
	{
		ILOG2_DD("dutTxGetPowerVectorPerAnt, index:%d, measuredVoltagePerPower:%d",index, measuredVoltagePowerVector->measuredVector[ant][index]);
	}
	memset(measuredVoltagePowerVector->measuredVector[ant],0x0,sizeof(uint16)*MAX_NUM_OF_POWER_VECTOR_INDEX);
	DUT_CfmToHost(DUT_STATUS_PASS);
}

static void dutTxStartPowerVectorTransmision(dutSetTransmitPowerVector_t *pTransmitPowerVectorInput)
{
	
	dutDB_t *dutDB_p = Dut_getDB();
	dutPowerAndPacketLength_t dutPowerAndPacketLength;

	memset(&ShramClbrDataBufferStoreChanData,0,sizeof(ClbrStoreChanData_t));
	measuredVoltagePowerVector  = (measuredVoltagePowerVector_t *)&ShramClbrDataBufferStoreChanData;
	
	if(pTransmitPowerVectorInput->lengthOfPowerVector != 0)
	{
		isTxPowerVectorOn = TRUE;
		PVpowerToTransmitIndex = 0;
		PVnumberOfPacketsTransmited = 0;
		packetSizeToadd = 0;

		packetSizeToadd += pTransmitPowerVectorInput->packetLengthIncrementPerIndex;
		dutPowerAndPacketLength.packetLength = packetSizeToadd + pTransmitPowerVectorInput->startingPacketLength;
		dutPowerAndPacketLength.txPower = pTransmitPowerVectorInput->powerIndexArray[PVpowerToTransmitIndex];
		dutSetPowerAndLength(&dutPowerAndPacketLength);
		PVchangedPowerFlag = 0x1;
		dutDB_p->TxPowerFeedbackRequested =TRUE;
	}
	
}

 void dutTxStartTransmision(IN dutTxParams_t *txParams_p)
{
	dutDB_t *dutDB_p = Dut_getDB();
	trafficParams_t *dutTrafficParams_p = &(dutDB_p->m_DutTrafficParams);

#ifdef DUT_LOGS_ON
	ILOG0_V("dutTxStartTransmision function");
	SLOG0(0, 0, dutTxParams_t, txParams_p);
#endif

	switch(dutTrafficParams_p->trafficState)
	{
	case DUT_TX_STATE_IDLE:// tx with repets need !=0, after set cahnnel
		{
	
			dutStatus_e dutStatus = DUT_STATUS_FAIL;		
			if (dutDB_p->isChannelSet == TRUE)
			{
#ifdef DUT_LOGS_ON
				ILOG0_V("-----IDLE_STATE: channel set. dutTxStartTransmision:fill traffic param ----");
#endif
				dutTxFillTrafficParams(txParams_p, dutTrafficParams_p);
#ifdef DUT_LOGS_ON
				SLOG0(0, 0, trafficParams_t, dutTrafficParams_p);
#endif
				dutStatus = DUT_STATUS_PASS;
				if (TRUE == txParams_p->isDateLong)
				{
#ifdef ENET_INC_ARCH_WAVE600
					dutTxSendLongPackets(txParams_p);
#endif
				}
				else
				{
					dutTxSendPackets();
				}
			}
			else
			{
#ifdef DUT_LOGS_ON
				ILOG0_D("Error!, dutTxStartTransmision: Channel NOT SET, isChannelSet:%d", dutDB_p->isChannelSet);
#endif
			}

			/*donot send conformation if this is power vector*/
			if(isTxPowerVectorOn != TRUE)
			{
				DUT_CfmToHost(dutStatus);
			}
		}
		break;
	case DUT_TX_STATE_TRANSMITTING:
#ifdef DUT_LOGS_ON
		ILOG0_V("dutTxStartTransmision, DUT_STATUS_TX_START_IS_ONGOING");
#endif
		DUT_CfmToHost(DUT_STATUS_TX_START_IS_ONGOING);
		break;
	case DUT_TX_STATE_STOPPING:
#ifdef DUT_LOGS_ON
		ILOG0_V("dutTxStartTransmision, DUT_STATUS_TX_STOP_IS_ONGOING");
#endif
		DUT_CfmToHost(DUT_STATUS_TX_STOP_IS_ONGOING);
		break;
	default:
		DEBUG_ASSERT(0); //klocwork ignore, UNREACH.GEN..... All the cases in the ENUM is handled, klockwork sees this assert as unreachable code
		break;
	}
}

/*********************************************************************************
Method:			dutTxStopTransmision
Description:  
Parameter:    	dutTxParams * txParams
Returns:      	void
Remarks:		None
*********************************************************************************/
static void dutTxStopTransmision(IN dutTxParams_t *txParams)
{
	dutDB_t *dutDB_p = Dut_getDB();
	isTxPowerVectorOn = FALSE;
	UNUSED_PARAM(txParams);	
#ifdef DUT_LOGS_ON
	ILOG0_DD("----- dutTxStopTransmision ---- TxState = 0x%x, isDataLongTransmitted:%d", dutDB_p->m_DutTrafficParams.trafficState,isDataLongTransmitted);
#endif
	switch(dutDB_p->m_DutTrafficParams.trafficState)
	{
	case DUT_TX_STATE_TRANSMITTING:
		
		dutTxSetState(DUT_TX_STATE_STOPPING);
		
		dutDB_p->sendCfm = TRUE;
		if (TRUE == isDataLongTransmitted)
		{
#ifdef ENET_INC_ARCH_WAVE600
			dutTxStopLongPackets();
#endif
			dutTxSetState(DUT_TX_STATE_IDLE);
			DUT_CfmToHost(DUT_STATUS_PASS);
		}
		else
		{
			dutDB_p->m_DutTrafficParams.numOfPacketToTransmit = 0;		
		}
		/* After transmitting each packet, call back function check if to stop transmitting "txManagerActionFrameHandler". 
			if yes, send confirmation to host from DUT_ACTION_PACKET_CB_HNDLR_REQ */

#ifdef DUT_LOGS_ON
		ILOG0_DD("dutTxStopTransmision: STATE TX changed to STOPPING. packetsTransmitted:%d, packetsProcessed:%d",dutDB_p->m_DutTrafficParams.packetsTransmitted, dutDB_p->m_DutTrafficParams.packetsProcessed);
#endif
		break;
	case DUT_TX_STATE_IDLE:
#ifdef DUT_LOGS_ON
		ILOG0_V("dutTxStopTransmision, DUT_STATUS_TX_ALREADY_STOPPED");
#endif
		DUT_CfmToHost(DUT_STATUS_TX_ALREADY_STOPPED);
		break;
	case DUT_TX_STATE_STOPPING:
#ifdef DUT_LOGS_ON
		ILOG0_V("dutTxStopTransmision, DUT_STATUS_TX_STOP_IS_ONGOING");
#endif
		DUT_CfmToHost(DUT_STATUS_TX_STOP_IS_ONGOING);
		break;
	default:
		DEBUG_ASSERT(0); //klocwork ignore, UNREACH.GEN..... All the cases in the ENUM is handled, klockwork sees this assert as unreachable code
		break;
	}
}

/*********************************************************************************
Method:			dutTxFillTrafficParams
Description:  
Parameter:    	IN dutTxParams_t * txParams
Returns:      	void
Remarks:		None
*********************************************************************************/
static void dutTxFillTrafficParams(IN dutTxParams_t *txParams_p, OUT trafficParams_t *dutTrafficParams_p)
{
	DEBUG_ASSERT(txParams_p->repeats != 0);
	
	dutTrafficParams_p->numOfPacketToTransmit	= txParams_p->repeats;
	dutTrafficParams_p->packetsProcessed 		= 0;
	dutTrafficParams_p->packetsTransmitted 		= 0;
	dutTrafficParams_p->isTxEndless 			= txParams_p->isTxEndless;
	dutTrafficParams_p->packetLength 			= txParams_p->packetLength;
}


/*********************************************************************************
Method:			DUT_stopTxCondition
Description:  
Parameter:    	
Returns:      	bool
Remarks:		checks if condition to stop Tx is met
*********************************************************************************/
bool DUT_stopTxCondition()
{
	bool toStop = FALSE;
	dutDB_t *dutDB_p = Dut_getDB();
	
	if(dutDB_p->m_DutTrafficParams.isTxEndless == FALSE)
	{
		if (dutDB_p->m_DutTrafficParams.packetsTransmitted >= dutDB_p->m_DutTrafficParams.numOfPacketToTransmit)
		{
			toStop = TRUE;
		}
	}
	
#ifdef DUT_LOGS_ON
		//	ILOG0_D("DUT_stopTxCondition, toSTOP bool???= %d", toStop );
#endif

	return (toStop);
}

static void dutTransmitPacketReq(uint32 length)
{
	K_MSG *pTransPacketMsg;
	dutTransmittPacketReqParams_t*	pTransPacketParams;
	dutDB_t* dutDB_p = Dut_getDB();
	uint8 	vapId = dutDB_p->vapIndex;

	pTransPacketMsg = OSAL_GET_MESSAGE(sizeof(dutTransmittPacketReqParams_t));
	pTransPacketParams = (dutTransmittPacketReqParams_t*)pK_MSG_DATA(pTransPacketMsg);
	pTransPacketParams->length = length;
	pTransPacketParams->retMsg = DUT_TRANSMIT_PACKET_CFM;
	pTransPacketParams->retTask = TASK_DUT;
	
	OSAL_SEND_MESSAGE(DUT_TRANSMIT_PACKET_REQ, TASK_TX_MANAGER,pTransPacketMsg, vapId);
}
void dutTransmitPacketCfm(K_MSG* pMsg)
{
	dutTransmittPacketReqParams_t*	pTransPacketParams;
	dutDB_t* dutDB_p = Dut_getDB();

	pTransPacketParams = (dutTransmittPacketReqParams_t*)pK_MSG_DATA(pMsg);

	dutDB_p->m_DutTrafficParams.txPacketIsOngoing = pTransPacketParams->allocationStatus;

	if(pTransPacketParams->allocationStatus == TRUE)
	{
		dutDB_p->m_DutTrafficParams.packetsProcessed++;
#ifdef DUT_LOGS_ON
		ILOG0_D("dutTransmitPacketCfm, packetsProcessed= %d",dutDB_p->m_DutTrafficParams.packetsProcessed);
#endif
	}
	else
	{
		/*Transmission failed - no buffer allocated*/
		ASSERT(0);
	}
#ifdef DUT_LOGS_ON
	ILOG0_D("dutTransmitPacketCfm, calling TxPacketsClassifier_SendManagementPacketFromFw, dutDB_p->m_DutTrafficParams.packetsProcessed:%d", 
	dutDB_p->m_DutTrafficParams.packetsProcessed);
#endif

}
#ifdef ENET_INC_ARCH_WAVE600

void dutTxStopLongPackets()
{
	//bbic_mac_emu_deactivate();
	PhyDrv_macEmuStop();
	isDataLongTransmitted = FALSE;
}
void dutTxSendLongPackets(dutTxParams_t *txParams_p)
{
	uint8 txAntMask;
	uint16 rate_out = FixedRateParameters.rate;
	uint8 RfPow = FixedPowerParameters.powerVal;
	uint8 bw = HDK_getChannelWidth();
	uint8 packet_format = FixedRateParameters.phyMode;
	uint8 rateIndex = convertTcr2RateIndex(packet_format, FixedRateParameters.rate);
	uint8 mcs=0;
	uint8 nss=0;
	uint32 packet_length = txParams_p->packetLength;
	uint8 ldpc = 0;
	uint8 gap;
	uint16 repeats = txParams_p->repeats;
	uint16 rate_debug=0;//debug
	dutDB_t *dutDB_p = Dut_getDB();
	gap = dutDB_p->dutHwSpacingParams.spacingUsec;
	txAntMask = dutDB_p->txAntEnableMask;
	
	isDataLongTransmitted = TRUE;
	dutTxSetState(DUT_TX_STATE_TRANSMITTING);
	
	if (repeats == 0xffff)
	{
		repeats =0;
	}
	if (FixedRateParameters.phyMode >= PHY_MODE_11AX_SU)
	{
		ldpc = 1;
	}
	else
	{
		ldpc = 0;
	}
	//debug

	if (packet_format >= PHY_MODE_11AX_SU)
	{
		nss = heRatesTable[rateIndex].numberOfNss;
		mcs = heRatesTable[rateIndex].vhtHeMcs;
	}
	else
	{
		nss = htVhtRatesTable[rateIndex].numberOfNss;
		if (packet_format == PHY_MODE_11AC)
		{
			mcs = htVhtRatesTable[rateIndex].vhtHeMcs;
		}
		else
		{
			mcs = htVhtRatesTable[rateIndex].htMcs;
		}
	}
	//for debug assert only
	switch (packet_format) 
	{
	case 0 : rate_debug=mcs;  break; // legacy [2:0] – mcs, [7:3] – 0
	case 1 : rate_debug=mcs;  break;// 11b	[1:0] – rate, [2] – long preamble=0		[7:3] – 0
	case 2 : rate_debug = mcs+nss*8 ; break;//ht rate is mcs[2:0]*nss is mcs[4:3], 	*mcs32 is when mcs[5:0]=32
	case 3 : rate_debug = mcs+nss*16; break;//vht	[3:0] – mcs	[6:4] – Nss	[7] - 0
	default: rate_debug = mcs+nss*16; //He	[3:0] – mcs	[6:4] – Nss	[7] - DCM
	}//till here

	ILOG0_DDDD("LongPackets antMask:%d, RfPow:%d, bw:%d, phymode:%d",txAntMask,RfPow,bw,packet_format);
	ILOG0_DDDD("packet_length:%d, ldpc:%d, gap:%d repeats:%d", packet_length, ldpc, gap, repeats);
	ILOG0_DDDD("rate_out:%d rate_debug:%d ,mcs:%d, nss:%d",rate_out,rate_debug, mcs, nss);
	ASSERT(rate_out == rate_debug);
	
	PhyDrv_macEmuRun(txAntMask, RfPow, bw, packet_format, mcs, nss, packet_length, ldpc, gap, repeats);

}
#endif

/*********************************************************************************
Method:			dutTxSendPackets
Description:  
Parameter:    	IN trafficParams_t * dutTrafficParams
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutTxSendPackets(void)
{
	trafficParams_t *dutTrafficParams_p = &(Dut_getDB()->m_DutTrafficParams);
	uint32 length = dutTrafficParams_p->packetLength;
	ILOG0_V("dutTxSendPackets to TxManager function. change state=>transmitting");

	dutTxSetState(DUT_TX_STATE_TRANSMITTING);
	dutTransmitPacketReq(length);
}


void dutHandleCbInTransmittingState(TxPd_t *pDesc)
{
	dutPowerAndPacketLength_t dutPowerAndPacketLength;
	dutDB_t *dutDB_p = Dut_getDB();
	trafficParams_t *m_DutTrafficParams_p = &(dutDB_p->m_DutTrafficParams);
	bool toStop = DUT_stopTxCondition();
	PVchangedPowerFlag = 0x0;
	if(isTxPowerVectorOn == TRUE)
	{
		PVnumberOfPacketsTransmited++;
#ifdef DUT_LOGS_ON
		ILOG0_D("dutHandleCbInTransmittingState transmitPowerVector.numOfTransmitionPerPower[PVpowerToTransmitIndex]:%d",pTransmitPowerVector->numOfTransmitionPerPower[PVpowerToTransmitIndex]);
#endif
		if(PVnumberOfPacketsTransmited >= pTransmitPowerVector->numOfTransmitionPerPower[PVpowerToTransmitIndex])
		{
			/*finish one power index*/
			measuredVoltagePowerVector->measuredVector[0][PVpowerToTransmitIndex] = measuredVoltagePowerVector->measuredVector[0][PVpowerToTransmitIndex]/PVnumberOfPacketsTransmited;
			measuredVoltagePowerVector->measuredVector[1][PVpowerToTransmitIndex] = measuredVoltagePowerVector->measuredVector[1][PVpowerToTransmitIndex]/PVnumberOfPacketsTransmited;
			measuredVoltagePowerVector->measuredVector[2][PVpowerToTransmitIndex] = measuredVoltagePowerVector->measuredVector[2][PVpowerToTransmitIndex]/PVnumberOfPacketsTransmited;
			measuredVoltagePowerVector->measuredVector[3][PVpowerToTransmitIndex] =	measuredVoltagePowerVector->measuredVector[3][PVpowerToTransmitIndex]/PVnumberOfPacketsTransmited;
			PVpowerToTransmitIndex++;
			PVnumberOfPacketsTransmited = 0;
			if(PVpowerToTransmitIndex >=pTransmitPowerVector->lengthOfPowerVector)
			{	/*end of power vector*/
				toStop = TRUE;
				isTxPowerVectorOn = FALSE;
				dutDB_p->TxPowerFeedbackRequested = FALSE;
				DUT_CfmToHost(DUT_STATUS_PASS);
			}
			else
			{
#ifdef DUT_LOGS_ON
				ILOG0_V("dutHandleCbInTransmittingState SET NEW POWER AND LENGTH");
#endif
				packetSizeToadd += pTransmitPowerVector->packetLengthIncrementPerIndex;
				dutPowerAndPacketLength.packetLength = packetSizeToadd + pTransmitPowerVector->startingPacketLength;
				dutPowerAndPacketLength.txPower = pTransmitPowerVector->powerIndexArray[PVpowerToTransmitIndex];
#ifdef DUT_LOGS_ON
				ILOG0_D("dutHandleCbInTransmittingState packetLength:%d",dutPowerAndPacketLength.packetLength);
				ILOG0_D("dutHandleCbInTransmittingState dutPowerAndPacketLength.txPower:%d",dutPowerAndPacketLength.txPower);
#endif				
				dutSetPowerAndLength(&dutPowerAndPacketLength);
				PVchangedPowerFlag = 0x2;
			}
		}
		else
		{
		}
		
	}
	
	if (toStop == FALSE)
	{
		pDesc->dataLength = dutDB_p->m_DutTrafficParams.packetLength + frame_sizeOfNewManagementFrameHeader(FALSE);

		m_DutTrafficParams_p->txPacketIsOngoing = TRUE;

		dutDB_p->m_DutTrafficParams.packetsProcessed++;

#ifdef DUT_LOGS_ON
		ILOG0_D("dutHandleCbInTransmittingState, calling TxPacketsClassifier_SendManagementPacketFromFw, m_DutTrafficParams_p->packetsProcessed:%d", 
		m_DutTrafficParams_p->packetsProcessed);
#endif
		if(PVchangedPowerFlag != 0x2)
		{

			dutTxSendManagementPacketFromFw(pDesc);
		

		}
		else
		{
			pDescForPowerChange = pDesc;
		}
	}
	else
	{
		dutTxSetState(DUT_TX_STATE_IDLE);

#ifdef DUT_LOGS_ON
		ILOG0_V("dutHandleTxActionPublicFrameCb, DUT_TX_STATE_TRANSMITTING -> DUT_TX_STATE_IDLE, calling ResourceManager_ReleaseDescriptor");
#endif
		dutTxReleaseManagementPacket(pDesc);

	}
}

void dutTxSendManagementPacketFromFw(TxPd_t* pDesc)
{
#ifdef DUT_LOGS_ON
				ILOG0_V("dutTxReleaseManagementPacket, toRelease?? = FALSE ");
#endif

	Dut_SendToTxPacketClassifier(pDesc, FALSE);
}


void dutTxReleaseManagementPacket(TxPd_t* pDesc)
{
	bool toReleasePacket = TRUE;
	
#ifdef DUT_LOGS_ON
			ILOG0_V("dutTxReleaseManagementPacket, toReleasePacket?? = TRUE ");
#endif
	Dut_SendToTxPacketClassifier(pDesc, toReleasePacket);
}


void Dut_SendToTxPacketClassifier(TxPd_t *pDesc, BOOL toRelease)
{

	K_MSG *pMsgToTxPacketClassifier;
	dutMsgBtwnCores_t* txPacketMsg= NULL;
	dutDB_t *dutDB_p = Dut_getDB();
	uint8 vapId = 0;
	vapId = dutDB_p->vapIndex;
	pMsgToTxPacketClassifier = OSAL_GET_MESSAGE(sizeof(dutMsgBtwnCores_t));
	txPacketMsg= (dutMsgBtwnCores_t*)pK_MSG_DATA(pMsgToTxPacketClassifier);
	txPacketMsg->pD = (uint32*)pDesc;
	txPacketMsg->toReleasePool = toRelease;

	OSAL_SEND_MESSAGE(DUT_ACTION_PACKET_CB_HNDLR_CFM, TASK_TX_MANAGER,pMsgToTxPacketClassifier, vapId);

}

void dutHandleCbInStoppingState(TxPd_t *pDesc)
{
	dutDB_t *dutDB_p = Dut_getDB();
	
	dutTxSetState(DUT_TX_STATE_IDLE);
	
	if (pDesc != PNULL)
	{
		dutTxReleaseManagementPacket(pDesc);
	}

	if (dutDB_p->sendCfm == TRUE)
	{
		dutDB_p->sendCfm = FALSE;
		DUT_CfmToHost(DUT_STATUS_PASS);
	}
}


/* call back from tx sent packet*/

void Dut_HandleTxActionPublicFrameCb(K_MSG* pMsg)
{
	dutMsgBtwnCores_t* msgTxActionPublicFrameCb = (dutMsgBtwnCores_t*)pK_MSG_DATA(pMsg);
	TxPd_t *pDesc = (TxPd_t *)msgTxActionPublicFrameCb->pD;
	dutDB_t* dutDB_p = Dut_getDB();
	
	if (dutDB_p->operationMode == OPERATION_MODE_DUT)
	{
		trafficParams_t *m_DutTrafficParams_p = &(dutDB_p->m_DutTrafficParams);
		/*if tx power vector ON*/
		dutHwAccessReadTxPowerFeedBack(FALSE);

		m_DutTrafficParams_p->packetsTransmitted++;

#ifdef DUT_LOGS_ON
		ILOG0_DDD("dutHandleTxActionPublicFrameCb, m_DutTrafficParams_p->trafficState:%d, m_DutTrafficParams_p->txPacketIsOngoing:%d, packetsTransmitted:%d", 
			m_DutTrafficParams_p->trafficState, 
			m_DutTrafficParams_p->txPacketIsOngoing,
			m_DutTrafficParams_p->packetsTransmitted);
#endif

		m_DutTrafficParams_p->txPacketIsOngoing = FALSE;

		switch(m_DutTrafficParams_p->trafficState)
		{
			case DUT_TX_STATE_IDLE:
				break;
			case DUT_TX_STATE_TRANSMITTING:
			{
				dutHandleCbInTransmittingState(pDesc);
			}
				break;
			case DUT_TX_STATE_STOPPING:
			{
				dutHandleCbInStoppingState(pDesc);
			}
				break;
			default:
				DEBUG_ASSERT(0); //klocwork ignore, UNREACH.GEN..... All the cases in the ENUM is handled, klockwork sees this assert as unreachable code
				break;
		}
	}
}


/**********************************************************************************
beaconHandler_SetTxCancelTimer  

Description:
------------
	Set MIPS timer 2 which is used for BEACON_TX_CANCEL
Input:
-----
	uint32 	timeout
Output:
-------
	None
Returns:
--------
	None
**********************************************************************************/
void DUT_SetTxTimer(uint32 timeout)
{
	MT_SetTimeTimer(MT_TIMER_2, timeout);
	MT_SetModeTimer(MT_TIMER_2, MT_TIMER_ENABLE, MT_TIMER_ONE_SHOT);
}


/**********************************************************************************
beaconHandler_ResetTxCancelTimer  

Description:
------------
	Reset MIPS timer 2 which is used for BEACON_TX_CANCEL
Input:
-----
	None
Output:
-------
	None
Returns:
--------
	None
**********************************************************************************/
void DUT_ResetTxTimer(void)
{
	MT_SetModeTimer(MT_TIMER_2, MT_TIMER_DISABLE, MT_TIMER_ONE_SHOT);
}

