/************************************************************************************
*    
*    File:		  ErrorHandler_Api.h
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef ERRORHANDLER_API_H_
#define ERRORHANDLER_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "System_Information.h"
/*---------------------------------------------------------------------------------
/                       Data Type Definition                        
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
typedef enum 
{
	HALT_MODULE_HOST_IF_GENRISC = 0,
	NUM_OF_HALTED_MODULES
} HaltedModules_e;
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
#define ASSERT(T)       {if (!(T)) ErrorHandler_AssertHandler(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__);}
#ifdef ENET_INC_ARCH_WAVE600
#define DEBUG_ASSERT(T) {if (!(T)) ErrorHandler_AssertHandler(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__);}
#else
#define DEBUG_ASSERT(T) {}
#endif
#define FATAL(M)        {ErrorHandler_AssertHandler(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__);}
#ifdef ENET_INC_ARCH_WAVE600
#define DEBUG_FATAL(M)  {ErrorHandler_AssertHandler(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__);}
#else
#define DEBUG_FATAL(T) {}
#endif

/*---------------------------------------------------------------------------------
/						Public Function Declaration									
/----------------------------------------------------------------------------------*/
void 	ErrorHadler_CheckAssertReqFromHost(void);
#if defined (ENET_INC_UMAC)
uint32 ErrorHandler_GetCtrlStructure(void);
#endif
void ErrorHandlerEnableModuleHalt(HaltedModules_e haltModuleId);

void ErrorHandler_AssertHandler(uint32 assertGroupId, uint32 assertFileId, uint32 assertLine);
void ErrorHandler_Exception(void);
void ErrorHandler_Ready(void);
void ErrorHandler_SetFwInterfaceId(uint32 fwInterface);
void ErrorHandler_Init(void);
void ErrorHandler_EnableDivideByZeroException(void);

#if defined (ENET_INC_ARCH_WAVE600)
#if defined(ENET_INC_LMAC0)
void vTLM_ASSERT_TO_LM0_FROM_UM_ISR(void);
void vTLM_ASSERT_TO_LM0_FROM_LM1_ISR(void);
#endif
#if defined (ENET_INC_UMAC)
void vTLM_ASSERT_TO_UM_FROM_LM0_ISR(void);
void vTLM_ASSERT_TO_UM_FROM_LM1_ISR(void);
#endif

#if defined(ENET_INC_LMAC1)
void vTLM_ASSERT_TO_LM1_FROM_UM_ISR(void);
void vTLM_ASSERT_TO_LM1_FROM_LM0_ISR(void);
#endif

#else // wave 500
void vTLM_ASSERT_TO_LM0_FROM_UM_ISR(void);
void vTLM_ASSERT_TO_UM_FROM_LM0_ISR(void);

#endif // ENET_INC_ARCH_WAVE600


#endif //ERRORHANDLER_API_H_

