/***************************************************************
 File:		EventsManager_api.h
 Module:	  	EventsManager  interface
 Purpose: 	interface of the EventsManager
 Description:  	This file is the API to the EventsManager module  
***************************************************************/

#ifndef EVENTS_MANAGER_API_H_
#define EVENTS_MANAGER_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef void (*EventsManagerGeneralFunc)(uint32 eventData);


typedef enum eventStatus
{
	EVENT_STATUS_ENABLE,
	EVENT_STATUS_DISABLE,
    NUM_OF_EVENT_STATUS,
    MAX_EVENT_STATUS = MAX_UINT8
}eventStatus_e;

#if defined(ENET_INC_ARCH_WAVE600)
typedef enum eventData
{
	EVENT_ID_DESCRIPTORS_PENDING_FOR_HOST_IF,
	EVENT_ID_TX_DONE_LISTS,
	EVENT_ID_TX_LIST_READY_PDS_LOW_PRI_NOT_EMPTY,
	EVENT_ID_TX_LIST_READY_PDS_HIGH_PRI_NOT_EMPTY,
	EVENT_ID_TX_IN_MANGEMENT_COUNT_NOT_EMPTY,
	EVENT_ID_RX_IN_MANGEMENT_COUNT_NOT_EMPTY,
	EVENT_ID_HIGH_PRI_RX_PD_READY,
	EVENT_ID_DMA_HOST_IF_DONE,
	EVENT_ID_DMA_FORWARD,
	EVENT_ID_DMA_HDK_BAND0,
	EVENT_ID_DMA_HDK_BAND1,
	EVENT_ID_MC_DATA_INT,
	EVENT_ID_CLASS_VIOLATION_BAND0,
	EVENT_ID_CLASS_VIOLATION_BAND1,
	EVENT_ID_FRAGMENT_FIFO_NOT_EMPTY,
	EVENT_ID_PS_SETTING_FIFO_NOT_EMPTY,
	EVENT_ID_RXF_FIFO_NOT_EMPTY,
	EVENT_ID_RX_AMSDU_PARSER_MSDU_DESC_NOT_EMPTY_BAND0,
	EVENT_ID_RX_AMSDU_PARSER_MSDU_DESC_NOT_EMPTY_BAND1,
	EVENT_ID_SEQUENCER_REPORTS_FIFO_NOT_EMPTY,	
	EVENT_ID_BAA_REPORTS_FIFO_NOT_EMPTY,
	EVENT_ID_PD_THRESHOLD_REACHED,
	EVENT_ID_TX_DISABLED_QUEUES_NOT_EMPTY,
	EVENT_ID_METRICS_FIFO_NOT_EMPTY,
	EVENT_ID_FW_STAT_DMA_DONE,
	EVENT_ID_ULPR_FIFO_NOT_EMPTY,
	EVENT_ID_PRE_AGG_FIFO_NOT_EMPTY,
#ifdef ATOMIC_COUNTER_ENABLER	
	EVENT_ID_MAILBOX_NOT_EMPTY,
#endif
    NUM_OF_EVENT_IDS,
    MAX_EVENT_IDS = MAX_UINT8
}eventId_e;

typedef enum eventType
{
	EVENT_TYPE_SW_EVENT,
	EVENT_TYPE_HW_INT,
	EVENT_TYPE_HW_EVENT_A_BAND0,
	EVENT_TYPE_HW_EVENT_A_BAND1,
	EVENT_TYPE_HW_EVENT_B_BAND0,
	EVENT_TYPE_HW_EVENT_B_BAND1,
	EVENT_TYPE_HW_EVENT_COMMON_A,	
	EVENT_TYPE_SHRAM_INT,
	EVENT_TYPE_RAB_NPU_INT,
	EVENT_TYPE_RAB_UPI_INT,
	EVENT_TYPE_RAB_PHI_INT,
	EVENT_TYPE_RAB_LPI_INT,	// to remove
	EVENT_TYPE_ERROR,
    NUM_OF_EVENT_TYPES,
    MAX_EVENT_TYPES = MAX_UINT8
}eventType_e;

#else
// Wave 500
typedef enum eventData
{
	EVENT_ID_DESCRIPTORS_PENDING_FOR_HOST_IF,
	EVENT_ID_DONE_PDS_PENDING_FOR_TX_MANAGER,
	EVENT_ID_TX_LIST_READY_PDS_LOW_PRI_NOT_EMPTY,
	EVENT_ID_TX_LIST_READY_PDS_HIGH_PRI_NOT_EMPTY,
	EVENT_ID_TX_IN_MANGEMENT_COUNT_NOT_EMPTY,
	EVENT_ID_RX_IN_MANGEMENT_COUNT_NOT_EMPTY,
	EVENT_ID_RX_RD_LIST_NOT_EMPTY,
	EVENT_ID_DMA_HOST_IF_DONE,
	EVENT_ID_DMA_FORWARD,
	EVENT_ID_DMA_HDK_BAND0,
	EVENT_ID_DMA_HDK_BAND1,
	EVENT_ID_MC_DATA_INT,
	EVENT_ID_CLASS_VIOLATION,
	EVENT_ID_FRAGMENT_FIFO_NOT_EMPTY,
	EVENT_ID_PS_SETTING_FIFO_NOT_EMPTY,
	EVENT_ID_PHY_HW_EVENT,
	EVENT_ID_RXF_FIFO_NOT_EMPTY,
	EVENT_ID_RX_CLASSIFIER_RXH_AVAILABLE_PENDING_RTD,
	EVENT_ID_SEQUENCER_REPORTS_FIFO_NOT_EMPTY,	
	EVENT_ID_BAA_REPORTS_FIFO_NOT_EMPTY,
	EVENT_ID_PD_THRESHOLD_REACHED,
	EVENT_ID_TX_DISABLED_QUEUES_NOT_EMPTY,
	EVENT_ID_METRICS_FIFO_NOT_EMPTY,
	EVENT_ID_FW_STAT_DMA_DONE,
	EVENT_ID_ERP_BSS_TX,
#ifdef ATOMIC_COUNTER_ENABLER	
	EVENT_ID_MAILBOX_NOT_EMPTY,
#endif	
    NUM_OF_EVENT_IDS,
    MAX_EVENT_IDS = MAX_UINT8
}eventId_e;

typedef enum eventType
{
	EVENT_TYPE_SW_EVENT,
	EVENT_TYPE_HW_INT,
	EVENT_TYPE_HW_EVENT,
	EVENT_TYPE_SHRAM_INT,
	EVENT_TYPE_RAB_NPU_INT,
	EVENT_TYPE_RAB_UPI_INT,
	EVENT_TYPE_RAB_PHI_INT,
	EVENT_TYPE_RAB_LPI_INT,
	EVENT_TYPE_ERROR,
    NUM_OF_EVENT_TYPES,
    MAX_EVENT_TYPES = MAX_UINT8
}eventType_e;

#endif // ENET_INC_ARCH_WAVE600

typedef enum sendSwEventStatus
{
	SW_EVENT_STATUS_DISABLE,
	SW_EVENT_STATUS_TRIGGERED,
    NUM_OF_SW_EVENT_STATUSES,
    MAX_SW_EVENT_STATUS = MAX_UINT8
}sendSwEventStatus_e;





typedef struct EventDetails
{
	eventStatus_e	status;
	eventType_e 	eventType;
	uint8 			eventData;
	bool 			triggerOnEnable;
	uint16 			taskId;
    uint16 			msgId;
} EventDetails_t;


//---------------------------------------------------------------------------------
//						Externs						
//---------------------------------------------------------------------------------


extern EventDetails_t EventsDb[];


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------



void EventManager_TurnOnEvent(eventId_e eventId);
void EventManager_TurnOffEvent(eventId_e eventId);
sendSwEventStatus_e EventManager_TriggerSwEvent(eventId_e eventId);
void EventManager_TriggerIntEmulator(eventId_e eventId);
void EventManager_DoNothing(uint32 eventData);
void EventManager_illegalEvent(uint32 eventData);
void EventManager_MaskInterrupt(uint32 eventData);
void EventManager_UnMaskInterrupt(uint32 eventData);
void EventManager_DisableSharedRamInt(uint32 eventData);
void EventManager_EnableSharedRamInt(uint32 eventData);
void EventManager_DisableNpuRabInt(uint32 eventData);
void EventManager_EnableNpuRabInt(uint32 eventData);
void EventManager_DisableUpiRabInt(uint32 eventData);
void EventManager_EnableUpiRabInt(uint32 eventData);
void EventManager_DisablePhiRabInt(uint32 eventData);
void EventManager_EnablePhiRabInt(uint32 eventData);
void EventManager_DisableLpiRabInt(uint32 eventData);
void EventManager_EnableLpiRabInt(uint32 eventData);
void EventManager_EnableSwEventHandler(uint32 eventData);
void EventManager_SetTriggerOnEnable(eventId_e eventId);

#if defined(ENET_INC_ARCH_WAVE600)
void EventManager_MaskHwEvent_A_Band0(uint32 eventData);
void EventManager_MaskHwEvent_B_Band0(uint32 eventData);
void EventManager_MaskHwEvent_A_Band1(uint32 eventData);
void EventManager_MaskHwEvent_B_Band1(uint32 eventData);
void EventManager_MaskHwEvent_Common_A(uint32 eventData);
void EventManager_UnMaskHwEvent_A_Band0(uint32 eventData);
void EventManager_UnMaskHwEvent_B_Band0(uint32 eventData);
void EventManager_UnMaskHwEvent_A_Band1(uint32 eventData);
void EventManager_UnMaskHwEvent_B_Band1(uint32 eventData);
void EventManager_UnMaskHwEvent_Common_A(uint32 eventData);

#else

void EventManager_MaskHwEvent(uint32 eventData);
void EventManager_UnMaskHwEvent(uint32 eventData);

#endif


#endif /* EVENTS_MANAGER_API_H_ */
