/***********************************************************************************
 File:		eventsManager.c
 Module:		Events Manager
 Purpose: 		
 Description:	
				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/

#include "EventsManager_api.h"
#include "InterruptManager_Api.h"
#include "HwEventsAndErrors_Api.h"
#include "ErrorHandler_Api.h"
#include "InterruptManager_Api.h"
#include "shram_interruptSection.h"
#include "OSAL_Tasks.h"
#include "loggerAPI.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_EVENTS_MANAGER
#define LOG_LOCAL_FID 1


/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

typedef struct EventTypeHandlers
{
	EventsManagerGeneralFunc eventEnableHandler;
	EventsManagerGeneralFunc eventDisableHandler;	
} EventTypeHandlers_t;


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

EventTypeHandlers_t eventsHandler[NUM_OF_EVENT_TYPES] =
	{
		{EventManager_EnableSwEventHandler,		EventManager_DoNothing}, 			// EVENT_TYPE_SW_EVENT
		{EventManager_UnMaskInterrupt, 			EventManager_MaskInterrupt},   		// EVENT_TYPE_HW_INT
		{EventManager_UnMaskHwEvent_A_Band0,	EventManager_MaskHwEvent_A_Band0},	// EVENT_TYPE_HW_EVENT_A_BAND0
		{EventManager_UnMaskHwEvent_A_Band1,	EventManager_MaskHwEvent_A_Band1},	// EVENT_TYPE_HW_EVENT_A_BAND1
		{EventManager_UnMaskHwEvent_B_Band0,	EventManager_MaskHwEvent_B_Band0},	// EVENT_TYPE_HW_EVENT_B_BAND0
		{EventManager_UnMaskHwEvent_B_Band1,	EventManager_MaskHwEvent_B_Band1},	// EVENT_TYPE_HW_EVENT_B_BAND1
		{EventManager_UnMaskHwEvent_Common_A,	EventManager_MaskHwEvent_Common_A},	// EVENT_TYPE_HW_EVENT_COMMON_A
		{EventManager_EnableSharedRamInt, 		EventManager_DisableSharedRamInt}, 	// EVENT_TYPE_SHRAM_INT
		{EventManager_EnableNpuRabInt, 			EventManager_DisableNpuRabInt},		// EVENT_TYPE_RAB_NPU_INT
		{EventManager_EnableUpiRabInt, 			EventManager_DisableUpiRabInt}, 	// EVENT_TYPE_RAB_UPI_INT
		{EventManager_EnablePhiRabInt, 			EventManager_DisablePhiRabInt}, 	// EVENT_TYPE_RAB_PHI_INT
		{EventManager_EnableLpiRabInt, 			EventManager_DisableLpiRabInt},		// EVENT_TYPE_RAB_LPI_INT		
		{EventManager_illegalEvent, 			EventManager_illegalEvent}			// EVENT_TYPE_ERROR
	};


/* Compiles for both lower and upper CPUs. */
EventDetails_t EventsDb[NUM_OF_EVENT_IDS] = 
{
#if defined(ENET_INC_UMAC)
		{EVENT_STATUS_ENABLE, 	EVENT_TYPE_SW_EVENT,   			EVENT_ID_DESCRIPTORS_PENDING_FOR_HOST_IF,		  FALSE, TASK_HIM,                  HIM_DESCRIPTORS_ON_DONE_LISTS}, 	// EVENT_ID_DESCRIPTORS_PENDING_FOR_HOST_IF
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_COMMON_A,	HW_EVENT_TX_DONE_LISTS,					  		  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_TX_DONE_LISTS
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_COMMON_A,	HW_EVENT_Q_MANAGER_LOW_PRI_TX_READY,			  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_TX_LIST_READY_PDS_LOW_PRI_NOT_EMPTY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_COMMON_A,	HW_EVENT_HIGH_PRI_TX_PD_READY,					  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_TX_LIST_READY_PDS_HIGH_PRI_NOT_EMPTY	
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_TX_IN_MNGMNT_COUNT_NOT_EMPTY,		  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_TX_IN_MANGEMENT_COUNT_NOT_EMPTY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_RX_IN_MNGMNT_COUNT_NOT_EMPTY,		  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_RX_IN_MANGEMENT_COUNT_NOT_EMPTY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_COMMON_A,	HW_EVENT_HIGH_PRI_RX_PD_READY,					  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_HIGH_PRI_RX_PD_READY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_SW_EVENT,			EVENT_ID_DMA_HOST_IF_DONE,						  FALSE, TASK_HIM,					HIM_RINGS_DMA_DONE},				// EVENT_ID_DMA_HOST_IF_DONE
#else // LOWER_MAC_CPU
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_DESCRIPTORS_PENDING_FOR_HOST_IF,		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_DESCRIPTORS_PENDING_FOR_HOST_IF
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				HW_EVENT_TX_DONE_LISTS,		  			  		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_TX_DONE_LISTS
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				HW_EVENT_Q_MANAGER_LOW_PRI_TX_READY,			  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_TX_LIST_READY_PDS_LOW_PRI_NOT_EMPTY
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				HW_EVENT_HIGH_PRI_TX_PD_READY,		  			  FALSE, (uint32)NULL,				(uint32)NULL},	                    // EVENT_ID_TX_LIST_READY_PDS_HIGH_PRI_NOT_EMPTY
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_TX_IN_MANGEMENT_COUNT_NOT_EMPTY,		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_TX_IN_MANGEMENT_COUNT_NOT_EMPTY
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_RX_IN_MANGEMENT_COUNT_NOT_EMPTY,		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_RX_IN_MANGEMENT_COUNT_NOT_EMPTY
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				HW_EVENT_HIGH_PRI_RX_PD_READY,			  		  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_HIGH_PRI_RX_PD_READY_BAND0
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_DMA_HOST_IF_DONE,						  FALSE, (uint32)NULL,				(uint32)NULL},	                    // EVENT_ID_DONE_PDS_PENDING_FOR_TX_MANAGER
#endif
#if defined(ENET_INC_UMAC)/* && !defined (HDK_REL_2_0) */
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_SW_EVENT,			EVENT_ID_DMA_FORWARD,							  FALSE, TASK_RX_MANAGER,			RX_MANAGER_DMA_COMPLETED},	        // EVENT_ID_DMA_FORWARD
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_SW_EVENT,			EVENT_ID_DMA_HDK_BAND0,							  FALSE, TASK_HDK_CDB_MANAGER,		HDK_CDB_MAN_CHUNK_DMA_COMPLETE_BAND0}, // EVENT_ID_DMA_HDK_BAND0
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_SW_EVENT,			EVENT_ID_DMA_HDK_BAND1, 						  FALSE, TASK_HDK_CDB_MANAGER,		HDK_CDB_MAN_CHUNK_DMA_COMPLETE_BAND1}, // EVENT_ID_DMA_HDK_BAND1
#else // LOWER_MAC_CPU
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_DMA_FORWARD,						  	  FALSE, (uint32)NULL,				(uint32)NULL},	                    // EVENT_ID_DMA_FORWARD
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_DMA_HDK_BAND0,							  FALSE, (uint32)NULL,				(uint32)NULL},                      // EVENT_ID_DMA_HDK_BAND0
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_DMA_HDK_BAND1, 						  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_DMA_HDK_BAND1

#endif
		{EVENT_STATUS_ENABLE, 	EVENT_TYPE_HW_EVENT_COMMON_A,	HW_EVENT_RAB_NPU_TO_UPI_IRQ,					  FALSE, (uint32)NULL,			    (uint32)NULL}, 	                    // EVENT_ID_MC_DATA_INT
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_A_BAND0,	HW_EVENT_RX_COORDINATOR_FRAME_CLASS_VIOLATION,	  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_CLASS_VIOLATION_BAND0
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_A_BAND1,	HW_EVENT_RX_COORDINATOR_FRAME_CLASS_VIOLATION,	  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_CLASS_VIOLATION_BAND1
		{EVENT_STATUS_ENABLE, 	EVENT_TYPE_HW_EVENT_COMMON_A, 	HW_EVENT_RXPP_FRAGMENT_FIFO_NOT_EMPTY,			  FALSE, (uint32)NULL,			    (uint32)NULL},                   	// EVENT_ID_FRAGMENT_FIFO_NOT_EMPTY
#if defined(ENET_INC_LMAC)
#if defined(ENET_INC_LMAC0)
		{EVENT_STATUS_ENABLE, 	EVENT_TYPE_HW_EVENT_A_BAND0,	HW_EVENT_PS_SETTING_FIFO_NOT_EMPTY,				  FALSE, (uint32)NULL,			    (uint32)NULL},                  	// EVENT_ID_PS_SETTING_FIFO_NOT_EMPTY
#endif
#if defined(ENET_INC_LMAC1)
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_A_BAND1,	HW_EVENT_PS_SETTING_FIFO_NOT_EMPTY, 			  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_PS_SETTING_FIFO_NOT_EMPTY
#endif
#else // UMAC
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				HW_EVENT_PS_SETTING_FIFO_NOT_EMPTY, 			  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_PS_SETTING_FIFO_NOT_EMPTY
#endif

		{EVENT_STATUS_ENABLE, 	EVENT_TYPE_HW_EVENT_COMMON_A, 	HW_EVENT_RXF_FIFO_NOT_EMPTY,					  FALSE, (uint32)NULL,			    (uint32)NULL}, 	                    // EVENT_ID_RXF_FIFO_NOT_EMPTY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_A_BAND0,	HW_EVENT_RX_AMSDU_PARSER_MSDU_DESC_NOT_EMPTY,	  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_RX_AMSDU_PARSER_MSDU_DESC_NOT_EMPTY_BAND0
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_A_BAND1,	HW_EVENT_RX_AMSDU_PARSER_MSDU_DESC_NOT_EMPTY,	  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_RX_AMSDU_PARSER_MSDU_DESC_NOT_EMPTY_BAND1
#if defined(ENET_INC_LMAC)
#if defined(ENET_INC_LMAC0)
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_SEQUENCER_FIFO_NOT_EMPTY_BAND0,		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_SEQUENCER_REPORTS_FIFO_NOT_EMPTY	
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_BAA_RA_FIFO_NOT_EMPTY_BAND0,			  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_BAA_REPORTS_FIFO_NOT_EMPTY	
#endif
#if defined(ENET_INC_LMAC1)
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_SEQUENCER_FIFO_NOT_EMPTY_BAND1,		  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_SEQUENCER_REPORTS_FIFO_NOT_EMPTY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_BAA_RA_FIFO_NOT_EMPTY_BAND1,			  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_BAA_REPORTS_FIFO_NOT_EMPTY
#endif
#else // UMAC
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_SEQUENCER_REPORTS_FIFO_NOT_EMPTY,		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // MAPPED_INT_SEQUENCER_FIFO_NOT_EMPTY
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_BAA_REPORTS_FIFO_NOT_EMPTY,			  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_BAA_REPORTS_FIFO_NOT_EMPTY				
#endif //ENET_INC_LMAC
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_COMMON_A,	HW_EVENT_PD_THRESHOLD_REACHED, 					  FALSE, (uint32)NULL,				(uint32)NULL},	                    // EVENT_ID_PD_THRESHOLD_REACHED			
#if defined(ENET_INC_UMAC)
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_EVENT_COMMON_A,	HW_EVENT_Q_MANAGER_DISABLE_LIST_NON_EMPTY_UMAC,	  FALSE, (uint32)NULL,				(uint32)NULL},	 					// EVENT_ID_TX_DISABLED_QUEUES_NOT_EMPTY			
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_SW_EVENT,			EVENT_ID_METRICS_FIFO_NOT_EMPTY,				  FALSE, TASK_STATISTICS_MANAGER,	STATISTICS_MANAGER_PHY_STAT_METRICS_FIFO_NOT_EMPTY}, // EVENT_ID_METRICS_FIFO_NOT_EMPTY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_SW_EVENT,			EVENT_ID_FW_STAT_DMA_DONE,						  FALSE, TASK_STATISTICS_MANAGER,	STATISTICS_MANAGER_FW_STAT_DMA_DONE}, // EVENT_ID_FW_STAT_DMA_DONE
#else // LOWER_MAC_CPU
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				HW_EVENT_Q_MANAGER_DISABLE_LIST_NON_EMPTY_UMAC,	  FALSE, (uint32)NULL,				(uint32)NULL},	 // EVENT_ID_TX_DISABLED_QUEUES_NOT_EMPTY			
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_METRICS_FIFO_NOT_EMPTY,				  FALSE, (uint32)NULL,		(uint32)NULL}, // EVENT_ID_METRICS_FIFO_NOT_EMPTY
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_FW_STAT_DMA_DONE,				 	      FALSE, (uint32)NULL,		(uint32)NULL}, // EVENT_ID_FW_STAT_DMA_DONE
#endif
#if defined(ENET_INC_LMAC)
#if defined(ENET_INC_LMAC0)
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_ULPR_FIFO_NOT_EMPTY_BAND0,			  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_ULPR_FIFO_NOT_EMPTY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_PRE_AGG_FIFO_NOT_EMPTY_BAND0,		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_PRE_AGG_FIFO_NOT_EMPTY
#endif
#if defined(ENET_INC_LMAC1)
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_ULPR_FIFO_NOT_EMPTY_BAND1,			  FALSE, (uint32)NULL,				(uint32)NULL},						// EVENT_ID_ULPR_FIFO_NOT_EMPTY
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_PRE_AGG_FIFO_NOT_EMPTY_BAND1,		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_PRE_AGG_FIFO_NOT_EMPTY
#endif
#else // UMAC
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_ULPR_FIFO_NOT_EMPTY,			  		  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_ULPR_FIFO_NOT_EMPTY		
		{EVENT_STATUS_DISABLE,	EVENT_TYPE_ERROR,				EVENT_ID_PRE_AGG_FIFO_NOT_EMPTY,				  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_PRE_AGG_FIFO_NOT_EMPTY	
#ifdef ATOMIC_COUNTER_ENABLER		
		{EVENT_STATUS_ENABLE,	EVENT_TYPE_HW_INT,				MAPPED_INT_HOST_MAILBOX_NOT_EMPTY,				  FALSE, (uint32)NULL,			    (uint32)NULL},	                    // EVENT_ID_MAILBOX_NOT_EMPTY
#endif

#endif

};


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/


void EventManager_TurnOnEvent(eventId_e eventId)
{
	eventType_e eventType;
	uint8 eventData;
	
	EventsDb[eventId].status = EVENT_STATUS_ENABLE;
	eventType = EventsDb[eventId].eventType;
	eventData = EventsDb[eventId].eventData;

	eventsHandler[eventType].eventEnableHandler(eventData);
}

void EventManager_TurnOffEvent(eventId_e eventId)
{
	eventType_e eventType;
	uint8 eventData;
	
	EventsDb[eventId].status = EVENT_STATUS_DISABLE;
	eventType = EventsDb[eventId].eventType;
	eventData = EventsDb[eventId].eventData;

	eventsHandler[eventType].eventDisableHandler(eventData);

}

void EventManager_SetTriggerOnEnable(eventId_e eventId)
{
	EventsDb[eventId].triggerOnEnable = TRUE;
}

sendSwEventStatus_e EventManager_TriggerSwEvent(eventId_e eventId)
{

	sendSwEventStatus_e sendSwEventStatus = SW_EVENT_STATUS_DISABLE; 
	if (EventsDb[eventId].status == EVENT_STATUS_ENABLE)
	{
		EventsDb[eventId].status = EVENT_STATUS_DISABLE;
		sendSwEventStatus = SW_EVENT_STATUS_TRIGGERED;
		OSAL_SEND_NO_DATA_MESSAGE(EventsDb[eventId].msgId , EventsDb[eventId].taskId,VAP_ID_DO_NOT_CARE);
	}
	return sendSwEventStatus;
}

void EventManager_TriggerIntEmulator(eventId_e eventId)
{
	UNUSED_PARAM(eventId);	
	ASSERT(0);
}

void EventManager_DoNothing(uint32 eventData)
{
	UNUSED_PARAM(eventData);
}

void EventManager_illegalEvent(uint32 eventData)
{
	UNUSED_PARAM(eventData);	
	ASSERT(0);
}


void EventManager_MaskInterrupt(uint32 eventData)
{
	InterruptManager_MaskInterrupt((MappedIntId_e)eventData);
}


void EventManager_UnMaskInterrupt(uint32 eventData)
{
	InterruptManager_UnMaskInterrupt((MappedIntId_e)eventData);
}

void EventManager_MaskHwEvent_A_Band0(uint32 eventData)
{
	HwEvents_MaskEvent_A_Band0((HwEventIdBandRelA_e)eventData);
}

void EventManager_MaskHwEvent_A_Band1(uint32 eventData)
{
	HwEvents_MaskEvent_A_Band1((HwEventIdBandRelA_e)eventData);
}

void EventManager_MaskHwEvent_B_Band0(uint32 eventData)
{
	HwEvents_MaskEvent_B_Band0((HwEventIdBandRelB_e)eventData);
}

void EventManager_MaskHwEvent_B_Band1(uint32 eventData)
{
	HwEvents_MaskEvent_B_Band1((HwEventIdBandRelB_e)eventData);
}

void EventManager_MaskHwEvent_Common_A(uint32 eventData)
{
	HwEvents_MaskEvent_Common_A((HwEventIdCommonA_e)eventData);
}


void EventManager_UnMaskHwEvent_A_Band0(uint32 eventData)
{
	HwEvents_UnMaskEvent_A_Band0((HwEventIdBandRelA_e)eventData);
}

void EventManager_UnMaskHwEvent_A_Band1(uint32 eventData)
{
	HwEvents_UnMaskEvent_A_Band1((HwEventIdBandRelA_e)eventData);
}

void EventManager_UnMaskHwEvent_B_Band0(uint32 eventData)
{
	HwEvents_UnMaskEvent_B_Band0((HwEventIdBandRelB_e)eventData);
}

void EventManager_UnMaskHwEvent_B_Band1(uint32 eventData)
{
	HwEvents_UnMaskEvent_B_Band1((HwEventIdBandRelB_e)eventData);
}

void EventManager_UnMaskHwEvent_Common_A(uint32 eventData)
{
	HwEvents_UnMaskEvent_Common_A((HwEventIdCommonA_e)eventData);
}




void EventManager_DisableSharedRamInt(uint32 eventData)
{
#if defined(ENET_INC_UMAC)
	SharedRamInt_DisableInt((ShRamIntIsr_e)eventData);
#else
	UNUSED_PARAM(eventData);
	ASSERT(0);
#endif
}


void EventManager_EnableSharedRamInt(uint32 eventData)
{
#if defined(ENET_INC_UMAC)
	SharedRamInt_EnableInt((ShRamIntIsr_e)eventData);
#else
	UNUSED_PARAM(eventData);
	ASSERT(0);
#endif	
}


void EventManager_DisableNpuRabInt(uint32 eventData)
{
	InterruptManager_DisableNpuRabInt((uint8)eventData);
}


void EventManager_EnableNpuRabInt(uint32 eventData)
{
	InterruptManager_EnableNpuRabInt((uint8)eventData);
}

void EventManager_DisableUpiRabInt(uint32 eventData)
{
	InterruptManager_DisableUpiRabInt((uint8)eventData);
}


void EventManager_EnableUpiRabInt(uint32 eventData)
{
	InterruptManager_EnableUpiRabInt((uint8)eventData);
}

void EventManager_DisablePhiRabInt(uint32 eventData)
{
	InterruptManager_DisablePhiRabInt((uint8)eventData);
}


void EventManager_EnablePhiRabInt(uint32 eventData)
{
	InterruptManager_EnablePhiRabInt((uint8)eventData);
}


void EventManager_DisableLpiRabInt(uint32 eventData)
{
	InterruptManager_DisableLpiRabInt((uint8)eventData);
}


void EventManager_EnableLpiRabInt(uint32 eventData)
{
	InterruptManager_EnableLpiRabInt((uint8)eventData);
}

void EventManager_EnableSwEventHandler(uint32 eventData)
{
	if (EventsDb[eventData].triggerOnEnable == TRUE)
	{
		EventsDb[eventData].triggerOnEnable = FALSE;
		
		EventsDb[eventData].status = EVENT_STATUS_DISABLE;
		
		OSAL_SEND_NO_DATA_MESSAGE(EventsDb[eventData].msgId , EventsDb[eventData].taskId, VAP_ID_DO_NOT_CARE);		
	}
}

