/***********************************************************************************
 File:			GidmManager_Api.h
 Module:		Group Id Management Action Frame Manager 
 Purpose: 		To handle Transmission of Group Id Management Action Frames
				for Multi-User MIMO transmissions
 Description:	
************************************************************************************/
#ifndef GIDM_MANAGER_API_H_
#define GIDM_MANAGER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "PacketDescriptor.h"
#include "frame.h"
#include "OSAL_Kmsg.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

typedef enum
{
	GIDM_STATUS_FRAME_TRANSMITTED,
	GIDM_STATUS_FRAME_DISCARDED,		
}	gidmTxStatus_e;

typedef enum
{
	GIDM_STOP_REASON_REMOVE_STA,
	GIDM_STOP_REASON_TIMEOUT,		
}	gidmStopReason_e;


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _GidmManagerStopTxReq_t
{
	StaId 				staIndex;
	gidmStopReason_e	stopReason;
} GidmManagerStopTxReq_t;

typedef struct _GidmManagerPacketConfirmed_t
{
	TxPd_t *pd;
} GidmManagerPacketConfirmed_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void gidmManager_SendGidmFrame(StaId stationIndex, TxPd_t* pPd);
void GidmManagerStartTxReq(StaId *stationIndex);
void GidmManagerStopTxReq(GidmManagerStopTxReq_t *stopTxParams);
void gidmManagerStaLockCfm(K_MSG* gidmManagerMessage);
void gidmManagerTxCfm(K_MSG* gidmManagerMessage);
void gidmManagerPdAllocated(K_MSG* gidmManagerMessage);
void gidmManagerHandleRxActionFrame(GroupIdManagementPayload_t* gidmFramePayload, uint8 vapIndex);
void gidmManager_Init(void);

#endif /* GIDM_MANAGER_API_H_ */




