/***********************************************************************************
 File:			GidmManager.h
 Module:		Group ID Management Action Frame Manager
 Purpose: 		To handle Transmission of GID Management Action Frames for
				Multi-User MIMO transiossion.
 Description:	
************************************************************************************/
#ifndef GIDM_MANAGER_H_
#define GIDM_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

// GIDM Manager events
typedef enum
{
	GIDM_MANAGER_EVENT_START_TX_REQ,	// 0x0
	GIDM_MANAGER_EVENT_STOP_TX_REQ,		// 0x1
	GIDM_MANAGER_EVENT_TX_CFM,			// 0x2
	GIDM_MANAGER_EVENT_PD_ALLOCATED,	// 0x3
	GIDM_MANAGER_EVENT_LOCK_CONFIRMED,	// 0x4
	GIDM_MANAGER_EVENT_NUM_EVENTS		// 0x5
} gidmManagerEvents_e;
	
//GIDM Manager states
typedef enum
{
	GIDM_MANAGER_STATE_IDLE,						// 0x0
	GIDM_MANAGER_STATE_WAIT_TX_CFM,					// 0x1
	GIDM_MANAGER_STATE_WAIT_FOR_PD,					// 0x2
	GIDM_MANAGER_STATE_WAIT_FOR_PD_PENDING_STOP,	// 0x3
	GIDM_MANAGER_STATE_WAIT_FOR_LOCK,				// 0x4
	GIDM_MANAGER_STATE_WAIT_FOR_LOCK_PD_CONFIRMED,	// 0x5
	GIDM_MANAGER_STATE_NUM_STATES,					// 0x6
	GIDM_MANAGER_MAX_STATE = 0xFF					
} gidmManagerStates_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _GidmStaManagerDb_t
{
#if defined(ENET_INC_ARCH_WAVE600)	
	uint32				pdOffset;
	uint16				requestId;
	gidmManagerStates_e	state;
	uint8				stopRequested;
	gidmStopReason_e	stopReason;
	uint8               reserved[3];
#else
	uint16				pdOffset;
	uint16				requestId;
	gidmManagerStates_e state;
	uint8				stopRequested;
	gidmStopReason_e	stopReason;
	uint8				reserved;
#endif
} GidmStaManagerDb_t;


typedef struct _GidmManagerDb_t
{
	GidmStaManagerDb_t staDb[HW_NUM_OF_STATIONS];
} GidmManagerDb_t;



// Function pointer 
typedef void (*GidmManager_Func)(void *parameter);


// GIDM State Machine
typedef struct _GidmManagerSm_t
{
	GidmManager_Func handler[GIDM_MANAGER_EVENT_NUM_EVENTS];	
} GidmManagerSm_t;



//---------------------------------------------------------------------------------
//						Static Function Declaration				
//---------------------------------------------------------------------------------

void GidmManager_RunStateMachine(gidmManagerEvents_e event, StaId staIndex, void *parameter);
void GidmManager_ChangeState(StaId staIndex, gidmManagerStates_e state);
void GidmManager_IllegalEvent(void *parameter);
void GidmManager_StartTx(void *parameter);
void GidmManager_StopInWaitTxCfm(void *parameter);
void GidmManager_StopInWaitForPd(void *parameter);
void GidmManager_TxCfm(void *parameter);
void GidmManager_TxCfmInWaitForLock(void *parameter);
void GidmManager_PdAllocatedInWaitforPd(void *parameter);
void GidmManager_PdAllocatedInPendingStop(void *parameter);
void GidmManager_LockCfmInWaitForLock(void *parameter);
void GidmManager_LockCfmInWaitLockPdConfirmed(void *parameter);
bool GidmManager_RemovePdFromQueue(StaId staIndex, TxPd_t* pGidmPd);

#endif /* GIDM_MANAGER_H_ */
