/***************************************************************
 File:		  GroupDatabase_Api.h
 Module:	  	  GroupDatabase
 Purpose: 	 
 Description:     This module is the API to the Group database module. Calls that access Group database parameters 
 			  should be made through the api functions located in this file. Direct access(Not through the api) to the
 			  VAP database parameters is not permitted.
***************************************************************/
#ifndef GroupDatabase_Api_H_
#define GroupDatabase_Api_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"

#include "mhi_ieee_address.h"
#include "database.h"
#include "SharedDbTypes.h"
#include "ShramSecurity.h"
#include "Std.h"
#include "GroupDb.h"
#include "GroupManager_API.h"
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Defines 					
//---------------------------------------------------------------------------------

#define MAX_STATION_IN_GROUP			(4)


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef struct GroupDbSwInfo
{
	uint32 reserved; //just place holder - need to be replaced with real fields;
} GroupDbSwInfo_t;

typedef enum GroupDbPpduTxMode
{
	GROUP_DB_PPDU_TX_MODE_LEGACY_ONLY = 0,
	GROUP_DB_PPDU_TX_MODE_LEGACY_AND_MPDU,
	GROUP_DB_PPDU_TX_MODE_TWO_LEVEL_AGGR = 3,
}	GroupDbPpduTxMode_e;



typedef enum GroupDbDataTransmissionType
{
	GROUP_DB_DATA_TX_TYPE_TRANSMIT_FULL_BAR_DATA_SEQ = 0, /*After data transmission BAR sent for each station and station returns with BA*/
	GROUP_DB_DATA_TX_TYPE_TRANSMIT_IMMEDIATE_BA_ONLY, 
}	GroupDbDataTransmissionType_e;


typedef struct GroupDbObject
{
	uint8  		  numOfActivatedGroups;
	GroupDbSwInfo_t groupDbSwEntries[TX_MU_GROUPS];
	MuGrpDb_t*      pGroupDbHwEntries; // [NUM_GROUP_DBASE_ENTRIES];
} GroupDbObject_t;



//---------------------------------------------------------------------------------
//						Globals
//---------------------------------------------------------------------------------




//---------------------------------------------------------------------------------
//						Public Function Declaration 			
//---------------------------------------------------------------------------------


RetVal_e GroupDB_Init(void);
void GroupDb_SetTxPpduModePerUspInGroup(uint8 groupId, uint8 usp, GroupDbPpduTxMode_e ppduTxMode);
void GroupDb_FillGroupParams(uint8 groupId, uint8 numOfStations, StaId* staIds, uint8* nssPerUsp, int8 mcsPerUsp[][MAX_STATION_IN_GROUP]);
void GroupDb_UpdateMuGroupTxopMode(uint8 groupId, bool txopMode);


#endif //  GroupDatabase_Api_H_
	

