/***************************************************************
 File:		  GroupDatabaseTest.c
 Module:	  	  GroupDatabase Test
 Purpose: 	 
 Description:     This module is the API to the dut module which is responsible for handling, 
			  processing and executing all requests sent from the applications (Dut_Gui, Litepoint) 
			  outside the chip during the production procedure
***************************************************************/

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "Wave500_Test.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Globals					
//---------------------------------------------------------------------------------

TxPd_t TestPdArray[TEST_PD_MAX];        // test packet descriptors array 
TxParams_t TxParamsArray[TX_PARAMS_MAX];	  // test TX parameterss array 

//---------------------------------------------------------------------------------
//						Function implementation				
//--------------------------------------------------------------------------------

void Wave500_Test_ArraysInit()
{
	uint8 i;
	uint16 ssn = 6;
	
	/* packet descriptors array init */
	for (i=0; i < TEST_PD_MAX ; i++)
	{
		TestPdArray[i].retries = 0;
		TestPdArray[i].sequenceControl = ssn << 4;
		TestPdArray[i].status = IN_PROCESS;
		TestPdArray[i].discard = FALSE;
		if (i == (TEST_PD_MAX - 1))
		{
			TestPdArray[i].next = &TestPdArray[0];
		}
		else
		{
			TestPdArray[i].next = &TestPdArray[i+1];
		}
		ssn++;
	}

	ssn = 4050;
	TestPdArray[0].sequenceControl = ssn << 4;
	ssn = 4095;
	TestPdArray[1].sequenceControl = ssn << 4;
	ssn = 4096;
	TestPdArray[2].sequenceControl = ssn << 4;
	ssn = 0;
	TestPdArray[3].sequenceControl = ssn << 4;
	ssn = 17;
	TestPdArray[4].sequenceControl = ssn << 4;
	ssn = 18;
	TestPdArray[5].sequenceControl = ssn << 4;


	/* LEGACY - 1 packet descriptor */
	TxParamsArray[LEGACY_1_PD].bAggregation = FALSE;
	TxParamsArray[LEGACY_1_PD].bBAR = FALSE;
	TxParamsArray[LEGACY_1_PD].pPdListHead = &TestPdArray[0];
	TxParamsArray[LEGACY_1_PD].pPdListTail = &TestPdArray[0];


	/* AGGREGATION - 1 Packet descriptor */
	TxParamsArray[AGGR_1_PD].bAggregation = TRUE;
	TxParamsArray[AGGR_1_PD].bBAR = FALSE;
	TxParamsArray[AGGR_1_PD].pPdListHead = &TestPdArray[0];
	TxParamsArray[AGGR_1_PD].pPdListTail = &TestPdArray[0];

	/* AGGREGATION - 2 Packet descriptor */
	TxParamsArray[AGGR_2_PD].bAggregation = TRUE;
	TxParamsArray[AGGR_2_PD].bBAR = FALSE;
	TxParamsArray[AGGR_2_PD].pPdListHead = &TestPdArray[0];
	TxParamsArray[AGGR_2_PD].pPdListTail = &TestPdArray[1];

	/* AGGREGATION - 3 Packet descriptor */
	TxParamsArray[AGGR_3_PD].bAggregation = TRUE;
	TxParamsArray[AGGR_3_PD].bBAR = FALSE;
	TxParamsArray[AGGR_3_PD].pPdListHead = &TestPdArray[0];
	TxParamsArray[AGGR_3_PD].pPdListTail = &TestPdArray[2];

	
	/* AGGREGATION - 4 Packet descriptor */
	TxParamsArray[AGGR_4_PD].bAggregation = TRUE;
	TxParamsArray[AGGR_4_PD].bBAR = FALSE;
	TxParamsArray[AGGR_4_PD].pPdListHead = &TestPdArray[0];
	TxParamsArray[AGGR_4_PD].pPdListTail = &TestPdArray[3];

	/* AGGREGATION - 5 Packet descriptor */
	TxParamsArray[AGGR_5_PD].bAggregation = TRUE;
	TxParamsArray[AGGR_5_PD].bBAR = FALSE;
	TxParamsArray[AGGR_5_PD].pPdListHead = &TestPdArray[0];
	TxParamsArray[AGGR_5_PD].pPdListTail = &TestPdArray[4];

	/* AGGREGATION - 6 Packet descriptor */
	TxParamsArray[AGGR_6_PD].bAggregation = TRUE;
	TxParamsArray[AGGR_6_PD].bBAR = FALSE;
	TxParamsArray[AGGR_6_PD].pPdListHead = &TestPdArray[0];
	TxParamsArray[AGGR_6_PD].pPdListTail = &TestPdArray[5];

	/* BAR */
	TxParamsArray[BAR].bAggregation = FALSE;
	TxParamsArray[BAR].bBAR = TRUE;
	TxParamsArray[BAR].pPdListHead = &TestPdArray[0];
	TxParamsArray[BAR].pPdListTail = &TestPdArray[0];

}


void Wave500_Test_TxInit(Test_Dctx_t * testDCTX)
{
	Wave500_Test_ArraysInit();
	Wave500_LMWrapper_TestInit(testDCTX, &TxParamsArray[AGGR_6_PD]);
	
	// initialise wrapper, BA descriptors pool, and test arrays containing Tx params and PD list
	Wave500_LMWrapper_Init();
}


