/***************************************************************
 File:		  GroupDatabase_Debug.c
 Module:	  	  Group Database Debug module
 Purpose: 	 
 Description:     This module is the implementation of the Group Database debug module. 
***************************************************************/

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "GroupDatabase_Api.h"
#include "ShramGroupDatabase.h"
#include "GroupDb.h"
#include "stringLibApi.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define LOG_LOCAL_GID   GLOBAL_GID_GROUP_DB
#define LOG_LOCAL_FID 2


typedef enum groupSwDbDebugIds
{
	GROUP_DB_NO_VALID_IDS = 0,

}	groupSwDbDebugIds_e;

typedef enum groupDebugSwHw
{
	GROUP_SW_DB = 0,
	GROUP_HW_DB
}	groupDebugSwHw_e;


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Globals					
//---------------------------------------------------------------------------------

MuGrpDb_t* pDebugGroupDbHwEntries;
GroupDbSwInfo_t* pDebugGroupDbSwEntries;

//---------------------------------------------------------------------------------
//						Private Function Declaration 			
//---------------------------------------------------------------------------------



void GroupDbDebug_init(MuGrpDb_t* pGroupDbHwEntries, GroupDbSwInfo_t* groupDbSwEntries)
{
	pDebugGroupDbHwEntries = pGroupDbHwEntries;
	pDebugGroupDbSwEntries = groupDbSwEntries;
}



