
/****************************************************************************
 ** COMPONENT:      ENET SW
 **
 ** MODULE:         StatisticsManagerPhyDriver.c
 **
 ** DESCRIPTION:    PHY driver for statistics manager
 **
 ****************************************************************************/


/***************************************************************************/
/***                         Include Files                               ***/
/***************************************************************************/
#include "System_GlobalDefinitions.h"
#include "PhyDriver.h"
#include "PhyDriverCommon.h"
#include "PhyDriver_API.h"
#include "Pac_Api.h"
#include "MT_Emerald_Env_regs.h"
#include "MacHtExtensionsRegs.h"
#include "RegAccess_Api.h"
#include "loggerAPI.h"
#include "PhyRxTdIfRiscPage0TdRegs.h"
#include "PhyRxTdIfRiscPage0TxbRegs.h"
#include "HwSemaphore_API.h"
#include "HwGlobalDefinitions.h"

#define LOG_LOCAL_GID   GID_STATISTICS_MANAGER
#define LOG_LOCAL_FID 0

/***************************************************************************/
/***                              Defines                                ***/
/***************************************************************************/

/******************************************************************************/
/***						Type Definition									***/
/******************************************************************************/
typedef struct _PhyMuGroupUspEntry_t
{
	uint32 enable		: 1;
	uint32 userPosition	: 2;
	uint32				: 0;
} PhyMuGroupUspEntry_t;

#define PHY_NUM_OF_MU_GROUPS			(64)

#pragma ghs section bss = ".PHY_MU_GROUP_USP_TABLE"
static volatile PhyMuGroupUspEntry_t PhyMuGroupUspArray[HW_NUM_OF_VAPS][PHY_NUM_OF_MU_GROUPS];
#pragma ghs section bss = default


/***************************************************************************/
/***                     Private Function Prototypes                     ***/
/***************************************************************************/

/***************************************************************************/
/***                         Private Data                                ***/
/***************************************************************************/

/***************************************************************************/
/***                        Private Functions                            ***/
/***************************************************************************/

/**********************************************************************************

PhyDrv_InitMuGroupUsp


Description:
------------


Input:
-----
uint16 vapId
uint16 group
uint16 userPosition
bool   enable/disable

Output:
-------
void	

Returns:
--------
void
	
**********************************************************************************/
void PhyDrv_InitMuGroupUsp(void)
{

	uint32 vapIdx, groupIdx;
	PhyMuGroupUspEntry_t e;

	e.enable = FALSE;
	e.userPosition = 0x0;

	for (vapIdx = 0; vapIdx < HW_NUM_OF_VAPS; vapIdx++)
	{
		for (groupIdx = 0; groupIdx < PHY_NUM_OF_MU_GROUPS; groupIdx++)
		{
			PhyMuGroupUspArray[vapIdx][groupIdx] = e;
		}
	}
}
/**********************************************************************************

PhyDrv_SetMuGroupUsp


Description:
------------


Input:
-----
uint16 vapId
uint16 group
uint16 userPosition
bool   enable/disable

Output:
-------
void	

Returns:
--------
void
	
**********************************************************************************/
void PhyDrv_SetMuGroupUsp(uint16 vapIdx, uint16 groupIdx, uint16 userPosition, bool enable)
{
	PhyMuGroupUspEntry_t e;

	DEBUG_ASSERT((vapIdx < HW_NUM_OF_VAPS) && (groupIdx < PHY_NUM_OF_MU_GROUPS) && (userPosition < 0x4));

	e.enable = enable;
	e.userPosition = userPosition;

	PhyMuGroupUspArray[vapIdx][groupIdx] = e;
}


