
/****************************************************************************
 ** COMPONENT:      ENET SW
 **
 ** MODULE:         StatisticsManagerPhyDriver.c
 **
 ** DESCRIPTION:    PHY driver for statistics manager
 **
 ****************************************************************************/


/***************************************************************************/
/***                         Include Files                               ***/
/***************************************************************************/
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <lmi.h>
#include "mt_cnfg.h"	
#include "RegAccess_Api.h"
#include "PhyRegsIncluder.h"
#include <mt_sysrst.h>
#include "PhyDriver_API.h"
#include "ErrorHandler_Api.h"
#include "RegAccess_Api.h"
#include "PhyRxTdRegs.h"
#ifdef ENET_INC_ARCH_WAVE600D2	
#include "PhyRxtdAnt0Regs.h"
#include "PhyRxtdAnt1Regs.h"
#include "PhyRxtdAnt2Regs.h"
#include "PhyRxtdAnt3Regs.h"
#else
#include "PhyRxTdAnt0Regs.h"
#include "PhyRxTdAnt1Regs.h"
#include "PhyRxTdAnt2Regs.h"
#include "PhyRxTdAnt3Regs.h"
#endif
#include "PhyTxRegs.h"
#include "PhyTxMacEmuRegs.h"
#include "PhyRxTdIfRegs.h"
#include "SharedDbTypes.h"
#include "HwMemoryMap.h"
#include "lib_wrx654_api.h"
#include "loggerAPI.h"
#include "mt_sysdefs.h"
#include "stringLibApi.h"
#include "HwSemaphore_API.h"
#include "HwGlobalDefinitions.h"

#define LOG_LOCAL_GID GID_STATISTICS_MANAGER
#define LOG_LOCAL_FID 3

/***************************************************************************/
/***                              Defines                                ***/
/***************************************************************************/

/***************************************************************************/
/***						Type Definition							     ***/
/***************************************************************************/


/***************************************************************************/
/***                     Private Function Prototypes                     ***/
/***************************************************************************/

/***************************************************************************/
/***                         Private Data                                ***/
/***************************************************************************/
/***						Function definition							 ***/
/***************************************************************************/

/**********************************************************************************

PhyDrv_SetMuGroupUsp


Description:
------------


Input:
-----
uint16 vapId
uint16 group
uint16 userPosition
bool   enable/disable

Output:
-------
void	

Returns:
--------
void
	
**********************************************************************************/
void PhyDrv_SetMuGroupUsp(uint16 vapIdx, uint16 groupIdx, uint16 userPosition, bool enable)
{
	UNUSED_PARAM(vapIdx);	
	UNUSED_PARAM(groupIdx);	
	UNUSED_PARAM(userPosition);	
	UNUSED_PARAM(enable);	
	ASSERT(0); // In gen6 we don't support being beamformee (even not as STA). Need to check why we got here.
}

