#ifndef __HdkTask_h__
#define __HdkTask_h__

#include "OSAL_Api.h"
#include "mhi_umi.h"
#include "Hdk_Api.h"
#include "CalibrationDefs.h"


#define FREQ_JUMP_BW_DB 3
#ifdef DEBUG_LOGGER_ENABLE
#define HDK_DEBUG_LOGGER
#endif
#define STA_CONNECTION_TIMEOUT_SEC		(10)

typedef enum ErpStaStat
{
	ERP_STA_NOT_CONNECTED			= 0,
	ERP_STA_CONNECTED_UNTRIGGERED	= 1,
	ERP_STA_CONNECTED_TRIGGERED		= 2
	
}ErpStaStat_e;

typedef struct SetChannelParams
{
	HdkSetChannelReqParams_t setChannelReqParams;
	uint32 calibrationBufferBaseAddress;
	uint8 mode;
	uint8 band;
	bool  isBwChanged; 
	uint8 txAntMask;
	uint8 txAntSelectionMask;
	uint8 rxAntMask;
	uint8 rxAntSelectionMask;
	uint8 txAntMaskOrig;	
	uint8 txAntSelectionMaskOrig;
	uint8 rxAntMaskOrig;	
	uint8 rxAntSelectionMaskOrig;
	uint8 ZwdfsAntMask;
	
} SetChannelParams_t;

/* HDK State Machines States */

typedef struct
{
	uint8 requestedProcessesBitmap;
	HdkProcessState_e state;
	HdkProcess_e processId;
} HdkProcess_t;

typedef struct
{
	HdkState_e hdkMainSmState;
	SetChannelState_e setChannelSmState;
	HdkProcess_t hdkProcessParams;
	HdkFreqJumpState_e freqJumpSmState;
	HdkOfflineCalState_e hdkOfflineCalState;
	HdkAntConfigState_e hdkAntConfigurationState;
} HdkSmStates_t;


typedef struct
{
	K_MSG *pMsg;				/*Since disable request may not be confirmed immediately, we need to store the message*/
	uint32 vapBitMap;			/*Bitmap of connected VAPs, ERP registers with Post VAP activation and Remove VAP whicha re not symetrc, e.g. VAP may be removed before reaching Post VAP activation is reached*/
	uint32 StartRfOnTsf;		/*Debug capture Tsf for start RF on timer*/
	uint32 StartRfOffTsf;		/*Debug capture Tsf for start RF off timer*/
	uint32 conectionTimerTsf;	/*Since we restart the connection timer in some cases we need to know if the timer event we get is not a pending one*/
	uint32 connectionTimeOut;	/*Wait for connection timeout, if 0, feature is disabled*/
	uint16 erpRfOnTimeout;		/*input configuration RF on timer [msec] */
	uint16 erpRfOffTimeOut;		/*input configuration RF off timer [msec] */
	uint8  numberOfStations;	/*counter for number of connected STA to the radio*/
	uint8  numberOfStaTh;		/*input configuration of the number of STA threshold inwhich the radio dutycycle will be disabled.*/
	ERPState_e erpSmState;		/* ERP machine current state*/ 
	ErpStaStat_e status;		/* ERP connected STA status inorder to handle the number of connected STA user input threshold in the code */ 
} erpDB_t;


typedef struct
{
	K_MSG 	*pMsg;	
	uint32  StartTsCts2self;
	uint32  StartTsRfOff;
	uint32  StartTsRfOn;
	uint16	dutycycleRfOnTimeout;
	uint16 	dutycycleRfOffTimeout;
	uint8 	isEnabled;
	DutyCycleState_e dutycycleSmState;
} dutycycleDB_t;



#define CLIPPING_RANGE 128
#define CLIPPING_ANTS 4
#define CLIPPING_FREQUENCIES 15

typedef struct _Clipping_t
{
	uint32 clipping20[CLIPPING_RANGE];
	uint32 clipping40[CLIPPING_RANGE];
	uint32 clipping80[CLIPPING_RANGE];
	uint32 addressAnt[CLIPPING_ANTS];
	uint32 frequency[CLIPPING_FREQUENCIES];
	uint32 clipping_en[CLIPPING_FREQUENCIES];

} Clipping_t;

typedef struct _RxThreshold_t
{
	uint32 onTime;
	uint32 offTime;
} RxThreshold_t;


#define CHANNEL_NOTIFICATION_DISABLED_BITMAP	(0)

typedef struct 
{
	uint8 requestersBitmap;
	uint8 notHandledReqCounter;
} HdkNotificationParams_t;
typedef struct 
{
	HdkNotificationParams_t antConfigParams;
} HdkAntConfigDb_t;

typedef struct 
{
	uint8 chan_width;
	uint8 low_chan_num;
	uint8 primary_chan_idx;
}HdkFreqJumpChanlDB_t;

typedef struct 
{
	HdkFreqJumpChanlDB_t	 chanDBperBW[FREQ_JUMP_BW_DB]; /*used by frequency calculation*/
	HdkSetChannelReqParams_t setChannelOriginalParams;/*store the Original set channel Params*/
	uint8			fjEnabled;
	uint8 			allocated;
} HdkFreqJumpParams_t;


typedef void (*HdkStateMachineFunctionEntry_t) (K_MSG* pMsg); 
typedef void (*SetChannelStateMachineFunctionEntry_t) (K_MSG* pMsg);
typedef void (*ERPStateMachineFunctionEntry_t) (K_MSG* pMsg); 
typedef void (*DutyCycleStateMachineFunctionEntry_t) (K_MSG* pMsg); 
typedef void (*HdkProcessStateMachineFunctionEntry_t) (K_MSG *psMsg, HdkProcess_e processId); 
typedef void (*LoadStoreStateMachineFunctionEntry_t) (void); 
typedef void (*OfflineCalStateMachineFunctionEntry_t) (K_MSG* pMsg); 
typedef void (*ChannelNotificationFunctionEntry_t) (void); 
typedef void (*AntConfigNotificationFunctionEntry_t) (void); 
typedef void (*AntConfigStateMachineFunctionEntry_t) (K_MSG* pMsg); 
typedef void (*HdkFreqJumpStateMachineFunctionEntry_t) (K_MSG* pMsg); 


/**********************    Event Handlers - HDK Main SM    *****************************/

void hdkInitDoneEventHandler(K_MSG* pMsg);
void hdkRemoveLastVapEventHandler(K_MSG* pMsg);
void hdkEnableDisableRfEventHandler(K_MSG* pMsg);
void hdkCalibrateEventHandler(K_MSG* pMsg);
void hdkSetChannelEventHandler(K_MSG* pMsg);
void hdkSchedOnlineCalibrationReqEventHandler(K_MSG* pMsg);
void hdkFinishOnlineCalibrationReqEventHandler(K_MSG* pMsg);
void hdkSetAntennasEventHandler(K_MSG* pMsg);
void hdkUserDemandEventHandler(K_MSG* pMsg);

/**********************    Event Handlers - Set Channel SM    *****************************/

void setChannelSetFrequencyEventHandler(K_MSG* pMsg);
void setChannelFrequencySetEventHandler(K_MSG* pMsg);
void setChannelCalResultsLoadedEventHandler(K_MSG* pMsg);
void setChannelOfflineCalDoneEventHandler(K_MSG* pMsg);
void setChannelCalResultsStoredEventHandler(K_MSG* pMsg);
void setChannelChannelNotificationDoneEventHandler(K_MSG* pMsg);
void setChannelRemoveLastVapEventHandler(K_MSG* pMsg);

/**********************    Event Handlers - HDK processes SM    *****************************/

void hdkProcessScheduleProcessReqEventHandler(K_MSG *psMsg, HdkProcess_e processId);
void hdkProcessProcessScheduledEventHandler(K_MSG *psMsg, HdkProcess_e processId);
void hdkProcessProcessFinishedEventHandler(K_MSG *psMsg, HdkProcess_e processId);
void hdkProcessExecutionCompletedEventHandler(K_MSG *psMsg, HdkProcess_e processId);
/**********************    Event Handlers - Frequency Jump SM    *****************************/
void hdkFreqJumpEventDisable(K_MSG *pMsg);
void hdkFreqJumpEventEnable(K_MSG* pMsg);
void hdkFreqJumpEventStart(K_MSG* pMsg);
void hdkFreqJumpEventNextBw(K_MSG* pMsg);
void hdkFreqJumpEventCalDone(K_MSG* pMsg);
void hdkFreqJumpEventIgnor(K_MSG* pMsg);
void hdkFreqJumpInvalidEvent(K_MSG* pMsg);
void hdkSetFreqJumpModeInCtsAutoReply(void);


/**********************    State Handlers - HDK Main SM    *****************************/

void hdkInitDoneStateHandler(K_MSG* pMsg);
void hdkRemoveLastVapStateHandler(K_MSG* pMsg);
void hdkEnableDisableRfStateHandler(K_MSG* pMsg);
void hdkCalibrateStateHandler(K_MSG* pMsg);
void hdkSetChannelStateHandler(K_MSG* pMsg);
void hdkOnlineTimerExpiredStateHandler(K_MSG* pMsg);
void hdkSetAntennasStateHandler(K_MSG* pMsg);
void hdkUserDemandStateHandler(K_MSG* pMsg);
void hdkIgnoreRadioEvent(K_MSG* pMsg);
void hdkIgnoreCocEvent(K_MSG* pMsg);
void hdkInvalidEvent(K_MSG* pMsg);
void hdkIgnoreOnlineTimerEvent(K_MSG* pMsg);

/**********************    State Handlers - Set Channel SM    *****************************/
#if !defined ENET_INC_ARCH_WAVE600 //ENET_INC_ARCH_WAVE600
void hdk_clippingTrigger(void);
#endif
void SelectClippingRam(K_MSG*pMsg);
void hdk_handleClipping(void);
void hdk_handleRxIqDefault(void);

void setChannelSetFrequencyStateHandler(K_MSG* pMsg);
void setChannelFrequencySetStateHandler(K_MSG* pMsg);
void setChannelCalResultsLoadedStateHandler(K_MSG* pMsg);
void setChannelOfflineCalDoneStateHandler(K_MSG* pMsg);
void setChannelCalResultsStoredStateHandler(K_MSG* pMsg);
void setChannelChannelNotificationDoneStateHandler(K_MSG* pMsg);
void setChannelRemoveLastVapStateHandler(K_MSG* pMsg);
void setChannelInvalidEvent(K_MSG* pMsg);


/**********************    State Handlers - ERP SM    *****************************/
void erpIgnoreEvent(K_MSG* pMsg);
void erpInvalidEvent(K_MSG* pMsg);
void erpAddVap(K_MSG* pMsg);
void erpAddVapInIdle(K_MSG* pMsg);
void erpRemoveVap(K_MSG* pMsg);
void erpRemoveVapWaitConnectionEvent(K_MSG* pMsg);
void erpRemoveVapInRfOnEvent(K_MSG* pMsg);
void erpAddSta(K_MSG* pMsg);
void erpAddStainWaitConnectionEvent(K_MSG* pMsg);
void erpAddStaInRfOnEvent(K_MSG* pMsg);
void erpAddStaInWaitProcessStartEvent(K_MSG *pMsg);
void erpAddStaInRfOffEvent(K_MSG *pMsg);
void erpAddStaInWaitProcessEndEvent(K_MSG *pMsg);
void erpRemoveSta(K_MSG* pMsg);
void erpRemoveStainWaitConnectionEvent(K_MSG * pMsg);
void erpRemoveStainConnectedEvent(K_MSG * pMsg);
void erpRemoveStaInWaitProcessStartAbortEvent(K_MSG *pMsg);
void erpRemoveStaInWaitProcessEndAbortEvent(K_MSG *pMsg);
void erpWaitConnectionTimerEvent(K_MSG* pMsg);
void erpRfOnTimerEvent(K_MSG* pMsg);
void erpRfOffTimerEvent(K_MSG* pMsg);
void erpProcessStartInWaitProcessStartEvent(K_MSG* pMsg);
void erpProcessStartInWaitProcessStartAbortEvent(K_MSG* pMsg);
void erpProcessStartInWaitProcessStartDisableEvent(K_MSG* pMsg);
void erpProcessEndInWaitProcessEndEvent(K_MSG* pMsg);
void erpProcessEndInWaitProcessEndAbortEvent(K_MSG* pMsg);
void erpProcessEndInWaitProcessEndDisableEvent(K_MSG* pMsg);
void erpBssTxInWaitConnectionEvent(K_MSG* pMsg);
void erpBssTxInRfOnEvent(K_MSG* pMsg);
void erpBssTxInWaitProcessStartEvent(K_MSG* pMsg);
void erpBssTxInRfOffEvent(K_MSG* pMsg);
void erpBssTxInWaitProcessStartEvent(K_MSG* pMsg);
void erpBssTxInRfOffEvent(K_MSG* pMsg);
void erpBssTxInWaitProcessEndEvent(K_MSG* pMsg);
void erpDisableInIdleEvent(K_MSG* pMsg);
void erpDisableInWaitConnectionEvent(K_MSG* pMsg);
void erpDisableInConnectedEvent(K_MSG* pMsg);
void erpDisableInRfOnEvent(K_MSG* pMsg);
void erpDisableInWaitProcessStartEvent(K_MSG* pMsg);
void erpDisableInRfOffEvent(K_MSG* pMsg);
void erpDisableInWaitProcessEndEvent(K_MSG* pMsg);
void erpDisableInWaitProcessStartAbortEvent(K_MSG* pMsg);
void erpDisableInWaitProcessEndAbortEvent(K_MSG* pMsg);
void erpDisableEvent(K_MSG* pMsg);
void erpEnableInDisableEvent(K_MSG* pMsg);
void erpEnableInWaitConnectionEvent(K_MSG* pMsg);
void erpEnableInConnectedEvent(K_MSG* pMsg);
void erpEnableInRfOnEvent(K_MSG* pMsg);
void erpEnableInRfOffEvent(K_MSG* pMsg);
void erpEnableInWaitProcessStartDisableEvent(K_MSG* pMsg);
void erpEnableInWaitProcessEndDisableEvent(K_MSG* pMsg);
void erpEnableEvent(K_MSG* pMsg);
void HDK_ERPChangeState(ERPState_e state);
extern erpDB_t erpDB;

/**********************    State Handlers - DutyCycle SM    *****************************/
void dutycycleRfOnTimerExpired(K_MSG* pMsg);
void dutycycleRfOffTimerExpired(K_MSG* pMsg);
void dutycycleProcessStart(K_MSG* pMsg);
void dutycycleProcessEnd(K_MSG* pMsg);
void dutycycleDisableExecution(K_MSG* pMsg);
void dutycycleEnableExecution (K_MSG* pMsg);

extern dutycycleDB_t dutycycleDB;
/*****************************************************************************/	
void HDK_TurnRadioOffOn(uint32 u32RadioOn);
void HDK_ERPPostVapActivation(K_MSG* pMsg);
void HDK_ERPRemoveVap(K_MSG *pMsg);
void HDK_ERPStaAdd(K_MSG *psMsg);
void HDK_ERPStaRemove(K_MSG *psMsg);
void HDK_ERPTimerExpired(K_MSG* pMsg);
void HDK_ERPSet(K_MSG *psMsg);
void HDK_ERPProcessStart(K_MSG *psMsg);
void HDK_ERPEndProcess(K_MSG *psMsg);
void HDK_ERPBssTX(K_MSG *psMsg);
void HDK_ERPRadioOnOffCommand(uint32 radioOnOffIndication);

void ERP_init(void);

void setChannelFrequencySetStateHandler(K_MSG* pMsg);
void setChannelCalResultsLoadedStateHandler(K_MSG* pMsg);
void setChannelOfflineCalDoneStateHandler(K_MSG* pMsg);
void setChannelCalResultsStoredStateHandler(K_MSG* pMsg);
void setChannelChannelNotificationDoneStateHandler(K_MSG* pMsg);
void setChannelRemoveLastVapStateHandler(K_MSG* pMsg);
void setChannelInvalidEvent(K_MSG* pMsg);


/**********************    State Handlers - HDK processes SM    *****************************/

void hdkProcessScheduleProcessReqStateHandler(K_MSG *psMsg, HdkProcess_e processId);
void hdkProcessProcessScheduledStateHandler(K_MSG *psMsg, HdkProcess_e processId);
void hdkProcessProcessFinishedStateHandler(K_MSG *psMsg, HdkProcess_e processId);
void hdkProcessExecutionCompletedStateHandler(K_MSG *psMsg, HdkProcess_e processId);
void hdkProcessInvalidEvent(K_MSG *psMsg, HdkProcess_e processId);

/**********************    State Handlers - HDK antenna configuration SM    *****************************/
void setAntennaConfigurationEventHandler(K_MSG* pMsg,HdkAntConfigEvent_e event);

/**********************    State Setters  *****************************/

void setHdkMainSmState(HdkState_e state);
void setSetChannelSmState(SetChannelState_e state);
void setHdkProcessSmState(HdkProcessState_e state);
void setHdkProcessId(HdkProcess_e processId);
void setFreqJumpSmState(HdkFreqJumpState_e state);

/**********************    Channel Notification handlers  *****************************/

void channelNotificationLATpcData(void);
void channelNotificationTpcTimerHandler(void);
void channelNotificationOnlineTimerHandler(K_MSG *psMsg);
void channelNotificationCoC(void);
uint8 getChannelNotification(void);
void ChannelNotificationHeGroupManager(void);
void antConfigNotificationToHeGroupManager(void);


/*****************************************************************/

void HDK_configure(UMI_HDK_CONFIG* params);
void HDK_preSetChannel(uint8 bandwidth);
SetChannelParams_t* HDK_getSetChannelParams(void);
HdkSetChannelReqParams_t* HDK_getSetChannelReqParams(void);
void HDK_scheduleRequestToProcessManager(uint8 processId, K_MSG* pReqParams, K_MSG_TYPE startProcessMessage, K_MSG_TYPE endProcessMessage, uint32 preServiceBitMap, uint32 postServiceBitMap, uint32 serviceData, bool dualCoreProcess);
uint8 HDK_convertChannelNumToIndex(uint8 channelNum, uint8 bandWidth, uint8 band);
void  set11bAntennaSelection(K_MSG* psMsg, uint8 driverMsg);
void  HDK_Get11bAntSelParams(uint8* rxAnt, uint8* txAnt, uint8* rate);
void  HDK_Set11bAntSelParams(uint8 rxAnt, uint8 txAnt, uint8 rate);
void  SelectBandFilterFW(K_MSG* pMsg);
bool  HDK_SetChannelFreeMsgNeeded(void);
uint8 HDK_GetFreqJumpOriginChannelWidth(void);
uint8 HDK_GetFreqJumpLowChanNum(uint8 bw);
HdkFreqJumpState_e HDK_GetFreqJumpSmState(void);
void  HDK_InitLoFrequenciesArr(void);
uint32 Hdk_GetRfChipId(void);
uint32 Hdk_GetBbChipId(void);
uint32 Hdk_GetSupportedBand(void);

uint32 Hdk_GetRxAntMask(void);
uint32 Hdk_GetZwdfsAntMask(void);
uint32 Hdk_GetRxAntSelectionMask(void);
uint32 Hdk_GetTxAntSelectionMask(void);
uint32 Hdk_GetMaxTxAntMask(void);
uint32 Hdk_GetMaxRxAntMask(void);
uint32 Hdk_GetMaxRxAntSelectionMask(void);
uint32 Hdk_GetMaxTxAntSelectionMask(void);
void sendOnlineCalMsgToHdkCdbMan(K_MSG_TYPE msgType, bool moreFrags, bool wasCalibrated, ClbrProcType_e nextCalibration, bool enDisCal);
void HDK_SetSsbModeReq(K_MSG* pMsg);
void HDK_RadarDetectionRssiThConfigReq(K_MSG* psMsg);
uint32* hdkGetPsdProgmodelShramAddress(void);
void sendHdkCdbManConfigSmCfm(void);
void offlineCalSetEvent(HdkOfflineCalEvent_e offlineCalEvent);
void erpRunStateMachine(ERPEvent_e event,K_MSG* pMsg);
bool Hdk_isTestBusEnable(void);
void HDK_InitConfigParams(void);
void hdkOfflineCalFinishedCoCCb(void);
void Hdk_SetTxWindowLimit(K_MSG *psMsg);


#endif // __HdkTask_h__

