#ifndef GLOBAL_DEFS_H_
#define GLOBAL_DEFS_H_

// Some simple input/output function header parameters definitions
#define IN
#define OUT
#define INOUT

// Function status code

/* */
typedef enum HdkPathTypeIndexTag
{
	HDK_PATH_TYPE_I = 0,
	HDK_PATH_TYPE_Q,
	HDK_PATH_TYPE_MAX //= HDK_PATH_TYPE_Q,
} HdkPathTypeIndex_e;

typedef enum RficPathTypeIndexTag
{
    RFIC_PATH_TYPE_I = 0,
    RFIC_PATH_TYPE_Q,
    RFIC_PATH_TYPE_I_AND_Q, // Path I and Path Q
    RFIC_PATH_TYPE_MAX = RFIC_PATH_TYPE_I_AND_Q,
} RficPathTypeIndex_e;

/* CB mode or nCB mode */
typedef enum
{
    SPECTRUM_MODE_NCB = 0,
    SPECTRUM_MODE_CB,
    SPECTRUM_MODE_MAX,
} SpectrumMode_e;


// The highest  OFDM bin that carries data on our transmission
#define HIGHEST_TRANSMISSION_BIN_BW160  250
#define HIGHEST_TRANSMISSION_BIN_BW80   122
#define HIGHEST_TRANSMISSION_BIN_BW40   58
#define HIGHEST_TRANSMISSION_BIN_BW20   28

typedef enum DcMode
{
    CHIP_MODE = 0,
    SW_MODE,
    MIX_MODE,
} DcMode_e;

#endif //GLOBAL_DEFS_H_

