/***********************************************************************************
 File:			Hdk_Api.h
 Module:		
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HDK_API_H_
#define HDK_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "CalibrationsDefines.h"
#include "mhi_umi.h"
#include "mhi_umi_propr.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define HDK_LOGS
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum QBF_CalibrationType
{
	AFE = 0,
	AGC_GAIN,
	K_CALIBRATION,
	AGC_OFFSET,
	TX_OFFSET,
	MAX_NUMBER_OF_BF_CALS,
	
}QBF_CalibrationType_e;


typedef struct LinkAdaptationCalibrationStatus
{
	uint8 rxDc[MAX_NUM_OF_ANTENNAS];
	uint8 txLo[MAX_NUM_OF_ANTENNAS];
	uint8 rxIq[MAX_NUM_OF_ANTENNAS];
	uint8 txIq[MAX_NUM_OF_ANTENNAS];
	uint8 BF[MAX_NUMBER_OF_BF_CALS];
}LinkAdaptationCalibrationStatus_t;

typedef enum PowerSaveStates
{
	DECREASE_NUM_OF_ANTS		= 	0x0,
	INCREASE_NUM_OF_ANTS		=	0x1,
	RADIO_OFF					=	0x2,
	RADIO_OFF_ERP_DUTY_CYCLE	=	0x3,
	RADIO_ON					=	0x4,
	RADIO_ON_INIT				=	0x5,
	RADIO_ON_AND_1_ON_1			=	0x6,
	_1_ON_1						=	0x7,
	OUT_OF_1_ON_1				=	0x8,
	
} PowerSaveStates_e;


#define OFFLINE_CAL_MODE_FULL	0
#define OFFLINE_CAL_MODE_SKIP	1

typedef struct _HdkSetChannelReqParams_t
{
	uint8  low_chan_num;
	uint8  low_chan_num2; // only for use with 80+80 mode
	uint8  chan_width; // values from the chanWidth enum
	uint8  primary_chan_idx; // within the 1 to 8 channels specified by chan_width, i.e., from 0 to 7
	
	uint8  isRadarDetectionNeeded;
	uint8  isContinuousInterfererDetectionNeeded;
	uint8  switchType;
	uint8  channelNotification;

	uint8  block_tx_post;
	uint8  RegulationType;
	uint8  reserved[2];
} HdkSetChannelReqParams_t;
typedef enum HdkSSB20MhzParameters
{
	HALF_BAND_40_80_SSB_20_40,
	SSB_20_80,
	SSB_LAST
} HdkSSB20MhzParameters_e;

typedef struct HdkSSBParameters
{
	bool ssbConfigurationValid;
	HdkSSB20MhzParameters_e ssb20MhzOption;
	uint8	hdkSSBTcrBw;
} HdkSSBParameters_t;

typedef struct HdkMinRssi
{
	uint8 minRssi;
} HdkMinRssi_t;
typedef struct txWindowSize
{
	uint8 sindowSizeOption; // 2 - 50nsec, 3 - 100nsec
} txWindowSize_t;

/* HDK State Machines Enumerations */

// HDK Main State Machine

typedef enum
{
	HDK_STATE_IDLE,
	HDK_STATE_INIT,
	HDK_STATE_READY,
	HDK_STATE_ACTIVE,
	HDK_STATE_DISABLED,
	HDK_NUMBER_OF_STATES
} HdkState_e;

typedef enum
{
	HDK_EVENT_INIT_DONE,
	HDK_EVENT_ADD_FIRST_VAP_BAND_CONFIG,
	HDK_EVENT_REMOVE_LAST_VAP,
	HDK_EVENT_ENABLE_RF,
	HDK_EVENT_DISABLE_RF,
	HDK_EVENT_CALIBRATE,
	HDK_EVENT_SET_CHANNEL,
	HDK_EVENT_SCHED_ONLINE_PROCESS,
	HDK_EVENT_SET_ANTENNAS,
	HDK_EVENT_USER_DEMAND,
	HDK_NUMBER_OF_EVENTS	
} HdkEvent_e;

// Set Channel State Machine

typedef enum
{
	SET_CHANNEL_STATE_IDLE,
	SET_CHANNEL_STATE_FREQUENCY_LOCK,
	SET_CHANNEL_STATE_LOAD_CAL,
	SET_CHANNEL_STATE_OFFLINE_CAL,
	SET_CHANNEL_STATE_STORE_CAL,
	SET_CHANNEL_STATE_SEND_PARAMS,
	SET_CHANNEL_STATE_ACTIVE,
	SET_CHANNEL_NUMBER_OF_STATES
} SetChannelState_e;

typedef enum
{
	SET_CHANNEL_EVENT_SET_FREQUENCY,
	SET_CHANNEL_EVENT_FREQUENCY_SET,
	SET_CHANNEL_EVENT_CAL_RESULTS_LOADED,
	SET_CHANNEL_EVENT_OFFLINE_CAL_DONE,
	SET_CHANNEL_EVENT_CAL_RESULTS_STORED,
	SET_CHANNEL_EVENT_CHANNEL_NOTIFICATION_DONE,
	SET_CHANNEL_EVENT_REMOVE_LAST_VAP,
	SET_CHANNEL_NUMBER_OF_EVENTS	
} SetChannelEvent_e;


typedef enum
{
	ERP_STATE_DISABLE,
	ERP_STATE_IDLE,
	ERP_STATE_WAIT_CONNECTION,
	ERP_STATE_CONNECTED,
	ERP_STATE_RF_ON,
	ERP_STATE_WAIT_PROCESS_START,
	ERP_STATE_RF_OFF,
	ERP_STATE_WAIT_PROCESS_END,
	ERP_STATE_WAIT_PROCESS_START_ABORT,
	ERP_STATE_WAIT_PROCESS_END_ABORT,
	ERP_STATE_WAIT_PROCESS_START_DISABLE,
	ERP_STATE_WAIT_PROCESS_END_DISABLE,
	ERP_NUMBER_OF_STATES
} ERPState_e;


typedef enum
{
	ERP_EVENT_ADD_VAP,
	ERP_EVENT_REMOVE_VAP,
	ERP_EVENT_ADD_STA,
	ERP_EVENT_REMOVE_STA,
	ERP_EVENT_TIMER,
	ERP_EVENT_PROCESS_START,
	ERP_EVENT_PROCESS_END,
	ERP_EVENT_BSS_TX,
	ERP_EVENT_DISABLE,
	ERP_EVENT_ENABLE,
	ERP_NUMBER_OF_EVENTS	
} ERPEvent_e;

typedef enum
{
	DC_STATE_DISABLE,
	DC_STATE_WAIT_PROCESS_START,
	DC_STATE_WAIT_PROCESS_START_DISABLE,
	DC_STATE_RF_OFF,
	DC_STATE_WAIT_PROCESS_END,
	DC_STATE_WAIT_PROCESS_END_DISABLE,
	DC_STATE_RF_ON,
	DC_NUMBER_OF_STATES
} DutyCycleState_e;

typedef enum
{
	DC_EVENT_DISABLE,
	DC_EVENT_ENABLE,
	DC_EVENT_PROCESS_START,
	DC_EVENT_PROCESS_END,
	DC_EVENT_TIMER_EXPIRED,
	DC_NUMBER_OF_EVENTS	
} DutyCycleEvent_e;


// Load & Store State Machine

typedef enum
{
	LOAD_STORE_STATE_IDLE,
	LOAD_STORE_STATE_WAIT_DMA_LOAD,
	LOAD_STORE_STATE_WAIT_DMA_STORE,
	LOAD_STORE_NUMBER_OF_STATES
} LoadStoreState_e;

typedef enum
{
	LOAD_STORE_EVENT_TRIGGER_LOAD,
	LOAD_STORE_EVENT_DMA_DONE,
	LOAD_STORE_EVENT_TRIGGER_STORE,
	LOAD_STORE_NUMBER_OF_EVENTS
} LoadStoreEvent_e;

// HDK Processes State Machine

typedef enum
{
	HDK_PROCESS_NONE,
	HDK_PROCESS_CALIBRATE,
	HDK_PROCESS_ONLINE_CAL,
	HDK_PROCESS_RADIO_ON_OFF,
	HDK_PROCESS_USER_DEMAND,
	HDK_PROCESS_SET_ANTENNA_CONFIGURATION,	
#if defined HDK_CDB_SUPPORT
	HDK_PROCESS_PAUSE_BAND,
#endif
	HDK_NUMBER_OF_PROCESSES
} HdkProcess_e;

typedef enum
{
	HDK_PROCESS_STATE_IDLE,
	HDK_PROCESS_STATE_WAIT_FOR_PROCESS_START,
	HDK_PROCESS_STATE_ACTIVE,
	HDK_PROCESS_STATE_WAIT_FOR_PROCESS_END,
	HDK_PROCESS_NUMBER_OF_STATES
} HdkProcessState_e;

typedef enum
{
	HDK_PROCESS_EVENT_SCHEDULE_PROCESS_REQ,
	HDK_PROCESS_EVENT_PROCESS_SCHEDULED,
	HDK_PROCESS_EVENT_PROCESS_FINISHED,
	HDK_PROCESS_EVENT_EXECUTION_COMPLETED,
	HDK_PROCESS_NUMBER_OF_EVENTS
} HdkProcessEvent_e;
typedef enum
{
	HDK_CONFIG_STATE_IDLE,
	HDK_CONFIG_STATE_PRE_CONFIGURATION_DONE,
	HDK_CONFIG_STATE_COMMON_CONFIGURATION_DONE,		
	HDK_CONFIG_NUMBER_OF_STATES,
} HdkConfigurationState_e;
typedef enum
{
	HDK_OFFLINE_CAL_STATE_IDLE,
	HDK_OFFLINE_CAL_STATE_WAIT_FOR_SET_MAX_ANTS,
	HDK_OFFLINE_CAL_STATE_WAIT_FOR_OFFLINE_CAL_START,
	HDK_OFFLINE_CAL_STATE_CALIBRATION_RUNNING,
	HDK_OFFLINE_CAL_NUMBER_OF_STATES,
} HdkOfflineCalState_e;
typedef enum
{
	HDK_OFFLINE_CAL_EVENT_RUN_CALIBRATION,
	HDK_OFFLINE_CAL_EVENT_START_CALIBRATION_PROC,		
	HDK_OFFLINE_CAL_EVENT_RUN_CAL_REQ_FROM_CDB_MANAGER,
	HDK_OFFLINE_CAL_EVENT_FINISH_CAL_FROM_CDB_MANAGER,
	HDK_OFFLINE_CAL_NUMBER_OF_EVENTS,
} HdkOfflineCalEvent_e;

/* Channel Notification requesters */

typedef enum
{
	CHANNEL_NOTIFICATION_LA_TPC_DATA,
	CHANNEL_NOTIFICATION_START_TPC_TIMER,
	CHANNEL_NOTIFICATION_COC,
	CHANNEL_NOTIFICATION_HE_GROUP_MANAGHER,
	CHANNEL_NOTIFICATION_MAX_NUM_OF_REQESTERS,
}ChannelNotificationRequesters_e;

// HDK Frequency Jump State Machine

typedef enum 
{
	FREQ_JUMP_STATE_DISABLED, /*not running*/
	FREQ_JUMP_STATE_INIT,	/*first Iteration*/
	FREQ_JUMP_STATE_FJ_CHANNEL,
	FREQ_JUMP_STATE_REQ_CHANNEL,
	FREQ_JUMP_NUMBER_OF_STATES
}HdkFreqJumpState_e;

typedef enum
{
	FREQ_JUMP_EVENT_ENABLE_FREQ,
	FREQ_JUMP_EVENT_DISABLE_FREQ,
	FREQ_JUMP_EVENT_START,
	FREQ_JUMP_EVENT_NEXT_BW,
	FREQ_JUMP_EVENT_CAL_DONE,
	FREQ_JUMP_NUMBER_OF_EVENTS	
} HdkFreqJumpEvent_e;
typedef enum 
{
	ANT_CONFIG_IDLE,
	ANT_CONFIG_WAIT_FOR_PROCESS_SCHED,
	ANT_CONFIG_DISABLE_ANT,
	ANT_CONFIG_SET_ANTENNA_WAIT_FOR_NOTIFICATION_CFM,
	ANT_CONFIG_WAIT_FOR_PROCESS_END,
	ANT_CONFIG_NUMBER_OF_STATES
}HdkAntConfigState_e;

typedef enum
{
	ANT_CONFIG_EVENT_SET_PROCESS,	
	ANT_CONFIG_EVENT_DISABLE_ANTS,	
	ANT_CONFIG_EVENT_SET_ANTS,
	ANT_CONFIG_EVENT_NOTIFICATION_DONE,
	ANT_CONFIG_EVENT_PROCESS_END,	
	ANT_CONFIG_NUMBER_OF_EVENTS 
} HdkAntConfigEvent_e;

typedef enum
{
	ANT_CONFIG_NOTIFICATION_LA,
	ANT_CONFIG_NOTIFICATION_COC,
	ANT_CONFIG_NOTIFICATION_HE_GROUP_MANAGER,
	ANT_CONFIG_MAX_NUM_OF_REQESTERS
}AntConfigurationNotificationRequesters_e;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//--------------------------------------------------------------------------------
void  HDK_Task(K_MSG *psMsg);     //Dispatching the events
void  HDK_Init(void);
void clippingInit(void);
uint8 HDK_getBand(void);
void HDK_setOfflineCalMode(uint8 mode);
uint8 HDK_getOfflineCalMode(void);
uint8 HDK_getChannelWidth(void);
uint8 HDK_getLowChannel(void);
void  HDK_setSsbParameters(K_MSG* psMsg);
void HDK_SetMaxAnts(uint8 numAnts, uint8 antMask);
K_MSG* HDK_GetCocSaveMsg(void);
void HDK_GetMaxActiveAntennasNumAndMask(uint8 * maxAnts,uint8 * antMask);
void HDK_SetFrequencyRadioOn(void);
PowerSaveStates_e HDK_FindPowerSaveState(bool radioOn, bool radioOff,uint8 requestedNumOfAnts, bool isCocUp, bool isErpDutyCycle);
#if !defined(ENET_INC_HW_FPGA)
void HDK_PowerSave_RadioOnInit(void);
void HDK_PowerSave_RadioOn(void);
void HDK_PowerSave_RadioOff(void);
void HDK_PowerSave_RadioOnAndCoc(AntennaBitmaps_e requestedTxAntsMask);
void HDK_PowerSave_Coc(AntennaBitmaps_e requestedTxAntsMask);
void HDK_PowerSave_OutOfCoc(AntennaBitmaps_e requestedTxAntsMask);
#endif
void  HDK_PowerSave(PowerSaveStates_e change, uint8 requestedNumOfAnts, AntennaBitmaps_e requestedTxAntsMask);
void  HDK_notify_interferer(PowerSaveStates_e powerSaveState);
void  HDK_SetAntennasReq(AntennaBitmaps_e requestedTxAntsMask, AntennaBitmaps_e requestedRxAntsMask, uint8 requestedNumOfAnts, PowerSaveStates_e change);
uint32 HDK_GetBaseHostDataAddrPointer(void);
void HDK_SetBaseHostDataAddr(uint32 val);
uint8 hdkGetChannelSwitchType(void);
void sendHdkInfoToOtherCore(K_MSG_TYPE msgType, K_TASKID toTask, uint8 maxActiveAnt, uint8 activeAntMask, uint8 chan_width);
uint8 HDK_IsFrequencyJumpEnabled(void);
void  HDK_FreqJumpCalMapHandler(uint32* pCalibMap);
void  HDK_SetFreqArr(uint16 freq, uint8 rfBwIdx);
void hdkCalcLoFrequencies(void);
uint16 HDK_GetLoFrequency(uint8 rfBwIdx);
uint8 HDK_GetRfBw(uint8 fwBw);
void  HDK_PostInit(void);
void HDK_override11bAntSel(uint8 antMask); //WORKAROUND function

/**********************    Globals - DutyCycle.c    *****************************/
void HDK_DCRequest(K_MSG *pMsg);
void HDK_DCRemoveLastVap (K_MSG* pMsg);
void HDK_DCTimerExpired(K_MSG* pMsg);
void HDK_DCProcessStart(K_MSG *psMsg);
void HDK_DCEndProcess(K_MSG *psMsg);
bool HDK_DCisEnable(void);
bool HDK_ERPisEnable(void);
void HDK_DCRadioOnOffCommand(uint32 radioOnOff);
void HDK_DCinit(void);
uint32 Hdk_GetTxAntMask(void);

/********************************************************************************/
// State Machines API functions

HdkState_e getHdkSmState(void);
SetChannelState_e getSetChannelSmState(void);
HdkProcessState_e getHdkProcessSmState(void);
HdkProcess_e getHdkProcessId(void);
LoadStoreState_e getLoadStoreSmState(void);
HdkFreqJumpState_e getFreqJumpSmState(void);
HdkAntConfigState_e getHdkAntConfigSmState(void);



#endif //HDK_API_H_
