#ifndef __CALIBRATION_DEFS_H__
#define __CALIBRATION_DEFS_H__

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"



typedef enum ClbrType
{
	CLBR_TYPE_INIT,
	CLBR_TYPE_OFFLINE,
	CLBR_TYPE_ONLINE,
	CLBR_TYPE_NUM
} ClbrType_e;

typedef enum CalDataState
{
	CAL_DATA_STATE_NONE    = 0,
	CAL_DATA_STATE_LOAD    = 1,
	CAL_DATA_STATE_STORE   = 2
} CalDataState_e;

// DO NOT ALTER ClbrProcType_e and ClbrProcBit_e without precaution!
// They are ordered the same, according to RF precedences
// Temporarily, we use two different enums for W300 and AR10/W400. We prefer not to make systematic changes like this
// in W300 right now. This should be changed back to have the same enum for both platforms

typedef enum ClbrProcType
{
    CLBR_PROC_TYPE_MS_REPLICA_TUNING = 0,
    CLBR_PROC_TYPE_MS_SSI_ADC,
    CLBR_PROC_TYPE_RFIC_BIAS,
    CLBR_PROC_TYPE_RX_DC_OFFSET,
    CLBR_PROC_TYPE_LPF,
    CLBR_PROC_TYPE_RSSI_DC_OFFSET,
    CLBR_PROC_TYPE_RX_IQ_NLMS,//CLBR_PROC_TYPE_RX_IQ_NLMS
    CLBR_PROC_TYPE_RSSI_PATH_CALIB,
    CLBR_PROC_TYPE_TX_LO_LEAKAGE,
    CLBR_PROC_TYPE_RX_IQ_MISMATCH,
    CLBR_PROC_TYPE_TX_IQ_MISMATCH,
    CLBR_PROC_TYPE_TPC,
    CLBR_PROC_TYPE_BEAM_FORMING,
    CLBR_PROC_TYPE_NUM,
    CLBR_PROC_TYPE_INVALID,
}ClbrProcType_e;

typedef enum ClbrProcBit
{
    CLBR_PROC_BIT_INVALID			= 0x0,
    CLBR_PROC_BIT_MS_REPLICA_TUNING	= 0x1,
    CLBR_PROC_BIT_MS_SSI_ADC		= 0x2,
    CLBR_PROC_BIT_RFIC_BIAS			= 0x4,
    CLBR_PROC_BIT_RX_DC_OFFSET		= 0x8,
    CLBR_PROC_BIT_LPF				= 0x10,
    CLBR_PROC_BIT_RSSI_DC_OFFSET	= 0x20,
    CLBR_PROC_BIT_RX_IQ_NLMS		= 0x40,
    CLBR_PROC_BIT_RSSI_PATH			= 0x80,
    CLBR_PROC_BIT_TX_LO_LEAKAGE		= 0x100,
    CLBR_PROC_BIT_RX_IQ_MISMATCH	= 0x200,
    CLBR_PROC_BIT_TX_IQ_MISMATCH	= 0x400,
    CLBR_PROC_BIT_TPC				= 0x800,
    CLBR_PROC_BIT_BEAM_FORMING		= 0x1000,
    CLBR_PROC_BIT_MIN				= CLBR_PROC_BIT_MS_REPLICA_TUNING, // Careful --> order is important!
    CLBR_PROC_BIT_MAX				= CLBR_PROC_BIT_BEAM_FORMING,    // Careful --> order is important!
}ClbrProcBit_e;

#if defined (ENET_INC_HW_FPGA)

#define SUPPORTED_OFFLINE_CALIBRATION_MASK 0

#define SUPPORTED_ONLINE_CALIBRATION_MASK	0

#define SUPPORTED_RSSI_CHANNEL_CALIBRATION_MASK		(0)

#define SUPPORTED_MASK_FOR_CALIBRATE_REQ_FIRST_CHANNEL	(0)

#define SUPPORTED_MASK_FOR_CALIBRATE_REQ_REST_CHANNELS	(0)

#define SUPPORTED_SCAN_CHANNEL_CALIBRATION_MASK		(0)

#define SUPPORTED_FREQUENCY_JUMP_RX_CALIBRATION_MASK (0)

#else // (ENET_INC_HW_FPGA)

#if defined (ENET_INC_ARCH_WAVE600)

#define SUPPORTED_OFFLINE_CALIBRATION_MASK (CLBR_PROC_BIT_RX_IQ_NLMS	 | \
											CLBR_PROC_BIT_RX_DC_OFFSET   | \
											CLBR_PROC_BIT_TX_LO_LEAKAGE  | \
											CLBR_PROC_BIT_RX_IQ_MISMATCH | \
											CLBR_PROC_BIT_TX_IQ_MISMATCH)

#define SUPPORTED_ONLINE_CALIBRATION_MASK	(CLBR_PROC_BIT_RX_DC_OFFSET | \
											 CLBR_PROC_BIT_TX_LO_LEAKAGE  | \
											 CLBR_PROC_BIT_TX_IQ_MISMATCH)

#define SUPPORTED_RSSI_CHANNEL_CALIBRATION_MASK		(CLBR_PROC_BIT_RX_DC_OFFSET | \
													CLBR_PROC_BIT_RX_IQ_MISMATCH)

#define SUPPORTED_MASK_FOR_CALIBRATE_REQ_FIRST_CHANNEL	(CLBR_PROC_BIT_RX_DC_OFFSET | \
												 		 CLBR_PROC_BIT_TX_LO_LEAKAGE | \
												 		 CLBR_PROC_BIT_RX_IQ_MISMATCH| \
												 		 CLBR_PROC_BIT_TX_IQ_MISMATCH)

#define SUPPORTED_MASK_FOR_CALIBRATE_REQ_REST_CHANNELS	(CLBR_PROC_BIT_RX_DC_OFFSET | \
												 		 CLBR_PROC_BIT_RX_IQ_MISMATCH)


#define SUPPORTED_SCAN_CHANNEL_CALIBRATION_MASK		(CLBR_PROC_BIT_RX_DC_OFFSET | \
													CLBR_PROC_BIT_RX_IQ_MISMATCH)

#define SUPPORTED_FREQUENCY_JUMP_RX_CALIBRATION_MASK (CLBR_PROC_BIT_RX_DC_OFFSET | \
													CLBR_PROC_BIT_RX_IQ_MISMATCH)

#else //ENET_INC_ARCH_WAVE600

#define SUPPORTED_OFFLINE_CALIBRATION_MASK	(CLBR_PROC_BIT_MS_SSI_ADC	  | \
											 CLBR_PROC_BIT_RFIC_BIAS | \
											 CLBR_PROC_BIT_RX_DC_OFFSET | \
											 CLBR_PROC_BIT_RSSI_DC_OFFSET | \
											 CLBR_PROC_BIT_RSSI_PATH | \
											 CLBR_PROC_BIT_TX_LO_LEAKAGE | \
											 CLBR_PROC_BIT_TX_IQ_MISMATCH | \
											 CLBR_PROC_BIT_BEAM_FORMING | \
											 CLBR_PROC_BIT_RX_IQ_MISMATCH )
											 
#define SUPPORTED_ONLINE_CALIBRATION_MASK	(CLBR_PROC_BIT_RX_DC_OFFSET | \
											 CLBR_PROC_BIT_TX_LO_LEAKAGE | \
											 CLBR_PROC_BIT_TX_IQ_MISMATCH | \
										     CLBR_PROC_BIT_RSSI_DC_OFFSET | \
											 CLBR_PROC_BIT_RX_IQ_MISMATCH)

#define SUPPORTED_RSSI_CHANNEL_CALIBRATION_MASK		(CLBR_PROC_BIT_RX_DC_OFFSET | \
													CLBR_PROC_BIT_RSSI_DC_OFFSET | \
													CLBR_PROC_BIT_RSSI_PATH | \
													CLBR_PROC_BIT_RX_IQ_MISMATCH )

#define SUPPORTED_MASK_FOR_CALIBRATE_REQ	(CLBR_PROC_BIT_MS_SSI_ADC	  | \
											 CLBR_PROC_BIT_RFIC_BIAS | \
											 CLBR_PROC_BIT_RX_DC_OFFSET | \
											 CLBR_PROC_BIT_RSSI_DC_OFFSET | \
											 CLBR_PROC_BIT_RSSI_PATH | \
											 CLBR_PROC_BIT_TX_IQ_MISMATCH | \
											 CLBR_PROC_BIT_RX_IQ_MISMATCH )

#define SUPPORTED_SCAN_CHANNEL_CALIBRATION_MASK		(CLBR_PROC_BIT_RX_DC_OFFSET | \
													CLBR_PROC_BIT_RSSI_DC_OFFSET | \
													CLBR_PROC_BIT_RSSI_PATH | \
													CLBR_PROC_BIT_RX_IQ_MISMATCH )

#define SUPPORTED_FREQUENCY_JUMP_RX_CALIBRATION_MASK (CLBR_PROC_BIT_RX_DC_OFFSET | \
													CLBR_PROC_BIT_RX_IQ_MISMATCH )

#endif /* ENET_INC_ARCH_WAVE600 */
#endif /* ENET_INC_HW_FPGA */

#endif // __CALIBRATION_DEFS_H__

