#ifndef __CalibrationHandler_h__
#define __CalibrationHandler_h__

#include "HdkGlobalDefs.h"
#include "System_GlobalDefinitions.h"
#include "lmi.h"
#include "CalibrationDefs.h"
#include "CalibrationManager.h"

/******************************************************************************/
/***						Definitions										***/
/******************************************************************************/
#define  RFIC_LO_FREQUENCIES 6
typedef enum _RF_BW_e
{
	RF_BW_80  	= 0x0,
	RF_BW_40  	= 0x1,
	RF_BW_20	= 0x2,
	RF_BW_MAX	= 0xFF
}RF_BW_e;

//************************************
// Method:    ClbrHndlr_Init
// Purpose:   Initialization of the Calibration Handler module
// Returns:   void
//************************************
void ClbrHndlr_Init(void);
/***************************************************************************
** NAME         ClbrHndlr_Calibrate
** PARAMETERS   CalibrSchedData_t* - pCalibData
**              u8Channel - channel ID
** RETURNS      na
** DESCRIPTION  Set Channel
****************************************************************************/
void ClbrHndlr_Calibrate(void);
//************************************
// Method:    ClbrHndlr_GetClbrType
// Purpose:   TBD
// Parameter: void
// Returns:   ClbrType_e
//************************************
ClbrType_e ClbrHndlr_GetClbrType(void);

//************************************
// Method:    ClbrHndlr_GetClbrBitmap
// Purpose:   TBD
// Parameter: void
// Returns:   calBitmap
//************************************
uint32 ClbrHndlr_GetClbrBitmap(void);

//************************************
// Method:    ClbrHndlr_Reset
// Purpose:   TBD
// Parameter: IN clbrHndlrResetConf_t * pConf
// Returns:   void
//************************************
void  ClbrHndlr_Reset (IN clbrHndlrResetConf_t* pConf); 

//************************************
// Method:    ClbrHndlr_GetCalibrationDataState
// Purpose:   Retrive store-load state (store, load, none)
// Parameter: OUT CalDataState_e *calDataState
// Returns:   void
//************************************
void ClbrHndlr_GetCalibrationDataState(OUT CalDataState_e *calDataState);
void ClbrHndlr_UpdateCalState(uint8 calIndex, bool calState);
void ClbrHndlr_setFrequency(void);
RetVal_e runCalibration(void);
void setNextOfflineCalibrationsBitmaps (CalibrSchedData_t* m_clbrSchedDataPtr, bool forceLoad);
void ClbrHndlr_ResetStatus(void);


#endif // __CalibrationHandler_h__

