#ifndef __CalibrationHandlerStatistics_h__
#define __CalibrationHandlerStatistics_h__

#include "System_GlobalDefinitions.h"
#include "mt_sysrst.h"
#include "CalibrationDefs.h"

/*********************************************
         Definitions      
**********************************************/

typedef struct  
{
	uint32	Dc_Ant_1_I	:4;
	uint32	Dc_Ant_2_I	:4;
	uint32	Dc_Ant_3_I	:4;
	uint32	Dc_Ant_4_I	:4;
	uint32	Dc_Ant_1_Q	:4;
	uint32	Dc_Ant_2_Q	:4;
	uint32	Dc_Ant_3_Q	:4;
	uint32	Dc_Ant_4_Q	:4;
	
	uint32	Rssi_Ant_1	:4;
	uint32	Rssi_Ant_2	:4;
	uint32	Rssi_Ant_3	:4;
	uint32	Rssi_Ant_4	:4;
	uint32	Lpf_Ant_1	:2;
	uint32	Lpf_Ant_2	:2;
	uint32	Lpf_Ant_3	:2;
	uint32	Lpf_Ant_4	:2;
	uint32	Rxiq_Ant_1	:2;
	uint32	Rxiq_Ant_2	:2;
	uint32	Rxiq_Ant_3	:2;
	uint32	Rxiq_Ant_4	:2;
	
	uint32	TXLL_Ant_1	 :2;
	uint32	TXLL_Ant_2	 :2;
	uint32	TXLL_Ant_3	 :2;
	uint32	TXLL_Ant_4	 :2;
	uint32	TXMM_Ant_1	 :2;
	uint32	TXMM_Ant_2	 :2;
	uint32	TXMM_Ant_3	 :2;
	uint32	TXMM_Ant_4	 :2;
	uint32  Vco			 :1;
	uint32  BF_afe		 :2;
	uint32  BF_agcGain	 :2;
	uint32  BF_K		 :2;
	uint32  BF_agcOffset :2;
	uint32  BF_txOffset	 :2;
	uint32  BF_modType	 :2;
	uint32  Alignment1	 :3;

	uint32	MsSsi_Ant_1   :4;
	uint32  MsSsi_Ant_2	  :4;
	uint32  MsSsi_Ant_3	  :4;
	uint32  MsSsi_Ant_4	  :4;
	uint32	Rssi_DC_Ant_1 :4;
	uint32	Rssi_DC_Ant_2 :4;
	uint32	Rssi_DC_Ant_3 :4;
	uint32	Rssi_DC_Ant_4 :4;
}CalStatus;

typedef struct offlineStatistics
{
	CalStatus  calibrationOfflineStatus;		
	uint32  RunTime[CLBR_PROC_TYPE_NUM]; // algo stat without TPC
}offlineStatistics_t;

typedef struct onlineStatistics
{
	//CalStatus  Calibration_Online_Status;
	uint32   RunTime[CLBR_PROC_TYPE_NUM]; 

}onlineStatistics_t;

/*********************************************
	     Globals and Extern Variable's       
**********************************************/
extern uint32* CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_NUM];  //Itai Statistics
extern offlineStatistics_t	offlineStatistics;

/*********************************************
    Function       
**********************************************/

//************************************
// Method:    ClbrStat_Init
// Purpose:   Initialization of the Calibration Handler Statistics module
// Returns:   void
//************************************
void ClbrHndlrStat_Init(void);

#endif // __CalibrationHandlerStatistics_h__
