#ifndef __AfePhaseClbrHndlr_h__
#define __AfePhaseClbrHndlr_h__

//#include "wlmmdefs.h"
#include "CalibrationDefs.h"
#include "HdkGlobalDefs.h"
#include "calibrationsParamsOtf.h"

//************************************
// Method:    AfePhase_Calibrate
// FullName:  AfePhase_Calibrate
// Access:    public 
// Returns:   RetVal_e
// Qualifier:
// Parameter: Non
//************************************
RetVal_e AfePhase_Calibrate(IN ClbrType_e inCalibType);

//************************************
// Method:    AfePhase_LoadResults
// Purpose:   Loads AfePhase data from a buffer
// Parameter: uint8 * in_puBuffer - Buffer containing calibration information
// Returns:   uint32 - Amount of bytes read from buffer
//************************************
uint32 AfePhase_LoadResults( uint8 * in_puBuffer);

//************************************
// Method:    AfePhase_StoreResults
// Purpose:   Saves AfePhase calibration data to a buffer
// Parameter: uint8 * out_puBuffer - Buffer containing calibration information
// Returns:   uint32 - Amount of bytes read from buffer
//************************************
uint32 AfePhase_StoreResults( uint8 * out_puBuffer);

//************************************
// Method:    AfePhase_SetStatus
// Purpose:   
// Parameter:  CalStatus_e inStatus - the new status
// Returns:   non
//************************************
void AfePhase_SetStatus(IN CalStatus_e inStatus);

//************************************
// Method:    AfePhase_GetStatus
// Purpose:   
// Parameter:  
// Returns:   non
//************************************
CalStatus_e AfePhase_GetStatus(void);

//************************************
// Method:    AfePhase_GetLastRunTime
// Purpose:   
// Parameter:  
// Returns:   non
//************************************
uint32 AfePhase_GetLastRunTime(void);

#endif // __AfePhaseClbrHndlr_h__

