#ifndef __BeamFormingClbrHndlr_h__
#define __BeamFormingClbrHndlr_h__


#include "HdkGlobalDefs.h"
#include "CalibrationDefs.h"

/******************************************************************************/
/***						Type Definitions									***/
/******************************************************************************/

typedef enum QbfSessions
{
	SESSION_0 = 0,				//transmit from antenna 0 to ant x
	SESSION_1,					//transmit from ant x to antenna 0 
	MAX_NUMBER_OF_CAL_SESSIONS,
}QbfSessions_e;

typedef struct QbfSessionsParams
{
	Antenna_e txAnt;
	Antenna_e rxAnt;
	Antenna_e calAnt;
	QbfSessions_e session;
	
} QbfSessionParams_t;

typedef struct QbfSavedRegs
{
	uint32 addr;
	uint32 val;
	
}QbfSavedRegs_t;

typedef struct QbfAgcGains
{
	uint8 pgc1Indx;
	uint8 pgc2Indx;
	uint8 pgc3Indx;
	uint8 lnaIndx;
	
} QbfAgcGains_t;

typedef struct int32_cmplx
{
	int32 real;
	int32 image;
	
}int32_cmplx_t;
typedef struct int16_cmplx
{
	int16 real;
	int16 image;
	
}int16_cmplx_t;

typedef struct int8_cmplx
{
	int8 real;
	int8 image;
	
}int8_cmplx_t;

typedef enum QbfSavedRegsNames
{
	firstSavedReg = 0,
	stbyMem       = 0,
	antEnableMem,
	txFeEnableMem,
	fftSharingMem,
	tx2ndInterpBypassMem,	
	txNoiseShapingEnMem,
	gpoMem,
	riscRunModeMem,
	tdEnableOverrideEnableMem,
	tdGlobalEnableMem,
	fdGclkBypassGsmMem,
	PhaseTrackBypassMem,
	FreqTrackEnableMem,
	detectionBypassMem,
	macMode20SsbMem,
	txEndDelayMem,
	txSwResetNregMem,
	txSublockEnableMem,
	implicitPrepMem,
	cpTimingEnableMem,
	tpcAccEnableMem,
	digitalGainAnt01Mem, 
	digitalGainAnt23Mem,
	NUMBER_OF_SAVE_REGISTERS,

}QbfSavedRegsNames_e;


typedef enum QBF_CalibrationPair
{
	PAIR_0 = 0,
	PAIR_1,
	MAX_NUMBER_OF_CAL_PAIRS,
	
}QBF_CalibrationPair_e;

typedef enum packetModulation
{
	QAM16_1_2,
	BPSK_1_2,
	TOTAL_MOD_OPTIONS
}packetModulation_e;

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
#define DEBUG_DIS_TX_CANCEL_VAL 0xAA

/******************************************************************************/
/***					Function Declaration							***/
/******************************************************************************/ 

void storeRegsValsBeforeAlb(bool* pAreRegsSaved);
void exitAirLoopBackMode(bool* pAreRegsSaved);
void acitvateAirLoopBackMode(bool agcOn,uint8 tpc, uint16 gain, uint8 isExtPa);
void prepareAndRouteTb(void);
CalStatus_e transmitValidatePacket(uint8* pNumOfPacketTransmitted, QbfSessionParams_t CalSessionParams, bool agcOn, QbfAgcGains_t agcGains, packetModulation_e mod, uint8 trSwRxAnt, uint8 trSwTxAnt,uint8 extLnaBypRxAnt);
int32_cmplx_t cmplxDiv(int16_cmplx_t in1, int16_cmplx_t in0, uint8 devisorShift, uint8 multShift);
void configureMacEmulatorPacket(packetModulation_e mod);
uint16 readChannelDataFromTB(int16_cmplx_t* pHcmplx
#ifdef QBF_CAL_DEBUG
											,QbfSessions_e session
#endif
																	);
uint16 readChannelDataFromChannelRam(QbfSessions_e session,Antenna_e rxAnt);
uint16 chRamRead(uint32 dataBins,uint32 groups);



//************************************
// Method:    BeamForming_run
// Purpose:   Run calibration procedure segments not more than the allocated time
// Parameter: IN uint32 time - Allocated time in milliseconds
// Returns:   int32
//************************************
RetVal_e BeamForming_run(IN ClbrType_e calibType);

#ifdef SDL_IGNORE_UNUSED_FUNCTION
//************************************
// Method:    pgcParamsInit
// Purpose:   
// Parameter: 
// Returns:   int32
//************************************
static void pgcParamsInit(void);
//************************************************
// Method:	beamFormingStatusInit
// Purpose: 
// Parameter: 
// Returns:   
//************************************************
static void beamFormingStatusInit(CalStatus_e calStatus);
#endif

//************************************
// Method:    BeamForming_Init
// Purpose:   
// Parameter: 
// Returns:   int32
//************************************
void BeamForming_Init(void);
//************************************
// Method:    BeamForming_GetStatus
// Purpose:   Get calibration status of given antenna
// Parameter: uint32 inAntennaPair
// Returns:   CalStatus_e - E_Fail or E_Pass
//************************************
CalStatus_e BeamForming_GetStatus(IN QBF_CalibrationType_e bfCalibrationType);

//************************************
// Method:    BeamForming_GetofflineModulationType
// Purpose:   Get offline calibration modulation type
// Parameter: uint32 inAntennaPair
//		CalStatus_E inStatus
// Returns:   void
//************************************

packetModulation_e BeamForming_GetofflineModulationType(void);

//************************************
// Method:    Qbf_SetStatus
// Purpose:   Set calibration status of given antenna
// Parameter: uint32 inAntennaPair
//		CalStatus_E inStatus
// Returns:   void
//************************************

void BeamForming_SetStatus(IN CalStatus_e inStatus, IN QBF_CalibrationType_e bfCalibrationType);

/*****************************************************/
// Method:	BeamForming_GetLastRunTime
// Purpose:   
// Parameter:
// Returns:   void
/*****************************************************/

uint32 BeamForming_GetLastRunTime(void);
/*****************************************************/
// Method:	BeamForming_Set64QamMode
// Purpose:   
// Parameter:
// Returns:   void
/*****************************************************/

#ifdef QBF_PHY_DEBUG

/*****************************************************/
void BeamForming_SetDisTxCancel (bool status);
/*****************************************************/
// Method:	BeamForming_GetDisTxCancel
// Purpose:   
// Parameter:
// Returns:   void
/*****************************************************/

uint8 BeamForming_GetDisTxCancel (void);


#endif //QBF_PHY_DEBUG
#endif // __BeamFormingClbrHndlr_h__



