#ifndef __BEAM_FORMING_DEFINITIONS_H__
#define __BEAM_FORMING_DEFINITIONS_H__

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
//QBF handler general definitions
#define QBF_MAX_FRAGMENT 0
#define N_GROUPS_CB 22
#define N_GROUPS_NCB 17
#define MAX_NUMBER_OF_CHANNEL_BINS 62

//Calculate calibration values
#define DEVIDER_RESULT_SHIFT 3
#define MULT_RESULT_SHIFT 6
#define MAX_12BIT_SIGN_VAL ((1 << 11) - 1)
#define WRITE_BINS_REAL_SHIFT 12
#define WRITE_BINS_IMAGE_SHIFT 0
#define WRITE_BINS_SKIPS (MAX_NUM_OF_DIGITAL_ANTENNAS << 2)
#define MASK_12_BIT 0xFFF
#define CAL_RESULT_WORD_LEN 4
#define PHASE_DIFF_TH 1175




/******************************************************************************/
/***						Macros											***/
/******************************************************************************/
#define TWOS_COMP_CONVERT_16BIT(VAL, NUMBER_OF_BITS) ((int16)(VAL << (16-NUMBER_OF_BITS))/(1<<(16-NUMBER_OF_BITS)))

/******************************************************************************/
/***					 Public Function Declarations						***/
/******************************************************************************/


#endif // __BEAM_FORMING_DEFINITIONS_H__


