
/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/

#include "CalibrationHandlerUtils.h"
#include "BeamFormingClbrHndlr.h"
#include "BeamFormingDefinitions.h"
#include "PhyDriver_API.h"
#include "PhyCalDriver_API.h"
#include "loggerAPI.h"
#include "Mtlkbfield.h"
#include "RficDriver_API.h"
#include "RficCommon.h"
#include "LmHdk_API.h"
#include "mib.h"
#include "PhyRegsIncluder.h"
#include "RFICDefines.h"
#include "lm.h"

#include "PhyRxBeIfRegs.h"
#include "PhyRxFdIfRegs.h"
#include "PhyRxTdIfRegs.h"
#include "PhyTxbIfRegs.h"
#include "PhyRxAgcIfRegs.h"
#include "PhyRxTdRegs.h"
#include "PhyTxRegs.h"
#include "PhyRxbeRegs.h"
#include "PhyRxFdRegs.h"
#include "mt_sysrst.h"
#include "RegAccess_Api.h"
#include "PhyTxMacEmuRegs.h"
#include "PSD.h"
#include "fast_mem_psd2mips.h"
#include "linkAdaptation_api.h"
#include "init_ifmsg.h"
#include "stringLibApi.h"

#include "CoC_Api.h"

	
/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/

#define LOG_LOCAL_GID	GLOBAL_GID_HDK_CALIBRATIONS_1
#define LOG_LOCAL_FID	4

/********************************************************************************
QbfAlgo:

Description:
------------

Output:
-------
*/
/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
//General definitions
#define LIMIT_SIGN(VAR, LIMIT) ((VAR>LIMIT)?LIMIT:((VAR<(-LIMIT))?(-LIMIT):VAR));

#define MASK_16LSB 0xFFFF
#define MASK_16MSB 0xFFFF0000
#define MASK_8LSB 0xFF
#define MASK_8MSB 0xFF00
#define SET_32BIT 0xFFFFFFFF
#define QBF_CAL_MOD_INIT QAM16_1_2

//TD regs
#define SW_RESET_VAL 0x2FFF
#define SW_EN_VAL 0x2FFF
#define MAC_MODE_20_SSB_MEM (RF_PHY_TD_BASE_ADDR + 0x0a80)
//Air loop back definitions

#define ALB_GPO_VALUE 0x5555

//TPC digital gain
#define TX_DIGITAL_GAIN_MASK 0x000001ff

// adc sampling polarity
#define ADC_SAMPLING_POLARITY_MASK 0xFFFF
 //ADC no power down
#define AFE_PD_CTRL_REG REG_AFE_PD_CTRL_RX0_PD
#define AFE_PD_CTRL_MASK_ALL 0xFFFF

//GenRisc Loopback mode 
#define SEMAPHORE_REG_04_LOOPBACK_MODE 0x1
#define SEMAPHORE_REG_04_LOOPBACK_MASK 0x1

//AGC
#define SEMAPHORE_REG_04_DISABLE_AGC_MASK 0x2
#define SEMAPHORE_REG_04_DISABLE_AGC_SHIFT 1

//TD enable overide
#define TD_ENABLE_OVERIDE_MASK 0x1

//TD FD BE global enable 
#define TD_FD_BE_GLOBAL_ENABLE_REG 0x10434
#define REG_TD_FD_BE_GLOBAL_ENABLE_MASK 0xFFFF
#define TD_FD_BE_GLOBAL_ENABLE_VAL 0xFFFF

//Short registers definitions

//Set short0
#define SHORT0_QBF_MASK 0xFFFF		
#define S0_SSION_VAL 0x2  
#define S0_SPU_VAL_RX_VAL 0x0 
#define S0_TX_ON 0x1 
#define S0_RX_ON 0x1
#define S0_RFFECTL_EXTLNA_2G5G_VAL 0x1 
#define TR_SWITCH_VAL 0x1
#define GENRISC_TR_SW_ADDR 0x20508

#define SHORT0_QBF_CAL_TX_VAL  ((S0_SSION_VAL << REG_RFIC_S0_SSION_SHIFT) \
								| (S0_TX_ON << REG_RFIC_S0_TXON_SHIFT) \
								| (S0_RFFECTL_EXTLNA_2G5G_VAL << REG_RFIC_S0_RFFECTL_EXTLNA_2G5G_SHIFT) \
								| (TR_SWITCH_VAL << REG_RFIC_S0_RFFECTL_RXTXSW_P_SHIFT)) 		//0x60a
#define SHORT0_QBF_CAL_RX_VAL  ((S0_SSION_VAL << REG_RFIC_S0_SSION_SHIFT) \
									| (S0_RX_ON << REG_RFIC_S0_RXON_SHIFT) \
									| (S0_RFFECTL_EXTLNA_2G5G_VAL << REG_RFIC_S0_RFFECTL_EXTLNA_2G5G_SHIFT) \
									| (TR_SWITCH_VAL << REG_RFIC_S0_RFFECTL_RXTXSW_N_SHIFT))		//0x506
	
#define SHORT0_QBF_CAL_RX_VAL_TR_SW_RX ((S0_SSION_VAL << REG_RFIC_S0_SSION_SHIFT) | (S0_RX_ON << REG_RFIC_S0_RXON_SHIFT) \
										| (S0_RFFECTL_EXTLNA_2G5G_VAL << REG_RFIC_S0_RFFECTL_EXTLNA_2G5G_SHIFT) \
										| (TR_SWITCH_VAL << REG_RFIC_S0_RFFECTL_RXTXSW_P_SHIFT)) //0x606
										
#define SHORT0_QBF_CAL_RX_VAL_TR_SW_TX 0x50a

#define SHORT0_QBF_CAL_RX_EXT_LNA_BYPASS 0x106


//Short3
#define TPC_AND_MIX_GAIN_ADDR REG_RFIC_S3_TPCGAIN
#define TPC_AND_MIX_GAIN_MASK (REG_RFIC_S3_TPCGAIN_MASK | REG_RFIC_S3_MIXGAIN_MASK | REG_RFIC_S3_SWC2_MOD2G_MASK | REG_RFIC_S3_PDGAIN_MASK)

// FD Gclock bypass - GSM
#define FD_GCLOCK_BYPASS_MASK 0x2000
#define FD_GCLOCK_BYPASS_VAL 0x2000

// Disable phase tracking	
#define PT_BYPASS_VAL 0x1

//GSM RAM offset
#define GSM_RAM_ADDR 0x20000
#define DISABLLE_FREQ_EST_FROM_LONG_MASK 0x2000000

/*Bypass detection*/
//Reset Tx
#define TX_SW_RESET_MASK 0xFFFFFFFF
#define SW_UN_RESET_VAL 0XFFFFFFFF

//Tx subclock enable
#define TX_ENABLE_MASK 0xFFFFFFFF
#define TX_ENABLE_VAL 0XFFFFFFFF

//BYpass detction 
#define BP_DETECTION_COUNTER_CB 888
#define BP_DETECTION_COUNTER_NCB 1124

//reset difi and td triggered from Tx   
#define RES_DIFI_RESET_TD_AND_TRIG_BP_DETECTION_MASK (REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_EN_MASK \
														| REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_RESET_RXTD_EN_MASK \
														| REG_PHY_RXTD_IF4C_DETECTOR_BYPASS_CLEAR_DIFI_EN_MASK)
#define RES_DIFI_RESET_TD_AND_TRIG_BP_DETECTION_VAL 0x7

//sw_reset mask during detector bypass mode 	
#define SW_RESET_GENERATE_VAL 0x47

// Tx style RAM address: 
#define TX_STYLE_RAM_ADDR (0x30000) //offset addr in B0_PHY_TX_BASE_ADDR

//Ssetting detection flag to rise to drop immediatly
#define TX_STLE_DETECTION_RISE_DROP_ADDR (TX_STYLE_RAM_ADDR + 0xDC)

// Tx style RAM address: setting NCB detection flag to rise to drop immediatly
#define TX_STLE_NCB_DETECTION_RISE_DROP_ADDR (TX_STYLE_RAM_ADDR + 0x54)
#define TX_STLE_DETECTION_RISE_DROP_MASK 0x4000

// configure channel in test bus for all 3 antennas
#define ENABLE_CHANNEL_TB_VALUE 0x7000

// set to capture mode (Mask 1) + cyclic disabled (mask 2) + No ext-trig (mask 4).
#define CAPUTRE_CYCLIC_NO_EXT_TRIG_MASK (REG_PHY_RXTD_REG84_TEST_FIFO_CAPTURE_MODE_MASK \
											| REG_PHY_RXTD_REG84_TEST_FIFO_CYCLIC_MODE_MASK \
											| REG_PHY_RXTD_REG84_TEST_FIFO_EXTERNAL_TRIG_EN_MASK)

#define CAPUTRE_CYCLIC_DIS_NO_EXT_TRIG_VAL 0x1

//Channel length
#define CHANNEL_LEN_CB 342
#define CHANNEL_LEN_NCB 168

//TX_RX_TABLE
#define TX_RX_TABLE_ADDR 0x12000 //offset addr in B0_PHY_FD_BASE_ADDR

// AGC DC TABLE
#define AGC_DC_TABLE_SIZE (DCTABLE1_ANT1_OFFSET*3*4)
#define DAC1I_SHIFT 15
#define DAC1Q_SHIFT 10
#define DAC2I_SHIFT 5
#define DAC2Q_SHIFT 0
#define DAC_WORD_LEN 5
#define DAC_WORD_MASK 0x1F
#define AGC_DC_TABLE_ANTENNA_SHIFT 5
#define AGC_DC_TABLE_PGC1_SHIFT 2
#define DAC2_REG_PGC2_OFFSET_SHIFT 2
#define DAC2_REG_PGC2_OFFSET_I_SHIFT 5
#define DAC2_REG_PGC2_OFFSET_Q_SHIFT 0
#define DAC2_REG_PGC2_OFFSET_WORD_LEN 5

//AFE stby mode
#define AFE_TX_STBY_MASK (REG_AFE_DYN_CTRL_TX0_STBY_MASK | REG_AFE_DYN_CTRL_TX1_STBY_MASK | REG_AFE_DYN_CTRL_TX2_STBY_MASK)
#define AFE_RX_STBY_MASK (REG_AFE_DYN_CTRL_RX0_STBY_MASK | REG_AFE_DYN_CTRL_RX1_STBY_MASK | REG_AFE_DYN_CTRL_RX2_STBY_MASK)
#define AFE_TX_STBY_ALL (0x7 << REG_AFE_DYN_CTRL_TX2_STBY_SHIFT)

//GenRisc configurations
#define GENRISC_SEND_PACKET_TRIGGER 0x203f4
//Genrisc Tx antenna information
#define GENRISC_DATA_RAM_ANT_INFO_ADDR 0x203f4
#define GENRISC_TX_ANT0_WORD 0x6
#define GENRISC_TX_ANT1_WORD 0x5
#define GENRISC_TX_ANT2_WORD 0x3

#define FTT_CONFIG_ANT_MASK (REG_TX_FFT_SHARING_FFT0_CONTROL_RX_MASK | REG_TX_FFT_SHARING_FFT1_CONTROL_RX_MASK | REG_TX_FFT_SHARING_FFT2_CONTROL_RX_MASK)

//GenRisc TB configuration
// Trigger GenRisc Request to record TB
#define GENRISC_SEND_TRIGGER_ADDR 0x20ab8
#define GENRISC_SEND_TRIGGER_MASK 0x1


//Check channel validity
#define WAIT_FOR_UPLOAD_CHANNEL_USEC_CB_16QAM 90		//Wait till GenRisc will finish uploading the received packet channel to the TB
#define WAIT_FOR_UPLOAD_CHANNEL_USEC_NCB_16QAM 92		//Wait till GenRisc will finish uploading the received packet channel to the TB
#define WAIT_FOR_UPLOAD_CHANNEL_USEC_AGC_OFF_16QAM 65
#define WAIT_FOR_UPLOAD_CHANNEL_USEC_CB_BPSK 95			//Wait till GenRisc will finish uploading the received packet channel to the TB
#define WAIT_FOR_UPLOAD_CHANNEL_USEC_NCB_BPSK 107		//Wait till GenRisc will finish uploading the received packet channel to the TB
#define WAIT_FOR_UPLOAD_CHANNEL_USEC_AGC_OFF_BPSK 80

#define GENRISC_RECORD_CHANNEL_INDICATIION_ADDR 0x20ab8
#define GENRISC_PACKET_LEN_VALIDITY_ADDR 0x20d54
#define CHANNEL_PACKET_LEN 3
#define CHANNEL_NOISE_EST_TH 192	// > 12in PHY studio screen
#define MAX_TRANSMIT_PACKETS 500
//Send validity packet
#define PACKET_TRANSMIT_MAX_RETRIES 3

//Read Channel from TB
#define CHANNEL_BINS_SAMPLING_FREQ 3
#define CARRIER_JUMP_CB 5
#define CARRIER_JUMP_NCB 3

#define CHANNEL_BINS_SKIP_CB CARRIER_JUMP_CB*TOTAL_ANTENNAS*4
#define CHANNEL_BINS_SKIP_NCB CARRIER_JUMP_NCB*TOTAL_ANTENNAS*4

#ifdef QBF_CAL_DEBUG
#define CHANNEL_BINS_SKIP_ALL_BINS	4
#endif
#define CHANNEL_BIN_REAL_WORD_SHIFT 0
#define CHANNEL_BIN_IMAGE_WORD_SHIFT 12
#define CHANNEL_BIN_WORD_LEN CHANNEL_BIN_IMAGE_WORD_SHIFT
#define TB_READ_CHANNEL_ADDR_CB_OFFSET 8
#define TB_READ_CHANNEL_ADDR_NCB_OFFSET 5
#define TB_FIFO_LOW_START_ADDRESS 0
#define TB_READ_CHANNEL_ADDR_CB (TB_FIFO_LOW_START_ADDRESS + TB_READ_CHANNEL_ADDR_CB_OFFSET*TOTAL_ANTENNAS*4) //6 pilot bins+2 carrier offset
#define TB_READ_CHANNEL_ADDR_NCB (TB_FIFO_LOW_START_ADDRESS + TB_READ_CHANNEL_ADDR_NCB_OFFSET*TOTAL_ANTENNAS*4) // 4 pilot bins+1 carrier offset

// SW reset
#define REG_PHY_RXTD_REG00_SW_RESET_N_GENRISC_SHIFT 6
#define REG_PHY_RXTD_REG01_BLOCK_EN_GENRISC_SHIFT 6

//MAC emulator
#define SCR_INIT_SEL_MASK 0x8
#define TX_END_DELAY 0x100

//Find AGC values for correct back off during calibration
#define MAX_DIGITAL_GAIN 320
#define MAX_DIGITAL_GAIN_RX 320

#define AGC_VALUES_ADDR_ANT0 0x209bc
#define AGC_VALUES_ADDR_ANT1 0x20ccc
#define AGC_VALUES_ADDR_ANT2 0x20cf8
#define RX_GAIN_LNA_LOW_GAIN 0
#define RX_GAIN_LNA_MID_GAIN 14
#define RX_GAIN_LNA_HIGH_GAIN 27
#define BACK_OFF_OFFSET 8
#define RELATIVE_GAIN_MIN_VAL 0
#define RELATIVE_GAIN_MAX_VAL 45
#define RELATIVE_GAIN_MAX_ERROR_VAL 50
#define PGC1_3_MIN_VAL 0
#define PGC1_MAX_VAL 5
#define PGC3_MAX_VAL 15
#define PGC1_2_STEP_DB 6

//Agc offset calibration
#define	DIGITAL_GAIN_LEVEL4 24
#define	DIGITAL_GAIN_LEVEL3 18
#define	DIGITAL_GAIN_LEVEL2 12
#define	DIGITAL_GAIN_LEVEL1 6

#define DIGITAL_GAIN_LEVEL4_SHIFT 4
#define DIGITAL_GAIN_LEVEL3_SHIFT 3
#define DIGITAL_GAIN_LEVEL2_SHIFT 2
#define DIGITAL_GAIN_LEVEL1_SHIFT 1

#define AGC_OFFSET_CAL_PGC1_ITERAIONS 7
#define AGC_OFFSET_CAL_PGC2_ITERAIONS 5

#define AGC_OFFSET_CAL_LNA_ITERAIONS 6
#define AGC_OFFSET_CAL_TR_SW_ITERAIONS 1

#define AGC_OFFSET_LNA_CAL_GAIN_PHASE_FIRST_INDX 0
#define AGC_OFFSET_PGC1_CAL_GAIN_PHASE_FIRST_INDX 5
#define AGC_OFFSET_PGC2_CAL_GAIN_PHASE_FIRST_INDX 12

#define AGC_OFFSET_TRSW_CAL_GAIN_PHASE_FIRST_INDX 4

#define AGC_OFFSET_FIRST_CAL_PACKETS_TRANS_BEFORE_CALC 2
#define AGC_OFFSET_TRANS_BEFORE_CALC 1

#define AGC_OFFSET_LNA_LOW_GAIN 10
#define AGC_OFFSET_LNA_MID_GAIN 24
#define AGC_OFFSET_LNA_HIGH_GAIN 37
#define AGC_OFFSET_CAL_GAIN_START_ADDR (B0_PHY_RX_TD_BASE_ADDR + 0x20c00 )
#define AGC_OFFSET_CAL_PHASE_START_ADDR (B0_PHY_FD_BASE_ADDR +0x38000)
#define MAX_AGC_CALIBRATIONS_VALS_NUMBER 18
#define MAX_8BIT_SIGN_VAL ((1 << 7) - 1)
#define DIV_RESULT_SHIFT 1
#define PHASE_CALC_SHIFT 7

#define PHASE_REAL_SHIFT 8
#define PHASE_IMAGE_SHIFT 0
#define DB_CALC_CORRECTION 3*14*8 	//3*14:original lsb bits,*8:2^3 because log result is 2^-3
#define MATLAB_OFFSET 3 			//+3:matlab shows reduced error(<=0.4, otherwise <=0.7)

// DB converter accurate calculation
#define NUM_CCA_RESIDUE_BITS 3

//Tx offset calibration
#define TX_CORRECTION_START_ADDERSS 0x0a000
#define TX_CORRECTION_ANT_OFFSET 0x800
#define TPC_INDEX_STEP 1
#define MAX_TX_CALIBRATIONS_VALS_NUMBER 5
#define TX_CALIRATION_RES_ADDR_STEP (MAX_TX_CALIBRATIONS_VALS_NUMBER << 2)

// External gain
#define PD_GAIN 12
#define MIXER_GAIN 12
#define EXT_GAIN_DB_ADDR 	0x20e18
#define EXT_PA_ADDR_OFFSET 	0x20e08
#define EXT_GAIN_ADDR 	 	0x20e14
#define TR_ATTEN_DB_ADDR 	0x20d4c
#define TX_ANT_INFO_ADDR 	0x20bf4

#define EXT_PA_MASK 	 0x100
#define EXT_PA_SHIFT 	 8

#define SPECTRUM_80M    	0
#define SPECTRUM_2080M    1
#define SPECTRUM_4080M    2

#define TOTAL_EXT_GAIN_DB_ADD   0x30020E34


/******************************************************************************/
/***						MACROs											***/
/******************************************************************************/
/******************************************************************************/
/***						Type Definitions								***/
/******************************************************************************/
typedef enum QbfAgcOffsetCalType
{
	LNA_CAL = 0,
	PGC1_CAL,	
	PGC2_CAL,
	TOTAL_CAL_TYPE,
}QbfAgcOffsetCalType_e;

typedef enum BFqaPassFail
{
	AGC_GAIN_PASS = 0x1,
	K_CALIB_PASS = 0x2,
	AGC_OFFSET_PASS = 0x4,
	TX_OFFSET_PASS = 0x8,
	CAL_MODE_16QAM_PASS = 0x10,
}BFqaPassFail_e;



typedef struct QbfParams
{
	Antenna_e numberOfAntennas; 	//number of calibration pairs, 1 or 2
	bool fragmentationOn;	//Fragmentation On/Off
	uint8 stateCnt;			//How many states already run
	bool areRegsSaved;
	uint8 numOfPacketTransmitted;
	uint8 currentCalPair;
#ifdef QBF_PHY_DEBUG
	uint8 disTxCancel;
#endif
	//uint8 pgc1Cal [TOTAL_ANTENNAS][MAX_NUMBER_OF_CAL_SESSIONS];
	//uint8 pgc3Cal [TOTAL_ANTENNAS][MAX_NUMBER_OF_CAL_SESSIONS];
	uint8 pgc1CalK [MAX_NUMBER_OF_CAL_SESSIONS];
	uint8 pgc3CalK [MAX_NUMBER_OF_CAL_SESSIONS];
	packetModulation_e offlineModulationType;
	uint16 digitalGainForKCal;
	uint8 tpcForKCal;
	uint8 TrSwForAgcAndTxCal;
	uint16 digitalGainForAgcCal;
	uint8 tpcForAgcCal;		 
	uint16 digitalGainForTxCal;
	uint8 tpcForTxCal;		 
	bool  isExternalGain;  
	uint8  isExternalPa;
	uint8 	extLnaForAgcAndTxCal;
} QbfParams_t;

typedef struct QbfResults
{
	CalStatus_e status[MAX_NUMBER_OF_BF_CALS];
	int16* pHreal; 	// 22 bins array for each pair read from TB
	int16* pHimage; 	// 22 bins array for each pair read from TB
	uint8 numberOfChannelBins [MAX_NUMBER_OF_CAL_PAIRS];
	uint32 lastRunTime; 
} QbfResults_t;

typedef struct QbfElements
{
	QbfParams_t params;
	QbfResults_t results;

} QbfElements_t;


typedef struct QbfAgcoffsetCalParams
{
	QbfSessionParams_t sessionParams;
	uint8 pgc2CalOn;
	uint8 pgc1CalOn;
	uint8 lnaCalOn;
	uint8 lnaIndex;
	uint8 trSwCalOn;
	uint8 gainIndx;
	uint8 phaseIndx;
	uint8 calNumOfIterations;
	bool firstIter;
	uint8 numOfPacketsCollectBeforeCalc;
}QbfAgcOffsetCalParams_t;

typedef struct QbfTxOffsetCalParams
{
	QbfSessionParams_t sessionParams;
	uint8 tpcFirstIndex;
}QbfTxOffsetCalParams_t;

/******************************************************************************/
/***						External Variables								***/
/******************************************************************************/


/******************************************************************************/
/***						Static Variables								***/
/******************************************************************************/
static QbfElements_t m_Qbf_elements;
static uint32 longPacket = 1;
static QbfAgcGains_t agcGainsForAllAntennas[MAX_NUM_OF_ANTENNAS - 1][MAX_NUMBER_OF_CAL_SESSIONS];
static QbfAgcGains_t agcGainsForKCAlibration[MAX_NUM_OF_ANTENNAS - 1];




int16_cmplx_t Hcmplx[MAX_NUMBER_OF_CAL_SESSIONS][MAX_NUMBER_OF_CHANNEL_BINS];
int16_cmplx_t HrealTemp[MAX_NUMBER_OF_CHANNEL_BINS];



#ifdef QBF_CAL_DEBUG
uint32 Hraw [MAX_NUMBER_OF_CAL_PAIRS][MAX_NUMBER_OF_CAL_SESSIONS][CHANNEL_LEN_CB] ;
#endif
#ifdef QBF_ONLINE_OFFLINE_DEBUG
	static uint32 KresultCmplxDebug [10][MAX_NUMBER_OF_CAL_PAIRS][MAX_NUMBER_OF_CHANNEL_BINS] = {0};
#endif

QbfSavedRegs_t SavedRegs[NUMBER_OF_SAVE_REGISTERS] ={
												
			/*stbyMem*/				{REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_AFE_DYN_CTRL,0},												
			/*antEnableMem*/			{REG_PHY_RX_TD_PHY_RXTD_REG3C,0},
			
			/*txFeEnableMem*/			{REG_PHY_TX_REGS_TX_BE_REG_07,0},
			/*fftSharingMem*/			{REG_PHY_TX_REGS_TX_FFT_SHARING,0},
			/*tx2ndInterpBypassMem*/	{REG_PHY_TX_REGS_TX_2ND_FILTER,0},
			/*txNoiseShapingEnMem*/		{REG_PHY_TX_REGS_NOISE_SHAPING,0},
			
			/*gpoMem*/					{REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IFFD,0},
			/*riscRunModeMem*/			{REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF04,0},
			/*tdEnableOverrideEnableMem*/{REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF1B,0},
			
			/*tdGlobalEnableMem*/		{REG_PHY_RX_TD_IF_RISC_PAGE_0_FD_PHY_RXFD_IF10D,0},
			/*fdGclkBypassGsmMem*/		{REG_PHY_RX_TD_IF_RISC_PAGE_0_FD_PHY_RXFD_IF11D,0},
			/*PhaseTrackBypassMem*/		{REG_PHY_RX_FD_PHY_RXFD_REG06,0},
			/*FreqTrackEnableMem*/		{REG_PHY_RX_FD_PHY_RXFD_REG0A,0},
			
			/*detectionBypassMem*/		{REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF4C,0},
			/*macMode20SsbMem*/		{MAC_MODE_20_SSB_MEM,0},
			
			/*txEndDelayMem*/			{REG_PHY_TX_REGS_TX_BE_REG_0E,0},
			/*txSwResetNregMem*/		{REG_PHY_RX_TD_IF_RISC_PAGE_0_TXB_PHY_TXB_RISC_REG1C5,0},
			/*txSublockEnableMem*/		{REG_PHY_RX_TD_IF_RISC_PAGE_0_TXB_PHY_TXB_RISC_REG1C6,0},
			
			/*implicitPrepMem*/			{REG_PHY_RX_TD_IF_RISC_PAGE_0_FD_PHY_RXFD_IF12D,0},
			/*cpTimingEnableMem*/		{REG_PHY_RX_TD_PHY_RXTD_REG24B,0},
			/*tpcAccEnableMem*/			{REG_PHY_TX_REGS_TPC_ACC,0},
			/*digitalGainAnt01Mem*/		{REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F,0},
			/*digitalGainAnt23Mem*/		{REG_PHY_TX_REGS_TX2_TX3_AMP_GAIN_F,0}

						};
RegPhyTxRegsTxBeReg07_u 				txBeReg07;
RegPhyTxRegsTxBeReg0E_u 				txBeReg0e;
RegPhyTxRegsTxBeReg11_u 				txBeReg11;
RegPhyTxRegsTx2NdFilter_u 				tx2NdFilter;
RegPhyTxRegsNoiseShaping_u 				txNoiseShaping;
RegPhyRxTdIfRiscPage0TdPhyRxtdIffd_u 	tdPhyRxtdIffd;
RegPhyRxTdIfRiscPage0TdPhyRxtdIf04_u 	tdPhyRxtdIf04;
RegPhyRxTdIfRiscPage0TdPhyRxtdIf1B_u 	tdPhyRxtdIf1b;
RegPhyRxTdIfRiscPage0FdPhyRxfdIf10D_u 	fdPhyRxfdIf10d;
RegPhyRxTdIfRiscPage0FdPhyRxfdIf11D_u 	fdPhyRxfdIf11d;
RegPhyRxFdPhyRxfdReg06_u 				fdPhyRxfdReg06;
RegPhyRxFdPhyRxfdReg0A_u 				fdPhyRxfdReg0a;
RegPhyRxTdIfRiscPage0TdPhyRxtdIf4C_u 	tdPhyRxtdIf4c;
RegPhyRxTdPhyRxtdReg3C_u 				rxTdReg3c;
RegPhyTxRegsTpcAcc_u 					tpcAcc;
RegPhyTxRegsTx0Tx1AmpGainF_u 			tx0Tx1AmpGain;
RegPhyTxRegsTx2Tx3AmpGainF_u 			tx2Tx3AmpGain;
RegPhyRxTdPhyRxtdReg24B_u               rxTdReg24b;







uint8 bins80[62] = {0,4,8,12,16,19,23,27,31,35,39,43,46,50,54,58,62,66,70,74,78,81,85,89,93,97,101,105,108,112,116,117,121,125,128,132,136,140,144,148,152,155,159,163,167,171,175,179,183,187,190,194,198,202,206,210,214,217,221,225,229,233};
uint8 bins40[30] = {0,4,7,11,15,19,23,27,31,34,38,42,45,49,53,54,58,62,65,69,73,76,80,84,88,92,96,100,103,107};
uint8 bins20[16] = {0,2,5,9,13,16,20,24,25,29,33,36,40,44,47,51};

/******************************************************************************/
/***					Static Function Declaration							***/
/******************************************************************************/ 

static RetVal_e run( IN ClbrType_e calibType, IN QbfElements_t* pElements);
static void getTxGainsFromExtGain(QbfElements_t* pElements); 
static void fillSessionParams(QbfSessionParams_t* pCalSessionParams, Antenna_e calAnt);
static void calculateAndWriteCalibrationValues (Antenna_e ant, QbfElements_t* pElements);
 CalStatus_e beamFormingCalFrag0(QbfElements_t* pElements);
 CalStatus_e CalibrateK(QbfElements_t* pElements, bool agcOn);
 CalStatus_e calibrateKproc (Antenna_e ant, bool agcOn, QbfElements_t* pElements);
static void setTxAndRxRegisters(QbfSessionParams_t calSessionParams, bool agcOn, QbfAgcGains_t agcGains,uint8 trSwRxAnt, uint8 trSwTxAnt,uint8 extLnaBypRxAnt);
static void setShort0(Antenna_e txAnt,Antenna_e rxAnt,uint8 trSwRxAnt, uint8 trSwTxAnt,uint8 extLnaBypRxAnt);
//static void setShort3(uint8 tpc, uint8 isExtPA);
static void setRficTxParams(uint8 tpc);
static void setRficRxGain(Antenna_e rxAnt,QbfAgcGains_t agcGains);

//static void setShort12(Antenna_e rxAnt, QbfAgcGains_t agcGains);
//static void createShort12(Antenna_e ant, QbfAgcGains_t agcGains, uint32* pShortArr);
static void triggerTB(void);
 bool checkChannelValidity(QbfSessionParams_t CalSessionParams, uint16 waitingTime);
//static void setPgc1_3(uint8 *pgc1, uint8 *pgc3, int16 relativeGain);
//static CalStatus_e setRxGainValues(QbfElements_t *pElements, QbfSessionParams_t sessionParams, QbfAgcGains_t agcGains, int16 *pRelativeGain);
static CalStatus_e calibrateRxGainsForCalibration (QbfElements_t *pElements, QbfSessionParams_t CalSessionParams, int16 *pRelativeGain,uint8 trSwTxAnt);
//static void setRxGainsForK (uint8 *pPgc1CalK, uint8 *pPgc3CalK, int16 relativeGain0, int16 relativeGain1);
static CalStatus_e agcGainCalibration (QbfElements_t* pElements);
static CalStatus_e calibrateAgcOffsets(QbfElements_t* pElements);
static CalStatus_e calibrateAgcOffsetsAnt(QbfElements_t* pElements, Antenna_e txAnt, Antenna_e rxAnt);
static void fillAgcOffsetCalParams (QbfAgcOffsetCalParams_t *agcOffsetCalParams, QbfAgcOffsetCalType_e type);
static  CalStatus_e calibrateAgcOffsetsProc(QbfElements_t* pElements, QbfAgcOffsetCalParams_t* pCalParams);
static uint16 setDigitalGainForAgcOffsetCal(int16 relativeGain);
static uint16 getDigitalAttenuation (int16 relativeGain);
static  void calculateAgcCorrection(QbfAgcOffsetCalParams_t *pCalParams, int16 gainFix);
static int8_cmplx_t calculatePhase(int32_cmplx_t input, uint8 shift);
static uint32 absHwAccurate(int32_cmplx_t input);
static uint16 dBConverterAccurate(uint32 power);
static CalStatus_e calibrateTxOffsetForBfProc(QbfElements_t* pElements, QbfTxOffsetCalParams_t *pCalParams);
static void calculateTxCorrection(QbfTxOffsetCalParams_t *pCalParams, uint8 calIndex);
static CalStatus_e calibrateTxOffsetsAnt (QbfElements_t* pElements, Antenna_e txAnt, Antenna_e rxAnt);
static CalStatus_e CalibrateTxOffsetsForBf (QbfElements_t* pElements);
static CalStatus_e transmitPacketAndCalcAgcCorrection(QbfElements_t* pElements, QbfAgcOffsetCalParams_t *pCalParams, bool agcOn, QbfAgcGains_t agcGains,  int16 gainFix, bool calcAgcCorrection, uint8 trSwRxAnt, uint8 TrSwTxAnt);
static void sendMacEmulatorPacket(void);
static uint32 getNumOfGroups(void);
static uint32 getGroupOffset(void);
static uint32 getNumOfDataBins(void);

RetVal_e runBeamFormingCalibration(QbfElements_t* pElements
#ifdef 	QBF_FRAGMENTATION
										 ,bool FragmentOn
#endif 
																	);
/******************************************************************************/
/***					External Functions 	eclaration							***/
/******************************************************************************/ 
//extern void memcpy(void * destaddr,void const * srcaddr,uint32 len);

/******************************************************************************/
/***						Functions Definitions							***/
/******************************************************************************/

RetVal_e BeamForming_run( IN ClbrType_e calibType )
{
	if (CoC_getNumActiveTxAnts() > 1)
	{
		return run(calibType, &m_Qbf_elements);
	}
	else
	{
		return RET_VAL_SUCCESS;
	}
}

//************************************
// Method:    run
// Purpose:   Internal master function to execute single algorithm session
// Parameter: IN ClbrType_e calibType - OFFLINE/ONLINE
// Parameter: IN DcElements_t * pElements
// Parameter: IN uint32 scanType
// Returns:   RetVal_e
//************************************


static RetVal_e run( IN ClbrType_e calibType, IN QbfElements_t* pElements)
{
	RetVal_e retVal = RET_VAL_SUCCESS;
	uint32 startCalTime = TIME_STAMP(START_TIME,0);
	packetModulation_e packetMod = QBF_CAL_MOD_INIT;
	uint32 txAntMask;
#ifdef QBF_FRAGMENTATION
	bool fragmentOn = pElements->params.fragmentationOn;
#endif 
	txAntMask = Hdk_GetTxAntMask();
	if(txAntMask == ANTENNA_BITMAP_ALL_ANTENNAS)
	{
		pElements->params.numberOfAntennas = MAX_NUM_OF_ANTENNAS;
	}
	else
	{
		pElements->params.numberOfAntennas = ANTENNA_1;
	}
	
#if BF_CALIBRATION_LOGS_ON
	ILOG0_V("START AFE CALIBRATION");
#endif	

    if (retVal!= RET_VAL_SUCCESS)
    {
		BeamForming_SetStatus(CAL_STATUS_FAIL, AFE);
		return retVal;
    }
	else
	{
		BeamForming_SetStatus(CAL_STATUS_PASS, AFE);
	}
	getTxGainsFromExtGain(pElements); 
/*	Saves the current registers, in order to return from air loop back mode to normal mode, after the calibration is finished*/
	storeRegsValsBeforeAlb(&(pElements->params.areRegsSaved));

/* In offline calibration mode we try first to run calibration with 16QAM 1/2 modulation, anf if it fail we switch to BPSK_1_2 and try again */
	do 	
	{
		pElements->params.offlineModulationType = packetMod;
		REGISTER(OFFLINE_BFCAL_DATABASE) = 0x0;
		configureMacEmulatorPacket(packetMod);
		retVal = runBeamFormingCalibration(pElements
#ifdef QBF_FRAGMENTATION
											,fragmentOn
#endif 
														);
		packetMod++;
#if BF_CALIBRATION_LOGS_ON
		ILOG0_DD("retVal=%d, packetMod=%d",retVal, packetMod);
#endif
	}
	while ((calibType==CLBR_TYPE_OFFLINE) && (retVal != RET_VAL_SUCCESS) && (packetMod < TOTAL_MOD_OPTIONS));
	
	if(packetMod < TOTAL_MOD_OPTIONS)
	{
		REGISTER(OFFLINE_BFCAL_DATABASE) |= CAL_MODE_16QAM_PASS;//debug for qa
	}
#if BF_CALIBRATION_LOGS_ON
	ILOG0_DD("packetMod=%d,pElements->results.offlineModulationType=%d ",packetMod, pElements->params.offlineModulationType); 
#endif

#if BF_CALIBRATION_LOGS_ON
		ILOG0_V ("exit ALB mode, calibration end!");
#endif
	exitAirLoopBackMode(&(pElements->params.areRegsSaved));

	pElements->results.lastRunTime = TIME_STAMP(END_TIME,startCalTime); //run time of one fragment

#if BF_CALIBRATION_LOGS_ON
	ILOG0_D("LastClRunTime: %d",pElements->results.lastRunTime);  
#endif

	return retVal; //report the need for additional time for next on-line session
}
//************************************
// Method:    runBeamFormingCalibration
// Purpose:   Internal master function to execute single algorithm session
// Parameter: IN ClbrType_e calibType - OFFLINE/ONLINE
// Parameter: IN DcElements_t * pElements
// Parameter: IN uint32 scanType
// Returns:   RetVal_e
//************************************

RetVal_e runBeamFormingCalibration(QbfElements_t* pElements
#ifdef 	QBF_FRAGMENTATION
												, bool FragmentOn
#endif 
																	)

{
	CalStatus_e calStatus = CAL_STATUS_INIT;
	RetVal_e retVal = RET_VAL_SUCCESS;

	/******************************/
	/*	perform calibration fragment #0 */
	/******************************/
#ifdef QBF_FRAGMENTATION
	if (pElements->params.stateCnt == 0)
#endif
	{
		calStatus = beamFormingCalFrag0(pElements);
	}
		
#ifdef QBF_FRAGMENTATION
	/******************************/
	/*	perform calibration fragment #1*/
	/******************************/
	if (FragmentOn == FALSE || pElements->params.stateCnt == 1)
	{
			
	}
#endif // QBF_FRAGMENTATION
		
	if (calStatus != CAL_STATUS_PASS)
	{
		retVal = RET_VAL_FAIL;
	}
#ifdef QBF_FRAGMENTATION
	
	else if (pElements->params.stateCnt != QBF_MAX_FRAGMENT)
	{
		retVal	= RET_VAL_FRAGMENTED;
		pElements->params.stateCnt++;
	}
	else		//stateCnt == QBF_MAX_FRAGMENT
	{
		pElements->params.stateCnt = 0;
	}
#if BF_CALIBRATION_LOGS_ON
	ILOG0_V ("QBF calibration finished");
#endif
#endif //QBF_FRAGMENTATION

	return retVal;
}
//************************************************
// Method:    activateAirLoopBackMode
// Purpose:   Enters the phy into a special mode, called Air Loop Back. In this mode we can
//transmit over the air from one modem antenna to another, with a constant 
//phase at reception.
// Parameter: 
// Returns:   void
//************************************************
static void acitvateAirLoopBackMode(bool agcOn,uint8 tpc, uint16 gain,uint8 isExtPa)
{
	
	RegAccess_Read(REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, &tx0Tx1AmpGain.val);
	tx0Tx1AmpGain.bitFields.digitalTpcGainEn = 0x1;
	RegAccess_Write(REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F,tx0Tx1AmpGain.val);
	
	tpcAcc.bitFields.tpcaccenable = 0;
	RegAccess_Write(REG_PHY_TX_REGS_TPC_ACC,tpcAcc.val);


	PhyCalDrv_SetDigitalGain(0,0,gain);
	
	// set TPC for all antennas (short 3) 
	//setShort3(tpc,isExtPa);
	setRficTxParams(tpc);
#if BF_CALIBRATION_LOGS_ON
		ILOG0_DD("Setting TPC: %d, for extPa = %d", tpc, isExtPa);
#endif
	//tx 2nd interpolation filter bypass
	//tx2NdFilter.bitFields.tx2NdFilterBypass = 1;
	//RegAccess_Write(REG_PHY_TX_REGS_TX_2ND_FILTER, tx2NdFilter.val);
	// noise shaper disabled
	//txNoiseShaping.bitFields.txNoiseShapingEn = 0;
	//RegAccess_Write(REG_PHY_TX_REGS_NOISE_SHAPING,txNoiseShaping.val);
	
	// gpo	 
	tdPhyRxtdIffd.bitFields.hypRxtdGpo = ALB_GPO_VALUE;
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IFFD, tdPhyRxtdIffd.val);
	
	// disable cp timing to avoid timing changes
	rxTdReg24b.bitFields.cpTimingEnable  = 0x0;
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG24B,rxTdReg24b.val);
	
	// Activate GenRisc Loopback mode 
	tdPhyRxtdIf04.bitFields.semaphoreReg04 |= SEMAPHORE_REG_04_LOOPBACK_MODE;
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF04,tdPhyRxtdIf04.val);
	// Disable AGC
	if(agcOn)
	{
		tdPhyRxtdIf04.bitFields.semaphoreReg04 &= ~0x0002;//bit 1 =0
	}
	else
	{
		tdPhyRxtdIf04.bitFields.semaphoreReg04 |= 0x0002; ///bit 1 = 1
	}
	
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF04,tdPhyRxtdIf04.val);
	// don't throw CB packets in CoEx mode SSB	
	RegAccess_Write(MAC_MODE_20_SSB_MEM, 0x0);
	// TD enable override - to enable loopback
	tdPhyRxtdIf1b.bitFields.tdEnableOverride = 0x1;
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF1B, tdPhyRxtdIf1b.val);
	// TD FD BE global enable - overide td global enable
	fdPhyRxfdIf10d.val |= TD_FD_BE_GLOBAL_ENABLE_VAL;
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_FD_PHY_RXFD_IF10D, fdPhyRxfdIf10d.val);
	// FD Gclock bypass - GSM
	fdPhyRxfdIf11d.bitFields.gclkDebugBypass |= FD_GCLOCK_BYPASS_VAL;
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_FD_PHY_RXFD_IF11D, fdPhyRxfdIf11d.val);
	// Disable phase tracking	
	fdPhyRxfdReg06.bitFields.ptBypass = PT_BYPASS_VAL;
	RegAccess_Write(REG_PHY_RX_FD_PHY_RXFD_REG06, fdPhyRxfdReg06.val);
	// Disable frequency tracking
	fdPhyRxfdReg0a.bitFields.ftEnable = 0x0;
	RegAccess_Write(REG_PHY_RX_FD_PHY_RXFD_REG0A, fdPhyRxfdReg0a.val);	
	
	

	/* Bypass detection*/
	/*Set detector fine timing bypass - trigger from TX  */
	//Reset TX
	//RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_00,0x0);
	//Get out of reset in TX
	//RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_00,SW_UN_RESET_VAL);
	//Enable TX
	//RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_01, TX_ENABLE_VAL);
	//Set Bypass counter
	tdPhyRxtdIf4c.bitFields.detectorBypassCntValue = 0x42c;
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF4C, tdPhyRxtdIf4c.val);
	//Reset difi and td triggered from Tx
	tdPhyRxtdIf4c.bitFields.detectorBypassEn = 0x1;
	tdPhyRxtdIf4c.bitFields.detectorBypassResetRxtdEn = 0x1;
	tdPhyRxtdIf4c.bitFields.reserved0 = 0x1;
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF4C, tdPhyRxtdIf4c.val);//Eran check mask with Nir reserved0 seconfd bit not defined
}

//************************************************
// Method:    prepareAndRouteTb
// Purpose:   Configure the Test-Bus to record the channel
// Parameter: 
// Returns:   void
//************************************************
void prepareAndRouteTb(void)
{
	
}
//************************************************
// Method:    calibrateKproc(uint8 ant)
// Purpose:   Calibrate antenna 'ant' relative to antenna 0
// Parameter: ant - number of antenna (1 or 2, antenna 0 doesn't need calibrate).
// Returns:   RetVal: success or fail
//************************************************
 CalStatus_e calibrateKproc (Antenna_e ant, bool agcOn, QbfElements_t* pElements)
{
	CalStatus_e calStatus;
	QbfSessions_e session;
	QbfSessionParams_t calSessionParams[MAX_NUMBER_OF_CAL_SESSIONS];
	QbfAgcGains_t agcGains;
	uint8 antIndexChange= 0;

	DEBUG_ASSERT (ant!=0);	//calibration is performed only for ant > 0,  compared to antenna 0

#if BF_CALIBRATION_LOGS_ON
	ILOG0_D("agcGains(ant %d)",ant);
	ILOG0_DDDD("lnaIndx = %d pgc1Indx = %d pgc2Indx = %d pgc3Indx = %d",agcGains.lnaIndx,agcGains.pgc1Indx,agcGains.pgc2Indx,agcGains.pgc3Indx);
#endif

	fillSessionParams(calSessionParams, ant);
	agcGains.pgc1Indx = agcGainsForKCAlibration[ant -1].pgc1Indx;
	agcGains.pgc2Indx = agcGainsForKCAlibration[ant-1].pgc2Indx;
	agcGains.lnaIndx = agcGainsForKCAlibration[ant-1].lnaIndx;

	for (session = SESSION_0; session < MAX_NUMBER_OF_CAL_SESSIONS; session++)
	{

#if BF_CALIBRATION_LOGS_ON
		ILOG0_DD ("Send packet %d => %d", calSessionParams[session].txAnt, calSessionParams[session].rxAnt);
#endif
		calStatus = transmitValidatePacket(&(pElements->params.numOfPacketTransmitted), calSessionParams[session], agcOn, agcGains, pElements->params.offlineModulationType,0,0,0);
		
		if (calStatus == CAL_STATUS_FAIL)
		{
			break;
		}
		
		//fills channel array
		readChannelDataFromChannelRam(session,(Antenna_e)((uint8)ant - antIndexChange));
		antIndexChange++;
#if BF_CALIBRATION_LOGS_ON
		ILOG0_DD("Packet sent from ant %d to ant %d", calSessionParams[session].txAnt, calSessionParams[session].rxAnt);
#endif
	}
	
	//calculate calibration result if validation succeeded

	if (calStatus != CAL_STATUS_FAIL)
	{
		
			calculateAndWriteCalibrationValues(ant, pElements);
#if BF_CALIBRATION_LOGS_ON
			ILOG0_V("BM calibration fail! number of recorded bins from sessions not identical");
#endif
	}
	
	return calStatus;
}
//************************************************
// Method:    setTxAndRxRegisters
// Purpose:   This function sets the transmitting and receiving antennas in the PHY, AFE and RF plains. The input to the function is (%txAnt= Antenna A, %rxAnt= Antenna B)
// Parameter: txAnt, rxAnt
// Returns:   
//************************************************

static void setTxAndRxRegisters(QbfSessionParams_t calSessionParams, bool agcOn, QbfAgcGains_t agcGains,uint8 trSwRxAnt, uint8 trSwTxAnt,uint8 extLnaBypRxAnt)
{
	Antenna_e txAnt = calSessionParams.txAnt;
	Antenna_e rxAnt = calSessionParams.rxAnt;
	uint16 stbyWord = 0;
	uint32 antIndex;

	//Stop GenRisc
#if BF_CALIBRATION_LOGS_ON
	ILOG0_V("StopRisc called");
#endif
	if(agcOn)
	{
		tdPhyRxtdIf04.bitFields.semaphoreReg04 &= ~0x0002;//bit 1 =0
	}
	else
	{
		tdPhyRxtdIf04.bitFields.semaphoreReg04 |= 0x0002; ///bit 1 = 1
	}
	
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF04,tdPhyRxtdIf04.val);
	PhyDrv_StopRisc();
	MT_Delay(20);
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_AFE_DYN_CTRL, MASK_16LSB, 0xffff);// first put all antennas in standby
	MT_Delay(20);
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF8F,MASK_16LSB,0x0);// reset all TD Eran check delay
	MT_Delay(20);
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_PHY_RXTD_IF8F,MASK_16LSB,0xffff);// remove reset Eran check if need del;ay

	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_FFT_SHARING,MASK_16LSB,0x1f1& ~(0x10<<txAnt));//FFT sharing overide - channel 0 TX, channel 1,2,3 RX  
	setShort0(txAnt,rxAnt,trSwRxAnt,trSwTxAnt,extLnaBypRxAnt);	// %txAnt is tx and all other are rx
	
	if (agcOn == FALSE)
	{
		for (antIndex = ANTENNA_0; antIndex < TOTAL_ANTENNAS; antIndex++)
		{
			if(txAnt != antIndex)
			{
				setRficRxGain(rxAnt,agcGains);
			}
		}
		
		//setShort12(rxAnt,agcGains);
	}
	
	//TxAnt transmits, only RxAnt receives
	stbyWord = ((0xf0 & (~(1 << (txAnt +4)))) | (0xf & (~(1 << rxAnt))));//// TxAnt transmits,  RxAnt receives 

	// Give GenRisc current Tx Ant information, GenRisc handles the TX stby mode
	RegAccess_WriteMasked(REG_PHY_RX_TD_IF_RISC_PAGE_0_TD_AFE_DYN_CTRL, MASK_16LSB, stbyWord);
	RegAccess_WriteMasked(B0_PHY_RX_TD_BASE_ADDR + TX_ANT_INFO_ADDR,MASK_16LSB,(stbyWord << 4));// give GenRisc current Tx Ant information, GenRisc handles the TX stby mode
	
	//Digital
	// Enable RxAnt 
	//digitalConfig = (0xf0 & ((1 << rxAnt) << REG_PHY_RXTD_REG3C_HOST_ANTENNA_EN_SHIFT));
	rxTdReg3c.bitFields.hostAntennaEn = (1 << rxAnt);
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG3C, rxTdReg3c.val);
	txBeReg07.val &= ~0x0003c000;
	txBeReg07.val |= (1 << txAnt) << 14;
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_07, txBeReg07.val);//Eran check mask

//	txBeReg07.val |= (15-(1 << rxAnt)) << 14;
//	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_07, txBeReg07.val);//Eran check mask
	//Run  GenRisc
#if BF_CALIBRATION_LOGS_ON
	ILOG0_V("StartRisc called");
#endif
	PhyDrv_StartRisc();
	
}
//************************************************
// Method:    setShort0
// Purpose:  set short 3 reg:  txAnt is tx and all other are rx
// Parameter: txAnt
// Returns:   void
//************************************************

static void setShort0(Antenna_e txAnt,Antenna_e rxAnt,uint8 trSwRxAnt, uint8 trSwTxAnt, uint8 extLnaBypRxAnt)
{
//	AntennaBitmaps_e txAntMask = (AntennaBitmaps_e)(1 << txAnt);
//	AntennaBitmaps_e rxAntMask = (AntennaBitmaps_e)((~txAntMask) & ANTENNA_BITMAP_ALL_ANTENNAS);
	uint16 regVal[4];
	uint32 short0Val = REGISTER(RF_RX0_COMMAND);
	uint32 txRxOnWord;
	uint16 rficShort1[MAX_NUM_OF_ANTENNAS];
	
	if (trSwRxAnt == 1)
	{
		short0Val =	REGISTER(RF_RX_TR_TX_COMMAND);;
	}
	if (extLnaBypRxAnt == 1)
	{
		short0Val =	REGISTER(RF_ELNA_BYPASS0_COMMAND);
	}
	
	regVal[0] = (uint16)short0Val;
	regVal[1] = (uint16)short0Val;
	regVal[2] = (uint16)short0Val;
	regVal[3] = (uint16)short0Val;
	regVal[txAnt] = (uint16)REGISTER(RF_TX0_COMMAND);	 
	if (trSwTxAnt == 1)
	{
		regVal[txAnt] = REGISTER(RF_TX_TR_RX_COMMAND);  
	}
//	RficDriver_setRffeMode(RX_MODE,rxAntMask); //Set Rx switch
//	RficDriver_setRffeMode(TX_MODE,txAntMask); //Set Tx switch
	//RficDriver_WriteMaskRegister(REG_RFIC_S0_SHORT_0,regVal, SHORT0_QBF_MASK);

// Set GenRisc Rx RF words with inverted TR Sw	
	//MT_WrReg(B0_PHY_RX_TD_BASE_ADDR, GENRISC_TR_SW_ADDR, trSwRxAnt|(trSwTxAnt<<1));
	txRxOnWord = (1<<(2*rxAnt)) + (1<<(2*txAnt+1));
	RficDriver_ReadRegister(REG_RFIC_S1_SHORT_1,rficShort1);

	MT_WrReg(B0_PHY_RX_TD_BASE_ADDR, 0x209cc, regVal[0] | (rficShort1[0]&~0x7c));
	MT_WrReg(B0_PHY_RX_TD_BASE_ADDR, 0x209d0, regVal[1] | (rficShort1[1]&~0x7c));
	MT_WrReg(B0_PHY_RX_TD_BASE_ADDR, 0x209d4, regVal[2] | (rficShort1[2]&~0x7c));
	MT_WrReg(B0_PHY_RX_TD_BASE_ADDR, 0x209d8, regVal[3] | (rficShort1[3]&~0x7c));
	MT_WrReg(B0_PHY_RX_TD_BASE_ADDR, 0x209e0, txRxOnWord);
#if BF_CALIBRATION_LOGS_ON
	ILOG0_DDD("TRSW: %x %x %x",regVal[0],regVal[1],regVal[2]);
#endif

}

 
//************************************************
// Method:	createShort12
// Purpose:  	modify pShortArr according to LNA, PGC and DC parmeters
// Parameter: ant, lnaGain, pgc1Gain, pgc2Gain, pgc3Gainp, pShortArr
// Returns:   void
//************************************************
static void setRficTxParams(uint8 tpc)
{
	uint32 baseAddressFromRam = (B0_PHY_RX_TD_BASE_ADDR + 0x202a0);//need to get adress from fast mem Harel To add
	REGISTER(baseAddressFromRam) = tpc;//Antenna0
	REGISTER(baseAddressFromRam + 4) = tpc;//Antenna1
	REGISTER(baseAddressFromRam + 8) = tpc;//Antenna2
	REGISTER(baseAddressFromRam + 12) = tpc;//Antenna3
}
 uint32 rxGainWord;
static void setRficRxGain(Antenna_e rxAnt,QbfAgcGains_t agcGains)
 {
	uint32 pgc1;
	uint32 pgc2;
	uint32 lnaLutGain;
	

	lnaLutGain = RficDriver_GetLnaGain(rxAnt, agcGains.lnaIndx);
	pgc1 = agcGains.pgc1Indx;
	pgc2 = agcGains.pgc2Indx;
	rxGainWord = lnaLutGain + (pgc1<<7) + (pgc2<<12);
	MT_WrReg(B0_PHY_RX_TD_BASE_ADDR, 0x209cc + rxAnt*4, rxGainWord);	
	
 }



/*
void createShort12(Antenna_e ant, QbfAgcGains_t agcGains, uint32* pShortArr)
{
	int8 value[2]={0};
	int8 correction[2]={0};
	int8 Dac2[2]={0};
	
	uint32 cb = HDK_getChannelWidth();
	PhyCalDrv_DCTable1Get(ant, cb, agcGains.pgc1Indx, (HdkLnaIndex_e)agcGains.lnaIndx, value,correction);
	// DAC2 retrieving	
	PhyCalDrv_DCTable2Get(ant, cb, agcGains.pgc2Indx, Dac2);
		
	Dac2[RFIC_PATH_TYPE_I] += correction[RFIC_PATH_TYPE_I]; //DAC2 I
	Dac2[RFIC_PATH_TYPE_Q] += correction[RFIC_PATH_TYPE_Q]; //DAC2 Q
	Dac2[RFIC_PATH_TYPE_I] &= 0x1f; 		
	Dac2[RFIC_PATH_TYPE_Q] &= 0x1f;
	value[RFIC_PATH_TYPE_I] &= 0x1f; 		
	value[RFIC_PATH_TYPE_Q] &= 0x1f;
	
	pShortArr[0] = ((agcGains.lnaIndx << REG_RFIC_S1_LNAGAIN_SHIFT) 
					| (agcGains.pgc3Indx << REG_RFIC_S1_PGC3GAIN_SHIFT) 
					| (value[RFIC_PATH_TYPE_Q] << REG_RFIC_S1_PGC1_DCOFF_Q_SHIFT) 
					| (value[RFIC_PATH_TYPE_I] << REG_RFIC_S1_PGC1_DCOFF_I_SHIFT));
					
	pShortArr[1] = ((agcGains.pgc1Indx << REG_RFIC_S2_PGC1GAIN_SHIFT) 
					| (agcGains.pgc2Indx << REG_RFIC_S2_PGC2GAIN_SHIFT)
					| (Dac2 [RFIC_PATH_TYPE_Q] << REG_RFIC_S2_PGC2_DCOFF_Q_SHIFT)
					| (Dac2 [RFIC_PATH_TYPE_I] << REG_RFIC_S2_PGC2_DCOFF_I_SHIFT));

}
*/

//************************************************
// Method:	  storeRegsValsBeforeAlb
// Purpose:  
// Parameter: 
// Returns:   void
//************************************************
void storeRegsValsBeforeAlb(bool* pAreRegsSaved)
{
	QbfSavedRegsNames_e indx = firstSavedReg;

	PhyDrv_StopRisc();
	
	for (indx = firstSavedReg; indx < NUMBER_OF_SAVE_REGISTERS; indx ++)
	{
		SavedRegs[indx].val = HW_CREG_U32(SavedRegs[indx].addr);
	}
	*pAreRegsSaved = TRUE;
	txBeReg07.val 		= SavedRegs[txFeEnableMem].val;
	txBeReg0e.val 		= SavedRegs[txEndDelayMem].val;
	txBeReg11.val 		= REGISTER(REG_PHY_TX_REGS_TX_BE_REG_11);
	tx2NdFilter.val 	= SavedRegs[tx2ndInterpBypassMem].val;
	txNoiseShaping.val 	= SavedRegs[txNoiseShapingEnMem].val;
	tdPhyRxtdIffd.val 	= SavedRegs[gpoMem].val;
	tdPhyRxtdIf04.val 	= SavedRegs[riscRunModeMem].val;
	tdPhyRxtdIf1b.val 	= SavedRegs[tdEnableOverrideEnableMem].val;
	fdPhyRxfdIf10d.val 	= SavedRegs[tdGlobalEnableMem].val;
	fdPhyRxfdIf11d.val 	= SavedRegs[fdGclkBypassGsmMem].val;
	fdPhyRxfdReg06.val 	= SavedRegs[PhaseTrackBypassMem].val;
	fdPhyRxfdReg0a.val 	= SavedRegs[FreqTrackEnableMem].val;
	tdPhyRxtdIf4c.val 	= SavedRegs[detectionBypassMem].val;
	rxTdReg3c.val 		= SavedRegs[antEnableMem].val;
	rxTdReg24b.val 		= SavedRegs[cpTimingEnableMem].val;
	tpcAcc.val			= SavedRegs[tpcAccEnableMem].val;
	tx0Tx1AmpGain.val	= SavedRegs[digitalGainAnt01Mem].val;
	tx2Tx3AmpGain.val 	= SavedRegs[digitalGainAnt23Mem].val;
	
}
//************************************************
// Method:	  restoreRegsValsBeforeAlb
// Purpose:  
// Parameter: 
// Returns:   void
//************************************************
void exitAirLoopBackMode(bool* pAreRegsSaved)
{
	QbfSavedRegsNames_e indx;
	uint16 swReset;
	uint16 blockEnable;
	
	if (!(*pAreRegsSaved))
	{
#if BF_CALIBRATION_LOGS_ON
		ILOG0_V ("Registers values were not saved, cannot restore them");
		DEBUG_ASSERT (0);
#endif
	}

#if BF_CALIBRATION_LOGS_ON
	ILOG0_V ("Stop risc");
#endif
	PhyDrv_StopRisc();

	//Restore first registers block
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_02, 0);
	for (indx = firstSavedReg; indx <= riscRunModeMem; indx++)
	{
		HW_CREG_U32(SavedRegs[indx].addr) = SavedRegs[indx].val;
	}

	//restore secnd RRregisters block
	for (indx = macMode20SsbMem; indx <= digitalGainAnt23Mem; indx++)
	{
		HW_CREG_U32(SavedRegs[indx].addr) = SavedRegs[indx].val;
	}
	//HW_CREG_U32(SavedRegs[clkStrbMem].addr) = SavedRegs[clkStrbMem].val;

	// turn off MAC Emulator
	RegAccess_WriteMasked(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG00, REG_TX_MAC_EMU_REG00_EMU_RUN_MASK, 0x0);

#if BF_CALIBRATION_LOGS_ON
	ILOG0_V ("Run risc");
#endif	
	swReset = RegAccess_ReadImmediate(REG_PHY_RX_TD_PHY_RXTD_REG00);
	blockEnable = RegAccess_ReadImmediate(REG_PHY_RX_TD_PHY_RXTD_REG01);

	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG00, ((1 << REG_PHY_RXTD_REG00_SW_RESET_N_GENRISC_SHIFT) | swReset)); // sw reset
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG01, ((1 << REG_PHY_RXTD_REG01_BLOCK_EN_GENRISC_SHIFT) | blockEnable)); // block enable  

	//restore secnd RRregisters block
	for (indx = tdEnableOverrideEnableMem; indx <= FreqTrackEnableMem; indx++)
	{
		HW_CREG_U32(SavedRegs[indx].addr) = SavedRegs[indx].val;
	}
	
	// TX reset & enable  
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG00, 0x0); 
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG00, SW_UN_RESET_VAL); 
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG01, SW_UN_RESET_VAL); 

	HW_CREG_U32(SavedRegs[detectionBypassMem].addr) = SavedRegs[detectionBypassMem].val;
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_04, REG_TX_BE_REG_04_MAC_EMU_MODE_EN_MASK, 0);
	
	REGISTER(REG_PHY_TX_REGS_TX_BE_REG_11) = txBeReg11.val;
	// Gen risc activation	
	RegAccess_Write(REG_PHY_RX_TD_PHY_RXTD_REG051, 0x1);
	PhyDrv_StartRisc();
	*pAreRegsSaved = FALSE;

}												


//************************************************
// Method:	 transmitValidatePacket
// Purpose:  	Transmits a MAC Emulator packet and validates the received channel. If needed, retransmits
// Parameter: 
// Returns:   void
//************************************************
CalStatus_e transmitValidatePacket(uint8* pNumOfPacketTransmitted, QbfSessionParams_t CalSessionParams, bool agcOn, QbfAgcGains_t agcGains, packetModulation_e mod,uint8 trSwRxAnt, uint8 trSwTxAnt,uint8 extLnaBypRxAnt)
{
	uint8 retriesCounter = 0;
	CalStatus_e calStatus = CAL_STATUS_FAIL;
	bool channelValidityRes = FALSE;
	uint32 cb = txBeReg07.bitFields.txIsHalfBand2080  | (txBeReg07.bitFields.txIsHalfBand4080 << 1);
	uint8 transmitPacketWaitTime = WAIT_FOR_UPLOAD_CHANNEL_USEC_CB_16QAM;

	DEBUG_ASSERT(mod==QAM16_1_2 || mod==BPSK_1_2);

	if (agcOn)
	{
		if (mod==QAM16_1_2)
		{
			transmitPacketWaitTime = cb ? WAIT_FOR_UPLOAD_CHANNEL_USEC_CB_16QAM : WAIT_FOR_UPLOAD_CHANNEL_USEC_NCB_16QAM;
		}
		else if (mod==BPSK_1_2)
		{
			
			transmitPacketWaitTime = cb ? WAIT_FOR_UPLOAD_CHANNEL_USEC_CB_BPSK : WAIT_FOR_UPLOAD_CHANNEL_USEC_NCB_BPSK;
		}
	}
	else
	{
		if (mod==QAM16_1_2)
		{
			transmitPacketWaitTime = WAIT_FOR_UPLOAD_CHANNEL_USEC_AGC_OFF_16QAM;
		}
		else if (mod==BPSK_1_2)
		{
			transmitPacketWaitTime = WAIT_FOR_UPLOAD_CHANNEL_USEC_AGC_OFF_BPSK;
		}
	}
	
	while ((retriesCounter < PACKET_TRANSMIT_MAX_RETRIES) && (channelValidityRes == FALSE) 
			&& (*pNumOfPacketTransmitted < MAX_TRANSMIT_PACKETS))
	{
		setTxAndRxRegisters (CalSessionParams, agcOn, agcGains,trSwRxAnt, trSwTxAnt,extLnaBypRxAnt);

		if (agcOn)
		{
			RficDriver_OverrideLnaConversionsTable(CalSessionParams.txAnt, RficDriver_getRffeMode(TX_MODE, CalSessionParams.txAnt));
		}
		triggerTB();

		// clear CRC counter		
		MT_WrReg(B0_PHY_BE_BASE_ADDR, REG_PHY_RXBE_REG24_CLEAR_COUNTERS, 0x1); 

		sendMacEmulatorPacket();
		channelValidityRes = checkChannelValidity(CalSessionParams, transmitPacketWaitTime);
		retriesCounter++;
	}
	(*pNumOfPacketTransmitted)+=retriesCounter;

	if (channelValidityRes == TRUE)
	{
		calStatus = CAL_STATUS_PASS;
	}
	else
	{

#if BF_CALIBRATION_LOGS_ON
		ILOG0_V ("BF Calibration Failed!! could not achieve a good channel");
#endif		
	}
	
	if (agcOn)
	{
		RficDriver_RestoreLnaConversionsTable(CalSessionParams.txAnt);
	}
	return calStatus;
}

//************************************************
// Method:	triggerTB
// Purpose:  	Configure the Test-Bus to record the channel
// Parameter: 
// Returns:   void
//************************************************
static void triggerTB(void)
{
#if BF_CALIBRATION_LOGS_ON
	ILOG0_V ("triggerTB");
#endif	

	// Trigger GenRisc Request to record TB	
	//RegAccess_WriteMasked(B0_PHY_RX_TD_BASE_ADDR + GENRISC_SEND_TRIGGER_ADDR, MASK_16LSB, 0x1);	
	
}

//************************************************
// Method:	sendMacEmulatorPacket
// Purpose:  	Transmits one synchronized MAC Emulator packet
// Parameter: 
// Returns:   void
//************************************************
static void sendMacEmulatorPacket(void)
{
	//Emuator run
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG00, 0x0);

	//Number of packets to send
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG01, 0x1); 

	// TX reset & enable  
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_00, 0x0); 
		MT_Delay(20);
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_06, 0x0); 
		MT_Delay(20);
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_00, 0xffffffff); 
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_06, 0xffffffff); 
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_01, 0xffffffff);
	

	// Activate MAC Emulator
	RegAccess_WriteMasked(REG_PHY_TX_REGS_TX_BE_REG_04, REG_TX_BE_REG_04_MAC_EMU_MODE_EN_MASK, (1 << REG_TX_BE_REG_04_MAC_EMU_MODE_EN_SHIFT));
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_02, SET_32BIT);

		MT_Delay(20);
	// Trigger GenRisc to send 1 synchronized packet
	RegAccess_WriteMasked(B0_PHY_RX_TD_BASE_ADDR + TX_ANT_INFO_ADDR, GENRISC_SEND_TRIGGER_MASK, 0x1);

}
//************************************************
// Method:	checkChannelValidity
// Purpose:  	Check the channel validity
// Parameter: 
// Returns:   Returns TRUE if the received channel passed validation
//************************************************
 bool checkChannelValidity(QbfSessionParams_t CalSessionParams, uint16 waitingTime)
{
	bool crc;
	// Wait till GenRisc will finish uploading the received packet channel to the TB, should take up to 80us  

	if(longPacket == 1)
	{
		waitingTime = waitingTime + 260;
	}
	MT_Delay(waitingTime); //wait 80 usec in CB or 85 usec in NCM
	/*Validate channel*/
	
	//Packet arrived validation
	//if (RegAccess_ReadImmediate(B0_PHY_RX_TD_BASE_ADDR + GENRISC_RECORD_CHANNEL_INDICATIION_ADDR) != 0)
	//{
#if BF_CALIBRATION_LOGS_ON
	//	ILOG0_V("Record Channel Failed !! packet did not arrive in time");
#endif
	//	return FALSE;
	//}
	

	//CRC validation
	
	// latch CRC counter 
	MT_WrRegMask(B0_PHY_BE_BASE_ADDR, REG_PHY_RXBE_REG25_LATCH_COUNTERS, REG_PHY_RXBE_REG25_LATCH_COUNTERS_SHIFT, 0x1); 
	crc = MT_RdReg(B0_PHY_BE_BASE_ADDR, REG_PHY_RXBE_REG38_CRC_ERR_PACKET_CNT_LATCHED);

	rfic_txoff(0xf);
	RficDriver_setRffeMode(RX_MODE,(AntennaBitmaps_e)0xf);
	if (crc == TRUE)
	{
#if BF_CALIBRATION_LOGS_ON
		ILOG0_V("Record channel failed!!! CRC error");
#endif
		return FALSE;

	}
	
	return TRUE;
	
}
static uint16 readChannelDataFromChannelRam(QbfSessions_e session,Antenna_e rxAnt)
{
	uint32 i;
	uint32 groups  = getNumOfGroups();
	uint32 dataBins  = getNumOfDataBins();
	chRamRead(groups,1);
	for (i = 0; i < groups; i++)
	{
		Hcmplx[session][i].real = HrealTemp[i].real;
		Hcmplx[session][i].image = HrealTemp[i].image;
	}
	return 1;
}

static uint16 chRamRead(uint32 numDataBins,uint32 groupd)
{
	uint8 *binsArray; 
	uint32 bin;
	uint32 i;
	uint32 cb = txBeReg07.bitFields.txIsHalfBand2080  | (txBeReg07.bitFields.txIsHalfBand4080 << 1);
	if(cb == 0)
	{
		binsArray = bins80;
	}
	else if(cb == 2)
	{
		binsArray = bins40;
	}
	else
	{
		binsArray = bins20;
	}
	for (i = 0; i < numDataBins; i++)
	{
		if(groupd  == 1)
		{
			bin = binsArray[i];
		}
		else
		{
			bin = i;
		}
		HrealTemp[i].real = REGISTER(B0_PHY_FD_BASE_ADDR + TX_STYLE_RAM_ADDR + 16*bin)&0xfff;
		HrealTemp[i].image= (REGISTER(B0_PHY_FD_BASE_ADDR + TX_STYLE_RAM_ADDR + 16*bin) >> 12) &0xfff;
		if(HrealTemp[i].real >= 2048)
		{
			HrealTemp[i].real = HrealTemp[i].real - 4096; 
		}
		if(HrealTemp[i].image >= 2048)
		{
			HrealTemp[i].image = HrealTemp[i].image - 4096; 
		}
		
	}
	return 1;
}


//************************************************
// Method:	readChannelDataFromTB
// Purpose:  	Reads how many bins were written to the TB (should be 66(CB) or 51(NCB)). 
//			Parse the channel data into array RAM (22bins*12bits*2complex).
//			We need to save 2 array RAMs data before we can calculate the calibration result
// Parameter: 
// Returns:   Returns TRUE if the received channel passed validation
//************************************************
uint16 readChannelDataFromTB(int16_cmplx_t* pHcmplx
#ifdef QBF_CAL_DEBUG
											,QbfSessions_e session
#endif
)
{
	uint16 numberOfBinsInFifo = 0;
	uint32 tbReadAdd;
	uint16 readIndx =0;
	uint16 writeIndx = 0;
	uint32 tbRawData = 0;
	uint32 cb = txBeReg07.bitFields.txIsHalfBand2080  | (txBeReg07.bitFields.txIsHalfBand4080 << 1);
	uint8 nGroups = 0;
	uint8 channelBinsSkips;
#ifdef QBF_CAL_DEBUG 
	uint16 channelLen = cb ? CHANNEL_LEN_CB : CHANNEL_LEN_NCB;
#endif

	switch (cb)
	{
	case MIB_SPECTRUM_40M:
		nGroups = N_GROUPS_CB;
		tbReadAdd = TB_READ_CHANNEL_ADDR_CB;
		channelBinsSkips = CHANNEL_BINS_SKIP_CB;

		break;

	case MIB_SPECTRUM_20M:
		nGroups = N_GROUPS_NCB;
		tbReadAdd = TB_READ_CHANNEL_ADDR_NCB;
		channelBinsSkips = CHANNEL_BINS_SKIP_NCB;

		break;
	
	default:
		DEBUG_ASSERT (0);
		break;
	}
		
	numberOfBinsInFifo = MT_RdReg(B0_PHY_RX_TD_BASE_ADDR, REG_PHY_RXTD_IF8C_RAM_WR_PNT0);
	
#if BF_CALIBRATION_LOGS_ON
	ILOG0_D("Record %d bins",numberOfBinsInFifo); 
#endif
	for (writeIndx = 0, readIndx = 0; writeIndx < nGroups; writeIndx++, readIndx += channelBinsSkips) //read with jump of  3 bins * bytes for bin = 3*4
	{
		tbRawData = MT_RdReg(B0_PHY_RX_TD_BASE_ADDR, (tbReadAdd + readIndx));

		// %H_real, %H_imag are global arrays of 22bins*12bits each
		pHcmplx[writeIndx].real =(int16)MTLK_U_BITS_GET(tbRawData, CHANNEL_BIN_REAL_WORD_SHIFT, CHANNEL_BIN_WORD_LEN);		//Get 12 LSB for Hreal
		pHcmplx[writeIndx].image =(int16)MTLK_U_BITS_GET(tbRawData, CHANNEL_BIN_IMAGE_WORD_SHIFT, CHANNEL_BIN_WORD_LEN);	//Get 12 MSB for Himage
		pHcmplx[writeIndx].real = TWOS_COMP_CONVERT_16BIT(pHcmplx[writeIndx].real, CHANNEL_BIN_WORD_LEN);
		pHcmplx[writeIndx].image = TWOS_COMP_CONVERT_16BIT(pHcmplx[writeIndx].image, CHANNEL_BIN_WORD_LEN);
	}
	
#ifdef QBF_CAL_DEBUG

	for (writeIndx = 0, readIndx = 0; writeIndx < channelLen; writeIndx++, readIndx += CHANNEL_BINS_SKIP_ALL_BINS) 
	{
		tbRawData = MT_RdReg(B0_PHY_RX_TD_BASE_ADDR, (TB_FIFO_LOW_START_ADDRESS + readIndx));

		Hraw[m_Qbf_elements.params.currentCalPair][session][writeIndx] = tbRawData;
	}

#endif

	return numberOfBinsInFifo;	
}
//************************************************
// Method:	BeamForming_Init
// Purpose: 
// Parameter: 
// Returns:   
//************************************************

void BeamForming_Init()
{
	m_Qbf_elements.params.fragmentationOn = FALSE;
	m_Qbf_elements.params.numberOfAntennas = ANTENNA_3;
	m_Qbf_elements.params.areRegsSaved = FALSE;
	m_Qbf_elements.params.stateCnt = 0;
	m_Qbf_elements.params.numOfPacketTransmitted = 0;
	m_Qbf_elements.params.offlineModulationType = QAM16_1_2;

	beamFormingStatusInit(CAL_STATUS_INIT);
#ifdef QBF_PHY_DEBUG
	m_Qbf_elements.params.disTxCancel = 0;
#endif
	pgcParamsInit();

}
//************************************************
// Method:	pgcParamsInit
// Purpose: 
// Parameter: 
// Returns:   
//************************************************

static void pgcParamsInit()
{
	QbfSessions_e sesssion;
	
	for (sesssion = SESSION_0; sesssion < MAX_NUMBER_OF_CAL_SESSIONS; sesssion++)
	{
		m_Qbf_elements.params.pgc1CalK[sesssion] = 0;
		m_Qbf_elements.params.pgc3CalK[sesssion] = 0;

	}
}
//************************************************
// Method:	beamFormingStatusInit
// Purpose: 
// Parameter: 
// Returns:   
//************************************************
static void beamFormingStatusInit(CalStatus_e calStatus)
{
	QBF_CalibrationType_e calibrationType;
	
	for (calibrationType = AFE; calibrationType < MAX_NUMBER_OF_BF_CALS; calibrationType++)
	{
		BeamForming_SetStatus(calStatus, calibrationType);
	}
}
//************************************************
// Method:	fillSessionParams
// Purpose:  
// Parameter: 
// Returns:   
//************************************************
static void fillSessionParams(QbfSessionParams_t* pCalSessionParams, Antenna_e calAnt)
{
	
	pCalSessionParams[SESSION_0].txAnt = ANTENNA_0;
	pCalSessionParams[SESSION_0].rxAnt = calAnt;
	pCalSessionParams[SESSION_0].session= SESSION_0;
	pCalSessionParams[SESSION_0].calAnt= calAnt;
	
	pCalSessionParams[SESSION_1].txAnt = calAnt;
	pCalSessionParams[SESSION_1].rxAnt = ANTENNA_0;
	pCalSessionParams[SESSION_1].session= SESSION_1;
	pCalSessionParams[SESSION_1].calAnt= calAnt;
	
	
}
//************************************************
// Method:	calculateAndWriteCalibrationValues
// Purpose:   	HAB: channel result between ant0->ant
//			HBA: channel result between ant->ant0
//			
//			Perform:
//			D = HAB x HBA* / |HAB|^2: 
//			HAB = a + jb,     HBA = c + jd
//			D = [(ac + bd) + j(bc - ad)] / (a^2 + b^2)
//			Adding fix point, the operation changes to:
//			K = [(ac + bd) <<6+ j(bc - ad)<<6] / ((a2 + b2)>>3) // // 32bit/23bit (signed), result is 12 bit with 9 lsbs
//			a =Hreal[0]
//			b= Himage[0]
//			c=Hreal[1]
//			d=Himage[1]
//			Finally, we write the calibration result to the RAM 

// Parameter: Hreal, Himage
// Returns:   void
//************************************************
static void calculateAndWriteCalibrationValues (Antenna_e ant, QbfElements_t* pElements)
{
	int16_cmplx_t* hCmplx0;
	int16_cmplx_t* hCmplx1;
//	QBF_CalibrationPair_e calPair = (QBF_CalibrationPair_e)(ant - 1);
	int32_cmplx_t kCmplx = {0,0};
	uint8 binIndx =0;
	uint32 kResultStartAddr = RXTD_TB_FIFO_high;
	uint32 writeIndx = 0;
	uint32 calWordToWrite = 0;
	uint32 kRealToWrite = 0;
	uint32 kImageToWrite = 0;
	uint8 nGroups = getNumOfGroups();
	uint32 offset = getGroupOffset();
	
	hCmplx0 = Hcmplx[0];
	hCmplx1 = Hcmplx[1];

#if BF_CALIBRATION_LOGS_ON
//	ILOG0_D ("CaluclateCalResult, calPair=%d", calPair);
#endif	
	//ASSERT (calPair < MAX_NUMBER_OF_CAL_PAIRS);

	kResultStartAddr += (ant << 2);

	
	for (binIndx = 0; binIndx < nGroups; binIndx++, writeIndx += WRITE_BINS_SKIPS)
	{
		//Calculate  devisor = (|HAB|^2) >> 9 =  (a2 + b2)>>9
		//Calculate K = HAB x HBA* / |HAB|^2 = ([(ac + bd) + j(bc - ad)] / devisor )
		kCmplx = cmplxDiv(hCmplx1[binIndx], hCmplx0[binIndx], DEVIDER_RESULT_SHIFT, MULT_RESULT_SHIFT);
		//Conjugate kCmplx
		kCmplx.image = -kCmplx.image;

		//Limit K to 12 BIT 
		kRealToWrite =  MASK_12_BIT & LIMIT_SIGN(kCmplx.real, MAX_12BIT_SIGN_VAL);
		kImageToWrite = MASK_12_BIT &  LIMIT_SIGN(kCmplx.image, MAX_12BIT_SIGN_VAL);
		calWordToWrite = ((kRealToWrite << WRITE_BINS_REAL_SHIFT) + (kImageToWrite << WRITE_BINS_IMAGE_SHIFT));

		//Write K result to PHY ram (12real<<12 + 12image)
		REGISTER(B0_PHY_FD_BASE_ADDR | (kResultStartAddr + writeIndx + ((offset*MAX_NUM_OF_DIGITAL_ANTENNAS) << 2)))= calWordToWrite;

	}
	
}

//*******************************************************************
// Method:	configureMacEmulatorPacket
// Purpose:  
// Parameter: Configures the MAC emulator to send the wanted packet:
//			16QAM/BPSK_1_2, CB/NCB, 1ss, length=16, with grouping, use TPC index
// Returns:   
//*******************************************************************
void configureMacEmulatorPacket(packetModulation_e mod)
{
	uint32 cb = txBeReg07.bitFields.txIsHalfBand2080  | (txBeReg07.bitFields.txIsHalfBand4080 << 1);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG01, 0x1);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG02, 0xc0e);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR1, 0x7e000);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR2, 0x0);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG0A, 0x0);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG0B, 0x80000003);//not in dump
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG0C, 0x162);//not in dump
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG0D, 0x0);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG0E, 0x11800032);
	if(longPacket  == 0)
	{
		RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR4, 0xc);
	}
	
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG11, 0x0);//not in dump
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG13, 0x0);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG14, 0x0);
	RegAccess_Write(REG_PHY_TX_MAC_EMU_TONE_GEN, 0x80);
	
	if (cb == SPECTRUM_80M)
	{
		RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR0, 0xffcfb);
		RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG08, 0x8003f6);
		if(longPacket  == 0)
		{
			RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0x600003);
			RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0xa5);
		}
		switch (mod)
		{
			case BPSK_1_2:
				{
					RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR3, 0x6);
					RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG09, 0x24e00);
					if(longPacket  == 0)
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x2024b);
					}
					else
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x210eb);
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR4, 0x248);//length
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0x600092);//sigb
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0x7c);
					}
					
					break;
				}
			case QAM16_1_2:
				{
					RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR3, 0x306);
					RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG09, 0x26a30);
					if(longPacket  == 0)
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x201eb);
					}
					else
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x210eb);
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR4, 0x924);//length
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0x600249);//sigb
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0x4e);
					}
					break;
				}
			default:
				break;
		}
	}
	else if(cb == SPECTRUM_4080M)
	{
		RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR0, 0xffcf7);
		RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG08, 0x8003f5);
		if(longPacket  == 0)
		{
			RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0x800003);
			RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0xc5);
		}
		
		switch (mod)
		{
			case BPSK_1_2:
				{
					RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR3, 0x6);
					RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG09, 0x3da00);
					if(longPacket  == 0)
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x2ab);
					}
					else
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x210eb);
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR4, 0x10c);//length
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0x180043);//sigb
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0x1f);	
					}
					
					
					break;
				}
			
			case QAM16_1_2:
				{
					RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR3, 0x306);
					RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG09, 0x3fe30);
					if(longPacket  == 0)
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x201eb);
					}
					else
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x210eb);
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR4, 0x438);//length
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0x18010e);//sigb
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0xd4);	
					}
					
					
					break;
				}
			default:
				break;
		}	
	}
	else if(cb == SPECTRUM_2080M)
	{
		RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR0, 0xffcf3);
		RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG08, 0x8003f4);
		if(longPacket  == 0)
		{
			RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0xe0003);
			RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0xc2);
		}
		
		switch (mod)
		{
			case BPSK_1_2:
				{
					RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR3, 0x6);
					RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG09, 0x35600);
					if(longPacket  == 0)
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x2036b);
					}
					else
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x210eb);
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR4, 0x80);//length
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0xe0020);//sigb
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0x47);	
					}
					
					
					break;
				}
			
			case QAM16_1_2:
				{
					RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR3, 0x306);
					RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG09, 0x37230);
					if(longPacket  == 0)
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x2024b);
					}
					else
					{
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG07, 0x210eb);
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_TCR4, 0x208);//length
						RegAccess_Write(REG_PHY_TX_MAC_EMU_MAC_EMU_VHT_SIGB, 0xe0082);//sigb
						RegAccess_Write(REG_PHY_TX_MAC_EMU_TX_MAC_EMU_REG16, 0xa2);	
					}
					
					
					break;
				}
			default:
				break;
		}	
		
	}
	else
	{
		DEBUG_ASSERT(0);
	}
	// in NCB (and CB 28/09/14 seen on 3.5.0.x) change Tx end delay, otherwise last 0.6us of the packet are cut
	txBeReg0e.bitFields.endDelayLen = TX_END_DELAY;
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_0E ,txBeReg0e.val);
	// TX_Reg_File:scr_init_sel
	txBeReg11.bitFields.scrInitSel = 0x1;
	RegAccess_Write(REG_PHY_TX_REGS_TX_BE_REG_11, txBeReg11.val);
	
	// TX 11b reset & enable
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TXB_PHY_TXB_RISC_REG1C5,0x0);

	// we disable 11b modem, so detections will not jump while calibrating
	RegAccess_Write(REG_PHY_RX_TD_IF_RISC_PAGE_0_TXB_PHY_TXB_RISC_REG1C6,0x0);

	
}
//************************************
// Method:    BeamForming_GetStatus
// Purpose:   Get calibration status of given antenna
// Parameter: uint32 inAntennaPair
// Returns:   CalStatus_e - E_Fail or E_Pass
//************************************
CalStatus_e BeamForming_GetStatus(IN QBF_CalibrationType_e bfCalibrationType)
{
	return m_Qbf_elements.results.status[bfCalibrationType];
}

//************************************
// Method:    BeamForming_GetofflineModulationType
// Purpose:   Set offline calibration modulation type
// Parameter: uint32 inAntennaPair
//		CalStatus_E inStatus
// Returns:   void
//************************************
packetModulation_e BeamForming_GetofflineModulationType()
{
	return m_Qbf_elements.params.offlineModulationType;
}

//************************************
// Method:    BeamForming_GetStatus
// Purpose:   Get calibration status of given antenna
// Parameter: uint32 inAntennaPair
// Returns:   CalStatus_e - E_Fail or E_Pass
//************************************
void BeamForming_SetStatus(IN CalStatus_e inStatus, IN QBF_CalibrationType_e bfCalibrationType)
{
	K_MSG *kMsg_p;
	LaBfCalStatusChanged_t *bfCalStatus_p;

	m_Qbf_elements.results.status[bfCalibrationType] = inStatus;
	
	if ((bfCalibrationType == TX_OFFSET) && (inStatus == CAL_STATUS_PASS))
	{
		kMsg_p = OSAL_GET_MESSAGE(sizeof(LaBfCalStatusChanged_t));
		bfCalStatus_p = (LaBfCalStatusChanged_t *)pK_MSG_DATA(kMsg_p);
		bfCalStatus_p->calibrationPass = TRUE;
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_UPDATE_BF_CAL_STATUS_REQ, TASK_LINK_ADAPTATION, kMsg_p, VAP_ID_DO_NOT_CARE);
	}

}

// Method:    BeamForming_GetElement
// Purpose:   return m_Qbf_elements
// Parameter: 
// Returns:   void
/************************************/
/*
uint32* BeamForming_GetElement(void)
{
	return (uint32*)&m_Qbf_elements;
}*/
/************************************/
// Method:	  BeamForming_GetElement
// Purpose:   return m_Qbf_elements
// Parameter: 
// Returns:   void
/************************************/
 CalStatus_e calStatus;

 CalStatus_e beamFormingCalFrag0(QbfElements_t* pElements)
{
	CalStatus_e calStatus = CAL_STATUS_INIT;
	//Antenna_e antNum  = pElements->params.numberOfAntennas;
	Antenna_e ant;
	QbfSessionParams_t calSessionParams[MAX_NUMBER_OF_CAL_SESSIONS];
	int16 relativeGain[MAX_NUMBER_OF_CAL_SESSIONS];
	uint32 extLnaForAgcAndTxCalTemp =0;
	QbfSessions_e session;
	DEBUG_ASSERT ((antNum > 0) && (antNum <= TOTAL_ANTENNAS));
	pElements->params.numOfPacketTransmitted = 0;
	BeamForming_SetStatus(CAL_STATUS_INIT, AGC_GAIN);
	BeamForming_SetStatus(CAL_STATUS_INIT, K_CALIBRATION);
	BeamForming_SetStatus(CAL_STATUS_INIT, AGC_OFFSET);
	BeamForming_SetStatus(CAL_STATUS_INIT, TX_OFFSET);

	//TD En
	MT_WrReg(B0_PHY_RX_TD_BASE_ADDR,REG_PHY_RXTD_REG00_SW_RESET_N_REG, SW_RESET_VAL);
	MT_WrReg(B0_PHY_RX_TD_BASE_ADDR,REG_PHY_RXTD_REG01_BLOCK_EN, SW_EN_VAL);
	for (ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		memset32((void *)(B0_PHY_TX_BASE_ADDR + TX_CORRECTION_START_ADDERSS+ TX_CORRECTION_ANT_OFFSET*ant), 32512,496);
	}
	memset32((void *)(AGC_OFFSET_CAL_PHASE_START_ADDR), 32512,4464) ;
	memset32((void *)(AGC_OFFSET_CAL_GAIN_START_ADDR), 32512,76) ;
	
	memset32((void *)(B0_PHY_FD_BASE_ADDR + RXTD_TB_FIFO_high), 0x200000,248);
	/* 	Configure the Test-Bus to record the channel */

#if BF_CALIBRATION_LOGS_ON
	ILOG0_V("START AGC GAINS CALIBRATION");
#endif

	/*Find AGC values for correct back off during calibration*/
	extLnaForAgcAndTxCalTemp = pElements->params.extLnaForAgcAndTxCal;
	pElements->params.extLnaForAgcAndTxCal = 0;
	calStatus = agcGainCalibration(pElements);
	BeamForming_SetStatus(calStatus, AGC_GAIN);

	/*RX-TX offsets of antennas 1, 2 from antenna 0 calibration (K1,K2) */
	if (calStatus != CAL_STATUS_FAIL)
	{
#if BF_CALIBRATION_LOGS_ON
		ILOG0_V("START K CALIBRATION");
#endif
		REGISTER(OFFLINE_BFCAL_DATABASE) |= AGC_GAIN_PASS;
		calStatus = CalibrateK(pElements, FALSE);
		BeamForming_SetStatus(calStatus, K_CALIBRATION);
	}

	if (calStatus != CAL_STATUS_FAIL)//dosetn enter this atate
	{
		REGISTER(OFFLINE_BFCAL_DATABASE) |= K_CALIB_PASS;
		if (pElements->params.isExternalGain == TRUE) // if there is external gain
		{
			pElements->params.extLnaForAgcAndTxCal = extLnaForAgcAndTxCalTemp;
			acitvateAirLoopBackMode(TRUE,pElements->params.tpcForAgcCal,pElements->params.digitalGainForAgcCal,pElements->params.isExternalPa);	// operate AGC
			fillSessionParams(calSessionParams, ANTENNA_1);
			for (session = SESSION_0; session < MAX_NUMBER_OF_CAL_SESSIONS; session++)
			{
				calibrateRxGainsForCalibration(pElements, calSessionParams[session], &relativeGain[session],pElements->params.TrSwForAgcAndTxCal);
			}		
			if (pElements->params.numberOfAntennas > ANTENNA_2)
			{
				fillSessionParams(calSessionParams, ANTENNA_2);
				calibrateRxGainsForCalibration(pElements,calSessionParams[SESSION_0], &relativeGain[SESSION_0],pElements->params.TrSwForAgcAndTxCal); 		 
			}
			acitvateAirLoopBackMode(FALSE,pElements->params.tpcForAgcCal,pElements->params.digitalGainForAgcCal,pElements->params.isExternalPa); // now we   work without AGC	 
		}
	/*Calibrate AGC Offsets*/
#if BF_CALIBRATION_LOGS_ON
		ILOG0_V("START AGC OFFSET CALIBRATION");
#endif
		acitvateAirLoopBackMode(FALSE,pElements->params.tpcForAgcCal,pElements->params.digitalGainForAgcCal,pElements->params.isExternalPa); // now we   work without AGC	 
		calStatus = calibrateAgcOffsets(pElements);
		BeamForming_SetStatus(calStatus, AGC_OFFSET);
	}
	pElements->params.extLnaForAgcAndTxCal = extLnaForAgcAndTxCalTemp;
	if (calStatus != CAL_STATUS_FAIL)
	{
#if BF_CALIBRATION_LOGS_ON
		ILOG0_V("START TX OFFSET CALIBRATION");
#endif
		acitvateAirLoopBackMode(FALSE,pElements->params.tpcForAgcCal,pElements->params.digitalGainForAgcCal,pElements->params.isExternalPa); // now we	 work without AGC	 

		REGISTER(OFFLINE_BFCAL_DATABASE) |= AGC_OFFSET_PASS;
		calStatus = CalibrateTxOffsetsForBf(pElements);
		BeamForming_SetStatus(calStatus, TX_OFFSET);
	}
	if (calStatus != CAL_STATUS_FAIL)
	{
		REGISTER(OFFLINE_BFCAL_DATABASE) |= TX_OFFSET_PASS;
		REGISTER(REG_PHY_TX_REGS_BEAM_FORMING0) |= 0x400000;
	}
	
#if BF_CALIBRATION_LOGS_ON
	ILOG0_D ("exit ALB mode, calibration end!, calStatus = %X",calStatus);
#endif
	return calStatus;
}

/*****************************************************/
// Method:	CalibrateK
// Purpose:   
// Parameter:We will calibrate antenna 1 relative to antenna 0, and then antenna 2 relative to antenna 0. 
/*			For each antennas' pair we will transmit and receive between the antennas (2 Txs), and record the received channel.
			After recoding the channels for one antennas' pair, we will calculate the relative channel for this pair using the function @CalculateAndWriteCalibrationValues(), and write it to the calibration RAM.
*/
// Returns:   void
/*****************************************************/

static CalStatus_e CalibrateK(QbfElements_t* pElements, bool agcOn)
{
	Antenna_e ant;
	CalStatus_e calStatus=  CAL_STATUS_INIT;
	Antenna_e antNum = pElements->params.numberOfAntennas;
	
	/*	Enters the phy into a special mode, called Air Loop Back. 
		In this mode we can transmit over the air from one modem antenna to another, with a constant phase at reception.*/
	//acitvateAirLoopBackMode(agcOn,pElements->params.tpcForKCal,pElements->params.digitalGainForKCal,pElements->params.isExternalPa); // now we work without AGC

	for (ant = ANTENNA_1; (ant <= (antNum-1)) && (calStatus != CAL_STATUS_FAIL); ant++)
	{
		pElements->params.currentCalPair = ant-1;

#if BF_CALIBRATION_LOGS_ON
		ILOG0_DD ("Start K%d calibration, CB=%d",ant, txBeReg07.bitFields.txIsHalfBand2080  | (txBeReg07.bitFields.txIsHalfBand4080 << 1));
#endif
		calStatus = calibrateKproc (ant, agcOn, pElements);
		
	}

	return calStatus;
	
}
/*****************************************************/
// Method:	cmplxDiv
// Purpose:  Calculate D=in1/in0 (complex)
//Parameters: in1, in0, devisorShift, multShift
// Returns:   result
/*****************************************************/
static void getTxGainsFromExtGain(QbfElements_t* pElements)
{
	//uint8 totalExtGainDb;
	//uint8 totalExtGainLin;
	//uint8 trSwAttenDb;
	//uint8 gainToAmplify;
	//uint8 extLnaAttenDb;
	//uint8 useTrSwInCal;
	//uint8 usedAttenDb = 0;
	//uint32 gpb505 = 0;
	//uint32 deltaTpcGpb505;
	//uint32 deltaTpDbGpb505;
	//bool preDriverForAgcCal = FALSE;
	//bool mixer = FALSE;
	
	//Calibration Gains for ext LNA/PA boards:
	// * K calibration : use TPC 8, TrSw normal, and KDigitalGain // must have TrSw normal
	// * AGC Calibration : use tpcForAgcCal, TrSwForAgcAndTxCal, MAX_DIGITAL_GAIN // must have max digital gain
	// * Tx Calibration : use tpcForTxCal, TrSwForAgcAndTxCal,  digitalGainForTxCal(must have mixer LOW(-12dB) and PD HIGH(0dB)
	
	// wait 5us for registers to update 	  
	
	// read board gains:B0_PHY_RX_TD_BASE_ADDR
	//totalExtGainDb = REGISTER(TOTAL_EXT_GAIN_DB)&0xff;
	pElements->params.isExternalPa = REGISTER(IS_EXTERNAL_PA)&0x1;
	//totalExtGainLin = REGISTER(TOTAL_EXT_GAIN_LIN)&0xff;
	//trSwAttenDb = REGISTER(TR_SW_ATTEN_DB)&0xff;
	//extLnaAttenDb = REGISTER(EXT_LNA_ATTEN_DB)&0xff;
	//useTrSwInCal = REGISTER(USE_TR_SW_IN_BF_CAL)&0xff;

	// temporary values Eran Delete
   // totalExtGainDb = 0;
    //pElements->params.isExternalPa = 0; 
    //totalExtGainLin = 1;


	
#if BF_CALIBRATION_LOGS_ON
	//ILOG0_DDD("extGainDb = %d, extGain = %d, trAttenDb = %d", totalExtGainDb, totalExtGainLin, trSwAttenDb);
#endif
	// init:	 
	pElements->params.isExternalGain = FALSE;
	// K cal
	pElements->params.digitalGainForKCal = MAX_DIGITAL_GAIN;	
	pElements->params.tpcForKCal = 12;	 
	// AGC cal
	pElements->params.TrSwForAgcAndTxCal = 0;
	pElements->params.extLnaForAgcAndTxCal = 0;
	pElements->params.digitalGainForAgcCal = MAX_DIGITAL_GAIN;
	pElements->params.tpcForAgcCal = 0;
	// TX cal
	pElements->params.digitalGainForTxCal = MAX_DIGITAL_GAIN;
	pElements->params.tpcForTxCal = 0;
			  
		
		
		
	 
#if BF_CALIBRATION_LOGS_ON
		//("digitalGainForKCal = %d tpcForKCal = %d TrSwForAgcAndTxCal = %d  digitalGainForAgcCal = %d tpcForAgcCal = %d digitalGainForTxCal = %d  tpcForTxCal = %d",pElements->params.digitalGainForKCal,pElements->params.tpcForKCal,pElements->params.TrSwForAgcAndTxCal,pElements->params.digitalGainForAgcCal,pElements->params.tpcForAgcCal,pElements->params.digitalGainForTxCal,pElements->params.tpcForTxCal);
#endif
}

int32_cmplx_t cmplxDiv(int16_cmplx_t in1, int16_cmplx_t in0, uint8 devisorShift, uint8 multShift)
{
	int32 devisor;
	int32_cmplx_t result;
	
	devisor = (in0.real*in0.real + in0.image*in0.image)>>devisorShift;
	devisor = (devisor == 0) ? 1 : devisor; 
	
	result.real = ((in0.real*in1.real + in0.image*in1.image) << multShift)/devisor;
	result.image = ((in0.real*in1.image - in0.image*in1.real) << multShift)/devisor;

	return result;
}

/*****************************************************/
// Method:	setPgc1_3
// Purpose:   Update pgc1Cal, pgc3Cal according to RelativeGain
// Parameter: 
// Returns:   void
/*****************************************************/

/*void setPgc1_3(uint8 *pgc1, uint8 *pgc3, int16 relativeGain)
{
#if BF_CALIBRATION_LOGS_ON
	ILOG0_D("relative gain = %d",relativeGain);
#endif	
	relativeGain= MIN(relativeGain,RELATIVE_GAIN_MAX_VAL);
	// %PGC1 is 0-5, jumps of 6dB
	*pgc1 = (MIN(MAX((relativeGain/PGC1_2_STEP_DB),PGC1_3_MIN_VAL), PGC1_MAX_VAL)); 

	// %PGC3 is 0-15, jumps of 1dB 
	*pgc3 = (MIN(relativeGain-(*pgc1)*PGC1_2_STEP_DB, PGC3_MAX_VAL)); 
}
*/
/********************************************************/
// Method:	setRxGainValues
// Purpose:   Find AGC values for correct back off during calibration
// Parameter: 
// Returns:   void
/********************************************************/
/*
static CalStatus_e setRxGainValues(QbfElements_t *pElements, QbfSessionParams_t sessionParams, QbfAgcGains_t agcGains, int16 *pRelativeGainOrig)
{
	uint8 lnaGainsTable[4] = {RX_GAIN_LNA_LOW_GAIN, RX_GAIN_LNA_MID_GAIN, RX_GAIN_LNA_MID_GAIN, RX_GAIN_LNA_HIGH_GAIN};
	CalStatus_e calStat = CAL_STATUS_PASS;
	uint8 *pPgc1Cal; 
	uint8 *pPgc3Cal;
	int16 relativeGain;
	
	ASSERT (sessionParams.calAnt > 0 && sessionParams.calAnt <= MAX_ANTENNA);

	pPgc1Cal = &agcGainsForAllAntennas[sessionParams.calAnt - 1][sessionParams.session].pgc1Indx;
	pPgc3Cal = &agcGainsForAllAntennas[sessionParams.calAnt - 1][sessionParams.session].pgc3Indx;

	*pRelativeGainOrig = PGC1_2_STEP_DB*agcGains.pgc1Indx + PGC1_2_STEP_DB*agcGains.pgc2Indx + agcGains.pgc3Indx 
							+ lnaGainsTable[agcGains.lnaIndx];
	
	relativeGain = *pRelativeGainOrig - BACK_OFF_OFFSET; //we want to be at -21dB backoff (power rising up to 6 dB during calibration)
	

	if (relativeGain < RELATIVE_GAIN_MIN_VAL)
	{
#if BF_CALIBRATION_LOGS_ON
		int16 temp = -15-relativeGain;
		ILOG0_D("Warning: working at %d instead of 15 dB backoff", temp);
#endif
		relativeGain = 0;
	}
	if(relativeGain > RELATIVE_GAIN_MAX_ERROR_VAL)
	{
		calStat = CAL_STATUS_FAIL;
#if BF_CALIBRATION_LOGS_ON
		ILOG0_D("BF Calibration Failed !! Attenuation between antennas too high:%d", relativeGain);
#endif
	}
	else
	{
		setPgc1_3(pPgc1Cal,	pPgc3Cal, relativeGain);
	}

	return calStat;
}
*/
/************************************/
// Method:	calibrateRxGainsForCalibration
// Purpose:   Find AGC values for correct back off during calibration
// Parameter: 
// Returns:   void
/************************************/
static CalStatus_e calibrateRxGainsForCalibration (QbfElements_t *pElements, QbfSessionParams_t CalSessionParams, int16 *pRelativeGain,uint8 trSwTxAnt)
{
	Antenna_e rxAnt = CalSessionParams.rxAnt;
	uint32 startAddress = B0_PHY_RX_TD_BASE_ADDR + AGC_VALUES_ADDR_ANT0 + (rxAnt << 2);
	CalStatus_e calStat = CAL_STATUS_PASS;
	uint32 gain0_word;
	QbfAgcGains_t agcGains = {{0},{0},{0},{0}};

	//Antenna_e txAnt = CalSessionParams.txAnt;
	calStat = transmitValidatePacket(&(pElements->params.numOfPacketTransmitted), CalSessionParams,TRUE, agcGains/*Eran not clear value*/, pElements->params.offlineModulationType,0, trSwTxAnt,pElements->params.extLnaForAgcAndTxCal);
	if(calStat != CAL_STATUS_PASS)
	{
		return CAL_STATUS_FAIL;
	}
	gain0_word = REGISTER(startAddress);
	agcGains.lnaIndx = gain0_word&0x7;
	agcGains.pgc1Indx = (gain0_word >> 3)&0x1f;
	agcGains.pgc2Indx = (gain0_word >> 8)&0xf;
	//pElements->params.pgc1Cal[CalSessionParams.calAnt-1][CalSessionParams.session] = ;
	//pElements->params.pgc3Cal[CalSessionParams.calAnt-1][CalSessionParams.session] = ;
	agcGainsForAllAntennas[CalSessionParams.calAnt - 1][CalSessionParams.session].lnaIndx  = agcGains.lnaIndx;
	agcGainsForAllAntennas[CalSessionParams.calAnt - 1][CalSessionParams.session].pgc1Indx = agcGains.pgc1Indx;
	agcGainsForAllAntennas[CalSessionParams.calAnt - 1][CalSessionParams.session].pgc2Indx = agcGains.pgc2Indx;
#if BF_CALIBRATION_LOGS_ON
	ILOG0_DD ("Send packet: Ant%d->Ant%d", CalSessionParams.txAnt, CalSessionParams.rxAnt);
	ILOG0_D("trSwTxAnt: %d",trSwTxAnt);
#endif
	
	*pRelativeGain = (int16)(agcGains.pgc1Indx + agcGains.pgc2Indx*2 + (agcGains.lnaIndx*6 +2));
	//calStat = setRxGainValues (pElements, CalSessionParams, agcGains, pRelativeGain);
	
	return calStat;
}

/*****************************************************/
// Method:	setPgc1_3
// Purpose:   Update pgc1Cal, pgc3Cal according to RelativeGain
// Parameter: 
// Returns:   void
/*****************************************************/

/*static void setRxGainsForK (uint8 *pPgc1CalK, uint8 *pPgc3CalK, int16 relativeGain0, int16 relativeGain1)
{
	// We take the minimal gain, so backoff will not reduce from 15dB
	int16 minRelativeGain = MIN(relativeGain0, relativeGain1);
	
	setPgc1_3(pPgc1CalK,pPgc3CalK, minRelativeGain);
}*/

/*****************************************************/
// Method:	agcGainCalibration
// Purpose:   We want to first check the attenuation between the antennas, in order to work at correct back off for each receiving antenna.			
/*			We also want that the different AGC components between antennas will be only PGC1, PGC3 which cause minor distortion. 
			We will check the received system gain and create it using PGC1, PGC3.
*/
// Returns:   void
/*****************************************************/
static CalStatus_e agcGainCalibration (QbfElements_t* pElements)
{
	Antenna_e ant;
	CalStatus_e calStatus=  CAL_STATUS_INIT;
	QbfSessionParams_t calSessionParams[MAX_NUMBER_OF_CAL_SESSIONS];
	QbfSessions_e session;
	QbfSessions_e relativeGainSession;
	int16 relativeGain[MAX_NUMBER_OF_CAL_SESSIONS];
	//Antenna_e numAnt = pElements->params.numberOfAntennas;
	uint32 txAntMask;
	txAntMask = Hdk_GetTxAntMask();
	
	acitvateAirLoopBackMode(TRUE,pElements->params.tpcForAgcCal,pElements->params.digitalGainForKCal,pElements->params.isExternalPa);	// operate AGC        

	for (ant = ANTENNA_1; (ant < MAX_NUM_OF_ANTENNAS) && (calStatus != CAL_STATUS_FAIL); ant++)
	{
		if(txAntMask&(1<<ant))
		{
			fillSessionParams(calSessionParams, ant);
			for (session = SESSION_0; (session < MAX_NUMBER_OF_CAL_SESSIONS); session++)
			{
				calStatus = calibrateRxGainsForCalibration(pElements, calSessionParams[session], &relativeGain[session],0);
				if (calStatus != CAL_STATUS_PASS)
				{
					return CAL_STATUS_FAIL;
				}
			}
		}
		if(relativeGain[0] > relativeGain[1])
		{
			relativeGainSession =SESSION_1;
		}
		else
		{
			relativeGainSession =SESSION_0;
		}
		agcGainsForKCAlibration[ant -1].lnaIndx = agcGainsForAllAntennas[ant -1][relativeGainSession].lnaIndx;  
		agcGainsForKCAlibration[ant -1].pgc1Indx = agcGainsForAllAntennas[ant -1][relativeGainSession].pgc1Indx; 
		agcGainsForKCAlibration[ant -1].pgc2Indx = agcGainsForAllAntennas[ant -1][relativeGainSession].pgc2Indx;
		//setRxGainsForK(&(pElements->params.pgc1CalK[ant-1]),&(pElements->params.pgc3CalK[ant-1]), relativeGain[0], relativeGain[1]); 

	}
	return calStatus;
}

/*******************************************************************************/
// Method: calibrateAgcOffsets
// Purpose: 
/*
	We need to calibrate the phase and gain differences for the AGC components, in order to compensate their distortion in the received channel.
	Because each calibration inserts noise, we minimize the number of calibrations to the most necessary ones: 
	"	TR Switch
	"	LNA
	"	PGC2 (phase only)
	For the other AGC values we don't see enough distortion to require calibration.

	For each receiving antenna, the calibration order is the following:
	1)	Go over all AGC calibration values by changing each time one gain and record HAB.
	2)	Compensate for the added receive gain by reducing the transmission power using Tx digital gain.
	3)	Calculate D = HAB(AGC value) / HAB(default AGC value)  per group
	4)	Calculate the phase change per group: (Dr + jDi) / sqrt(Dr2 + Di2) and save in Phase RAM
	5)	Calculate the flat gain difference for this gain and save it in the Gain RAM: 10log10(average(Abs(D)^2) on all bins)
*/
// Parameters: agcOffsetCalParams, type
// Returns:   void
/*********************************************************************************/
static CalStatus_e calibrateAgcOffsets(QbfElements_t* pElements)
{
	CalStatus_e calStatus = CAL_STATUS_INIT;
	
	{
		calStatus = calibrateAgcOffsetsAnt(pElements, ANTENNA_1, ANTENNA_0);

		if (calStatus != CAL_STATUS_FAIL)
		{
			calStatus = calibrateAgcOffsetsAnt(pElements, ANTENNA_0, ANTENNA_1);
		}

		if ((pElements->params.numberOfAntennas > ANTENNA_2) && (calStatus != CAL_STATUS_FAIL))
		{
			calStatus = calibrateAgcOffsetsAnt(pElements, ANTENNA_0, ANTENNA_2);
			calStatus = calibrateAgcOffsetsAnt(pElements, ANTENNA_0, ANTENNA_3);

		}
	}

	return calStatus;

}
/*******************************************************************************/
// Method: calibrateAgcOffsetsAnt
// Purpose: 
// Parameters: 
// Returns:   void
/*********************************************************************************/
static CalStatus_e calibrateAgcOffsetsAnt(QbfElements_t* pElements, Antenna_e txAnt, Antenna_e rxAnt)
{
	
	CalStatus_e calStatus = CAL_STATUS_PASS;
	QbfAgcOffsetCalParams_t agcOffsetCalParams;
	QbfAgcOffsetCalType_e calType ;	
	
	agcOffsetCalParams.firstIter = TRUE;

	agcOffsetCalParams.sessionParams.txAnt = txAnt;
	agcOffsetCalParams.sessionParams.rxAnt = rxAnt;
	agcOffsetCalParams.sessionParams.session = txAnt ? SESSION_1: SESSION_0;
	agcOffsetCalParams.sessionParams.calAnt = txAnt ? txAnt : rxAnt;
																					
	agcOffsetCalParams.numOfPacketsCollectBeforeCalc = AGC_OFFSET_FIRST_CAL_PACKETS_TRANS_BEFORE_CALC; //in the first calibration we need to collect 2 channels before calculation

	for(calType = LNA_CAL; (calType < TOTAL_CAL_TYPE) && (calStatus != CAL_STATUS_FAIL) ; calType++)
	{
		fillAgcOffsetCalParams(&agcOffsetCalParams, calType);
		calStatus = calibrateAgcOffsetsProc(pElements, &agcOffsetCalParams);
		agcOffsetCalParams.numOfPacketsCollectBeforeCalc = AGC_OFFSET_TRANS_BEFORE_CALC; ////if not the first calibration we need to collect 1 channels before calculation because channel  0 already saved

	}

	return calStatus;
}

/*******************************************************************************/

// Method: fillAgcOffsetCalParams
// Purpose: set AGC offset parameters according to calibration type: PGC2, LNA, TRSW
// Parameters: agcOffsetCalParams, type
// Returns:   void
/*********************************************************************************/
static void fillAgcOffsetCalParams (QbfAgcOffsetCalParams_t *pAgcOffsetCalParams, QbfAgcOffsetCalType_e type)
{
	switch (type)
	{
	case (LNA_CAL):
		pAgcOffsetCalParams->pgc1CalOn = FALSE;
		pAgcOffsetCalParams->pgc2CalOn = FALSE;
		pAgcOffsetCalParams->lnaCalOn = TRUE;
		pAgcOffsetCalParams->trSwCalOn = FALSE;
		pAgcOffsetCalParams->calNumOfIterations = AGC_OFFSET_CAL_LNA_ITERAIONS; //calNumOfIterations need to be grater or equal to 3
		pAgcOffsetCalParams->gainIndx = AGC_OFFSET_LNA_CAL_GAIN_PHASE_FIRST_INDX;
		pAgcOffsetCalParams->phaseIndx = AGC_OFFSET_LNA_CAL_GAIN_PHASE_FIRST_INDX;
		break;
		
	case(PGC1_CAL):
		pAgcOffsetCalParams->pgc1CalOn = TRUE;
		pAgcOffsetCalParams->pgc2CalOn = FALSE;
		pAgcOffsetCalParams->lnaCalOn = FALSE;
		pAgcOffsetCalParams->trSwCalOn = FALSE;
		pAgcOffsetCalParams->calNumOfIterations = AGC_OFFSET_CAL_PGC1_ITERAIONS;
		pAgcOffsetCalParams->gainIndx = AGC_OFFSET_PGC1_CAL_GAIN_PHASE_FIRST_INDX;
		pAgcOffsetCalParams->phaseIndx = AGC_OFFSET_PGC1_CAL_GAIN_PHASE_FIRST_INDX;
	
			break;

	case(PGC2_CAL):
		pAgcOffsetCalParams->pgc1CalOn = FALSE;
		pAgcOffsetCalParams->pgc2CalOn = TRUE;
		pAgcOffsetCalParams->lnaCalOn = FALSE;
		pAgcOffsetCalParams->trSwCalOn = FALSE;
		pAgcOffsetCalParams->calNumOfIterations = AGC_OFFSET_CAL_PGC2_ITERAIONS;
		pAgcOffsetCalParams->gainIndx = AGC_OFFSET_PGC2_CAL_GAIN_PHASE_FIRST_INDX;
		pAgcOffsetCalParams->phaseIndx = AGC_OFFSET_PGC2_CAL_GAIN_PHASE_FIRST_INDX;

		break;
		
	default:
		DEBUG_ASSERT (0);
	}
}
/*******************************************************************************/
// Method: calibrateAgcOffsetsProc
// Purpose: calculate agc offset calibrations (PGC2, LNA, TRSW) according to input parameters 
// Parameters: pElements, pCalParams
// Returns:   void
/*********************************************************************************/
#define LNA_GAIN_TABLE_SIZE 5


static CalStatus_e calibrateAgcOffsetsProc(QbfElements_t* pElements, QbfAgcOffsetCalParams_t* pCalParams)
{
	CalStatus_e calStatus = CAL_STATUS_PASS;
	uint32 txDigitalGainAdd[4] = {REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, REG_PHY_TX_REGS_TX2_TX3_AMP_GAIN_F,REG_PHY_TX_REGS_TX2_TX3_AMP_GAIN_F};	
	uint32 txDigitalGainMask[4] = {0x1ff, 0x1ff000, 0x1ff,0x3fe00};
	uint32 txDigitalGainMaskShift[4] = {0x0, 0xc, 0x0,0x9};
	uint16 digitalGain;
	uint32 txAnt;
	QbfAgcGains_t agcGains = {{0},{0},{0},{0}};
	int32 lnaGainsTable[LNA_GAIN_TABLE_SIZE];
	uint8 lnaIndxTable [5] = {0,1,2,3,4};
	uint8 pgc1IndexIndxTable [7] = {6,8,10,12,14,16,18};
	uint8 pgc2IndexIndxTable [5] = {0,2,4,6,8};
	uint16 refGain; 
	int16 relativeGain = 0;
	uint8 iteration;
	int16 gainFix;
	int16 gainFixPrev = 0;
	bool calcAgcCorrection = FALSE;
	uint32 index;
	// Set TPC for all antennas (short 3) (doesn't need to change during calibration)
	//setShort3(pElements->params.tpcForAgcCal,pElements->params.isExternalPa);
	setRficTxParams(pElements->params.tpcForAgcCal);
	for(index = 0; index < LNA_GAIN_TABLE_SIZE;index++)
	{
		lnaGainsTable[index] = REGISTER(LNA_GAIN_START_ADDRESS + index*4)/*in q1*/;
		if(lnaGainsTable[index]&0x200)
		{
			lnaGainsTable[index] = lnaGainsTable[index] | 0xfffffc00;
		}
		lnaGainsTable[index] = lnaGainsTable[index]/2;
	}
	
	agcGains.pgc1Indx = agcGainsForAllAntennas[pCalParams->sessionParams.calAnt-1][pCalParams->sessionParams.session].pgc1Indx;
	agcGains.pgc2Indx = agcGainsForAllAntennas[pCalParams->sessionParams.calAnt-1][pCalParams->sessionParams.session].pgc2Indx;
	agcGains.lnaIndx = agcGainsForAllAntennas[pCalParams->sessionParams.calAnt-1][pCalParams->sessionParams.session].lnaIndx;

	refGain = ((agcGains.pgc1Indx)*1 + (agcGains.pgc2Indx)*2);
	refGain = refGain + lnaGainsTable[agcGains.lnaIndx];
	if(pCalParams->pgc1CalOn)
	{
		agcGains.pgc1Indx = pgc1IndexIndxTable[0];
	}
	if(pCalParams->pgc2CalOn)
	{
		agcGains.pgc2Indx = pgc2IndexIndxTable[0];
	}
	//agcGains.lnaIndx = (1 - pCalParams->lnaCalOn)*agcGains.lnaIndx;
	
	for (iteration = 0; (iteration < pCalParams->calNumOfIterations) && (calStatus != CAL_STATUS_FAIL); iteration++)
	{
						
		relativeGain = agcGains.pgc1Indx*1 + agcGains.pgc2Indx*2  + lnaGainsTable[agcGains.lnaIndx] - refGain;
		digitalGain = setDigitalGainForAgcOffsetCal(relativeGain);
#if BF_CALIBRATION_LOGS_ON
		ILOG0_D("digital gain %d",digitalGain);
#endif
		gainFix = -getDigitalAttenuation(relativeGain) + relativeGain;
		txAnt = pCalParams->sessionParams.txAnt;
		RegAccess_WriteMasked( txDigitalGainAdd[txAnt],txDigitalGainMask[txAnt], digitalGain<<txDigitalGainMaskShift[txAnt]);

		if (iteration == (pCalParams->numOfPacketsCollectBeforeCalc))
		{
			calcAgcCorrection = TRUE;
		}

		calStatus = transmitPacketAndCalcAgcCorrection(pElements, pCalParams, FALSE, agcGains, gainFixPrev, calcAgcCorrection,pCalParams->trSwCalOn, pElements->params.TrSwForAgcAndTxCal);
#if BF_CALIBRATION_LOGS_ON
		ILOG0_DDDD("running for gains : LnaIndex %d, pgc1Index %d, pgc2Index %d,pgc3Index %d",agcGains.lnaIndx,agcGains.pgc1Indx,agcGains.pgc2Indx,agcGains.pgc3Indx);
#endif
		gainFixPrev = gainFix;	//gainFixPrev holds the previous channel gain fix for the next agc calculation because agcCalculation work on the previous channel while transmitting the current channel
		readChannelDataFromChannelRam((QbfSessions_e)(!pCalParams->firstIter),pCalParams->sessionParams.rxAnt);
		if (calcAgcCorrection == TRUE)
		{
			pCalParams->gainIndx++;
			pCalParams->phaseIndx++;
		}

		if(pCalParams->lnaCalOn)
		{
			agcGains.lnaIndx = lnaIndxTable[iteration];
		}
		if(pCalParams->pgc1CalOn)
		{
			agcGains.pgc1Indx = pgc1IndexIndxTable[iteration + 1];
		}
		if(pCalParams->pgc2CalOn)
		{
			agcGains.pgc2Indx = pgc2IndexIndxTable[iteration + 1];
		}
		
		pCalParams->firstIter = FALSE;
	}

	//Calculate last packet agc correction
	calculateAgcCorrection(pCalParams, gainFix);

	return calStatus;
}

/*****************************************************/
// Method: setDigitalGainForAgcOffsetCal
// Purpose:  
// Parameters: 
// Returns:   void
/*****************************************************/
static uint16 setDigitalGainForAgcOffsetCal(int16 relativeGain)
{
	uint16 digitalGain;
	
	if (relativeGain >= DIGITAL_GAIN_LEVEL4)
	{
		digitalGain = (MAX_DIGITAL_GAIN_RX + 1) >> DIGITAL_GAIN_LEVEL4_SHIFT;
	}
	else if (relativeGain >= DIGITAL_GAIN_LEVEL3)
	{
		digitalGain = (MAX_DIGITAL_GAIN_RX + 1) >> DIGITAL_GAIN_LEVEL3_SHIFT;
	}
	else if (relativeGain >= DIGITAL_GAIN_LEVEL2)
	{
		digitalGain = (MAX_DIGITAL_GAIN_RX + 1) >> DIGITAL_GAIN_LEVEL2_SHIFT;
	}
	
	else if (relativeGain >= DIGITAL_GAIN_LEVEL1)
	{
		digitalGain = (MAX_DIGITAL_GAIN_RX + 1) >> DIGITAL_GAIN_LEVEL1_SHIFT;
	}
	else 
	{
		digitalGain = MAX_DIGITAL_GAIN_RX;
	}

	return digitalGain;
}
/*****************************************************/
// Method: getDigitalAttenuation
// Purpose:  
// Parameters: 
// Returns:   void
/*****************************************************/

static uint16 getDigitalAttenuation (int16 relativeGain)
{
	uint16 attenuation;

	if (relativeGain >= DIGITAL_GAIN_LEVEL4)
	{
		attenuation = DIGITAL_GAIN_LEVEL4;
	}
	
	else if (relativeGain >= DIGITAL_GAIN_LEVEL3)
	{
		attenuation = DIGITAL_GAIN_LEVEL3;
	}
	else if (relativeGain >= DIGITAL_GAIN_LEVEL2)
	{
		attenuation = DIGITAL_GAIN_LEVEL2;
	}
	else if (relativeGain >= DIGITAL_GAIN_LEVEL1)
	{
		attenuation = DIGITAL_GAIN_LEVEL1;
	}
	else
	{
		attenuation = 0;
	}

	return attenuation;
}
/*****************************************************/
// Method:   calculateAgcCorrection
// Purpose:  Calculates the Gain and Phase distortions caused from varying AGC values, 
//		      and writes the correction to its suiting position in the Gain RAM and Phase RAM
//Parameters: sessionParam, pCalParams, gainFix
// Returns:   void
/*****************************************************/
static void calculateAgcCorrection(QbfAgcOffsetCalParams_t *pCalParams, int16 gainFix)
{
	uint32 gainStartAddress =  AGC_OFFSET_CAL_GAIN_START_ADDR;
	uint32 phaseAddr;
	uint32 phaseAddrNew;
	uint32 power;
	uint32 avgPower = 0;
	int16 avgPowerDb;
	int8 gainCorrection;
	uint8 nGroups = getNumOfGroups();
	uint32 offset  = getGroupOffset();
	int32_cmplx_t dResultcmplx; //D=H1/H0
	int8_cmplx_t phase;
	uint8 groupIndx;
	uint16 phaseValWriteToRam;
	uint32 gainTableIndex;
	uint32 ramGainAddr;
	uint16 ramGainVal;
	
	uint32 phaseIndex = pCalParams->phaseIndx;
	uint32 toCalibratePhase = TRUE;
	phaseAddr = AGC_OFFSET_CAL_PHASE_START_ADDR + ((pCalParams->sessionParams.rxAnt*MAX_AGC_CALIBRATIONS_VALS_NUMBER + phaseIndex) << 2);
	phaseAddrNew = phaseAddr;
	for (groupIndx = 0; groupIndx < nGroups; groupIndx++)
	{
		dResultcmplx = cmplxDiv(Hcmplx[1][groupIndx], Hcmplx[0][groupIndx],DIV_RESULT_SHIFT, MULT_RESULT_SHIFT);

		phase = calculatePhase(dResultcmplx, PHASE_CALC_SHIFT);
		phaseValWriteToRam = (phase.real  << PHASE_REAL_SHIFT) + (phase.image  << PHASE_IMAGE_SHIFT);
		if(toCalibratePhase == TRUE)
		{
			phaseAddrNew = phaseAddr +  (offset+groupIndx)*((MAX_AGC_CALIBRATIONS_VALS_NUMBER * MAX_NUM_OF_DIGITAL_ANTENNAS) << 2);
			RegAccess_WriteMasked(phaseAddrNew, MASK_16LSB, phaseValWriteToRam);

		}
		if (!pCalParams->pgc2CalOn&&!pCalParams->pgc1CalOn)
		{
			power = dResultcmplx.real*dResultcmplx.real + dResultcmplx.image*dResultcmplx.image;
			avgPower += power;
		}
	}
	avgPower /= nGroups;		
	if ((!pCalParams->pgc2CalOn)&&(!pCalParams->pgc1CalOn)&&(avgPower>0))
	{
		
		// calculate power offset

		avgPowerDb = dBConverterAccurate(avgPower) - DB_CALC_CORRECTION + MATLAB_OFFSET;
		avgPowerDb -= (gainFix << 3);
		avgPowerDb = LIMIT_SIGN(avgPowerDb, MAX_8BIT_SIGN_VAL);
		gainCorrection =(-avgPowerDb);// corrects the gain difference

		// in each Gain register there are 2 8bits values. We need to add our value in the correct position into the register	
		gainTableIndex = ((pCalParams->gainIndx)*MAX_NUM_OF_DIGITAL_ANTENNAS + pCalParams->sessionParams.rxAnt);
		ramGainAddr = gainStartAddress + ((gainTableIndex >> 1) << 2);

		ramGainVal = REGISTER(ramGainAddr);
		
		if ((gainTableIndex & 0x1) == 0)
		{
			ramGainVal =  ((ramGainVal & MASK_8MSB) | (gainCorrection));
		}
		else
		{
			ramGainVal = ((ramGainVal & MASK_8LSB) | (gainCorrection << 8));
		}
		
		// write to location in gain RAM
		RegAccess_WriteMasked(ramGainAddr, MASK_16LSB, ramGainVal);
		
	}

}
/*****************************************************/
// Method:	calculatePhase
// Purpose:  Calculates D/abs(D), which is the complex phase.
//Parameters: input
// Returns:   result
/*****************************************************/
static int8_cmplx_t calculatePhase(int32_cmplx_t input, uint8 shift)
{
	int32 abs;
	int32_cmplx_t phase;
	int8_cmplx_t retPhase;
	abs = absHwAccurate(input);
	phase.real = ((input.real << shift)/abs);

	phase.image = ((input.image << shift)/abs);

	// saturate phase values  
	retPhase.real = (int8)LIMIT_SIGN(phase.real,MAX_8BIT_SIGN_VAL);
	retPhase.image = (int8)LIMIT_SIGN(phase.image,MAX_8BIT_SIGN_VAL);

	return retPhase;
}
/*****************************************************/
// Method:   absHwAccurate
// Purpose:  Returns approximated abs(%real+j*%imag)
//Parameters: input
// Returns:   result
/*****************************************************/
static uint32 absHwAccurate(int32_cmplx_t input)
{
	int32_cmplx_t inputAbs;
	uint32 bigger;
	uint32 smaller;
	uint32 retVal;

	inputAbs.real = (input.real > 0) ? input.real : (-input.real); 
	inputAbs.image = (input.image > 0) ? input.image : (-input.image); 
	
	if (inputAbs.real >= inputAbs.image)
	{
		bigger = inputAbs.real;
		smaller = inputAbs.image;
	}
	else
	{
		bigger = inputAbs.image;
		smaller = inputAbs.real;		
	}
	if (bigger >= (smaller << 1))
	{
		retVal = (bigger + (((smaller << 1) + smaller) >> 3));
	}
	else
	{
		retVal =  (((bigger + (bigger << 1)) >> 2)  + (((smaller << 3) + (smaller << 1)) >> 4));
	}

	return retVal;

}

/********************************************************************************************/
// Method:	dBConverterAccurate
// Purpose:  Returns approximated 10log10(%num). Result is signed, with 3 bits representing the fracture part.
//Parameters: input
// Returns:   result
/********************************************************************************************/
static uint16 dBConverterAccurate(uint32 power)
{
	uint8 msb = 0;
	uint32 residue;
	uint16 retVal;
	
	DEBUG_ASSERT(power);

	while ((power >> msb) != 0)
	{
		msb++;
	}
	msb--;

	residue = power - (1 << msb);
	
	if (msb < NUM_CCA_RESIDUE_BITS)
	{
		residue <<=(NUM_CCA_RESIDUE_BITS - msb);
	}
	else
	{
		residue >>= (msb - NUM_CCA_RESIDUE_BITS);
	}

	retVal = 3*((msb << NUM_CCA_RESIDUE_BITS) + residue);

	return retVal;

}
/********************************************************************************************/
// Method:  calibrateTxOffsetForBfProc
// Purpose: Calibrates the mixer gain. %tpcIndex need to be>=8 (mixer low).
//Parameters: pElements, pCalParams
// Returns:   result
/********************************************************************************************/
static CalStatus_e calibrateTxOffsetForBfProc(QbfElements_t* pElements, QbfTxOffsetCalParams_t *pCalParams)
{
	uint32 txDigitalGainAdd[4] = {REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, REG_PHY_TX_REGS_TX0_TX1_AMP_GAIN_F, REG_PHY_TX_REGS_TX2_TX3_AMP_GAIN_F,REG_PHY_TX_REGS_TX2_TX3_AMP_GAIN_F};	
	uint32 txDigitalGainMask[4] = {0x1ff, 0x1ff000, 0x1ff,0x3fe00};
	uint32 txDigitalGainMaskShift[4] = {0x0, 0xc, 0x0,0x9};
	Antenna_e txAnt = pCalParams->sessionParams.txAnt;
	uint8 tpcIndex = pCalParams->tpcFirstIndex;
	CalStatus_e calStatus = CAL_STATUS_PASS;
	QbfAgcGains_t agcGains = {{0},{0},{0},{0}};
	uint16 txDigitalGainVal [3];
	uint8 iteration;
	
	txDigitalGainVal[0] = MAX_DIGITAL_GAIN;
	txDigitalGainVal[1] = MAX_DIGITAL_GAIN/2;
	txDigitalGainVal[2] = MAX_DIGITAL_GAIN/3;
	agcGains.lnaIndx  = agcGainsForAllAntennas[pCalParams->sessionParams.calAnt-1][pCalParams->sessionParams.session].lnaIndx;
	agcGains.pgc1Indx = agcGainsForAllAntennas[pCalParams->sessionParams.calAnt-1][pCalParams->sessionParams.session].pgc1Indx;
	agcGains.pgc2Indx = agcGainsForAllAntennas[pCalParams->sessionParams.calAnt-1][pCalParams->sessionParams.session].pgc2Indx;
	//agcGains.pgc1Indx = pElements->params.pgc1Cal[pCalParams->sessionParams.calAnt-1][pCalParams->sessionParams.session];
	//agcGains.pgc3Indx = pElements->params.pgc3Cal[pCalParams->sessionParams.calAnt-1][pCalParams->sessionParams.session];
	
	
	//REGISTER(REG_PHY_TX_REGS_BEAM_FORMING0) &= ~0x400000;
	
	RegAccess_WriteMasked(txDigitalGainAdd[txAnt], txDigitalGainMask[txAnt], txDigitalGainVal[0] << txDigitalGainMaskShift[txAnt]);
	//setShort3(0,pElements->params.isExternalPa);
	setRficTxParams(tpcIndex);
	calStatus = transmitValidatePacket(&(pElements->params.numOfPacketTransmitted), pCalParams->sessionParams, FALSE, agcGains, pElements->params.offlineModulationType,0,pElements->params.TrSwForAgcAndTxCal,pElements->params.extLnaForAgcAndTxCal);
	readChannelDataFromChannelRam((QbfSessions_e)0,pCalParams->sessionParams.rxAnt);
	tpcIndex += TPC_INDEX_STEP;
	for (iteration = 1; (iteration < 3) && (calStatus != CAL_STATUS_FAIL); iteration++, tpcIndex += TPC_INDEX_STEP)
	{
		RegAccess_WriteMasked(txDigitalGainAdd[txAnt], txDigitalGainMask[txAnt], txDigitalGainVal[iteration] << txDigitalGainMaskShift[txAnt]);
		
		// Set TPC for all antennas (short 3) (doesn't need to change during calibration)
		//setShort3(tpcIndex,pElements->params.isExternalPa);
		setRficTxParams(tpcIndex);
		calStatus = transmitValidatePacket(&(pElements->params.numOfPacketTransmitted), pCalParams->sessionParams, FALSE, agcGains, pElements->params.offlineModulationType,0,pElements->params.TrSwForAgcAndTxCal,pElements->params.extLnaForAgcAndTxCal);

		readChannelDataFromChannelRam((QbfSessions_e)1,pCalParams->sessionParams.rxAnt);
		// Set RAM Index0 with Mixer=0, Index1 with Mixer=1. Index 1 is all ones
		calculateTxCorrection(pCalParams, iteration);
	}
	

	return calStatus;	
}

/********************************************************************************************/
// Method:  calculateTxCorrection
// Purpose: Calculates the Phase correction and writes it to the suiting index in the TX RAM
//Parameters: pElements, pCalParams
// Returns:   result
/********************************************************************************************/

static void calculateTxCorrection(QbfTxOffsetCalParams_t *pCalParams, uint8 calIndex)
{
	uint32 txCalPhaseAddr = TX_CORRECTION_START_ADDERSS + TX_CORRECTION_ANT_OFFSET*(pCalParams->sessionParams.txAnt) + (calIndex << 2);
	uint16 txCalPhaseValWriteToRam;
	int8_cmplx_t phase;
	uint8 nGroups = getNumOfGroups();
	uint32 offset = getGroupOffset();
	uint8 groupIndx;
	int32_cmplx_t dResultcmplx; 
	int32 real;
	int32 image;

	for (groupIndx = 0; groupIndx < nGroups; groupIndx++)
	{
		// calculate D=H1/H0
		dResultcmplx = cmplxDiv(Hcmplx[1][groupIndx], Hcmplx[0][groupIndx],DIV_RESULT_SHIFT, MULT_RESULT_SHIFT);

		// calculate complex phase: phase=D/abs(D) 
		phase = calculatePhase(dResultcmplx, PHASE_CALC_SHIFT);
		real = phase.real;
		image = phase.image;
		txCalPhaseValWriteToRam = ((0xff&real)  << PHASE_REAL_SHIFT) | ((0xff&image)  << PHASE_IMAGE_SHIFT);

		// write to group #i location in #Txant phase RAM
		MT_WrRegMask(B0_PHY_TX_BASE_ADDR, txCalPhaseAddr + ((groupIndx+offset)*8*4),  MASK_16LSB, txCalPhaseValWriteToRam );

	}
}

/*******************************************************************************/
// Method: calibrateTxOffsetsAnt
// Purpose: 
// Parameters: 
// Returns:   void
/*********************************************************************************/
static CalStatus_e calibrateTxOffsetsAnt (QbfElements_t* pElements, Antenna_e txAnt, Antenna_e rxAnt)
{
	CalStatus_e calStatus = CAL_STATUS_PASS;
	QbfTxOffsetCalParams_t txOffsetCalParams;

	txOffsetCalParams.sessionParams.txAnt = txAnt;
	txOffsetCalParams.sessionParams.rxAnt = rxAnt;
	txOffsetCalParams.sessionParams.session = txAnt ? SESSION_1: SESSION_0;
	txOffsetCalParams.sessionParams.calAnt = txAnt ? txAnt : rxAnt;
	txOffsetCalParams.tpcFirstIndex = pElements->params.tpcForTxCal;
	
	calStatus = calibrateTxOffsetForBfProc(pElements, &txOffsetCalParams);

	return calStatus;
}

/********************************************************************************************/
// Method:  CalibrateTxOffsetsForBf
// Purpose: 
/*
			We need to calibrate the phase differences for the Tx components(TPC and mixer), in order to compensate their distortion in the transmitted packet (we cannot compensate for gain differences in the Tx path).
			Because each calibration inserts noise, we minimize the number of calibrations to the most necessary ones: 
			"	Mixer phase
			For the other TPC values we don't see enough distortion to require calibration, and also there is limited RAM space there.

			For each transmitting antenna, the calibration order is the following:
			1)	Go over all TPC calibration values by changing each time one TPC and record HAB.
			2)	Compensate for the added Tx gain by reducing the transmission power using Tx digital gain.
			3)	Calculate D = HAB(TPC value) / HAB(default TPC value)  per group
			4)	Calculate the phase change per group: (Dr + jDi) / sqrt(Dr2 + Di2) and save in TX Phase RAM
*/
//Parameters: pElements
// Returns:   result
/********************************************************************************************/
static CalStatus_e CalibrateTxOffsetsForBf (QbfElements_t* pElements)
{
	
	CalStatus_e calStatus = CAL_STATUS_INIT;
	
	calStatus = calibrateTxOffsetsAnt(pElements, ANTENNA_0, ANTENNA_1);

	if (calStatus != CAL_STATUS_FAIL)
	{

		calStatus = calibrateTxOffsetsAnt(pElements, ANTENNA_1, ANTENNA_0);

	}

	if ((pElements->params.numberOfAntennas > ANTENNA_2) && (calStatus != CAL_STATUS_FAIL))
	{

		calStatus = calibrateTxOffsetsAnt(pElements, ANTENNA_2, ANTENNA_0);
		if (calStatus != CAL_STATUS_FAIL)
		{
			calStatus = calibrateTxOffsetsAnt(pElements, ANTENNA_3, ANTENNA_0);
		}

	}
	

	return calStatus;
}
//************************************************
// Method:	 transmitValidatePacket
// Purpose:  	Transmits a MAC Emulator packet and validates the received channel. If needed, retransmits
// Parameter: 
// Returns:   void
//************************************************
static CalStatus_e transmitPacketAndCalcAgcCorrection(QbfElements_t* pElements, QbfAgcOffsetCalParams_t *pCalParams, bool agcOn, QbfAgcGains_t agcGains,  int16 gainFix, bool calcAgcCorrection, uint8 trSwRxAnt, uint8 trSwTxAnt)
{
	
	uint8 retriesCounter = 0;
	CalStatus_e calStatus = CAL_STATUS_FAIL;
	bool channelValidityRes = FALSE;
	uint16 transmitPacketWaitTime = WAIT_FOR_UPLOAD_CHANNEL_USEC_AGC_OFF_16QAM;
	uint16 transmitPacketWaitTimeFirstVal = WAIT_FOR_UPLOAD_CHANNEL_USEC_AGC_OFF_16QAM;
	uint8 agcCorrectionCalcTime;
	bool calcAgcCorrectionDone = FALSE;
	packetModulation_e mod = pElements->params.offlineModulationType;
	
	DEBUG_ASSERT(mod==QAM16_1_2 || mod== BPSK_1_2);
	
	if (mod==QAM16_1_2)
	{
		transmitPacketWaitTime = WAIT_FOR_UPLOAD_CHANNEL_USEC_AGC_OFF_16QAM;
	}
	else if(mod==BPSK_1_2)
	{
		transmitPacketWaitTime = WAIT_FOR_UPLOAD_CHANNEL_USEC_AGC_OFF_BPSK;
	}
	transmitPacketWaitTimeFirstVal = transmitPacketWaitTime ;

	while ((retriesCounter < PACKET_TRANSMIT_MAX_RETRIES) && (channelValidityRes == FALSE) 
			&& (pElements->params.numOfPacketTransmitted < MAX_TRANSMIT_PACKETS))
	{
		setTxAndRxRegisters(pCalParams->sessionParams, agcOn, agcGains, trSwRxAnt, trSwTxAnt,pElements->params.extLnaForAgcAndTxCal);
		triggerTB();

		// clear CRC counter		
		MT_WrReg(B0_PHY_BE_BASE_ADDR, REG_PHY_RXBE_REG24_CLEAR_COUNTERS, 0x1); 

		sendMacEmulatorPacket();

		//Take into account the time we do calculateAgcCorrection and sustruct it from transmitPacketWaitTime
		if ((calcAgcCorrectionDone == FALSE) && (calcAgcCorrection == TRUE))		//calculateAgcCorrection called after we have H0 and H1
		{
			agcCorrectionCalcTime = TIME_STAMP(START_TIME,0);
			calculateAgcCorrection(pCalParams, gainFix);
			agcCorrectionCalcTime = TIME_STAMP(END_TIME,agcCorrectionCalcTime);
			transmitPacketWaitTime -= (agcCorrectionCalcTime);
			calcAgcCorrectionDone = TRUE;
		}
		else
		{
			transmitPacketWaitTime = transmitPacketWaitTimeFirstVal ;
		}

		channelValidityRes = checkChannelValidity(pCalParams->sessionParams, transmitPacketWaitTime);
		retriesCounter++;
	}

	pElements->params.numOfPacketTransmitted+=retriesCounter;

	if (channelValidityRes == TRUE)
	{
		calStatus = CAL_STATUS_PASS;
	}
	else
	{
#if BF_CALIBRATION_LOGS_ON
		ILOG0_V ("BF Calibration Failed!! could not achieve a good channel");
#endif
	}

	return calStatus;
}

//************************************************
// Method:	 BeamForming_GetLastRunTime
// Purpose:  	
// Parameter: 
// Returns:   void
//************************************************
uint32 BeamForming_GetLastRunTime(void)
{
	return m_Qbf_elements.results.lastRunTime;
}

 uint32 getNumOfGroups(void)
{
	uint32 cb = txBeReg07.bitFields.txIsHalfBand2080  | (txBeReg07.bitFields.txIsHalfBand4080 << 1);
	if(cb == 0)
	{
		return 62;
	}
	if(cb == 2)
	{
		return 30;
	}
	else
	{
		return 16;
	}
}
 
 uint32 getGroupOffset(void)
{
	uint32 cb = txBeReg07.bitFields.txIsHalfBand2080  | (txBeReg07.bitFields.txIsHalfBand4080 << 1);
	if(cb == 0)
	{
		return 0;
	}
	if(cb == 2)
	{
		return 16;
	}
	else
	{
		return 23;
	}
}
 
 uint32 getNumOfDataBins(void)
{
	uint32 cb = txBeReg07.bitFields.txIsHalfBand2080  | (txBeReg07.bitFields.txIsHalfBand4080 << 1);
	if(cb == 0)
	{
		return 234;
	}
	else if(cb == 2)
	{
		return 108;
	}
	else
	{
		return 52; 
	}
}

#ifdef QBF_PHY_DEBUG
void BeamForming_SetDisTxCancel (bool status)
{
	if (status)
	{
		m_Qbf_elements.params.disTxCancel = DEBUG_DIS_TX_CANCEL_VAL;
#if BF_CALIBRATION_LOGS_ON
		ILOG0_V("DisTxCancel");
#endif
	}
	else
	{
		m_Qbf_elements.params.disTxCancel = 0;
#if BF_CALIBRATION_LOGS_ON
		ILOG0_V("EnTxCancel");
#endif
	}
}
uint8 BeamForming_GetDisTxCancel (void)
{
	return m_Qbf_elements.params.disTxCancel;
}
#endif //QBF_PHY_DEBUG



