#ifndef __LpfClbrHndlrApi_h__
#define __LpfClbrHndlrApi_h__

#include "System_GlobalDefinitions.h"
#include "HdkGlobalDefs.h"
#include "CalibrationDefs.h"
#include "calibrationsParamsOtf.h"

/**********************************************************************/
/***				Publicic Functions Definitions					***/
/**********************************************************************/

//************************************
// Method:    LPF_Calibrate
// Purpose:   Run calibration procedure segments
// Parameter: IN ClbrType_e calibType - Online/Offline
// Returns:   int32
//************************************
RetVal_e LPF_Calibrate(IN ClbrType_e calibType);
//************************************
// Method:      LPF_LoadResults
// Purpose:     Loads LPF calibration data from a buffer
// Parameter: None
// Returns:     None
//************************************
void LPF_LoadResults(void);

//************************************
// Method:    LPF_SetStatus
// Purpose:   Set calibration status of given antenna
// Parameter: IN uint32 antenna
// Parameter: IN CalStatus_e status
// Returns:   void
//************************************
void LPF_SetStatus(IN uint32 antenna, IN CalStatus_e status);
//************************************
// Method:    LPF_GetStatus
// Purpose:   Get calibration status of given antenna
// Parameter: IN uint32 antenna
// Returns:   CalStatus_e
//************************************
CalStatus_e LPF_GetStatus(IN uint32 antenna);
//************************************
// Method:    LPF_GetLastRunTime
// Purpose:   Get last LPF calibration run time duration
// Parameter: void
// Returns:   uint32
//************************************
uint32 LPF_GetLastRunTime(void);
//************************************
// Method:    LPF_GetElement
// Purpose:   Statistics
// Parameter: void
// Returns:   uint32* - pointer to the 
//************************************
uint32* LPF_GetElement(void);

#endif // __LpfClbrHndlrApi_h__

