#ifndef __LpfClbrHndlr_h__
#define __LpfClbrHndlr_h__

#include "System_GlobalDefinitions.h"
#include "CalibrationDefs.h"
#include "LpfDefinitions.h"
#include "RficDriver_API.h"



/**********************************************************************/
/***			Module Internal Functions Definitions				***/
/**********************************************************************/

//************************************
// Method:    LpfDep_PerformAntennaCalibration
// Purpose:   Performs the LPF calibration for the antenna specified in pElements
//            Platform Dependant!!
// Parameter: LpfElements_t* pElements - A structure containing all parameters,
//                                       results and scratch-pad needed for the LPF calibration
// Returns:   RET_VAL_SUCCESS or RET_VAL_FAIL
//************************************
RetVal_e LpfDep_PerformAntennaCalibration(IN LpfElements_t* pElements);
//************************************
// Method:    LpfDep_SetAntCalibResults
// Purpose:   Set the calibration results. Cannot be done during the calibration since the registers are used repeatedly
// Parameter: IN LpfElements_t * pElements - A data structure containg the calibration results
// Returns:   void
//************************************
void LpfDep_SetAntCalibResults(IN LpfElements_t* pElements);

#endif // __LpfClbrHndlr_h__

