#include "CalibrationHandlerUtils.h"

// LPF word search params
#define MAX_LPF_WORD				(31)
#define MIN_LPF_WORD				(0)
#define INITIAL_LPF_WORD			(0x10)
#define MAX_NUM_OF_STEPS_EDGE_BAND	(5)

// Branch selection
#define LPF_NUM_OF_RF_PATHS_TO_CALIB (2) // Both I branch and Q branch are calibrated in AR10/W400

// Single Antenna mode
#define SINGLE_ANTENNA_MODE (FALSE)

// Rx gains settings for the calibration
#define PGC1_GAIN (6)
#define PGC2_GAIN (0)
#define PGC3_GAIN (0) // AKA VGA

// Goertzel Configuration
#define NUM_OF_GOERTZEL_CYCLES (8) // for goertzel = 2048 samples , 1 cycles is 256

// Tone Gnerator Configuration
#define TONE_GEN_AMPLITUDE	(11)

// Algorithm bins
#define RX_CB_STOP_BIN		(56)	// in shift up mode ==> practical is 56+64 = 120
#define RX_CB_EDGE_BIN		(57)	
#define RX_CB_ADJACENT_BIN	(7)		// in shift up mode ==> practical is 7+64 = 71
#define RX_NCB_EDGE_BIN		(0)		// in shift up mode ==> practical is 0+32 = 32
#define RX_NCB_RIPPLE_BIN	(26)
#define RX_NCB_STOP_BIN		(20)	// in shift up mode ==> practical is 20+32 = 52
#define TX_CB_CAL_BIN		(63)
#define TX_NCB_CAL_BIN		(31)
#define TX_CB_STOP_BIN		(26)	// in shift up mode ==> practical is 26+64 = 90
#define TX_NCB_STOP_BIN		(20)	// in shift up mode ==> practical is 20+32 = 52

// Reference bins
#define FIRST_PASS_BAND_REF_BIN		(1)
#define PASS_BAND_REF_BIN_NUM		(6)

#define ENFORCED_PAIRING_BIN_OFFSET (3) // Bin pairing offset in min search

// dB adjustment
#define RX_CB_PAIRING_CAL_BIN_ADJUST(x)						REDUCE_BY_1_8_dB(x)
#define RX_CB_ADJACENT_BIN_ADJUST(x)						REDUCE_BY_3_6_dB(x)
#define RX_NCB_OUT_OF_BAND_BIN_LEVEL_ADJUST(x)				REDUCE_BY_8_5_dB(x)
#define RX_NCB_OUT_OF_BAND_BIN_LEVEL_ADJUST_ADC_DAC(x)		REDUCE_BY_3_6_dB(x)
#define RX_NCB_IN_BAND_BIN_LEVEL_ADJUST_ADC_DAC(x)			(x) // No change needed for now. placeholder remains since measurements for reduction of 0.3dB hav been shown
#define RX_CB_DESIRED_POWER_LEVEL_ADJUST(x)					INCREASE_BY_2_0_5_dB(x)
#define RX_CB_DESIRED_POWER_LEVEL_ADJUST_SINC_ATTEN(x)		REDUCE_BY_1_25_dB(x) // D2A A2D frequency response
#define TX_DESIRED_POWER_LEVEL_ADJUST(x)					REDUCE_BY_1_dB(x)
#define RX_CB_UPPER_BOUND_STOP_BAND_ADJUST(x)				REDUCE_BY_15_dB(x)
#define RX_CB_UPPER_BOUND_STOP_BAND_ADJUST_SINC_ATTEN(x)	REDUCE_BY_2_05_dB(x)
#define RX_NCB_UPPER_BOUND_STOP_BAND_ADJUST(x)				REDUCE_BY_35_dB(x)
#define RX_NCB_UPPER_BOUND_STOP_BAND_ADJUST_SINC_ATTEN(x)	REDUCE_BY_15_dB(x) // D2A A2D frequency response
#define TX_CB_UPPER_BOUND_STOP_BAND_ADJUST(x)				REDUCE_BY_40_dB(x)
#define TX_CB_UPPER_BOUND_STOP_BAND_ADJUST_SINC_ATTEN(x)	REDUCE_BY_26_dB(x) // D2A A2D frequency response
#define TX_NCB_UPPER_BOUND_STOP_BAND_ADJUST(x)				REDUCE_BY_10_dB(x)
#define TX_NCB_UPPER_BOUND_STOP_BAND_ADJUST_SINC_ATTEN(x)	REDUCE_BY_24_dB(x)
#define RX_CB_UPPER_BOUND_ERROR_MARGIN_ADJUST(x)			INCREASE_BY_1_dB(x)
#define RX_CB_LOWER_BOUND_ERROR_MARGIN_ADJUST(x)			REDUCE_BY_1_dB(x)
#define RX_NCB_UPPER_BOUND_ERROR_MARGIN_ADJUST(x)			INCREASE_BY_0_6_dB(x)
#define RX_NCB_LOWER_BOUND_ERROR_MARGIN_ADJUST(x)			REDUCE_BY_0_6_dB(x)
#define TX_CB_UPPER_BOUND_ERROR_MARGIN_ADJUST(x)			INCREASE_BY_0_6_dB(x)
#define TX_CB_LOWER_BOUND_ERROR_MARGIN_ADJUST(x)			REDUCE_BY_0_6_dB(x)
#define TX_NCB_UPPER_BOUND_ERROR_MARGIN_ADJUST(x)			INCREASE_BY_0_6_dB(x)
#define TX_NCB_LOWER_BOUND_ERROR_MARGIN_ADJUST(x)			REDUCE_BY_0_6_dB(x)
#define UPPER_BOUND_STOP_BAND_MARGIN_ADJUST(x)				INCREASE_BY_5_dB(x)
#define SHIFTER_ENERGY_LEVEL_ADJUST(x)						INCREASE_BY_6_dB(x)

// LPF word energy direction
#define RX_NCB_HIGHER_ENERGY_UNIT	(1)
#define RX_CB_HIGHER_ENERGY_UNIT	(-1)
#define TX_HIGHER_ENERGY_UNIT		(1)

// Fixed point bits to shift
#define RX_FIXED_POINT_BITS_SHIFT	(0)
#define TX_FIXED_POINT_BITS_SHIFT	(20)
