#ifndef __MsSsiAdcClbrHndlr_h__
#define __MsSsiAdcClbrHndlr_h__

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "CalibrationDefs.h"

/******************************************************************************/
/***						Public Function Declarations					***/
/******************************************************************************/
//************************************
// Method:    MsSsiAdc_Calibrate
// Purpose:   Run calibration procedure segments not more than the allocated time
// Parameter: IN ClbrType_e inCalibType - OFFLINE or ONLINE
// Returns:   RetVal_e - success(S_SUCCESS), fail(S_FAIL)
//************************************
 RetVal_e  MsSsiAdc_Calibrate(IN ClbrType_e inCalibType);
//************************************
// Method:    MsSsiAdc_SetStatus
// Purpose:   Set calibration status of given antenna
// Parameter: 
//			uint32 inAntenna
//			CalStatus_e inStatus
// Returns:   void
//************************************
 void MsSsiAdc_SetStatus(IN uint32 inAntenna, IN CalStatus_e inStatus);
//************************************
// Method:    MsSsiAdc_GetStatus
// Purpose:   Get calibration status of given antenna
// Parameter: 
//			uint32 inAntenna
// Returns:   CalStatus_e Fail or Pass
//************************************
 CalStatus_e MsSsiAdc_GetStatus( IN uint32 inAntenna );
//************************************
// Method:    MsSsiAdc_GetLastRunTime
// Purpose:   Get last MS SSI ADC calibration run time duration
// Parameter: None
// Returns:   Run time duration
//************************************
 uint32 MsSsiAdc_GetLastRunTime(void);
//************************************
// Method:      MsSsiAdc_LoadResults
// Purpose:     Loads MS SSI ADC calibration data from a buffer
// Parameter: None
// Returns:     None
//************************************
void MsSsiAdc_LoadResults(void);
 //************************************
 // Method:    MsSsiAdc_GetElement
 // Purpose:   Statistics
 // Parameter: None
 // Returns:   uint32*- Pointer to m_msSsiAdc_elements	
 //************************************
uint32* MsSsiAdc_GetElement(void);

#endif // __MsSsiAdcClbrHndlr_h__
