
//#include <enet_sw.h>
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <System_Configuration.h>

#include <lmi.h>
#include <lm.h>
#include "MT_Math.h"
#include <PhyDriver_API.h>
#include <PhyCalDriver_API.h>
#include <CalibrationHandler.h>
#include "CalibrationHandlerUtils.h"
#include "Shram_ClbrDataBuffer.h"
#include "CalibrationHandlerDB.h"
#include "MsSsiAdcClbrHndlr.h"
#include "MsSsiAdcDefinitions.h"
#include "mt_sysrst.h"
#include "RficDriver_API.h"
#include "Afe_API.h"
#include "System_Information.h"

#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 6


/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/

/* Maximum iterations during gain/offset binary search */
#define SSI_ADC_MAX_SEARCH_STEPS ((SSI_ADC_TRIM_BIT_WIDTH)+1)	// gain/offset trims are 5 bit

/* Maximum verification distance allowed between gain/offset dataOut and threshold */
#define SSI_ADC_DATA_OUT_MAX_DIST (10) //TBD - Orit

/******************************************************************************/
/***						Type Definitions								***/
/******************************************************************************/

typedef struct 
{
	CalStatus_e status[MAX_NUM_OF_ANTENNAS];		
	CalStatus_e statusGain[MAX_NUM_OF_ANTENNAS];	
	CalStatus_e statusOffset[MAX_NUM_OF_ANTENNAS];	
	uint32		lastRunTime;
	uint8		gain[MAX_NUM_OF_ANTENNAS];
	uint8		offset[MAX_NUM_OF_ANTENNAS];
	uint8		dataOutGain[MAX_NUM_OF_ANTENNAS];	//Output data value for calibrated gain
	uint8		dataOutOffset[MAX_NUM_OF_ANTENNAS];	//Output data value for calibrated offset
} MsSsiAdc_results_t;

typedef struct 
{
	uint8		avrgNumSamples;
	uint8		dataOutMaxDist;
} MsSsiAdc_params_t;

typedef struct 
{
	MsSsiAdc_results_t	results;
	MsSsiAdc_params_t	params;
} MsSsiAdc_elements_t;

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/

/******************************************************************************/
/***					Static Member Declarations							***/
/******************************************************************************/

static MsSsiAdc_elements_t	m_msSsiAdc_elements = 
{
	//results
	{
		{CAL_STATUS_INIT, CAL_STATUS_INIT, CAL_STATUS_INIT},	//status[MAX_NUM_OF_ANTENNAS]
		{CAL_STATUS_INIT, CAL_STATUS_INIT, CAL_STATUS_INIT},	//statusGain[MAX_NUM_OF_ANTENNAS]
		{CAL_STATUS_INIT, CAL_STATUS_INIT, CAL_STATUS_INIT},	//statusOffset[MAX_NUM_OF_ANTENNAS]
		0,								//lastRunTime
		{SSI_ADC_TRIM_MIN, SSI_ADC_TRIM_MIN, SSI_ADC_TRIM_MIN},	//gain[MAX_NUM_OF_ANTENNAS]
		{SSI_ADC_TRIM_MIN, SSI_ADC_TRIM_MIN, SSI_ADC_TRIM_MIN}, //offset[MAX_NUM_OF_ANTENNAS]
		{0, 0, 0},						//dataOutGain[MAX_NUM_OF_ANTENNAS]
		{0, 0, 0}						//dataOutOffset[MAX_NUM_OF_ANTENNAS]
	},
	//params
	{
		SSI_ADC_AVERAGE_NUM_SAMPLES,	//avrgNumSamples
		SSI_ADC_DATA_OUT_MAX_DIST		//dataOutMaxDist
	}
}; 

/******************************************************************************/
/***					Private Function Declarations						***/
/******************************************************************************/   
static RetVal_e run(MsSsiAdc_elements_t* outElements_p);

////////////////////////
// Methods
////////////////////////
//************************************
// Method:    run
// Purpose:   Run calibration procedure for all RX enabled antennas
// Parameter: MsSsiAdc_elements_t* outElements_p
// Returns:   RetVal_e - success(RET_VAL_SUCCESS), fail(RET_VAL_FAIL)
//************************************
static RetVal_e run(MsSsiAdc_elements_t* outElements_p)
{
	RetVal_e ret = RET_VAL_SUCCESS;
	return(ret);
}

/********************************************************************************

Method:	void calibrateAntennasGainOffset(AfeMsSsiAdcMode_e inMode, uint8 inRxAntMask, MsSsiAdc_elements_t* outElements_p)

Description:
------------
    
    Run gain or offset calibration for all antennas simultaneously - 
	find the trim that gives closest value to SSI_ADC_DATA_OUT_THRESHOLD.

	Binary search can be used based on the assumption that the data out vs. trim 
	function is a monotonic function (ascending for gain, descending for offset).
  
Input:
-----
	inMode - GAIN or OFFSET
	inRxAntMask
			
Output:
-------
	outElements_p - calibrated gain/offset trims
	
Return:	void
-------
*************************************************************************************/

//************************************
// Method:    MsSsiAdc_Calibrate
// Purpose:   Run calibration procedure segments not more than the allocated time
// Parameter: IN ClbrType_e inCalibType - OFFLINE or ONLINE
// Returns:   RetVal_e - success(RET_VAL_SUCCESS), fail(RET_VAL_FAIL)
//************************************
RetVal_e MsSsiAdc_Calibrate(IN ClbrType_e inCalibType)
{
	return run(&m_msSsiAdc_elements);
}
/********************************************************************************

Method:	void MsSsiAdc_SetStatus(IN uint32 inAntenna, IN CalStatus_e inStatus)

Description:
------------
    
    Set calibration status of given antenna
  
Input:
-----
			
Output:
-------

********************************************************************************/
 void MsSsiAdc_SetStatus(IN uint32 inAntenna, IN CalStatus_e inStatus)
{
	m_msSsiAdc_elements.results.status[inAntenna] = inStatus;
}

/********************************************************************************

Method:	CalStatus_e MsSsiAdc_GetStatus( IN uint32 inAntenna )

Description:
------------
    
    Get calibration status of given antenna
  
Input:
-----
			
Output:
-------
	status - Fail or Pass
	

********************************************************************************/
 CalStatus_e MsSsiAdc_GetStatus( IN uint32 inAntenna )
{
	return m_msSsiAdc_elements.results.status[inAntenna];
}

/********************************************************************************

Method:	uint32 MsSsiAdc_GetLastRunTime(void)

Description:
------------
    
    Get last MS SSI ADC calibration run time duration
  
Input:
-----
    
			
Output:
-------
	return - run time duration	

********************************************************************************/
 uint32 MsSsiAdc_GetLastRunTime(void)
{
	return m_msSsiAdc_elements.results.lastRunTime;
}

/********************************************************************************

Method:	MsSsiAdc_LoadResults

Description:
------------
    
    Loads MS SSI ADC calibration data from a buffer
  
Input:
-----
    param None
			
Output:
-------
	return None

********************************************************************************/
void MsSsiAdc_LoadResults(void)
{
    Antenna_e antNum;
   uint8 rxAntMask, numOfAnts;

    for(antNum = ANTENNA_0; antNum < TOTAL_ANTENNAS; antNum++)
    {
        /* Update internal variables with loaded values */
        m_msSsiAdc_elements.results.gain[antNum]   = ShramClbrDataBufferStoreChanData.msSsiAdcData.gain[antNum];
        m_msSsiAdc_elements.results.offset[antNum] = ShramClbrDataBufferStoreChanData.msSsiAdcData.offset[antNum];

        MsSsiAdc_SetStatus(antNum, ShramClbrDataBufferStoreChanData.msSsiAdcData.calStatus[antNum]);
    }

    /* Set stored variables to HW */
    // Get the enabled RX antennas
    
	HDK_GetMaxActiveAntennasNumAndMask(&numOfAnts, &rxAntMask);
   
    AFE_SetRssiAdcGainAndOffset((AntennaBitmaps_e)rxAntMask, m_msSsiAdc_elements.results.gain, m_msSsiAdc_elements.results.offset, AFE_MS_SSI_ADC_MODE_FUNCTIONAL);
}

/********************************************************************************

Method:	MsSsiAdc_StoreResults

Description:
------------
    
    Stores MS SSI ADC calibration data to a buffer
  
Input:
-----
    param RetVal_e calRetVal - Calibration return value
			
Output:
-------
	return None

********************************************************************************/

 /********************************************************************************

Method:	uint32* MsSsiAdc_GetElement(void)

Description:
------------
    
    Get m_msSsiAdc_elements address for BroadBand statistic  
  
Input:
-----
    
			
Output:
-------
	return - pointer to m_msSsiAdc_elements 

********************************************************************************/
 uint32* MsSsiAdc_GetElement(void)
 {
	 return (uint32*)&m_msSsiAdc_elements;
 }



 
