#ifndef __RssiDcOffsetClbrHndlr_h__
#define __RssiDcOffsetClbrHndlr_h__

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "CalibrationDefs.h"

/******************************************************************************/
/***						Public Function Declarations					***/
/******************************************************************************/
//************************************
// Method:    RssiDcOffset_Calibrate
// Purpose:   Run calibration procedure segments not more than the allocated time
// Parameter: IN ClbrType_e inCalibType - OFFLINE or ONLINE
// Returns:   RetVal_e
//************************************
 RetVal_e  RssiDcOffset_Calibrate(IN ClbrType_e inCalibType);
//************************************
// Method:    RssiDcOffset_SetStatus
// Purpose:   Set calibration status of given antenna
// Parameter: 
//			uint32 inAntenna
//			CalStatus_E inStatus
// Returns:   void
//************************************
 void RssiDcOffset_SetStatus(IN uint32 inAntenna, IN CalStatus_e inStatus);
//************************************
// Method:    RssiDcOffset_GetStatus
// Purpose:   Get calibration status of given antenna
// Parameter: 
//			uint32 inAntenna
// Returns:   CalStatus_e - E_Fail or E_Pass
//************************************
 CalStatus_e RssiDcOffset_GetStatus( IN uint32 inAntenna );
//************************************
// Method:    RssiDcOffset_GetLastRunTime
// Purpose:   Get last RSSI DC offset calibration run time duration
// Parameter: None
// Returns:   Run time duration
//************************************
 uint32 RssiDcOffset_GetLastRunTime(void);
//************************************
// Method:    RssiDcOffset_LoadResults
// Purpose:   Loads RSSI DC offset calibration data from a buffer
// Parameter: None
// Returns:     None
//************************************
 void RssiDcOffset_LoadResults( void );
 //************************************
 // Method:    rssiDcOffse_GetElement(void)
 // Purpose:   Statistics (BroadBand)
 // Parameter: None
 // Returns:   uint32*- pointer to m_rssiDcOffset_elements
 //************************************
uint32* RssiDcOffse_GetElement(void);

#endif // __RssiDcOffsetClbrHndlr_h__
