#ifndef __RssiPathClbrHndlr_h__
#define __RssiPathClbrHndlr_h__

#include "System_GlobalDefinitions.h"
#include "CalibrationDefs.h"
#include <PhyCalDriver_API.h>
#include "OSAL_Kmsg.h"

//************************************
// Method:    RssiPath_Calibrate
// Purpose:   Calibrate RFIC RSSI path
// 				1. First stage
// 				*Do RSSI measurement for every section (SECTION_SIZE in dB).
// 				*Calculate derivative for each section.
// 				*Find and Mark sections which are not linear.
// 
// 				2. Second stage
// 				*Sections which were found not linear (based on thresholds LOW_PATITION_THRESHOLD 
// 				and HIGH_PATITION_THRESHOLD) are divided to smaller sections.
// 				*More measurements are done to the new partitioned sections
// 				*Calculate derivative again for all sections (including the new ones).
// 
// 				3. Third stage
// 				*Find sections at the edges of the rssi graph (using EDGE_THRESHOLD) and
// 				make these sections flat (zero their derivative).
// 				*Run over the table cells which are just before second uncalibrated zone (make them also flat)
// 				*Run over the table cells which are just after first uncalibrated zone (make them also flat)
// 
// 				4. Generate RSSI table and verify results.
// Parameter: 
// Returns:   RetVal_e - 
//			  RET_VAL_SUCCESS - All antennas calibration succeeded 
//			  RET_VAL_FAIL - At least one antenna calibration failed
//************************************

#ifdef ENET_INC_ARCH_WAVE600
typedef struct RssiPathConfig
{
	uint32 accumNos;
	uint16 analogCalTimeout;
	uint16 accumTimeout;
	uint16 digSuccessThreshold;
	uint8 integratorBw;
	uint8 firstLnaIndex;	
	uint8 lastLnaIndexAnalog;	
	uint8 lastLnaIndexDigital;
	uint8 maxTries;
}RssiPathConfig_t;

typedef struct RssiPathParams
{
	RssiPathConfig_t RssiPathconfiguration;
	bool firstOnlineFragment;
	int8 dynamicRange[MAX_NUM_OF_ANTENNAS];
	int8 measurementVariation[MAX_NUM_OF_ANTENNAS];
	CalStatus_e status[MAX_NUM_OF_ANTENNAS];	
	uint32 lastRunTime;
}RssiPathParams_t;

extern RssiPathParams_t rssiPathParams;
#endif

RetVal_e RssiPath_Calibrate(IN ClbrType_e inCalibType); 

void RssiPath_SetStatus(IN uint32 inAntNum, IN CalStatus_e inStatus);
CalStatus_e RssiPath_GetStatus( IN uint32 inAntNum );

int8 RssiPath_GetDynamicRange(IN uint32 inAntNum);
int8 RssiPath_GetMeasurementVariation(IN uint32 inAntNum);
uint32 RssiPath_GetLastRunTime(void);
void RssiPath_GetTableFromDriver(K_MSG *kmsg);
//void RssiPath_measureRssi(uint16 numberOfSamples,uint16 rssiResult[MAX_NUM_OF_ANTENNAS]);
void setS2dGainAndOffset(int32 ioffs, int32 s2dGainInput, uint32 antenna, uint8 regionIndex);
void RssiPath_setLnaMidGain(uint8 lnaMidGainWordInput[MAX_NUM_OF_ANTENNAS]);
void RssiPath_extractValuesFromCalBin(void);
void GetRssiPathCisData(uint16 *size, uint8 **params);
void GetRssiPathCisDataLnamidgain(uint8 ant, uint8 *midword, int16 *idx0, int16 *idx1, int16 *idx2, int16 *idx3, int16 *idx4, int16 *idx5, int16 *idx6, int16 *idx7);
void RssiPath_getValuesFromCalBin(void);






//GALIA - empty load/store functions
void RssiPath_LoadResults(void);

#ifdef SDL_IGNORE_UNUSED_FUNCTION
static void RssiPath_StoreResults(void);
#endif
uint32* RssiPath_GetElement(void);

#endif // __RssiPathClbrHndlr_h__

