#ifndef __RSSI_PATH_DEFINITIONS_H__
#define __RSSI_PATH_DEFINITIONS_H__

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/

#define RSSI_PATH_TONE_POWER_OFFSET                 (0)    // used in toneGenSetOutputPower()

#define RSSI_PATH_TONE_CAL_GAIN_LIMIT               (14)   //use range [-58,14] maximum power (14)

#define RUN_OVER_NUM_CELLS_HIGH_TABLE_ZONE          (1)     //the table cells which are just before second uncalibrated zone will be zeroed or
                                                            //extrapolated if RSSI_PATH_USE_EXTRAPOLATION is TRUE
#define RUN_OVER_NUM_CELLS_LOW_TABLE_ZONE           (0)     //the table cells which are just after first uncalibrated zone will be zeroed (63)

#define RSSI_PATH_USE_EXTRAPOLATION                 (TRUE)  //TRUE if we want to use extrapolation for the PHY table (used in AR10/W400)
#define RSSI_PATH_DO_SECTION_PARTITION              (TRUE)  //TRUE if we want to use section partition when sections are not linear

#define RSSI_PATH_INIT_ATT                          (0)     // -0dB

#define RSSI_PATH_TABLE_OFFSET                      (0)     //no table offset
#define RSSI_PATH_NCB_TABLE_OFFSET                  (0)     //due to different sampling rate (10MHz) - this offset needs to be checked again after adding 

#define RSSI_PATH_NUM_INDEX_GO_BACK_IN_LOW_ZONE     (1)      //number of indexes to go back when extrapolating/flattening low zone (can be 0 or 1 only)
#define RSSI_PATH_NUM_INDEX_GO_BACK_IN_HIGH_ZONE    (0)      //number of indexes to go back when extrapolating/flattening high zone (can be 0 or 1 only)
#define RSSI_PATH_NUM_INCLINES_GO_BACK_IN_HIGH_ZONE (RSSI_PATH_NUM_INDEX_GO_BACK_IN_HIGH_ZONE+1) //number of inclines to go back when extrapolating/flattening high zone (can be 0 or 1 only)

#define NUMBER_OF_LNA_CROSSING_POINT 	7
#define NUMBER_OF_RX_FLATNESS_POINT 	5
#define NUMBER_OF_LNA_GAINS_POINT 		6


/******************************************************************************/
/***						Macros											***/
/******************************************************************************/

#endif // __RSSI_PATH_DEFINITIONS_H__
