#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <System_Configuration.h>

#include <lmi.h>
#include <lm.h>
#include "MT_Math.h"
#include "RegAccess_Api.h"
#include <PhyDriver_API.h>
#include <PhyCalDriver_API.h>
#include <CalibrationHandler.h>
#include "CalibrationHandlerUtils.h"
#include "Shram_ClbrDataBuffer.h"
#include "CalibrationHandlerDB.h"
#include "RssiDcOffsetClbrHndlr.h"
#include "RssiDcOffsetDefinitions.h"
#include "mt_sysrst.h"
#include "RficDriver_API.h"
#include "Afe_API.h"

#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 10

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/

/* Maximum iterations during offsets lion in the desert search */
#define RSSI_DC_MAX_SEARCH_STEPS ((RSSI_DC_DAC_BIT_WIDTH)+1)	// offsets are 4 bit

/******************************************************************************/
/***						Type Definitions								***/
/******************************************************************************/

/* Output Results */
typedef struct 
{
	// offset calibration results per antenna - 10 value DC offset array: I1-5, Q1-5
	uint8			offsets[MAX_NUM_OF_ANTENNAS][RFIC_RSSI_STG_TOTAL]; 
	// corresponding data out per antenna - 10 value DC offset data out array: I1-5, Q1-5
	uint8			dataOutOffsets[MAX_NUM_OF_ANTENNAS][RFIC_RSSI_STG_TOTAL]; 
	CalStatus_e		status[MAX_NUM_OF_ANTENNAS];	// currently there is no FAIL status
	uint32			lastRunTime;
} RssiDcOffset_results_t;

/* Input Parameters */
typedef struct 
{
	uint8			avrgNumSamples;
} RssiDcOffset_params_t;

typedef struct 
{
	RssiDcOffset_results_t	results;
	RssiDcOffset_params_t	params;
} RssiDcOffset_elements_t;

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/


void RssiDcOffset_SetStatus(IN uint32 inAntenna, IN CalStatus_e inStatus)
{
}

/********************************************************************************

Method:	CalStatus_e RssiDcOffset_GetStatus( IN uint32 antenna )

Description:
------------
    
    Get calibration status of given antenna
  
Input:
-----
			
Output:
-------
	status - Fail_E or Pass_E
	

********************************************************************************/
 CalStatus_e RssiDcOffset_GetStatus( IN uint32 inAntenna )
{
	return CAL_STATUS_INIT;
}

/********************************************************************************

Method:	uint32 RssiDcOffset_GetLastRunTime(void)

Description:
------------
    
    Get last RSSI DC offset calibration run time duration
  
Input:
-----
    
			
Output:
-------
	return - run time duration	

********************************************************************************/
 uint32 RssiDcOffset_GetLastRunTime(void)
{
	return 1;
}

/********************************************************************************

Method:	RssiDcOffset_LoadResults

Description:
------------
    
    Loads RssiDcOffset calibration data from a buffer
  
Input:
-----
    param in_puBuffer Buffer from which to load calibration information	
			
Output:
-------
	return Amount of bytes read from buffer	

********************************************************************************/
void RssiDcOffset_LoadResults(void)
{
}
 uint32* RssiDcOffse_GetElement(void)
 {
	 return (uint32*)0x0;
 }
  RetVal_e RssiDcOffset_Calibrate(IN ClbrType_e inCalibType)
 {
	 return RET_VAL_SUCCESS;
 }

 
 


 
