/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include <stdint.h>

#include "System_GlobalDefinitions.h"
#include "RssiPathClbrHndlr.h"
#include "RssiPathDefinitions.h"
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <System_Configuration.h>
#include <PhyDriver_API.h>
#include "stringLibApi.h"
#include "Afe_API.h"
#include "PhyTestBus_API.h"

#include <lmi.h>
#include <mt_cnfg.h>	
#include "RegAccess_Api.h"
#include <MT_Math.h>
#include "CalibrationHandler.h"
#include "CalibrationHandlerUtils.h"
#include "Shram_ClbrDataBuffer.h"
#include "PhyCalDriver_API.h"
#include "RficDriver_API.h"
#include "mt_sysrst.h"
#include "ErrorHandler_Api.h"
#include "lib_rf_4x4_api.h"
#include "interface_rf_4x4.h"
#include "PhyRegsIncluder.h"
#include "PhyRxTdRegs.h"
#include "PhyRxAgcPage1Regs.h"
#include "fast_mem_psd2mips.h"
#include "PSD.h"


#define SIZE_OF_RSSI_TABLE 256
#define NUM_OF_VALUES_RX_FLATNESS_ARRAY (10)




#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 14


/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
/*

*/
//defines array size	


/******************************************************************************/
/***						Type Definitions								***/
/******************************************************************************/
#define RX_FLATNESS_FREQ_STEP 		10//IN mHZ
#define RX_FLATNESS_GAIN_STEP 		1 //0.5 dB shifted left by 1
#define RX_FLATNESS_FREQ_OFFSET 	2400
#define RX_FLATNESS_GAIN_OFFSET 	8
#define RSSI_TABLE_REGION_SHIFT 	7
#define RSSI_TABLE_REGION_MASK 		0x0000007f
#define RSSI_OFFSET1_ANTENNA_OFFSET 0X100
#define RSSI_S2D_MID_GAIN_ADDRESS 	0xaf32011c
#define LNA_CROSSING_FREQ_STEP 		10//IN mHZ
#define NUM_OF_LNA_GAIN_INDEX   	5
#define ALPHA_OFFST_IN_Q8 			384
#define BETA_OFFST_IN_Q2 			120

uint32 numOfRxFlatness = 0;



typedef struct rssiPathCalibrationHeaderParams
{
	uint8 totalSizeOfRssiSection;
	uint8 antMask;
	uint8 lnaSubBandCrossingPoint[MAX_NUMBER_OF_LNA_CROSSING_POINT];
} rssiPathCalibrationHeaderParams_t;






extern Calibration_params_otf_t Calibration_params_otf;




/******************************************************************************/
/***					Static Function Declarations						***/
/******************************************************************************/ 
static RetVal_e run(RssiPath_elements_t* outElements_p);

static  void extrapolateFromRxFlatnessTable(uint32 freq);
static  void extrapolateFromRxFlatnessRssiTable(uint32 freq);

static  void generateRxFlatnessTable(void);
static  void generateRxFlatnessRssiTable(void);

static  void generateRssiTable(void);
static uint32 measureRssi(uint32 method,uint8 inAntNum ,uint16 inNumSamplesToAverage);
static void triggerMeasureRssi(uint32 method,uint8 inAntNum ,uint16 inNumSamplesToAverage);

static void RssiPath_extractValuesFromCalBin(void);
static void resetS2dGainAndOffset( uint32 antenna);


uint8 calBinFileArrivedFromDriver =0;
//Information from calibration file

//array of frequencies given by an index to nultiply from the previoues frequency for the rx path
uint32 fcalFile[NUM_OF_VALUES_RX_FLATNESS_ARRAY] = {1,2,3,4,5};	

//array of frequencies given by an index to nultiply from the previoues frequency for the rssi path
uint32 fcalFileRssi[NUM_OF_VALUES_RX_FLATNESS_ARRAY] = {1,2,3,4,5};

// an array of gains which corrsepands to the array of frequencies for the rx path
int32 deltaGFcalFile[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY] = {{1,2,3,4,5},
																		 {6,7,8,9,10},
																		 {11,12,13,14,15},
																		 {1,3,5,7,9},
																		} ;
// an array of gains which corrsepands to the array of frequencies for the rssi path
int32 deltaGFcalFileRssi[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY] = {{1,2,3,4,5},
																		 {6,7,8,9,10},
																		 {11,12,13,14,15},
																		 {1,3,5,7,9},
																		} ;
// alpha from driver
uint32 alpha[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS] = {{230,235,240},
															 {240,245,250},
															 {250,240,230},
															 {235,235,235},
															} ;
// beta from driver
uint32 beta[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS] = {{140,150,160},
															 {110,120,130},
															 {100,120,150},
															 {190,180,210},
															 				} ;// q2 +120
// s2Gain from driver (S2D_Gain_db + 10)/2
int32 s2dGain[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS] = {{12*2-10,9*2-10,3*2-10},
															 {12*2-10,9*2-10,2*2-10},
															 {12*2-10,9*2-10,2*2-10},
															 {12*2-10,9*2-10,2*2-10},
																		};
//s2d offset from driver														 				
int32 s2dOffset[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS] = {{13,14,22},
															 	{13,14,24},
															 	{12,13,23},
															 	{13,14,24},
															 				} ;
uint32 phyAdressSpaceOfAgcGainAndOffset1[NUMBER_OF_RSSI_REGIONS] = {REG_PHY_RX_AGC_PAGE_1_PHY_RXAGC_IF1F,REG_PHY_RX_AGC_PAGE_1_PHY_RXAGC_IF20,REG_PHY_RX_AGC_PAGE_1_PHY_RXAGC_IF21};
uint32 phyAdressSpaceOfAgcGainAndOffset2[NUMBER_OF_RSSI_REGIONS] = {REG_PHY_RX_AGC_PAGE_1_PHY_RXAGC_IF2C,REG_PHY_RX_AGC_PAGE_1_PHY_RXAGC_IF2D,REG_PHY_RX_AGC_PAGE_1_PHY_RXAGC_IF2E};
													

int32 pmin[NUMBER_OF_RSSI_REGIONS] = {-27*2,-18*2,-23*2};//Q1	
int32 pmax[NUMBER_OF_RSSI_REGIONS] = {-12*2,0,-8*2};//Q1	
uint8 lnaMidGainWord[MAX_NUM_OF_ANTENNAS];


uint32 margin = 0;


// self used arrays
// extrapolation array of fcal rx path
uint32 fcalResult[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY];
// extrapolation array of fcal rssi path
uint32 fcalResultRssi[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY];
//extrapolation of deltaGFcalFile
int32 deltaB[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY];//in 0.25 db
//extrapolation of deltaGFcalFile rssi path
int32 deltaBRssi[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY];//in 0.25 db
// calculation of b from the data 
int32 deltaBFreq[MAX_NUM_OF_ANTENNAS];
// calculation of b from the data 
int32 deltaBFreqRssi[MAX_NUM_OF_ANTENNAS];
//measure gamma according to ds2dOffset and gain per region per antenna
uint32 gamma[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS] =		{{44,75,57},
															 	{53,80,71},
															 	{53,78,66},
															 	{115,113,81},
															 				} ;;


static RetVal_e run(RssiPath_elements_t* outElements_p)
{
	uint32 Start_Cal_Time;
	RetVal_e ret = RET_VAL_SUCCESS;
	uint32 ant;
	RssiRegion_e region;
	uint32 freq;
	SetChannelParams_t *channelParams;
	uint32 numberOfsamples = 16000;
    
	if(calBinFileArrivedFromDriver != 1)
	{
		return RET_VAL_FAIL;
	}
    
	Start_Cal_Time = TIME_STAMP(START_TIME,0);
	/*get calibration frequency*/
	channelParams = HDK_getSetChannelParams();
	freq = RficDriver_CalcLoFrequency(channelParams);

	AFE_RestoreFromLoopBack();
	AFE_SetLoopBack((Antenna_e)0, (Antenna_e)1, AFE_MODE_RX, 0);
	SetRxGains(ANTENNA_BITMAP_ALL_ANTENNAS_GEN5 ,HDK_LNA_INDEX_MIN_INDEX,0,0,0);
	SetRffeMode((uint8)0xf);
	RssiPath_extractValuesFromCalBin();
	
	/*Generate calibration tables*/
	generateRxFlatnessTable();
	extrapolateFromRxFlatnessTable(freq);
	generateRxFlatnessRssiTable();
	extrapolateFromRxFlatnessRssiTable(freq);
	
	/*start measuring of rssi*/
	rfic_rxon(0xf);
	
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG80) |= 0x10;//enable Gclock to RxIqEstimator
	MT_DELAY(1000);


	for(region = RSSI_REGION_LOW; region < NUMBER_OF_RSSI_REGIONS; region++)
	{
		for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			setS2dGainAndOffset(s2dOffset[ant][region], (s2dGain[ant][region]*2 -10), ant, 0);
			triggerMeasureRssi(0,ant,numberOfsamples);
		}
		for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			gamma[ant][region] = measureRssi(0,ant,numberOfsamples>>2) ;/*Gamma in q2*/
			REGISTER(RSSI_GAMMA_REG0_ANT0 + region*16 + ant*4) = (gamma[ant][region] + 2) >> 2;
		}
		
	}
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG80) &= 0xffffffef;//disable Gclock to RxIqEstimator
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		rfic_config_rssi_low((1 << ant),(s2dGain[ant][RSSI_REGION_HIGH]*2) - 10,s2dOffset[ant][RSSI_REGION_HIGH]);
		rfic_config_rssi_high((1 << ant),(s2dGain[ant][RSSI_REGION_LOW]*2) - 10 ,s2dOffset[ant][RSSI_REGION_LOW]);
		REGISTER(S2D_RSSI_manual_RANGE_ant0 + ant*4) = (((s2dGain[ant][RSSI_REGION_MID])  << 5)| s2dOffset[ant][RSSI_REGION_MID]) << 6;
		REGISTER(S2D_RSSI_manual_RANGE_low_ant0 + ant*4) = (((s2dGain[ant][RSSI_REGION_LOW])  << 5)| s2dOffset[ant][RSSI_REGION_LOW]) << 6;
		REGISTER(S2D_RSSI_manual_RANGE_high_ant0 + ant*4) = (((s2dGain[ant][RSSI_REGION_HIGH])  << 5)| s2dOffset[ant][RSSI_REGION_HIGH]) << 6;
		REGISTER(S2D_RSSI0_ant0 + ant*4) = 0x200 |(s2dOffset[ant][RSSI_REGION_LOW] << 4)| (s2dGain[ant][RSSI_REGION_LOW]);
	}

	generateRssiTable();
	rfic_rxoff(0xf);
    
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		resetS2dGainAndOffset(ant);
	}
	
#if LM_CALIBRATION_LOGS_ON
	ILOG2_V("RSSI Path: Executing Calibration");
#endif

	outElements_p->results.lastRunTime = TIME_STAMP(END_TIME,Start_Cal_Time);
	AFE_RestoreFromLoopBack();

	return ret;
    
}

RetVal_e RssiPath_Calibrate(IN ClbrType_e inCalibType)
{
	DEBUG_ASSERT(inCalibType == CLBR_TYPE_OFFLINE);

	return run(&Calibration_params_otf.Rssiparams);
}


void RssiPath_SetStatus( IN uint32 inAntNum, IN CalStatus_e inStatus )
{
	Calibration_params_otf.Rssiparams.results.status[inAntNum] = inStatus;
}

CalStatus_e RssiPath_GetStatus( IN uint32 inAntNum )
{
	return (CalStatus_e)Calibration_params_otf.Rssiparams.results.status[inAntNum];
}

int8 RssiPath_GetDynamicRange( IN uint32 inAntNum )
{
	return Calibration_params_otf.Rssiparams.results.dynamicRange[inAntNum];
}

int8 RssiPath_GetMeasurementVariation( IN uint32 inAntNum )
{
	return Calibration_params_otf.Rssiparams.results.measurementVariation[inAntNum];
}

uint32 RssiPath_GetLastRunTime(void)
{
	return Calibration_params_otf.Rssiparams.results.lastRunTime;
}

void RssiPath_LoadResults(void)
{

}
uint32* RssiPath_GetElement(void)
{
	return (uint32*)&Calibration_params_otf.Rssiparams;
}

//fCAL [i] = (fCalFile[i]* freq_step +fCAL [i-1]);
//deltab[i] = -4 + deltaGCalFile[i]*gain_step;
static void generateRxFlatnessTable(void)
{
	Antenna_e ant;
	uint32 i;
//	uint32 freqStep =  RX_FLATNESS_FREQ_STEP;// in Mhz	
//	uint32 gainStep = RX_FLATNESS_GAIN_STEP;// 0.5 dB shifted left by 1

	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {	
		fcalResult[ant][0]  = fcalFile[0];
        
		for(i = 1; i < numOfRxFlatness; i++)
    	{
			fcalResult[ant][i]  = fcalFile[i];
			deltaB[ant][i] = ((deltaGFcalFile[ant][i]) << 1)/*check with michael*/;
		}
		
	}
}

static void generateRxFlatnessRssiTable(void)
{
	Antenna_e ant;
	uint32 i;
	uint32 freqStep =  RX_FLATNESS_FREQ_STEP;// in Mhz	
	uint32 gainStep = RX_FLATNESS_GAIN_STEP;// 0.5 dB shifted left by 1
	
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {	
		fcalResultRssi[ant][0]  = fcalFileRssi[0]*freqStep + RX_FLATNESS_FREQ_OFFSET;
        
		for(i = 1; i < NUM_OF_VALUES_RX_FLATNESS_ARRAY; i++)
    	{
			fcalResultRssi[ant][i]  = fcalFileRssi[i]*freqStep + fcalResultRssi[ant][i-1];
			deltaBRssi[ant][i] = ((deltaGFcalFileRssi[ant][i]*gainStep) >> 1) - RX_FLATNESS_GAIN_OFFSET /*check with michael*/;
		}
		
	}
}
 //deltab_f=(deltab[i]+(deltab[i+1]-deltab[i])/(f_CAL [i+1]-f_CAL [i])*(f_channel-f_CAL [i]))

static void extrapolateFromRxFlatnessTable(uint32 freq)
{
	Antenna_e ant;
	uint32 i;
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {
		if (freq <= fcalResult[ant][0])
		{
			deltaBFreq[ant] = deltaB[ant][0];
			continue;
		}
		if (freq >= fcalResult[ant][numOfRxFlatness - 1])
		{
			deltaBFreq[ant] = deltaB[ant][numOfRxFlatness -1];
			continue;
		}
		for(i = 1; i < numOfRxFlatness; i++)
		{
			if (freq < fcalResult[ant][i])
			{
				deltaBFreq[ant] =deltaB[ant][i - 1] + ((((deltaB[ant][i] - deltaB[ant][i - 1])* (int32)(freq  - fcalResult[ant][i - 1]))
														/(int32)(fcalResult[ant][i] - fcalResult[ant][i - 1])));
				break;
			}
			
		}
	}
}
 
static void extrapolateFromRxFlatnessRssiTable(uint32 freq)
{
	Antenna_e ant;
	uint32 i;
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {
		if (freq <= fcalResultRssi[ant][0])
		{
			deltaBFreqRssi[ant] = deltaBRssi[ant][0];
			continue;
		}
		if (freq >= fcalResultRssi[ant][NUM_OF_VALUES_RX_FLATNESS_ARRAY - 1])
		{
			deltaBFreqRssi[ant] = deltaBRssi[ant][NUM_OF_VALUES_RX_FLATNESS_ARRAY -1];
			continue;
		}
		for(i = 1; i < NUM_OF_VALUES_RX_FLATNESS_ARRAY; i++)
		{
			if (freq < fcalResultRssi[ant][i])
			{
				deltaBFreqRssi[ant] = deltaBRssi[ant][i - 1] + (((deltaBRssi[ant][i] - deltaBRssi[ant][i - 1])* (int32)(freq  - fcalResultRssi[ant][i - 1]))
																	/(int32)(fcalResultRssi[ant][i] - fcalResultRssi[ant][i - 1]));
				break;
			}
			
		}

		
	}
}
 
 
#define LOG_ACCURACY_BIT (5)
#define Q2_MULTI_AFTER_LOG (2)
// craete rssi table

static void generateRssiTable(void)
{
	uint32 offset1,offset2;
	uint32 tableIndex;
	uint32 i = 0;
	uint32 ant= 0;
	RssiRegion_e region=RSSI_REGION_LOW;
	int32 alpha1;
	int32 beta1;
	uint32 gamma1;
	int32 pmin1;
	int32 pmax1;
	int32 margin1;
	volatile uint32* pTable;
	int32 temp1=0;
	int32 tempresult;
	margin1 = margin;//q1
	
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		pTable = (volatile uint32*)(PHY_TD_BASE_ADDR + RSSI_TABLE_ANT0 + RSSI_TABLE_ANT_OFFSET*ant);
		memset((void*)pTable,0x0,RSSI_TABLE_ANT_OFFSET);
		for(region = RSSI_REGION_LOW; region < NUMBER_OF_RSSI_REGIONS; region++)
		{	
			alpha1 = alpha[ant][region] + ALPHA_OFFST_IN_Q8;//Q8
			//beta1 = beta[ant][region] + deltaBFreq[ant] + deltaBFreqRssi[ant] + 80;//Q1
			beta1 = beta[ant][region] + BETA_OFFST_IN_Q2 + deltaBFreq[ant];//Q2
			gamma1 = gamma[ant][region];//Q2
			pmin1 = pmin[region];
			pmax1 = pmax[region];//q1
			offset1 = 0;//gamma1 ;// need to check where to place gamma
			
			if(pmax1 + margin1 > 0)
			{
				offset2 = pmax1 + margin1;
			}
			else
			{
				offset2 = 0; 
			}
            
			REGISTER(phyAdressSpaceOfAgcGainAndOffset2[region] + ant*RSSI_OFFSET1_ANTENNA_OFFSET) = offset2;
			REGISTER(phyAdressSpaceOfAgcGainAndOffset1[region] + ant*RSSI_OFFSET1_ANTENNA_OFFSET) = offset1;//write offset1
			
			for(tableIndex = 0; tableIndex < SIZE_OF_RSSI_TABLE; tableIndex++)
			{
				if(tableIndex <= ((gamma1 + 4)>>3))
				{
					tempresult = pmin1;
				}
				else
				{
					i= 2*tableIndex;
					temp1 = 2*MATH_10Log10Res((i<<2) - gamma1 ,LOG_ACCURACY_BIT) - ((2*Q2_MULTI_AFTER_LOG*THREE_DB_FACTOR)<<LOG_ACCURACY_BIT);/*return q5*/
					tempresult = (((((temp1) - (beta1<<3/*Q5*/)) << 8)/alpha1)+ 8/*round in q4*/) >> (LOG_ACCURACY_BIT -1);//Q1
					if(tempresult < pmin1)
					{
						tempresult = pmin1;
					}
					else
					{
						if(tempresult> pmax1 + margin1)
						{
							tempresult = pmax1 + margin1;
						}
					}
				}
				pTable[tableIndex] |= (-1*(tempresult - (int)offset2 )) << (RSSI_TABLE_REGION_SHIFT*region);
				
				
			}
		}
	}
}

static void triggerMeasureRssi(uint32 method,uint8 inAntNum ,uint16 inNumSamplesToAverage)
 {
 	uint32 antOffset;
	antOffset = inAntNum*0x200;
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG263) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG263)| 0x2;//Accumulator choose rSSI  rx on FOR ALL ANTENNAS
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG06 + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG06 + antOffset)| 0X01000000 | 0X10000000;//ENABLE DC
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0C + antOffset) = inNumSamplesToAverage;//ENTER NUMBER OF SAMPLES
	
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) & 0XFFFFFFEF;//DISABLING BIT 4 START
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) | 0X100;//ENABLING BIT 8 RESET
	MT_DELAY(1);
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) & 0XFFFFFEFF;//DISABLING BIT 8 RESET // wait 30 clocks
	MT_DELAY(10);
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) | 0x10;//enabling bit 4 start
 }

static uint32 measureRssi(uint32 method,uint8 inAntNum ,uint16 inNumSamplesToAverage)
{
	uint32 antOffset;
	uint32 readresult;
	uint32 antMask;


	antMask = Hdk_GetRxAntMask();
	if (((1 << inAntNum) & antMask) != 0)
	{
		antOffset = inAntNum*0x200;
		
		while(!(REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0D + antOffset) & 0x1000))//READ BIT 12 UNTIL IS 0
		{
		}
		readresult = REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG0F + antOffset);
		return readresult/inNumSamplesToAverage;
	}
	else
	{
		return 0;
	}
		
}
// set rfioc path to measure rssi 
 void setS2dGainAndOffset(int32 ioffs, int32 s2dGain, uint32 antenna, uint8 regionIndex)
{
	rfic_set_tssi_gain_offset((0x1 << antenna), s2dGain, ioffs);//offset gain
	RFIC_FCSI_RMW(0x1<<antenna, RF_ANTENNA0_FCSI_RSSI0, (~0x200)&0xffff, 0x200);
}

static void resetS2dGainAndOffset(uint32 antenna)
{
	RFIC_FCSI_RMW(0x1<<antenna, RF_ANTENNA0_FCSI_RSSI0, (~0x200)&0xffff, 0x000);
}

int32 lnaGainAtIndex[MAX_NUM_OF_ANTENNAS][NUM_OF_LNA_GAIN_INDEX + 1];
uint32 numberOfExtraLnaGain=0;

// get information elements from drivver
/*		cal bin file parsing
1.		lnaSubBandCrossing
2.	extract rx flatness freq fcalFile	
3.	extract rssi flatness freq
	Per antenna
4.		lnaMidGainWord  per antenna
5. 		averageLna gain  (workaround for Wave504 A11)
6. 		rx fltaness gain
7. 		s2d offset
8.		s2dgain
9		alpha
10		beta
11. 		rssi flatness gain*/
void RssiPath_GetTableFromDriver(K_MSG *kmsg)
{
	uint32 index;
	uint32 antMaskFromCAlFile;
	uint32 temp = RX_FLATNESS_FREQ_OFFSET;
	uint32 ant;
	uint8 *data;
	uint32 numOfAntennas = 0;
	uint32 numberOfRssiFlatness;
	uint32 regionOffset = 0;
	rssiPathCalibrationHeaderParams_t *headerParam;
	uint16 lnaSubBandCrossing[MAX_NUM_OF_ANTENNAS][MAX_NUMBER_OF_LNA_CROSSING_POINT];
	headerParam = (rssiPathCalibrationHeaderParams_t *)kmsg->abData;
	antMaskFromCAlFile = headerParam->antMask;
    
	for(index = ANTENNA_0; index < MAX_NUM_OF_ANTENNAS; index++)
	{
		if(antMaskFromCAlFile&(0x1<<index))
		{
			numOfAntennas++;
		}
	}
    
	data = &headerParam->lnaSubBandCrossingPoint[0];
	DEBUG_ASSERT(numOfAntennas <= MAX_NUM_OF_ANTENNAS);//Eran add assert of of antenna mask
	
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {	
		for(index = regionOffset; index < MAX_NUMBER_OF_LNA_CROSSING_POINT;)
		{
			regionOffset = 0;
			temp = temp + LNA_CROSSING_FREQ_STEP*(data[0]&0xf);
			lnaSubBandCrossing[ant][index] = temp ; 
			index++;
			if(index < MAX_NUMBER_OF_LNA_CROSSING_POINT)
			{
				temp = temp + LNA_CROSSING_FREQ_STEP*((data[0]>>4)&0xf);
				lnaSubBandCrossing[ant][index] = temp;
				if( index == MAX_NUMBER_OF_LNA_CROSSING_POINT-1)
					temp = RX_FLATNESS_FREQ_OFFSET;
			}
			else
			{
				temp = RX_FLATNESS_FREQ_OFFSET + LNA_CROSSING_FREQ_STEP*((data[0]>>4)&0xf);
				lnaSubBandCrossing[ant+1][0] = temp;//yossi
				regionOffset = 1;
			}
			index++;
			data++;
		}
	}
    
	RficDriver_SetRxBandLUT(&lnaSubBandCrossing[0][0]);
	data++;
	numOfRxFlatness = data[0];
	data++;
	//extract rx flatness freq
	temp= RX_FLATNESS_FREQ_OFFSET;
	ASSERT(numOfRxFlatness <= NUM_OF_VALUES_RX_FLATNESS_ARRAY);
    
	for(index = 0; index < numOfRxFlatness;)
	{
		temp = temp + RX_FLATNESS_FREQ_STEP*(data[0]&0xf); 
		fcalFile[index] = temp; 
		index++;
		if(index < numOfRxFlatness)
		{
			temp = temp + RX_FLATNESS_FREQ_STEP*((data[0] >> 4)&0xf); 
			fcalFile[index] = temp;
		}
		index++;
		data++;
	}
    
	numberOfRssiFlatness = data[0];
	data++;
	//extract rssi flatness freq
	temp= RX_FLATNESS_FREQ_OFFSET;
	DEBUG_ASSERT(numberOfRssiFlatness <= 5);
    
	for(index = 0; index < numberOfRssiFlatness;)
	{
		temp = temp + RX_FLATNESS_FREQ_STEP*(data[0]&0xf);  
		fcalFileRssi[index] = temp; 
		index++;
		if(index < numberOfRssiFlatness)
		{
			temp = temp + RX_FLATNESS_FREQ_STEP*((data[0] >> 4)&0xf);
			fcalFileRssi[index] = temp;
		}
		index++;
		data++;
	}
	
	
	/*perAntenna*/
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if(antMaskFromCAlFile&(0x1<<ant))
		{
			lnaMidGainWord[ant] = data[0];//write rfic register
			data++;
			//extract lna gain index
			for(index = 0; index < NUM_OF_LNA_GAIN_INDEX;)
			{
				lnaGainAtIndex[ant][index] =(int8)data[0];
				index++;
				data++;
			}
			//extract rxGain 
			for(index = 0; index < numOfRxFlatness;)
			{
				deltaGFcalFile[ant][index] = data[0]&0xf; 
				if(deltaGFcalFile[ant][index]&0x8)
				{
					deltaGFcalFile[ant][index] |= 0xfffffff0;//sign extension
				}
				index++;
				if(index < numOfRxFlatness)
				{
					deltaGFcalFile[ant][index] = (data[0]>> 4)&0xf;
					if(deltaGFcalFile[ant][index]&0x8)
					{
						deltaGFcalFile[ant][index] |= 0xfffffff0;//sign extension
					}
				}
				index++;
				data++;
			}
				s2dOffset[ant][RSSI_REGION_LOW] = data[0]&0x1f;
				data++;
				s2dGain[ant][RSSI_REGION_LOW] = data[0]&0xf;
				data++;
				s2dOffset[ant][RSSI_REGION_MID] = data[0]&0x1f;
				data++;
				s2dGain[ant][RSSI_REGION_MID] = data[0]&0xf;
				data++;
				s2dOffset[ant][RSSI_REGION_HIGH] = data[0]&0x1f;
				data++;
				s2dGain[ant][RSSI_REGION_HIGH] = data[0]&0xf;
				data++;

				alpha[ant][RSSI_REGION_LOW] = data[0];
				data++;
				beta[ant][RSSI_REGION_LOW] = data[0];
				data++;
				alpha[ant][RSSI_REGION_MID] = data[0];
				data++;
				beta[ant][RSSI_REGION_MID] = data[0];
				data++;
				alpha[ant][RSSI_REGION_HIGH] = data[0];
				data++;
				beta[ant][RSSI_REGION_HIGH] = data[0];
				data++;
			//extract rssiGain 
			for(index = 0; index < numberOfRssiFlatness;)
			{
				deltaGFcalFileRssi[ant][index] = data[0]&0xf; 
				if(deltaGFcalFileRssi[ant][index]&0x8)
				{
					deltaGFcalFileRssi[ant][index] |= 0xf0;//sign extension
				}
				index++;
				if(index < numOfRxFlatness)
				{
					deltaGFcalFileRssi[ant][index] = (data[0]>> 4)&0xf;
					if(deltaGFcalFileRssi[ant][index]&0x8)
					{
						deltaGFcalFileRssi[ant][index] |= 0xf0;//sign extension
					}
				}
				index++;
				data++;
			}
		}
		
	}
    
	if(data[0] == 0xe1)
	{
		data++;
		numberOfExtraLnaGain = 1;
		for(ant = 0; ant < MAX_NUM_OF_ANTENNAS;)
		{
			lnaGainAtIndex[ant][5] =(int8)data[0];
			ant++;
			data++;
		}
	}
    
	calBinFileArrivedFromDriver = 1;
    
}
 void RssiPath_extractValuesFromCalBin(void)
{
	uint32 index;
	uint32 ant;
	uint32 requestedRxAntsMask = Hdk_GetRxAntMask();
	for(index = 0; index < NUM_OF_LNA_GAIN_INDEX + numberOfExtraLnaGain;index++)
	{
		for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			if(requestedRxAntsMask&(0x1<<ant))
			{
				REGISTER(LNA_GAIN_START_ADDRESS + (index*4) + (ant*LNA_GAIN_ANT_OFFSET)) = lnaGainAtIndex[ant][index];
			}
		}
	}
	RssiPath_setLnaMidGain(lnaMidGainWord);
}

void RssiPath_setLnaMidGain(uint8 lnaMidGainWord[MAX_NUM_OF_ANTENNAS])
{
	uint32 ant;
	uint32 antMask;
	uint32 requestedRxAntsMask = Hdk_GetRxAntMask();
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		antMask = 0x1<<ant;
		if(requestedRxAntsMask&(0x1<<ant))
		{
			rfic_set_lnaMidGain(antMask,lnaMidGainWord[ant]);
		}
	}
}

void RssiPath_measureRssi(uint16 numberOfSamples,uint16 rssiResult[MAX_NUM_OF_ANTENNAS],uint8 inRxAntMask)
{
	uint32 ant;

	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG80) |= 0x10;//enable Gclock to RxIqEstimator
	
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		triggerMeasureRssi(0,ant,numberOfSamples);
	}
    
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		rssiResult[ant] = measureRssi(0,ant,numberOfSamples);
	}
    
	REGISTER(REG_PHY_RX_TD_PHY_RXTD_REG80) &= 0xffffffef;//disable Gclock to RxIqEstimator
	
}
void RssiPath_getDB(RssiDBPower_t *rssiDB )
{
	
	memcpy(rssiDB->alpha,alpha,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS*sizeof(uint32));
	memcpy(rssiDB->beta,beta,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS*sizeof(uint32));
	memcpy(rssiDB->s2dGain,s2dGain,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS*sizeof(uint32));
	memcpy(rssiDB->s2dOffset,s2dOffset,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS*sizeof(uint32));
	memcpy(rssiDB->gamma,gamma,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS*sizeof(uint32));
	
}




