

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/

#include "System_GlobalDefinitions.h"
#include "RssiPathClbrHndlr.h"
#include "RssiPathDefinitions.h"
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <System_Configuration.h>
#include <PhyDriver_API.h>
#include "stringLibApi.h"
#include "Afe_API.h"
#include "PhyTestBus_API.h"
#include <lmi.h>
#include <mt_cnfg.h>	
#include "RegAccess_Api.h"
#include <MT_Math.h>
#include <math.h>
#include "CalibrationHandler.h"
//#include "CalibrationHandlerUtils.h"
#include "Shram_ClbrDataBuffer.h"
#include "PhyCalDriver_API.h"
#include "loggerAPI.h"
#include "RficDriver_API.h"
#include "mt_sysrst.h"
#include "ErrorHandler_Api.h"
#include "lib_wrx654_api.h"
#include "lib_wav600_api.h"
//#include "interface_rf_4x4.h"
#include "PhyAgcAnt0Regs.h"
#include "calibrationsParamsOtf.h"

#include "PhyRegsIncluder.h"
#include "PhyRxTdRegs.h"
#ifndef ENET_INC_ARCH_WAVE600D2
#include "PhyRxAgcIfRegs.h"
#endif
#include "fast_mem_psd2mips.h"
#include "PSD.h"
#include "ConfigurationManager_api.h"
#include "RegAccess_Api.h"
#define SIZE_OF_RSSI_TABLE 256
#define NUM_OF_VALUES_RX_FLATNESS_ARRAY (11)

#define LOG_LOCAL_GID   GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 15


/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
/*

*/
//defines array size	


/******************************************************************************/
/***						Type Definitions								***/
/******************************************************************************/
#define RX_FLATNESS_FREQ_STEP 		40//IN mHZ
#define RX_FLATNESS_GAIN_STEP 		1 //0.5 dB shifted left by 1
#define RX_FLATNESS_FREQ_OFFSET 	4900
#define RX_FLATNESS_GAIN_OFFSET 	8
#define RSSI_TABLE_REGION_SHIFT 	7
#define RSSI_TABLE_REGION_MASK 		0x0000007f
#define RSSI_OFFSET1_ANTENNA_OFFSET 0X100
#define RSSI_S2D_MID_GAIN_ADDRESS 	(B0_PHY_RX_TD_BASE_ADDR + 0x2011c)
#define LNA_CROSSING_FREQ_STEP 		20//IN mHZ
#define NUM_OF_LNA_GAIN_INDEX   	8  // always places for 8. now use index 0 - 5....
#define ALPHA_OFFST_IN_Q8 			384
#define BETA_OFFST_IN_Q2 			55518  // changed from 120
#define NUMBER_OF_FLATNESS_AND_MID_DELTA 3
// #difine NUMBER_OF_FLATNESS 3 // same as NUMBER_OF_FLATNESS_AND_MID_DELTA
#define FLATNESS_LNA_HIGH			(NUMBER_OF_FLATNESS_AND_MID_DELTA - 1) // ?????????????????

#define FLATNESS_MIDGAIN_DELTA		    0 //in cal_file MidGainDelta Green
#define FLATNESS_LNA_EXTERNAL_HIGH		1 //in cal_file RxGainDelta Blue
#define FLATNESS_LNA_EXTERNAL_BYPASS 	2 //in cal_file RxGainDelta Gray



uint32 numOfRxFlatness = 0;
uint32 numberOfRssiFlatness = 0;
uint32 rxFlatnessFreqOffset = 0;

#define MAX_RSSI_TABLE_DATA_LENGTH 	(MAX_SIZE_OF_RSSI_TABLE - 9) // 217 RX CIS max size - 9
#define ALL_IMPLEMENTED	0
typedef struct rssiPathCalibrationHeaderParams
{
	//uint16 dataSize;  //two byte totalSize starting ant mask
	uint8 dataSize; // but driver only pass totoal size with one byte. since suffice because max rx section can not exceed 217
	uint8 antMask;
	uint16 CISStartFreqChannel;
	uint16 CISEndFreqChannel;
	uint16 CalibrationFreqChannel;
	uint8 TChip;   // will set TChip[6:0] as chip temperature; and set TChip[7] as bool indicating if the sub-band crossing is in the CIS or not ?
	uint8 MandL;
	uint8 data[MAX_RSSI_TABLE_DATA_LENGTH];
} __attribute__((aligned(1), packed)) rssiPathCalibrationHeaderParams_t;

rssiPathCalibrationHeaderParams_t rssiPathData;

RssiPathParams_t rssiPathParams = {0};


/******************************************************************************/
/***					Static Function Declarations						***/
/******************************************************************************/ 

static  void extrapolateFromRxFlatnessTable(uint32 freq);
static  void extrapolateFromRxFlatnessRssiTable(uint32 freq);

static  void generateRxFlatnessTable(void);
static  void generateRxFlatnessRssiTable(void);

static  void generateRssiTable(void);
#ifdef SDL_IGNORE_UNUSED_FUNCTION
static uint32 measureRssi(uint32 method,uint8 inAntNum ,uint16 inNumSamplesToAverage);
static void triggerMeasureRssi(uint32 method,uint8 inAntNum ,uint16 inNumSamplesToAverage);
#endif

uint8 calBinFileArrivedFromDriver =0;
uint8 flatnesscalcon = 0;
uint8 flatnessrssicalcon = 0;
//Information from calibration file

//array of frequencies given by an index to nultiply from the previoues frequency for the rx path
uint32 fcalFile[NUM_OF_VALUES_RX_FLATNESS_ARRAY] = {1,2,3,4,5};	

//array of frequencies given by an index to nultiply from the previoues frequency for the rssi path
uint32 fcalFileRssi[NUM_OF_VALUES_RX_FLATNESS_ARRAY] = {1,2,3,4,5};

// an array of gains which corrsepands to the array of frequencies for the rx path
int32 deltaGFcalFile[MAX_NUM_OF_ANTENNAS][NUMBER_OF_FLATNESS_AND_MID_DELTA][NUM_OF_VALUES_RX_FLATNESS_ARRAY] = {{{1,2,3,4,5},{1,2,3,4,5},{1,2,3,4,5}},
																		 {{6,7,8,9,10},{6,7,8,9,10},{6,7,8,9,10}},
																		 {{11,12,13,14,15},{11,12,13,14,15},{11,12,13,14,15}},
																		 {{1,3,5,7,9},{1,3,5,7,9},{1,3,5,7,9}},
																		} ;
// an array of gains which corrsepands to the array of frequencies for the rssi path
int32 deltaGFcalFileRssi[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY] = {{1,2,3,4,5},
																		 {6,7,8,9,10},
																		 {11,12,13,14,15},
																		 {1,3,5,7,9},
																		} ;

int16 alpha[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS_GEN6] = {{230,240},
															 {240,250},
															 {250,230},
															 {235,235},
															} ;

int16 beta[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS_GEN6] = {{140,160},
															 {110,130},
															 {100,150},
															 {190,210},
															 				} ;// q2 +120															 				

int32 s2dGain[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS_GEN6] = {{12*2-10,3*2-10},
															 {12*2-10,2*2-10},
															 {12*2-10,2*2-10},
															 {12*2-10,2*2-10},
																		};

int32 s2dOffset[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS_GEN6] = {{13,22},
															 	{13,24},
															 	{12,23},
															 	{13,24},
															 				} ;
//int32 s2dOffsetCoarse[MAX_NUM_OF_ANTENNAS][NUMBER_OF_RSSI_REGIONS_GEN6];
											

int32 pmin[NUMBER_OF_RSSI_REGIONS_GEN6] = {-27*2,-23*2};//Q1
int32 pmax[NUMBER_OF_RSSI_REGIONS_GEN6] = {-12*2,-8*2};//Q1
uint8 lnaMidGainWord[MAX_NUM_OF_ANTENNAS];

uint32 margin = 0;

// self used arrays


// extrapolation array of fcal rssi path
uint32 fcalResultRssi[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY];
//extrapolation of deltaGFcalFile
int32 deltaB[MAX_NUM_OF_ANTENNAS][NUMBER_OF_FLATNESS_AND_MID_DELTA][NUM_OF_VALUES_RX_FLATNESS_ARRAY];//in 0.25 db // NUMBER_OF_FLATNESS -> NUMBER_OF_FLATNESS_AND_MID_DELTA
//extrapolation of deltaGFcalFile rssi path
int32 deltaBRssi[MAX_NUM_OF_ANTENNAS][NUM_OF_VALUES_RX_FLATNESS_ARRAY];//in 0.25 db
// calculation of b from the data 
int32 deltaBFreq[MAX_NUM_OF_ANTENNAS][NUMBER_OF_FLATNESS_AND_MID_DELTA]; // NUMBER_OF_FLATNESS -> NUMBER_OF_FLATNESS_AND_MID_DELTA
// calculation of b from the data 
int32 deltaBFreqRssi[MAX_NUM_OF_ANTENNAS];

uint16 gamma[NUMBER_OF_RSSI_REGIONS_GEN6][MAX_NUM_OF_ANTENNAS] ={{44,53,53,115},
															 	{57,71,66,81}
															 				} ;





//static RetVal_e run(RssiPath_elements_t* outElements_p)
static RetVal_e run(IN ClbrType_e calibType)
{
	uint32 Start_Cal_Time;
	RetVal_e ret = RET_VAL_SUCCESS;
	//uint32 ant;
	RssiRegion_e region;
	uint32 freq;
	SetChannelParams_t *channelParams;
	uint32 requestedRxAntsMask = Hdk_GetRxAntMask();
	uint16 numberOfsamples = 16000;
	UNUSED_PARAM(calibType);	
	if(calBinFileArrivedFromDriver != 1)
	{
		return RET_VAL_FAIL;
	}
	Start_Cal_Time = TIME_STAMP(START_TIME,0);
	/*get calibration frequency*/
	channelParams = HDK_getSetChannelParams();
	freq = RficDriver_CalcLoFrequency(channelParams);
	SetRxGains(ANTENNA_BITMAP_ALL_ANTENNAS_GEN5 ,HDK_LNA_INDEX_MIN_INDEX,0,0,0);
	
	/*Generate calibration tables*/
	generateRxFlatnessTable();
	extrapolateFromRxFlatnessTable(freq);
	generateRxFlatnessRssiTable();
	extrapolateFromRxFlatnessRssiTable(freq);
	
	RssiPath_extractValuesFromCalBin();

	
	/*start measuring of rssi*/
	rfic_rxon(0xf);

	MT_DELAY(1000);


	for(region = RSSI_REGION_LOW; region < NUMBER_OF_RSSI_REGIONS_GEN6; region++)
	{
		//for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		//{
			//rfic_select_rssi((0x1 << ant), region);
		//	RssiPath_measureRssi(numberOfsamples,gamma[region],( 0x1 << ant));
		//}
		RssiPath_measureRssi(numberOfsamples,gamma[region],requestedRxAntsMask);	
	}

	generateRssiTable();
	rfic_rxoff(0xf);
	
#if LM_CALIBRATION_LOGS_ON
	ILOG0_V("RSSI Path: Executing Calibration");
#endif

	//outElements_p->results.lastRunTime = TIME_STAMP(END_TIME,Start_Cal_Time);
	rssiPathParams.lastRunTime = TIME_STAMP(END_TIME,Start_Cal_Time);

	return ret;
}

RetVal_e RssiPath_Calibrate(IN ClbrType_e inCalibType)
{
	DEBUG_ASSERT(inCalibType == CLBR_TYPE_OFFLINE);
 
	//return run(&Calibration_params_otf.Rssiparams);
	return run(inCalibType);
}

void RssiPath_SetStatus( IN uint32 inAntNum, IN CalStatus_e inStatus )
{

	//Calibration_params_otf.Rssiparams.results.status[inAntNum] = inStatus;
	rssiPathParams.status[inAntNum] = inStatus;
}

CalStatus_e RssiPath_GetStatus( IN uint32 inAntNum )
{

	//return (CalStatus_e)Calibration_params_otf.Rssiparams.results.status[inAntNum];
	return rssiPathParams.status[inAntNum];
}

int8 RssiPath_GetDynamicRange( IN uint32 inAntNum )
{

	//return Calibration_params_otf.Rssiparams.results.dynamicRange[inAntNum];
	return rssiPathParams.dynamicRange[inAntNum];
}

int8 RssiPath_GetMeasurementVariation( IN uint32 inAntNum )
{

	//return Calibration_params_otf.Rssiparams.results.measurementVariation[inAntNum];
	return rssiPathParams.measurementVariation[inAntNum];
}

uint32 RssiPath_GetLastRunTime(void)
{

	//return Calibration_params_otf.Rssiparams.results.lastRunTime;
	return rssiPathParams.lastRunTime;
}


void RssiPath_LoadResults(void)
{

}

static void generateRxFlatnessTable(void)
{
	Antenna_e ant;
	uint32 i;
	uint32 flatness;
	uint32 rxAntsMask = Hdk_GetRxAntMask();
	
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)	
    {
      if(rxAntsMask&(0x1<<ant))
      {
          if(numOfRxFlatness >= 1)
          {
    		for(i = 0; i < numOfRxFlatness; i++)
        	{
    			for (flatness = 0; flatness < NUMBER_OF_FLATNESS_AND_MID_DELTA; flatness++) // NUMBER_OF_FLATNESS -> NUMBER_OF_FLATNESS_AND_MID_DELTA
    			{
    				deltaB[ant][flatness][i] = ((deltaGFcalFile[ant][flatness][i]) /* << 1*/);
    			}
    		}
    	  }
      }
	}
}


/* FLATNESS RSSI NOT DONE ON wave600 */
static void generateRxFlatnessRssiTable(void)
{
	Antenna_e ant;
	uint32 i;
	uint32 freqStep =  RX_FLATNESS_FREQ_STEP;// in Mhz	
	uint32 gainStep = RX_FLATNESS_GAIN_STEP;// 0.5 dB shifted left by 1
	uint32 rxAntsMask = Hdk_GetRxAntMask();
	
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {	
        if(rxAntsMask&(0x1<<ant))
        {
          if(numberOfRssiFlatness >= 1)
          {
            
    		fcalResultRssi[ant][0]  = fcalFileRssi[0]*freqStep + rxFlatnessFreqOffset;
            
    		for(i = 1; i < numberOfRssiFlatness; i++)
        	{
    			fcalResultRssi[ant][i]  = fcalFileRssi[i]*freqStep + fcalResultRssi[ant][i-1];
    			deltaBRssi[ant][i] = ((deltaGFcalFileRssi[ant][i]*gainStep) >> 1) - RX_FLATNESS_GAIN_OFFSET /*check with michael*/;
    		}
         }
       }
	}
}

static void extrapolateFromRxFlatnessTable(uint32 freq)
{
	Antenna_e ant;
	uint32 i;	
	uint32 flatness;
	uint32 rxAntsMask = Hdk_GetRxAntMask();
	
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {
      if(rxAntsMask&(0x1<<ant))
      {
		for (flatness = 0; flatness < NUMBER_OF_FLATNESS_AND_MID_DELTA; flatness++) // NUMBER_OF_FLATNESS -> NUMBER_OF_FLATNESS_AND_MID_DELTA
		{
		  if(numOfRxFlatness >= 1)
		  {
		    flatnesscalcon = 1;
			
			/* first freq */
			if (freq <= fcalFile[0])
			{
				deltaBFreq[ant][flatness] = deltaB[ant][flatness][0];
				continue;
			}

			/* last freq */
			if (freq >= fcalFile[numOfRxFlatness - 1])
			{
				deltaBFreq[ant][flatness] = deltaB[ant][flatness][numOfRxFlatness -1];
				continue;
			}

			/* equal  freq or middle freq */
			for(i = 1; i < numOfRxFlatness; i++)
			{
				if (freq == fcalFile[i])
				{
					deltaBFreq[ant][flatness] =deltaB[ant][flatness][i];
					break;
				}			
				else if (freq < fcalFile[i])
				{
					deltaBFreq[ant][flatness] =deltaB[ant][flatness][i - 1] + ((((deltaB[ant][flatness][i] - deltaB[ant][flatness][i - 1])* (int32)(freq  - fcalFile[i - 1]))
															/(int32)(fcalFile[i] - fcalFile[i - 1])));
					break;
				}
				
			}
		  }
		  else
		  	deltaBFreq[ant][flatness] = 0;  // assume default 0 ; not available for delta ?????
		}
      }
	}
}
static void extrapolateFromRxFlatnessRssiTable(uint32 freq)
{
	Antenna_e ant;
	uint32 i;
	uint32 rxAntsMask = Hdk_GetRxAntMask();
	
	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {
      if(rxAntsMask&(0x1<<ant))
      {
        if(numberOfRssiFlatness >= 1)
        {
            flatnessrssicalcon = 1;
    		if (freq <= fcalResultRssi[ant][0])
    		{
    			deltaBFreqRssi[ant] = deltaBRssi[ant][0];
    			continue;
    		}
    		if (freq >= fcalResultRssi[ant][numberOfRssiFlatness - 1])
    		{
    			deltaBFreqRssi[ant] = deltaBRssi[ant][numberOfRssiFlatness -1];
    			continue;
    		}
    		for(i = 1; i < numberOfRssiFlatness; i++)
    		{
    			if (freq < fcalResultRssi[ant][i])
    			{
    				deltaBFreqRssi[ant] = deltaBRssi[ant][i - 1] + (((deltaBRssi[ant][i] - deltaBRssi[ant][i - 1])* (int32)(freq  - fcalResultRssi[ant][i - 1]))
    																	/(int32)(fcalResultRssi[ant][i] - fcalResultRssi[ant][i - 1]));
    				break;
    			}
    		}
        }
		else
			deltaBFreqRssi[ant] = 0; // assume default 0 ; not available for delta ?????
      }	
	}
}
 
 
#define LOG_ACCURACY_BIT (5)
#define Q2_MULTI_AFTER_LOG (2)
// craete rssi table
static void generateRssiTable(void)
{
	uint32 ant= 0;
	RssiRegion_e region=RSSI_REGION_LOW;
	int16 alpha1;
	int16 beta1;
	int32 margin1;
	volatile uint32* pTable;
	uint32 rxAntsMask = Hdk_GetRxAntMask();
	
	margin1 = margin;//q1
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
	  if(rxAntsMask&(0x1<<ant))
	  {
		pTable = (volatile uint32*)(B0_PHY_RX_TD_BASE_ADDR + RSSI_TABLE_ANT0 + RSSI_TABLE_ANT_OFFSET*ant);//glick are define good?? instead of table should write a, b into registers but not calculat it
		memset((void*)pTable,0x0,RSSI_TABLE_ANT_OFFSET);
        
		for(region = RSSI_REGION_LOW; region < NUMBER_OF_RSSI_REGIONS_GEN6; region++)
		{
			bbic_set_rx_rssi_offset1(ant,region,gamma[region][ant]);
			alpha1 = alpha[ant][region] + ALPHA_OFFST_IN_Q8;//Q8
			//beta1 = beta[ant][region] + deltaBFreq[ant] + deltaBFreqRssi[ant] + 80;//Q1
			beta1 = beta[ant][region] + BETA_OFFST_IN_Q2 + deltaBFreq[ant][0];//Q2      //glick what deltaBFreq to take????????

		}
	  }
	}
}


#if ALL_IMPLEMENTED
#ifdef SDL_IGNORE_UNUSED_FUNCTION
static void triggerMeasureRssi(uint32 method,uint8 inAntNum ,uint16 inNumSamplesToAverage)
 {
 	uint32 antOffset;

	RegPhyRxTdAnt2PhyRxtdAntReg31_u reg31;
	RegPhyRxTdAnt0PhyRxtdAntReg02_u reg02;
	RegPhyRxTdAnt0PhyRxtdAntReg04_u reg04;
	RegPhyRxTdAnt0PhyRxtdAntReg05_u reg05;

	BandId_e band = ConfigurationManager_GetMyBand();

	antOffset = band*BAND_OFFSET + inAntNum*ANT_REGS_OFFSET;

	//Accumulator choose rSSI  rx on FOR ALL ANTENNAS
	RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG31 + antOffset,&reg31.val);
	reg31.bitFields.iqMismatchAccumRssi = 1;
	RegAccess_Write(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG31 + antOffset,reg31.val);

	//ENABLE DC
	RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG02 + antOffset,&reg02.val);
	reg02.bitFields.iqMismatchEstRegularISum = 1;
	reg02.bitFields.iqMismatchEstRegularQSum = 1;
	RegAccess_Write(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG02 + antOffset,reg02.val);

	//ENTER NUMBER OF SAMPLES
	RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG04 + antOffset,&reg04.val);
	reg04.bitFields.iqMismatchEstAccCounter = inNumSamplesToAverage;//ENTER NUMBER OF SAMPLES
	RegAccess_Write(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG04 + antOffset,reg04.val);

	//DISABLING BIT 4 START
	RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset,&reg05.val);
	reg05.bitFields.iqMismatchEstStartWork = 0;
	RegAccess_Write(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset,reg05.val);

	//ENABLING BIT 8 RESET
	RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset,&reg05.val);
	reg05.bitFields.iqMismatchEstResetRegs = 1;
	RegAccess_Write(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset,reg05.val);
	
	MT_DELAY(1);
	
	//DISABLING BIT 8 RESET // wait 30 clocks
	RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset,&reg05.val);
	reg05.bitFields.iqMismatchEstResetRegs = 0;
	RegAccess_Write(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset,reg05.val);

	MT_DELAY(10);

	//enabling bit 4 start
	RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset,&reg05.val);
	reg05.bitFields.iqMismatchEstStartWork = 1;
	RegAccess_Write(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset,reg05.val);

}



static uint32 measureRssi(uint32 method,uint8 inAntNum ,uint16 inNumSamplesToAverage)
{
	uint32 antOffset;
	uint32 readresult;
	uint32 antMask;
	RegPhyRxTdAnt0PhyRxtdAntReg05_u reg05;
	RegPhyRxTdAnt0PhyRxtdAntReg06_u reg06;

	BandId_e band = ConfigurationManager_GetMyBand();
	antMask = Hdk_GetRxAntMask();

	if (((1 << inAntNum) & antMask) != 0)
	{
		antOffset = band*BAND_OFFSET + inAntNum*ANT_REGS_OFFSET;
		RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset, &reg05.val);
        
		while(reg05.bitFields.iqMismatchEstValidIq != 1)//READ BIT 12 UNTIL IS 1
		{
			RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG05 + antOffset, &reg05.val);
		}
        
		RegAccess_Read(REG_PHY_RX_TD_ANT0_PHY_RXTD_ANT_REG06 + antOffset, &reg06.val);
		readresult = reg06.bitFields.iqMismatchEstRegIi;

		return readresult/inNumSamplesToAverage;
	}
	else
	{
		return 0;
	}
		
}
#endif // SDL_IGNORE_UNUSED_FUNCTION
#endif

void GetRssiPathCisData(uint16 *size, uint8 **params)
{
  *size = rssiPathData.dataSize;
  *params = (uint8*)&rssiPathData;
}

int16 lnaGainAtIndex[MAX_NUM_OF_ANTENNAS][NUM_OF_LNA_GAIN_INDEX];
uint32 numberOfExtraLnaGain=0;

void GetRssiPathCisDataLnamidgain(uint8 ant, uint8 *midword, int16 *idx0, int16 *idx1, int16 *idx2, int16 *idx3, int16 *idx4, int16 *idx5, int16 *idx6, int16 *idx7)
{
	*midword = lnaMidGainWord[ant];
	*idx0 = lnaGainAtIndex[ant][0];
	*idx1 = lnaGainAtIndex[ant][1];
	*idx2 = lnaGainAtIndex[ant][2];
	*idx3 = lnaGainAtIndex[ant][3];
	*idx4 = lnaGainAtIndex[ant][4];
	*idx5 = lnaGainAtIndex[ant][5];
	*idx6 = lnaGainAtIndex[ant][6];
	*idx7 = lnaGainAtIndex[ant][7];
}

void RssiPath_getValuesFromCalBin(void)
{
	uint32 ant;
	uint32 requestedRxAntsMask = Hdk_GetRxAntMask();
	if(calBinFileArrivedFromDriver == 1)
	{
		for( ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			if(requestedRxAntsMask&(0x1<<ant))
			{
				bbic_get_lna_gain_lut(ant, lnaGainAtIndex[ant]);
			}
		}
	}
}



// get information elements from drivver
/*		cal bin file parsing
1.		lnaSubBandCrossing
2.	extract rx flatness freq fcalFile	
3.	extract rssi flatness freq
	Per antenna
4.		lnaMidGainWord  per antenna
5. 		averageLna gain  (workaround for Wave504 A11)
6. 		rx fltaness gain
8.		s2dgain
9		alpha
10		beta
11. 		rssi flatness gain*/


void RssiPath_GetTableFromDriver(K_MSG *kmsg)
{
	rssiPathCalibrationHeaderParams_t *headerParam;
	uint32 antMaskFromCAlFile;
	uint32 numOfAntennas = 0; 
	uint32 index;
	uint32 flatness;
	uint32 temp;
	uint8 *data;
	uint32 ant;
	uint16 lnaSubBandCrossing[MAX_NUM_OF_ANTENNAS][MAX_NUMBER_OF_LNA_CROSSING_POINT];
	
	headerParam = (rssiPathCalibrationHeaderParams_t *)kmsg->abData;
	MEMCPY(&rssiPathData,headerParam,sizeof(rssiPathData));
#if LM_CALIBRATION_LOGS_ON
	ILOG0_DDDD("RssiPath_GetTableFromDriver RSSI CIS: totalSize: %d, antMask: 0x%x, CISStartFreqChannel: %d, CISEndFreqChannel: %d",rssiPathData.dataSize, rssiPathData.antMask, rssiPathData.CISStartFreqChannel, rssiPathData.CISEndFreqChannel);	
	SLOG0(0, 0, rssiPathCalibrationHeaderParams_t, headerParam);
#endif
	antMaskFromCAlFile = headerParam->antMask;

	for( index = ANTENNA_0; index < MAX_NUM_OF_ANTENNAS; index++)
	{
		if( antMaskFromCAlFile & ( 0x1 << index))
		{
			numOfAntennas++;
		}
	}
	DEBUG_ASSERT( numOfAntennas <= MAX_NUM_OF_ANTENNAS);//Eran add assert of of antenna mask
	
	rxFlatnessFreqOffset = headerParam->CISStartFreqChannel;
	
	temp= rxFlatnessFreqOffset;
	numOfRxFlatness = (headerParam->MandL & 0xf);
	numberOfRssiFlatness = ((headerParam->MandL>>4)&0xf);
	data = &headerParam->data[0];
	
	DEBUG_ASSERT(numOfRxFlatness <= NUM_OF_VALUES_RX_FLATNESS_ARRAY);
	//rx flatness cal freq points
	for(index = 0; index < numOfRxFlatness;)
	{
		temp = temp + RX_FLATNESS_FREQ_STEP*(data[0]&0xf); 
		fcalFile[index] = temp; 
		index++;
		if(index < numOfRxFlatness)
		{
			temp = temp + RX_FLATNESS_FREQ_STEP*((data[0] >> 4)&0xf); 
			fcalFile[index] = temp;
		}
		index++;
		data++;
	}
	//extract rssi flatness freq   ////rssi flatness points
	temp= rxFlatnessFreqOffset;
	DEBUG_ASSERT(numberOfRssiFlatness <= 5);
	for(index = 0; index < numberOfRssiFlatness;)
	{
		temp = temp + RX_FLATNESS_FREQ_STEP*(data[0]&0xf);  
		fcalFileRssi[index] = temp; 
		index++;
		if(index < numberOfRssiFlatness)
		{
			temp = temp + RX_FLATNESS_FREQ_STEP*((data[0] >> 4)&0xf);
			fcalFileRssi[index] = temp;
		}
		index++;
		data++;
	}
	/*perAntenna*/

	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if(antMaskFromCAlFile&(0x1<<ant))
		{
			//lna sub bands crossing points
			if((headerParam->TChip>>7)&0x1)
			{
			temp = rxFlatnessFreqOffset;
			for(index = 0; index < MAX_NUMBER_OF_LNA_CROSSING_POINT;)
			{
				//regionOffset = 0;
				temp = temp + LNA_CROSSING_FREQ_STEP*(data[0]&0xf);
				lnaSubBandCrossing[ant][index] = temp ; 
				index++;
				if(index < MAX_NUMBER_OF_LNA_CROSSING_POINT)
				{
					temp = temp + LNA_CROSSING_FREQ_STEP*((data[0]>>4)&0xf);
					lnaSubBandCrossing[ant][index] = temp;
				}
				index++;
				data++;
			}
			}
			
			lnaMidGainWord[ant] = data[0];//write rfic register
			data++;
			//extract lna gain index //lna sub bands
			for(index = 0; index < NUM_OF_LNA_GAIN_INDEX;)	
			{
				lnaGainAtIndex[ant][index] =(int8)data[0];
				index++;
				data++;
			}
			//extract rxGain 
			for(flatness = 0; flatness < NUMBER_OF_FLATNESS_AND_MID_DELTA; flatness++)
			{
				for(index = 0; index < numOfRxFlatness;)
				{
					deltaGFcalFile[ant][flatness][index] = data[0]&0xf; 
					if(deltaGFcalFile[ant][flatness][index]&0x8)
					{
						deltaGFcalFile[ant][flatness][index] |= 0xfffffff0;//sign extension
					}
					index++;
					if(index < numOfRxFlatness)
					{
						deltaGFcalFile[ant][flatness][index] = (data[0]>> 4)&0xf;
						if(deltaGFcalFile[ant][flatness][index]&0x8)
						{
							deltaGFcalFile[ant][flatness][index] |= 0xfffffff0;//sign extension
						}
					}
					index++;
					data++;
				}
			}
			//s2dOffset[ant][RSSI_REGION_LOW] = data[0]&0x1f;
			s2dOffset[ant][RSSI_REGION_LOW] = data[0]&0x7f;
			//s2dOffsetCoarse[ant][RSSI_REGION_LOW] = (data[0] >> 5)&0x3;
			data++;
			s2dGain[ant][RSSI_REGION_LOW] = data[0]&0xf;
			data++;
			//s2dOffset[ant][RSSI_REGION_HIGH] = data[0]&0x1f;
			s2dOffset[ant][RSSI_REGION_HIGH] = data[0]&0x7f;
			//s2dOffsetCoarse[ant][RSSI_REGION_HIGH] = (data[0] >> 5)&0x3;
			data++;
			s2dGain[ant][RSSI_REGION_HIGH] = data[0]&0xf;
			data+=3;

			alpha[ant][RSSI_REGION_LOW] = data[0];
			data++;
			beta[ant][RSSI_REGION_LOW] = data[0];
			data++;
			alpha[ant][RSSI_REGION_HIGH] = data[0];
			data++;
			beta[ant][RSSI_REGION_HIGH] = data[0];
			data+=3;

			//extract rssiGain 
			for(index = 0; index < numberOfRssiFlatness;)
			{
				deltaGFcalFileRssi[ant][index] = data[0]&0xf; 
				if(deltaGFcalFileRssi[ant][index]&0x8)
				{
					deltaGFcalFileRssi[ant][index] |= 0xf0;//sign extension
				}
				index++;
				if(index < numOfRxFlatness)
				{
					deltaGFcalFileRssi[ant][index] = (data[0]>> 4)&0xf;
					if(deltaGFcalFileRssi[ant][index]&0x8)
					{
						deltaGFcalFileRssi[ant][index] |= 0xf0;//sign extension
					}
				}
				index++;
				data++;
			}
		}
	}	
	if((headerParam->TChip>>7)&0x1)
		RficDriver_SetRxBandLUT(&lnaSubBandCrossing[0][0]);
	calBinFileArrivedFromDriver = 1;		
}
	

 void RssiPath_extractValuesFromCalBin(void)
{
	uint32 ant;
	RssiRegion_e region;
	uint32 requestedRxAntsMask = Hdk_GetRxAntMask(); 
	uint32 freq;
	SetChannelParams_t *channelParams;
	//uint16 numberOfsamples = 16000;
	int16 lnaGainAtIndexTmp[NUM_OF_LNA_GAIN_INDEX + 1];
	uint8 tmpLnaMidGainWord[4];
	if(calBinFileArrivedFromDriver == 1)
	{
		channelParams = HDK_getSetChannelParams();
		freq = RficDriver_CalcLoFrequency(channelParams);

		generateRxFlatnessTable(); /* need to move to " parsing cal file", because needed todo only once and not per freq.*/
		extrapolateFromRxFlatnessTable(freq);

/* NUM_OF_LNA_GAIN_INDEX == need in the future to take from PSD, it's allready done in DC calibration  */
		
		for( ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			if(requestedRxAntsMask&(0x1<<ant))
			{
			
				for( uint32 lnaIndex = 0; lnaIndex < NUM_OF_LNA_GAIN_INDEX; lnaIndex++)
				{
					if(lnaIndex < (NUM_OF_LNA_GAIN_INDEX/2))
					{
							lnaGainAtIndexTmp[lnaIndex] = lnaGainAtIndex[ant][lnaIndex];
							
					}
					else
					{
							lnaGainAtIndexTmp[lnaIndex] = lnaGainAtIndex[ant][lnaIndex] +  (deltaBFreq[ant][FLATNESS_LNA_EXTERNAL_BYPASS]); 				
					}
					lnaGainAtIndexTmp[0] = lnaGainAtIndex[ant][0] + (deltaBFreq[ant][FLATNESS_LNA_EXTERNAL_HIGH]);

					
							
#if LM_CALIBRATION_LOGS_ON
					ILOG0_DDDD("Ant#=%d, lnaIndex=%d, lnaGainAtIndexTmp =%d , lnaGainAtIndex=%d",ant,lnaIndex,lnaGainAtIndexTmp[lnaIndex],lnaGainAtIndex[ant][lnaIndex]);
#endif
								
				}

				
				
				bbic_set_lna_gain_lut(ant, lnaGainAtIndexTmp);
				
				tmpLnaMidGainWord[ant] = lnaMidGainWord[ant] + deltaBFreq[ant][FLATNESS_MIDGAIN_DELTA];
								
				rfic_set_lnamidgain(0x1<<ant,tmpLnaMidGainWord[ant]);
				
#if LM_CALIBRATION_LOGS_ON
				ILOG0_DDD("Ant#= %d, lnaMidGainWord = %d, tmpLnaMidGainWord = %d",ant,lnaMidGainWord[ant]  ,tmpLnaMidGainWord[ant]);
#endif
				
				for(region = RSSI_REGION_LOW; region < NUMBER_OF_RSSI_REGIONS_GEN6; region++)
				{	
					/*
					math code:
					rxCalBuf[byteOffset++] = (byte)ant.s2dOffset[i];
					rxCalBuf[byteOffset++] = (byte)(Math.Round((double)ant.s2dGain[i] - (-10)) / 2);
					*/
					setS2dGainAndOffset(s2dOffset[ant][region], s2dGain[ant][region]*2 - 10, (0x1 << ant), region);



					/*
					to bb_api
					B:
					B_for_api = 55518 - 64*(B_8bit_parsed);    //(2^16 + round((X/(-4)-10*log10(2^13))*256))
					A:
					A_for_api= round(A_8bit_parsed * 256);
					
					math code:
					tmpBuf[offset++] = (byte)Math.Round((antData.pointsAB[region].a - 1.5f) * 256);
					tmpBuf[offset++] = (byte)Math.Round(antData.pointsAB[region].b * -4);
					*/
					/* (A/256+1.5)*256 = A+384 */
					/* 55518 - 64*(B/(-4)) = 55518+16*B */
					/*5518 = 2^16 - 40*256   coef in resolution of 8 bit 40 is constant in HW*/ 
					
#if LM_CALIBRATION_LOGS_ON
					ILOG0_DDDD("RSSI FLATNESS: Ant#= %d, alpha = %d, beta=%d, deltaBFreqRssi = %d",ant,alpha[ant][region]  ,beta[ant][region],deltaBFreqRssi[ant]);
#endif
					bbic_set_rx_rssi_coef(ant,region,alpha[ant][region]+384,(-64*(beta[ant][region]))+55518);
				}
			}
		}
	}
}


void RssiPath_measureRssi(uint16 numberOfSamples,uint16 rssiResult[MAX_NUM_OF_ANTENNAS],uint8 inRxAntMask)
{
	uint32 ant;
	uint32_t NOS[MAX_NUM_OF_ANTENNAS];
	uint32 i;
	uint8 dcMode = 1; /*DCMode - accumulate sample values (1-DC mode) or squared values (0-PWR mode) */
	uint8 rssiMode = 1; /*RssiMode - connect I-accumulator to RSSI signal (1) or to I/Q inputs (0)*/
	uint8 rate = 1; /* Rate - connect accumulators before dec chan filter (1) or after dec chan filter (0) */
	uint8 accumShift = 8; // AccumShift - bits to round after squaring (active in PWR mode only)
	uint8_t Rate[MAX_NUM_OF_ANTENNAS];
	uint8_t AccumShift[MAX_NUM_OF_ANTENNAS];
	uint8_t RssiMode[MAX_NUM_OF_ANTENNAS];
	uint8_t DCMode[MAX_NUM_OF_ANTENNAS];
	CorrRes_t Results[MAX_NUM_OF_ANTENNAS];
	CorrOverflow_t corrOf[MAX_NUM_OF_ANTENNAS];
	for(i =0; i<MAX_NUM_OF_ANTENNAS; i++)
	{
		NOS[i] = numberOfSamples;
		DCMode[i] = dcMode;
		RssiMode[i] = rssiMode;
		Rate[i] = rate;
		AccumShift[i] = accumShift ;
	}

	PhyCalDrv_CorrInit(inRxAntMask,NOS,DCMode,RssiMode,Rate,AccumShift); //Orit please check the params.
	PhyCalDrv_CorrMeasure(inRxAntMask, 10000/*rxiqParams.accumTimeout*/, Results, corrOf);
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		rssiResult[ant] = (Results[ant].II/NOS[ant]);
	}
	
}



void RssiPath_setLnaMidGain(uint8 lnaMidGainWordInput[MAX_NUM_OF_ANTENNAS])
{
	uint32 ant;
	uint32 antMask;
	uint32 requestedRxAntsMask = Hdk_GetRxAntMask();
		
	for(ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		antMask = 0x1<<ant;
		if(requestedRxAntsMask&(0x1<<ant))
		{
			rfic_set_lnamidgain(antMask,lnaMidGainWordInput[ant]);
		}
	}
}

void setS2dGainAndOffset(int32 ioffs, int32 s2dGainInput, uint32 antenna, uint8 regionIndex)
{
// antenna is antmask
	rfic_config_rssi((uint8_t)antenna, regionIndex, (uint8_t)s2dGainInput, (uint8_t)((ioffs & 0x60) >> 0x5), (uint8_t)(ioffs & 0x1F)); // BIT[6:5} and BIT[4:0]
	rfic_select_rssi((uint8_t)antenna, regionIndex);
}

void RssiPath_getDB(RssiDBPower_t *rssiDB )
{
	
	MEMCPY(rssiDB->alpha,alpha,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS_GEN6*sizeof(uint32));
	MEMCPY(rssiDB->beta,beta,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS_GEN6*sizeof(uint32));
	MEMCPY(rssiDB->s2dGain,s2dGain,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS_GEN6*sizeof(uint32));
	MEMCPY(rssiDB->s2dOffset,s2dOffset,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS_GEN6*sizeof(uint32));//glick changed
	MEMCPY(rssiDB->gamma,gamma,MAX_NUM_OF_ANTENNAS*NUMBER_OF_RSSI_REGIONS_GEN6*sizeof(uint32));
}

