#ifndef __RficBiasClbrHndlr_h__
#define __RficBiasClbrHndlr_h__

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "CalibrationDefs.h"

/******************************************************************************/
/***						Public Function Declarations					***/
/******************************************************************************/
//************************************
// Method:    RficBias_Calibrate
// Purpose:   Run calibration procedure segments not more than the allocated time
// Parameter: IN ClbrType_e inCalibType - OFFLINE or ONLINE
// Returns:   RetVal_e - success(S_SUCCESS), fail(S_FAIL)
//************************************
 RetVal_e RficBias_Calibrate(IN ClbrType_e inCalibType);
//************************************
// Method:    RficBias_SetStatus
// Purpose:   Set calibration status 
// Parameter: 
//			CalStatus_E inStatus
// Returns:   void
//************************************
 void RficBias_SetStatus(IN CalStatus_e inStatus);
//************************************
// Method:    RficBias_GetStatus
// Purpose:   Get calibration status 
// Parameter: 
// Returns:   CalStatus_E - E_Fail or E_Pass
//************************************
 CalStatus_e RficBias_GetStatus( void );
//************************************
// Method:    RficBias_GetLastRunTime
// Purpose:   Get last RFIC bias calibration run time duration
// Parameter: None
// Returns:   Run time duration
//************************************
 uint32 RficBias_GetLastRunTime(void);
//************************************
// Method:      RficBias_LoadResults
// Purpose:     Loads RFIC bias calibration data from a buffer
// Parameter: None
// Returns:     None
//************************************
 void RficBias_LoadResults(void);

 uint32* RficBias_GetElement(void);
#endif // __RficBiasClbrHndlr_h__

