#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <System_Configuration.h>

#include <lmi.h>
#include <lm.h>
#include "RegAccess_Api.h"
#include "MT_Math.h"
#include <PhyDriver_API.h>
#include <CalibrationHandler.h>
#include "CalibrationHandlerUtils.h"
#include "Shram_ClbrDataBuffer.h"
#include "RficBiasClbrHndlr.h"
#include "mt_sysrst.h"
#include "RficDriver_API.h"
#include "PhyCalDriver_API.h"
#include "Afe_API.h"
#include "PhyCalDriver_API.h"

#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 7


/******************************************************************************/
/***						Constant Definitions							***/
/******************************************************************************/

//comparator values
#define RFIC_BIAS_COMPARATOR_HI     (1)
#define RFIC_BIAS_COMPARATOR_LO     (0)

/******************************************************************************/
/***						Type Definitions								***/
/******************************************************************************/

typedef struct 
{
	uint32		lastRunTime;
	CalStatus_e status;
	CalStatus_e statusRpos;
	CalStatus_e statusRneg;
	uint8		Rpos;
	uint8		Rneg;
	uint8		Rint;		// Final calibration result (average bias)
} RficBias_results_t;

typedef struct 
{
	RficBias_results_t results;
}RficBias_elements_t;

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/

/******************************************************************************/
/***					Static Members Declaration							***/
/******************************************************************************/

static RficBias_elements_t	m_rficBias_elements = 
{
	//results
	{
		0, 
		CAL_STATUS_INIT, CAL_STATUS_INIT, CAL_STATUS_INIT, 
		RFIC_CENT_BIAS_RINT_MIN, RFIC_CENT_BIAS_RINT_MIN, RFIC_CENT_BIAS_RINT_MIN 
	}
};

/******************************************************************************/
/***					Private Function Declarations						***/
/******************************************************************************/   
static RetVal_e run(RficBias_elements_t* outElements_p);
////////////////////////
// Methods
////////////////////////
//************************************
// Method:    run
// Purpose:   Run calibration procedure
// Parameter: RficBias_elements_t* outElements_p
// Returns:   RetVal_e - success(RET_VAL_SUCCESS), fail(RET_VAL_FAIL)
//************************************
static RetVal_e run(RficBias_elements_t* outElements_p)
{
	RetVal_e RetFailOk = RET_VAL_SUCCESS;
    return RetFailOk;
}

/********************************************************************************

Method:	RetVal_e calibrateRpos(RficBias_elements_t* outElements_p)

Description:
------------
    
    Calibrate Rpos
  
Input:
-----
			
Output:	Calculated Rpos
-------

Return Value:
-------------
	Success (RET_VAL_SUCCESS), Fail (RET_VAL_FAIL)
	In case of calibration Fail - calibrated Rpos will equal RFIC_DRV_BIAS_RINT_MAX

********************************************************************************/

//************************************
// Method:    RficBias_Calibrate
// Purpose:   Run calibration procedure segments not more than the allocated time
// Parameter: IN ClbrType_e inCalibType - OFFLINE or ONLINE
// Returns:   int32 - success(RET_VAL_SUCCESS), fail(RET_VAL_FAIL)
//************************************
 RetVal_e RficBias_Calibrate(IN ClbrType_e inCalibType)
{
	return run(&m_rficBias_elements);
}

/********************************************************************************

Method:	void RficBias_SetStatus(IN CalStatus_e inStatus)

Description:
------------
    
    Set calibration status
  
Input:
-----
			
Output:
-------

********************************************************************************/
 void RficBias_SetStatus(IN CalStatus_e inStatus)
{
	m_rficBias_elements.results.status = inStatus;
}

/********************************************************************************

Method:	CalStatus_e RficBias_GetStatus(void)

Description:
------------
    
    Get calibration status
  
Input:
-----
			
Output:
-------
	status - Fail_E or Pass_E
	

********************************************************************************/
 CalStatus_e RficBias_GetStatus(void)
{
	return m_rficBias_elements.results.status;
}

/********************************************************************************

Method:	uint32 RficBias_GetLastRunTime(void)

Description:
------------
    
    Get last RFIC bias calibration run time duration
  
Input:
-----
    
			
Output:
-------
	return - run time duration	

********************************************************************************/
 uint32 RficBias_GetLastRunTime(void)
{
	return m_rficBias_elements.results.lastRunTime;
}

/********************************************************************************

Method:	RficBias_LoadResults

Description:
------------
    
    Loads RFIC bias calibration data from a buffer
  
Input:
-----
    param None
			
Output:
-------
	return None

********************************************************************************/
void RficBias_LoadResults(void)
{
    /* Update internal variables with loaded values */
    m_rficBias_elements.results.Rint = ShramClbrDataBufferStoreChanData.rficBiasData.Rint;

    /* Set stored variables to HW */
    RficDriver_SetRintValue(m_rficBias_elements.results.Rint);

#if LM_CALIBRATION_LOGS_ON
    ILOG2_D("RficBias_LoadResults(): Rint=%d", m_rficBias_elements.results.Rint);
#endif

    RficBias_SetStatus(ShramClbrDataBufferStoreChanData.rficBiasData.calStatus);
}


/********************************************************************************

Method:	RficBias_StoreResults

Description:
------------
    
    Stores RFIC bias calibration data to a buffer
  
Input:
-----
    param out_puBuffer Buffer to which to store calibration information	
			
Output:
-------
	return Amount of bytes written to buffer	

********************************************************************************/
uint32* RficBias_GetElement(void)
{
	 return (uint32*)&m_rficBias_elements;
}

 
