#ifndef __RxDcOffsetClbrHndlr_h__
#define __RxDcOffsetClbrHndlr_h__

#include "System_GlobalDefinitions.h"
#include "HdkGlobalDefs.h"
#include "CalibrationDefs.h"
#include "RficDriver_API.h"

#ifdef ENET_INC_ARCH_WAVE600
typedef struct RxDcConfig
{
	uint32 accumNos;
	uint16 analogCalTimeout;
	uint16 accumTimeout;
	uint16 digSuccessThreshold;
	uint8 integratorBw;
	uint8 firstLnaIndex;	
	uint8 lastLnaIndexAnalog;	
	uint8 lastLnaIndexDigital;
	uint8 maxTries;
}RxDcConfig_t;

typedef struct RxDCParams
{
	RxDcConfig_t RxDCconfiguration;
	bool firstOnlineFragment;
	CalStatus_e status[MAX_NUM_OF_ANTENNAS];	
	uint32 lastRunTime;
}RxDCParams_t;

extern RxDCParams_t rxDcParams;
#endif
//************************************
// Method:    RxDcOffset_run
// Purpose:   Run calibration procedure segments not more than the allocated time
// Parameter: IN uint32 time - Allocated time in milliseconds
// Returns:   int32
//************************************
RetVal_e RxDcOffset_Calibrate(IN ClbrType_e calibType);  
//************************************
// Method:    RxDcOffset_LoadResults
// Purpose:   Loads DC calibration data from a buffer
// Parameter: None
// Returns:   None
//************************************
void RxDcOffset_LoadResults(void);

//************************************
// Method:    RxDcOffset_Reset
// Purpose:   TBD
// Parameter: void
// Returns:   void
//************************************
void RxDcOffset_Reset(void);
//************************************
// Method:    RxDcOffset_GetStatusI
// Purpose:   TBD
// Parameter: IN uint32 antenna
// Returns:   CalStatus_e
//************************************
#ifdef ENET_INC_ARCH_WAVE600
CalStatus_e RxDcOffset_GetStatus( IN uint32 antenna);
#else
CalStatus_e RxDcOffset_GetStatus( IN uint32 antenna, IN RficPathTypeIndex_e path);
#endif
//************************************
// Method:    RxDcOffset_SetStatus
// Purpose:   TBD
// Parameter: IN uint32 antenna
// Parameter: IN RficPathTypeIndex_e path
// Parameter: IN CalStatus_e status
// Returns:   void
//************************************
#ifdef ENET_INC_ARCH_WAVE600
void RxDcOffset_SetStatus(uint8 antMask, CalStatus_e status);
#else
void RxDcOffset_SetStatus(IN uint32 antenna, IN RficPathTypeIndex_e path, IN CalStatus_e status);
#endif
//************************************
// Method:    RxDcOffset_GetLastRunTime
// Purpose:   TBD
// Parameter: void
// Returns:   uint32
//************************************
uint32 RxDcOffset_GetLastRunTime(void);
//************************************
// Method:    RxDc_GetElement
// Purpose:   Statistics
// Parameter: None
// Returns:   uint32* pointer to m_RxDcElements 
//************************************
uint32* RxDc_GetElement(void);

void RxDC_ReadPSD(void);
//************************************
// Method:    RxDC_getAddressPerBW
// Purpose:   get address per bw
// Parameter: None
// Returns:   uint32 address to store dc
//************************************
uint32  RxDC_getAddressPerBW(void);
#ifdef ENET_INC_ARCH_WAVE600
void RxDcOffset_CliConfigAnalog(K_MSG* psMsg);
void RxDcOffset_CliConfigDigital(K_MSG* psMsg);
#endif
#endif // __RxDcOffsetClbrHndlr_h__
