/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "RxDcOffsetClbrHndlr.h"
#include "MT_Math.h"
#include "CalibrationHandlerUtils.h"
#include "stringLibApi.h"
#include "PhyDriver_API.h"
#include "PhyCalDriver_API.h"
#include "Afe_API.h"
#include "loggerAPI.h"
#include "MT_Math.h"
#include "mt_sysdefs.h"
#include "mt_sysrst.h"
#include "RegAccess_Api.h"
#include "LmHdk_API.h"
#include "ErrorHandler_Api.h"
#include "mt_sysdefs.h"
#include "CalibrationHandler.h"
#include "Shram_ClbrDataBuffer.h"
#include "mt_sysrst.h"
#include "AFEDefines.h"
#include "PSD.h"
#include "lib_wrx654_api.h"
#include "Pac_Api.h"
#include "RficDriver_API.h"
#include "lib_wav600_api.h"

#define LOG_LOCAL_GID	GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 22

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/

RxDCParams_t rxDcParams = {0};
/******************************************************************************/
/***						MACROs											***/
/******************************************************************************/

/******************************************************************************/
/***					Static Function Declaration							***/
/******************************************************************************/ 
static void RxDcOffset_StoreResults(uint8 antMask);
static void calibrateRxDC(uint8 antMask, ClbrType_e calibType);
static void runAnalogCalibration(uint8 antMask, uint8 lnaIndex);
static void runDigitalCalibration(uint8 antMask, uint8 lnaIndex, ClbrType_e calibType);
static uint8 runVerification(uint8 antMask, uint8 pgcGain, uint8 lnaIndex, int16* dcI, int16* dcQ);
static void initDcParams(uint8 antMask, ClbrType_e calibType);
static void configureRxDcCalibration(uint8 antMask, uint8* storedDifi2Gain, ClbrType_e calibType);
static void configureDigitalforRxDcCalibration(uint8 antMask, uint8* storedDifi2Gain);
static RetVal_e finalizeRxDcCalibration(uint8 antMask, uint8* storedDifi2Gain, ClbrType_e calibType);
RetVal_e run( IN ClbrType_e calibType);


/******************************************************************************/
/***						Functions Definitions							***/
/******************************************************************************/

//************************************
// Method:    run
// Purpose:   Internal master function to execute single algorithm session
// Parameter: IN ClbrType_e calibType - OFFLINE/ONLINE
// Returns:   RetVal_e
//************************************
RetVal_e run( IN ClbrType_e calibType)
{
	uint8 antMask, maxAnts;
	RetVal_e retVal;
	CalDataState_e calStoreState;	 
	uint8 storedDifi2Gain[MAX_NUM_OF_ANTENNAS];
	uint32 startTime = TIME_STAMP(START_TIME,0);
		
#ifdef WRX600_BU_LOGS
	ILOG0_V("run RxDC");
#endif

	HDK_GetMaxActiveAntennasNumAndMask(&maxAnts, &antMask);	
	
	/* Configurations */
	configureRxDcCalibration(antMask, storedDifi2Gain, calibType);

	/* Calibrate */	
	calibrateRxDC(antMask, calibType);

	/* Finalize */
	retVal = finalizeRxDcCalibration(antMask, storedDifi2Gain, calibType);

	/* Store the calibration results */
	ClbrHndlr_GetCalibrationDataState(&calStoreState);
	if(calStoreState == CAL_DATA_STATE_STORE)
	{
		RxDcOffset_StoreResults(antMask);
	}    
	
	rxDcParams.lastRunTime = TIME_STAMP(END_TIME,startTime);
#ifdef WRX600_BU_LOGS
	ILOG0_DD("RxDC Calibration done. elapsed time = %d usec. retVal %d",rxDcParams.lastRunTime, retVal);
#endif
	return retVal;
}
static void calibrateRxDC(uint8 antMask, ClbrType_e calibType)
{
	uint8 lnaIndex;
	
#ifdef WRX600_BU_LOGS
	ILOG0_DDDD("calibrateRxDC. antMask 0x%x firstLnaIndex %d lastLnaIndex(Analog) %d lastLnaIndex(digital) %d", antMask, rxDcParams.RxDCconfiguration.firstLnaIndex, rxDcParams.RxDCconfiguration.lastLnaIndexAnalog, rxDcParams.RxDCconfiguration.lastLnaIndexDigital);
#endif
	for (lnaIndex = rxDcParams.RxDCconfiguration.firstLnaIndex; lnaIndex < rxDcParams.RxDCconfiguration.lastLnaIndexAnalog; lnaIndex++)
	{
		/* Run RFIC calibration */
		runAnalogCalibration(antMask, lnaIndex);
	}
	
	/* Run Digital Cancellation */
	AFE_RxOn(antMask);
	if (CLBR_TYPE_OFFLINE == calibType)
	{
		RxDcOffset_SetStatus(antMask, CAL_STATUS_PASS);
	}
	for (lnaIndex = rxDcParams.RxDCconfiguration.firstLnaIndex; lnaIndex < rxDcParams.RxDCconfiguration.lastLnaIndexDigital; lnaIndex++)
	{	
		runDigitalCalibration(antMask, lnaIndex, calibType);	
	}
	//set initial rx gain for next calibration
	RficDriver_SetRxGains(antMask, TX_INITIAL_LNA_INDEX, TX_INITIAL_PGC_GAIN_DB);
	AFE_RxOff(antMask);
}

static void runAnalogCalibration(uint8 antMask, uint8 lnaIndex)
{	
#ifdef WRX600_BU_LOGS
	ILOG0_DD("runAnalogCalibration. antMask 0x%x lnaIndex %d", antMask, lnaIndex);
#endif
	/* Prepare and run RFIC DC cancellation */
	RficDriver_RunRxDcCal(antMask, lnaIndex, rxDcParams.RxDCconfiguration.analogCalTimeout);
	/* Stop DC cancellation */
	RficDriver_RxDcStopDcCal(antMask);
}

static void runDigitalCalibration(uint8 antMask, uint8 lnaIndex, ClbrType_e calibType)
{
	int8 pgcGainDb = RXDC_PGC_GAIN_FOR_ANALOG_CALIBRATION_DB;
	uint8 repeatCount;
	uint8 antsToCal;
	uint8 digitalSuccessMask;
	CorrOverflow_t corrOf[MAX_NUM_OF_ANTENNAS];
	int16_t dcI[MAX_NUM_OF_ANTENNAS] = {0};
	int16_t dcQ[MAX_NUM_OF_ANTENNAS] = {0};
	int16_t initialDc[MAX_NUM_OF_ANTENNAS] = {0};
		
#ifdef WRX600_BU_LOGS
	ILOG0_DD("runDigitalCalibration. antMask 0x%x lnaIndex %d", antMask, lnaIndex);
#endif

	while (pgcGainDb >= 0)
	{
		antsToCal = antMask;
		repeatCount = 0;
		/* Initialize regs */
		PhyCalDrv_SetDcResultsToPm(antMask, initialDc, initialDc);
		RficDriver_SetRxGains(antMask, lnaIndex, pgcGainDb);
#ifdef WRX600_BU_LOGS
		ILOG0_DD("Set PGC gain(dB) = %d. lnaIndex = %d", pgcGainDb, lnaIndex);
#endif
		while (repeatCount < rxDcParams.RxDCconfiguration.maxTries)
		{
			PhyCalDrv_setDcCancellationMode(antsToCal, FALSE); // Disable digital DC cancellation

			/* Measure Accumulator and set to PHY regs */
			PhyCalDrv_CorrDcMeasureDcAvg(antsToCal,rxDcParams.RxDCconfiguration.accumTimeout, dcI, dcQ, corrOf);
			PhyCalDrv_SetDcResultsToPm(antsToCal, dcI, dcQ);

			/*run verification */
			digitalSuccessMask = runVerification(antsToCal, pgcGainDb, lnaIndex, dcI, dcQ);
			antsToCal &= (~digitalSuccessMask);
#ifdef WRX600_BU_LOGS
			ILOG0_DDDD("try #%d end. lnaIndex %d pgcGainDb %d antsToCal %d", repeatCount, lnaIndex, pgcGainDb, antsToCal);
#endif
			if (antsToCal == 0x0)
			{
				break;
			}
			repeatCount++;
		}
		if (CLBR_TYPE_OFFLINE == calibType)
		{
			RxDcOffset_SetStatus(antsToCal, CAL_STATUS_FAIL);
		}
		pgcGainDb -= 2;
	}
}

static uint8 runVerification(uint8 antMask, uint8 pgcGain, uint8 lnaIndex, int16* dcI, int16* dcQ)
{
	uint8 digitalSuccessMask;

#ifdef WRX600_BU_LOGS
	ILOG0_DD("runVerification. lnaIndex %d pgcGain %d",lnaIndex, pgcGain);
#endif
	PhyCalDrv_setDcCancellationMode(antMask, TRUE); // Enable digital DC cancellation
	
	digitalSuccessMask = PhyCalDrv_RunDcVerification(antMask, dcI, dcQ, rxDcParams.RxDCconfiguration.digSuccessThreshold, pgcGain, lnaIndex);
#ifdef WRX600_BU_LOGS
	ILOG0_D("digitalSuccessMask = 0x%x",digitalSuccessMask);
#endif	
	return digitalSuccessMask;
}
static void configureRxDcCalibration(uint8 antMask, uint8* storedDifi2Gain, ClbrType_e calibType)
{
	/* init DB */
	initDcParams(antMask, calibType);
	
	/* configure RFIC */
	RficDriver_RxDcInit(antMask, rxDcParams.RxDCconfiguration.integratorBw);

	/* configure BBIC */
	configureDigitalforRxDcCalibration(antMask, storedDifi2Gain);
}

static void initDcParams(uint8 antMask, ClbrType_e calibType)
{
	UNUSED_PARAM(antMask);	
	rxDcParams.RxDCconfiguration.accumNos = RXDC_ACCUM_NUM_OF_SAMPLES;
	rxDcParams.RxDCconfiguration.accumTimeout = RXDC_TIMEOUT_FOR_ACCUMULATOR;
	rxDcParams.RxDCconfiguration.digSuccessThreshold = RXDC_SUCCESS_TH;
	rxDcParams.lastRunTime = 0;
	if (calibType == CLBR_TYPE_OFFLINE)
	{
		rxDcParams.RxDCconfiguration.integratorBw = RXDC_INTEGRATOR_BW_OFFLINE;
		rxDcParams.RxDCconfiguration.firstLnaIndex = RXDC_FIRST_LNA_INDEX;		
		rxDcParams.RxDCconfiguration.lastLnaIndexAnalog = RXDC_NUM_OF_LNA_SETTINGS - 1;		
		rxDcParams.RxDCconfiguration.lastLnaIndexDigital= RXDC_NUM_OF_LNA_SETTINGS - 1;		
		rxDcParams.RxDCconfiguration.analogCalTimeout = RXDC_TIMEOUT_FOR_ANALOG_CALIBRATION_OFFLINE;		
		rxDcParams.RxDCconfiguration.maxTries = RXDC_MAX_NUM_OF_TRIES_OFFLINE;	
		rxDcParams.firstOnlineFragment = TRUE;
	}
	else
	{
		rxDcParams.RxDCconfiguration.integratorBw = RXDC_INTEGRATOR_BW_ONLINE;
		rxDcParams.RxDCconfiguration.analogCalTimeout = RXDC_TIMEOUT_FOR_ANALOG_CALIBRATION_ONLINE;		
		rxDcParams.RxDCconfiguration.maxTries = RXDC_MAX_NUM_OF_TRIES_ONLINE;	
		if (rxDcParams.firstOnlineFragment == TRUE)
		{
			rxDcParams.RxDCconfiguration.firstLnaIndex = RXDC_FIRST_LNA_INDEX;			
			rxDcParams.RxDCconfiguration.lastLnaIndexAnalog = RXDC_LAST_LNA_INDEX_FIRST_ONLINE; 	
			rxDcParams.RxDCconfiguration.lastLnaIndexDigital= RXDC_LAST_LNA_INDEX_FIRST_ONLINE;
		}
		else
		{
			rxDcParams.RxDCconfiguration.firstLnaIndex = RXDC_LAST_LNA_INDEX_FIRST_ONLINE;			
			rxDcParams.RxDCconfiguration.lastLnaIndexAnalog = RXDC_NUM_OF_LNA_SETTINGS - 1; 	
			rxDcParams.RxDCconfiguration.lastLnaIndexDigital= RXDC_NUM_OF_LNA_SETTINGS - 1;
		}
	}	
#ifdef WRX600_BU_LOGS
	SLOG0(0, 0, RxDCParams_t, &rxDcParams);
#endif
}

static void configureDigitalforRxDcCalibration(uint8 antMask, uint8* storedDifi2Gain)
{
	uint32 NOS[MAX_NUM_OF_ANTENNAS] = {rxDcParams.RxDCconfiguration.accumNos, rxDcParams.RxDCconfiguration.accumNos, rxDcParams.RxDCconfiguration.accumNos, rxDcParams.RxDCconfiguration.accumNos};
	uint8 DCMode[MAX_NUM_OF_ANTENNAS] = {RXDC_ACCUM_DC_MODE, RXDC_ACCUM_DC_MODE, RXDC_ACCUM_DC_MODE, RXDC_ACCUM_DC_MODE};
	uint8 RssiMode[MAX_NUM_OF_ANTENNAS] = {RXDC_ACCUM_RSSI_MODE, RXDC_ACCUM_RSSI_MODE, RXDC_ACCUM_RSSI_MODE, RXDC_ACCUM_RSSI_MODE};
	uint8 Rate[MAX_NUM_OF_ANTENNAS] = {RXDC_ACCUM_RATE, RXDC_ACCUM_RATE, RXDC_ACCUM_RATE, RXDC_ACCUM_RATE};
	uint8 AccumShift[MAX_NUM_OF_ANTENNAS] = {RXDC_ACCUM_SHIFT, RXDC_ACCUM_SHIFT, RXDC_ACCUM_SHIFT, RXDC_ACCUM_SHIFT}; // Irrelevant in DC mode accumulation
	uint8 difi2Gain[MAX_NUM_OF_ANTENNAS] = {RXDC_DIFI_2_GAIN, RXDC_DIFI_2_GAIN, RXDC_DIFI_2_GAIN, RXDC_DIFI_2_GAIN};

	PhyCalDrv_setDcAccMode(antMask, FALSE); 			// Disable DC accelerator
	PhyCalDrv_setDcCancellationMode(antMask, FALSE);    // Disable digital DC cancellation

	/* Accumulator Init */
	PhyCalDrv_CorrInit(antMask,NOS,DCMode,RssiMode,Rate,AccumShift);
	/* Store current difi 2 gain, use RXDC_DIFI_2_GAIN for calibration */
	PhyCalDrv_getDifi2Gain(antMask, storedDifi2Gain);
	PhyCalDrv_setDifi2Gain(antMask, difi2Gain);
	
#ifdef WRX600_BU_LOGS
	ILOG0_D("configureDigitalforRxDcCalibration. storedDifi2Gain[0] %d",storedDifi2Gain[0]);
#endif
}

static RetVal_e finalizeRxDcCalibration(uint8 antMask, uint8* storedDifi2Gain, ClbrType_e calibType)
{
	RetVal_e retVal = RET_VAL_SUCCESS;
	
	PhyCalDrv_setDifi2Gain(antMask, storedDifi2Gain);
	PhyCalDrv_setDcAccMode(antMask, TRUE); 			// Enable DC accelerator
	PhyCalDrv_setDcCancellationMode(antMask, TRUE); // Enable digital DC cancellation
	if (calibType == CLBR_TYPE_ONLINE)
	{
		if (rxDcParams.firstOnlineFragment == TRUE)
		{
			retVal = RET_VAL_FRAGMENTED;
		}
		rxDcParams.firstOnlineFragment = !rxDcParams.firstOnlineFragment;
	}

	return retVal;
}

void RxDcOffset_LoadResults(void)
{
	// Currently don't store & load, stay with last results and wait for online
	//rfic_set_rxdcoffset (uint8_t AntMsk, int8_t dacI, int8_t dacQ)//should be like rfic_get_rxdcoffset (not I,Q)
	uint8 antMask, maxAnts;
	int8 pgcGainDb = RXDC_PGC_GAIN_FOR_ANALOG_CALIBRATION_DB;
	int8 pgcIndex;
	uint8 lnaIndex;
	int16 dcI[MAX_NUM_OF_ANTENNAS] = {0};
	int16 dcQ[MAX_NUM_OF_ANTENNAS] = {0};
	uint8 ant;
	uint8 bw = HDK_getChannelWidth();
	HDK_GetMaxActiveAntennasNumAndMask(&maxAnts, &antMask);
#ifdef WRX600_BU_LOGS
	ILOG0_D("RxDcOffset_LoadResults antMask:%d",antMask);
#endif
	for (pgcIndex = 0; pgcIndex < RXDC_NUM_OF_PGC_GAINS; pgcIndex++)
	{
		for (lnaIndex = RXDC_FIRST_LNA_INDEX; lnaIndex < (RXDC_NUM_OF_LNA_SETTINGS - 1); lnaIndex++)
		{
			pgcGainDb = 2*pgcIndex;
			for (ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
			{
				if (antMask & (1 << ant))
				{
					dcI[ant] = ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.dcI[lnaIndex][pgcIndex];
					dcQ[ant] = ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.dcQ[lnaIndex][pgcIndex];
#ifdef WRX600_BU_LOGS
//					ILOG0_D("ant:%d",ant);
//					ILOG0_DDDD("pgcGainDb:%d,lnaIndex:%d, i:%d, q:%d",pgcGainDb,lnaIndex,dcI[ant],dcQ[ant]);
#endif
					if (pgcIndex == 0)//enter here only once, not per pgc
					{//to call rfic by rficdriver!!!!!!!!!!!!!!!!!!!! to copy to load rxdc!!!!!!!!!!!!!!!!!!!!!!!!!!
						RficDriver_SetRxdcOffset((1 << ant), lnaIndex, bw, ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.dcAnalog[lnaIndex]);
#ifdef WRX600_BU_LOGS
//						ILOG0_DDD("analog cal, ant:%d,lnaindex:%d reg:%d",ant,lnaIndex,ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.dcAnalog[lnaIndex]);
#endif
						if (RXDC_FIRST_LNA_INDEX == lnaIndex)
						{
#ifdef WRX600_BU_LOGS
//						ILOG0_DD("SetStatus ant:%d status:%d",ant,ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.calStatus);
#endif
							RxDcOffset_SetStatus((1 << ant),ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.calStatus);
						}

					}

				}
			}
			PhyCalDrv_writeRamDCAll(antMask, dcI, dcQ, pgcGainDb, lnaIndex, bw);	
		}
	}
} 




//************************************
// Method:     RxDcOffset_StoreResults
// Purpose:    Stores DC calibration data to a buffer
// Parameter: None
// Returns:     None
//************************************
static void RxDcOffset_StoreResults(uint8 antMask)
{	
	// Currently don't store & load, stay with last results and wait for online
	//rfic_get_rxdcoffset (uint8_t Ant, uint8_t rfrxgainidx, uint8_t rxdcidx)
	int8 pgcGainDb = RXDC_PGC_GAIN_FOR_ANALOG_CALIBRATION_DB;	
	uint8 pgcIndex;
	uint8 lnaIndex;
	int16 dcI[MAX_NUM_OF_ANTENNAS] = {0};
	int16 dcQ[MAX_NUM_OF_ANTENNAS] = {0};
	uint8 ant;
	uint8 bw = HDK_getChannelWidth();
#ifdef WRX600_BU_LOGS
		ILOG0_D("RxDcOffset_StoreResults antMask:%d",antMask);
#endif

	for (pgcIndex = 0; pgcIndex < RXDC_NUM_OF_PGC_GAINS; pgcIndex++)
	{
		for (lnaIndex = RXDC_FIRST_LNA_INDEX; lnaIndex < (RXDC_NUM_OF_LNA_SETTINGS - 1); lnaIndex++)
		{
			pgcGainDb = 2*pgcIndex;
			PhyCalDrv_readRamDC(antMask, dcI, dcQ, pgcGainDb, lnaIndex, bw);	
			for (ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
			{
				if (antMask & (1 << ant))
				{
					ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.dcI[lnaIndex][pgcIndex]=dcI[ant];
					ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.dcQ[lnaIndex][pgcIndex]=dcQ[ant];
#ifdef WRX600_BU_LOGS
//					ILOG0_D("!!!!!!!!!readRamDC importent to compare cal results ant:%d",ant);
//					ILOG0_DDDD("pgcGainDb:%d,lnaIndex:%d, i:%d, q:%d",pgcGainDb,lnaIndex,dcI[ant],dcQ[ant]);				
#endif
					if (pgcIndex == 0)//enter here only once, not per pgc
					{//to call rfic by rficdriver!!!!!!!!!!!!!!!!!!!! to copy to load rxdc!!!!!!!!!!!!!!!!!!!!!!!!!!
						ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.dcAnalog[lnaIndex] = RficDriver_GetRxdcOffset(ant, lnaIndex, bw);
#ifdef WRX600_BU_LOGS
//						ILOG0_DDD("analog cal, ant:%d,lnaindex:%d reg:%d",ant,lnaIndex,ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.dcAnalog[lnaIndex]);
#endif
						if (RXDC_FIRST_LNA_INDEX == lnaIndex)
						{
#ifdef WRX600_BU_LOGS
//						ILOG0_DDD("status, ant:%d reg:%d, curent status:%d",ant,ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.calStatus,RxDcOffset_GetStatus(ant));
#endif
							ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxDcData.calStatus = RxDcOffset_GetStatus(ant);

						}
					}

				}
			}
		}
	}

	ClbrHndlr_UpdateCalState(CLBR_PROC_TYPE_RX_DC_OFFSET, TRUE);    
} 

RetVal_e RxDcOffset_Calibrate( IN ClbrType_e calibType )
{
	return run(calibType);
}

void RxDcOffset_SetStatus(uint8 antMask, CalStatus_e status)
{
	uint8 ant;
	
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if ((1 << ant) & antMask)
		{
			rxDcParams.status[ant] = status;
		}
	}
}

CalStatus_e RxDcOffset_GetStatus( IN uint32 antenna)
{
	return rxDcParams.status[antenna];
}

uint32 RxDcOffset_GetLastRunTime(void)
{
	return rxDcParams.lastRunTime;
}

void RxDcOffset_CliConfigAnalog(K_MSG* psMsg)
{	
	RxDcConfig_t *rxDcConfig = (RxDcConfig_t *)pK_MSG_DATA(psMsg);
	
	rxDcParams.RxDCconfiguration.integratorBw	   = rxDcConfig->integratorBw;
	rxDcParams.RxDCconfiguration.analogCalTimeout = rxDcConfig->analogCalTimeout;
}
void RxDcOffset_CliConfigDigital(K_MSG* psMsg)
{	
	RxDcConfig_t *rxDcConfig = (RxDcConfig_t *)pK_MSG_DATA(psMsg);
	
	rxDcParams.RxDCconfiguration.accumNos 		= rxDcConfig->accumNos;
	rxDcParams.RxDCconfiguration.accumTimeout  = rxDcConfig->accumTimeout;
	rxDcParams.RxDCconfiguration.digSuccessThreshold = rxDcConfig->digSuccessThreshold;
	rxDcParams.RxDCconfiguration.maxTries      = rxDcConfig->maxTries;
}

