#ifndef __RxIQMismatchClbrHndlr_h__
#define __RxIQMismatchClbrHndlr_h__

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "CalibrationDefs.h"
#include "CalibrationHandlerStatistics.h"
#include "HdkGlobalDefs.h"
#include "PhyCalDriver_API.h"

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
typedef enum ClbrIteration
{
	CLBR_ITERATION_OFFLINE,
	CLBR_ITERATION_FIRST_ONLINE,
	CLBR_ITERATION_SECOND_ONLINE,
	CLBR_ITERATION_MAX_ONLINE
} ClbrIteration_e;

/******************************************************************************/
/***						structs Defines								***/
/******************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
#define DEBUG_RXIQ_SIZE 	(80)
#define DEBUG_RXIQ_RUNTIME 	(DEBUG_RXIQ_SIZE>>3)
#define RXIQ_NLMS_VERIFY_NUM_OF_BINS	5
#define RXIQ_NLMS_PASS_CRITERIA			47
#define RXIQ_NLMS_PASS_CRITERIA_160		45
typedef struct RxIQWs
{
	uint16 w1[MAX_NUM_OF_ANTENNAS];	
	int16 w2[MAX_NUM_OF_ANTENNAS];	
}RxIQWs_t;

typedef struct RxIQDefaultFromPSD
{
	RxIQWs_t rxIqDefaultCh36;
	RxIQWs_t rxIqDefaultCh100;
	uint32 threshold;
	uint8 paramsAreInitialized;
}RxIQDefaultFromPSD_t;

typedef struct RxIQParams
{
	CorrResRxIq_t lastAccumResults[MAX_NUM_OF_ANTENNAS];
	CalStatus_e status[MAX_NUM_OF_ANTENNAS];
	RxIQWs_t nominalWs;
	uint32 lastRunTime;
	uint32 numberOfSamplesToCalibrate;
	int16 imrDbLast[MAX_NUM_OF_ANTENNAS];
	uint16 accumTimeout;
	ClbrIteration_e iterationType;
	int8 successThreshold;
	uint8 maxNumOfTries;
}RxIQParams_t;


typedef struct DebugRxIq
{
	int16 imrDb[MAX_NUM_OF_ANTENNAS];
	uint8 bw;// = HDK_getChannelWidth();
	uint8 channel; //HDK_getLowChannel()
	uint8 antMask;
}DebugRxIq_t;

typedef struct Debug_NLMS
{
	int16 imrDb[MAX_NUM_OF_ANTENNAS];
	GoertzelRes_t Results[MAX_NUM_OF_ANTENNAS];
	uint8 bw;// = HDK_getChannelWidth();
	uint8 channel; //HDK_getLowChannel()
	uint8 antMask;
	uint8 pgcIdx;
	uint32 reserved;
}Debug_NLMS_t;

typedef struct RxIQ_NLMS_Params
{
	int isCalibrated[MAX_NUM_OF_BW];
	uint32 lastRunTime[DEBUG_RXIQ_RUNTIME];
	uint8 p_failedAntMask[MAX_NUM_OF_BW][RXIQ_NUM_OF_PGC_GAINS];
	
} RxIQ_NLMS_Params_t;

typedef struct XTalkParams
{
	uint8 maxNumOfTries;

}XTalkParams_t;

typedef struct Debug_Xtalk
{
	int32 xtalk[RFIC_PATH_TYPE_MAX][MAX_NUM_OF_ANTENNAS];
	int32 xtalkVerify[RFIC_PATH_TYPE_MAX][MAX_NUM_OF_ANTENNAS];
}Debug_Xtalk_t;

extern RxIQDefaultFromPSD_t rxIqDefaultFromPSD;
#endif

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/

/******************************************************************************/
/***					 Public Function Declarations						***/
/******************************************************************************/
//************************************
// Method:    RxIQ_Calibrate
// Purpose:   Run calibration procedure segments not more than the allocated time
// Parameter: IN ClbrType_e inCalibType - OFFLINE or ONLINE
// Returns:   RetVal_e
//************************************
 RetVal_e  RxIQ_Calibrate(IN ClbrType_e inCalibType);
RetVal_e RxIQ_Calibrate_NLMS(IN ClbrType_e inCalibType);

//************************************
// Method:    RxIQ_SetStatus
// Purpose:   Set calibration status of given antenna
// Parameter: 
//			uint32 inAntenna
//			CalStatus_e inStatus
// Returns:   void
//************************************
#ifdef ENET_INC_ARCH_WAVE600
 void RxIQ_SetStatus(uint8 antMask, IN CalStatus_e inStatus);
#else
 void RxIQ_SetStatus(IN uint32 inAntenna, IN CalStatus_e inStatus);
#endif
//************************************
// Method:    RxIQ_GetStatus
// Purpose:   Set calibration status of given antenna
// Parameter: 
//			uint32 inAntenna
// Returns:   CalStatus_e - E_Fail or E_Pass
//************************************
 CalStatus_e RxIQ_GetStatus( IN uint32 inAntenna );
//************************************
// Method:    RxIQ_GetLastRunTime
// Purpose:   Get last RXIQ mismatch calibration run time duration
// Parameter: None
// Returns:   Run time duration
//************************************
 uint32 RxIQ_GetLastRunTime(void);
//************************************
// Method:    RxIQ_LoadResults
// Purpose:   Loads RXIQ calibration data from a buffer
// Parameter: uint8 * in_puBuffer - Buffer containing calibration information
// Returns:   uint32 - Amount of bytes read from buffer
//************************************
 void RxIQ_LoadResults(void);
 void RxIQ_NLMS_LoadResults(void);
 void RxIQ_Xtalk_LoadResults(void);
 uint32* RxIQ_GetElement(void);
  


 #endif // __RxIQMismatchClbrHndlr_h__
