
/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <System_Configuration.h>
#include <PhyDriver_API.h>

#include <lmi.h>
#include <lm.h>
#include "RegAccess_Api.h"
#include "MT_Math.h"
#include <CalibrationHandler.h>
#include "CalibrationHandlerUtils.h"
#include "CalibrationHandlerStatistics.h"
#include "RxIQMismatchClbrHndlr.h"
#include "mt_sysrst.h"
#include "RficDriver_API.h"
#include "Afe_API.h"
#include "PhyCalDriver_API.h"
#include "Shram_ClbrDataBuffer.h"
#include "mhi_dut.h"
#include "lib_wrx654_api.h"
#include "loggerAPI.h"
#include "Pac_Api.h"
#include "stringLibApi.h"

#define LOG_LOCAL_GID   GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 23


#define DEBUG_THRESHOLD   			(50)

/******************************************************************************/
/***						Constant Definitions										  ***/
/******************************************************************************/


/******************************************************************************/
/***						Type Definitions											  ***/
/******************************************************************************/	
//w1w2 params 
RxIQDefaultFromPSD_t rxIqDefaultFromPSD;
RxIQParams_t rxiqParams = {0};

//nlms params
RxIQ_NLMS_Params_t rxiqNlmsParams = {0};

//xtalk params
XTalkParams_t xTalkParamas = {0};

//w1w2 debug params 

#define DEBUG_NLMS_RESULT_SIZE 80
CorrResRxIq_t Results_debug_first_measure[DEBUG_NLMS_RESULT_SIZE][MAX_NUM_OF_ANTENNAS];
CorrResRxIq_t Results_debug_verify[DEBUG_NLMS_RESULT_SIZE][MAX_NUM_OF_ANTENNAS];
int index_debug = 0;
int index_bug = 0;
int index_channel[DEBUG_NLMS_RESULT_SIZE];
DebugRxIq_t DebugRxIq1[DEBUG_RXIQ_SIZE];
int DebugRxIq1_index = 0;
uint16 AFE_regVal[32][5];
int rxIq_bug_global = 0;

//nlms debug params
#define DEBUG_NLMS_SIZE 60
Debug_NLMS_t DebugNLMS[DEBUG_NLMS_SIZE];
int16 imrDbAll[DEBUG_NLMS_SIZE][RXIQ_NLMS_VERIFY_NUM_OF_BINS][MAX_NUM_OF_ANTENNAS];
int DebugNLMS_index = 0;

#define XTALK_DEBUG_FLAG 0
#if (XTALK_DEBUG_FLAG)
#define   MAX_INDEX 	80
Debug_Xtalk_t Debugxtalk[MAX_INDEX];
int Debugxtalk_index=0;
#endif
/******************************************************************************/
/***						Macros													  ***/
/******************************************************************************/


									
/******************************************************************************/
/***					Private Function Declarations									  ***/
/******************************************************************************/   
static RetVal_e run_NLMS(ClbrType_e inCalibType);
static RetVal_e run(ClbrType_e inCalibType);
static void RxIQ_NLMS_StoreResults(uint8 antMask);
static void RxIQ_StoreResults(uint8 antMask);
#ifdef SDL_IGNORE_UNUSED_FUNCTION
static void  RxIQ_ResetOfflineStatus(void);
static void calcAdaptGain(uint8 antMask, int32* PgcAdaptiveGain,int32* Calc_PWR, int8 TargetPWR, uint8 PGC_Gain);
static void findAdaptiveGain(uint8 antMask);
static void calcImrr(uint8 antMask, RxIQWs_t* Ws, RxIQWs_t* prevWs, int32* imrr);
#endif

/* W1 W2 Calibration */
static RetVal_e runW1W2Calibration(uint8 antMask, ClbrType_e inCalibType);
static RetVal_e runNLMSCalibration(uint8 antMask, ClbrType_e inCalibType);
static void initNLMSCalibration(uint8 antMask, ClbrType_e inCalibType, uint8* storedDifi2Gain);
static void initW1W2Calibration(uint8 antMask, ClbrType_e inCalibType, RxIQWs_t* PrevWs, uint8* detectorResetTh, uint8* detector11b, bool* FrcStatus, bool* PhyFDLStatus);
static void RxIq_CorrInit(uint8 antMask);

static void calcIMRAll(uint8 antMask, int16* IMRdB, CorrResRxIq_t* Results);
static int32 calcIMR(CorrResRxIq_t* Result);
static void calcIMRAllGoertzel(uint8 antMask, int16* IMRdB, GoertzelRes_t* Results);
static uint32 calcIMRGoertzel(GoertzelRes_t* Result_out);
static void RxIq_CorrInit(uint8 antMask);
static void configureRficForNLMSCalibration(uint8 antMask);
static void configurePhyForNLMSCalibration(uint8 antMask, uint8* storedDifi2Gain);
static void configureRficForW1W2Calibration(uint8 antMask);
static void configurePhyForW1W2Calibration(uint8 antMask);
static void restoreRficFromNLMSCalibration(uint8 antMask);
static void restorePhyFromNLMSCalibration(uint8 antMask, uint8* storedDifi2Gain);

static void restoreRficFromW1W2Calibration(uint8 antMask);
static void restorePhyFromW1W2Calibration(uint8 antMask, uint8 detectorResetTh, uint8 detector11b, bool* FrcStatus, bool* PhyFDLStatus);
static uint8 getNumberOfAnt(uint8 antMask);
static void verifyNLMSCalibrationResults(uint8* failedAntMask, int pgc_idx, uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS]);
static void NLMSAlgorithm(uint8 antMask, uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS]);
static void calibrateNLMS(uint8* antMask);
static void calibrateW1W2(uint8* antMask, RxIQWs_t* prevWs);
static RetVal_e finishNLMSCalibration(uint8 antMask, uint8 failedMask,uint8* storedDifi2Gain);
static RetVal_e finishW1W2Calibration(uint8 antMask, uint8 failedMask, RxIQWs_t* prevWs, uint8 detectorResetTh, uint8 detector11b, bool* FrcStatus, bool* PhyFDLStatus);
static void verifyW1W2CalibrationResults(uint8* antMask, RxIQWs_t* prevWs, RxIQWs_t* setWs);
static void calcWs(uint8 antMask, CorrResRxIq_t* corrRes, RxIQWs_t* Ws);
static void calcW1(CorrResRxIq_t* corrRes,int32 inW2, int32 *outW1_p);
static void setRxIQParams(ClbrType_e inCalibType);
static void handleFailure(uint8 failedMask, RxIQWs_t* prevWs);
//crosstalk
#ifdef SDL_IGNORE_UNUSED_FUNCTION
static RetVal_e runXTalkCalibration( ClbrType_e inCalibType);
static void initXTalkCalibration(uint8 antMask, ClbrType_e inCalibType, uint8* storedDifi2Gain);
static void configureRficForXTalkCalibration(uint8 antMask);
static void configurePhyForXTalkCalibration(uint8 antMask, uint8* storedDifi2Gain);
static void restoreRficFromXTalkCalibration(uint8 antMask);
static void restorePhyFromXTalkCalibration(uint8 antMask, uint8* storedDifi2Gain);
static void xTalkMeasureEnergy(uint8 antMask, int pgc_idx, int8 kFixed_ram[RFIC_PATH_TYPE_MAX][RXIQ_NUM_OF_PGC_GAINS][MAX_NUM_OF_ANTENNAS]);
static void calibrateXTalk(uint8* antMask);
static RetVal_e finishXTalkCalibration(uint8 antMask, uint8 failedMask, uint8* storedDifi2Gain);
static void verifyXTalkCalibrationResults(uint8* antMask, uint8 kFixed[RFIC_PATH_TYPE_MAX][MAX_NUM_OF_ANTENNAS]);
static void setXTalkParams(ClbrType_e inCalibType);
#endif

/********************************************************************************
Method:	run
Description: - Execute RX IQ calibration using air noise (Open rx path in RFIC)
---------
Input:
-----
Output: - RxIQRF_elements_t* outElements_p 
------
Returns: - RetVal_e - 		RET_VAL_SUCCESS - verify success
-------		                   RET_VAL_FAIL - verify fail
*******************************************************************************/
static RetVal_e run_NLMS(ClbrType_e inCalibType)
{
	RetVal_e ret = RET_VAL_SUCCESS;
	uint8 rxAntMask, numOfAnts;
    CalDataState_e calStoreState;
	uint32 startTime = TIME_STAMP(START_TIME,0);
	uint8 bw = HDK_getChannelWidth();
	int debug_runTimeIndex;
	/* NLMS calibration */
	//no return value yet
#ifdef WRX600_BU_LOGS
	ILOG0_DD("run RxIQ nlms bw:%d isCalibrated:%d",bw,rxiqNlmsParams.isCalibrated[bw]);
#endif
	HDK_GetMaxActiveAntennasNumAndMask(&numOfAnts, &rxAntMask);
	if (FALSE == rxiqNlmsParams.isCalibrated[bw])
    {
		runNLMSCalibration(rxAntMask, inCalibType);//always return success for now
		rxiqNlmsParams.isCalibrated[bw]=TRUE;
		debug_runTimeIndex=DebugNLMS_index/11;
		rxiqNlmsParams.lastRunTime[debug_runTimeIndex] = TIME_STAMP(END_TIME,startTime);
    }

	/* Store calibration results */
	ClbrHndlr_GetCalibrationDataState(&calStoreState);
	if((calStoreState == CAL_DATA_STATE_STORE) && (CLBR_TYPE_OFFLINE == ClbrHndlr_GetClbrType()))
	{
		RxIQ_NLMS_StoreResults(rxAntMask);
	}

	
	return(ret);
}

static RetVal_e run(ClbrType_e inCalibType)
{
	RetVal_e ret = RET_VAL_SUCCESS;
    CalDataState_e calStoreState;
	uint8 rxAntMask, numOfAnts;	
	uint32 startTime = TIME_STAMP(START_TIME,0);

#ifdef WRX600_BU_LOGS
	ILOG0_V("run RxIQ");
#endif
	
    // Get the enabled RX antennas

	HDK_GetMaxActiveAntennasNumAndMask(&numOfAnts, &rxAntMask);

	/* W1,W2 calibration */
	ret = runW1W2Calibration(rxAntMask, inCalibType);
	
	/* Store calibration results */
	ClbrHndlr_GetCalibrationDataState(&calStoreState);
	if((calStoreState == CAL_DATA_STATE_STORE) && (CLBR_TYPE_OFFLINE == ClbrHndlr_GetClbrType()))
	{
		RxIQ_StoreResults(rxAntMask);
	}
	
	rxiqParams.lastRunTime = TIME_STAMP(END_TIME,startTime);
#ifdef WRX600_BU_LOGS
	ILOG0_DD("RxIQ ALGO:Finished Calibration. Ret Code = %d, Run Time = %d", ret, rxiqParams.lastRunTime);
#endif
	return(ret);
}

static RetVal_e runNLMSCalibration(uint8 antMask, ClbrType_e inCalibType)
{
		uint8 storedDifi2Gain[MAX_NUM_OF_ANTENNAS];
		uint8 failedAntMask = antMask;
		RetVal_e ret = RET_VAL_SUCCESS;
		
#ifdef WRX600_BU_LOGS
		ILOG0_D("runNLMSCalibration. antMask 0x%x",antMask);
#endif	
		/* Initialize */
		initNLMSCalibration(antMask, inCalibType, storedDifi2Gain);
		
		/* Calibrate */
		calibrateNLMS(&failedAntMask);
		
		/* Finish */	
		ret = finishNLMSCalibration(antMask, failedAntMask, storedDifi2Gain);
		
#ifdef WRX600_BU_LOGS
		ILOG0_DD(" retVal %d failedAntMask 0x%x",ret, failedAntMask);
#endif	
	
		return ret;
}

uint32 counterAdc = 0;
static RetVal_e runW1W2Calibration(uint8 antMask, ClbrType_e inCalibType)
{
	uint8 failedAntMask = antMask;
	RetVal_e ret = RET_VAL_SUCCESS;
	uint8 tryCounter = 0;
	RxIQWs_t PrevWs = {0};

	uint8 detectorResetTh;
	uint8 detector11b;
	bool FrcStatus[MAX_NUM_OF_ANTENNAS];
	bool PhyFDLStatus[MAX_NUM_OF_ANTENNAS];
	int ant;
	
#ifdef WRX600_BU_LOGS
	ILOG0_D("runW1W2Calibration. antMask 0x%x",antMask);
#endif	
	/* Initialize */
	
	initW1W2Calibration(antMask, inCalibType, &PrevWs, &detectorResetTh, &detector11b, FrcStatus, PhyFDLStatus);

#ifndef	ENET_INC_ARCH_WAVE600B
	if(counterAdc == 0)
	{
		rfic_rxoff(antMask);
		PhyCalDrv_enableCalMode(TRUE);
		AFE_ADC_Calibration();
		rfic_rxon(antMask);
		counterAdc++;
	}
#endif	
	for ( ant = 0; ant < 4; ant++)//debug
	{
		ILOG0_DDDD("!!!! w1,36:%d w2,36:%d,w1,100:%d,w2,100:%d",rxIqDefaultFromPSD.rxIqDefaultCh36.w1[ant],rxIqDefaultFromPSD.rxIqDefaultCh36.w2[ant],rxIqDefaultFromPSD.rxIqDefaultCh100.w1[ant],rxIqDefaultFromPSD.rxIqDefaultCh100.w2[ant]);
		ILOG0_D("threshold: %d",rxIqDefaultFromPSD.threshold);
		ILOG0_D("threshold low: %d",RXIQ_INITIAL_W1_VALUE-rxIqDefaultFromPSD.threshold);
		ILOG0_D("threshold high: %d",RXIQ_INITIAL_W1_VALUE+rxIqDefaultFromPSD.threshold);
	}
	while((failedAntMask != 0) && (tryCounter < rxiqParams.maxNumOfTries))
	{
#ifdef WRX600_BU_LOGS
		ILOG0_DD("failedAntMask 0x%x, tryCounter %d",failedAntMask, tryCounter);
#endif	
		/* Calibrate */
		calibrateW1W2(&failedAntMask, &PrevWs);
		tryCounter++;
	}
	
	/* Finish */	
	ret = finishW1W2Calibration(antMask, failedAntMask, &PrevWs, detectorResetTh, detector11b, FrcStatus, PhyFDLStatus);
	
#ifdef WRX600_BU_LOGS
	ILOG0_DDD(" retVal %d failedAntMask 0x%x, tryCounter %d",ret, failedAntMask, tryCounter);
#endif	

	return ret;
}


static void initNLMSCalibration(uint8 antMask, ClbrType_e inCalibType, uint8* storedDifi2Gain)
{
	UNUSED_PARAM(inCalibType);
	
	/* Configure RFIC */
	configureRficForNLMSCalibration(antMask);
	
	/* Configure BBIC */
	configurePhyForNLMSCalibration(antMask, storedDifi2Gain);
}



static void initW1W2Calibration(uint8 antMask, ClbrType_e inCalibType, RxIQWs_t* PrevWs, uint8* detectorResetTh, uint8* detector11b, bool* FrcStatus, bool* PhyFDLStatus)
{
	/* Set RxIQ Database */
	setRxIQParams(inCalibType);
	
	/* store a copy of the last W1,W2 values for a case of online failure */
	if (rxiqParams.iterationType != CLBR_ITERATION_OFFLINE)
	{
		PhyCalDrv_RxIQGetWCoeffs(antMask, HDK_getChannelWidth(), PrevWs->w1, PrevWs->w2);
	}
	//AFE_RxOff
	PhyCalDrv_resetRxtd(TRUE);
	PhyCalDrv_resetRxtd(FALSE);
	PhyCalDrv_enableRxtdFifo(FALSE);
	PhyCalDrv_enableRxtdFifo(TRUE);

	//PhyCalDrv_enableDetector(FALSE);

	PhyCalDrv_GetBypassFrcStatus(antMask, FrcStatus);
	PhyCalDrv_BypassFrc(antMask, TRUE);
	PhyCalDrv_GetBypassFdlStatus(antMask, PhyFDLStatus);
	PhyCalDrv_BypassFdl(antMask, TRUE);
	*detectorResetTh = PhyCalDrv_GetDetectorResetTh();
	PhyCalDrv_SetDetectorResetTh(RXIQ_XTALK_DETECTOR_THRESHOLD);
	*detector11b = PhyCalDrv_Get11bDetectorState();
	PhyCalDrv_Enable11bDetector(FALSE);
	PhyCalDrv_resetChannelFilter();
	PhyCalDrv_enableCalMode(TRUE);

	/* Configure RFIC */
	configureRficForW1W2Calibration(antMask);
	
	/* Configure BBIC */
	configurePhyForW1W2Calibration(antMask);
	
}
#ifdef SDL_IGNORE_UNUSED_FUNCTION
static void calcAdaptGain(uint8 antMask, int32* PgcAdaptiveGain,int32* Calc_PWR, int8 TargetPWR, uint8 PGC_Gain)
{
	int ant;
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if(1<<ant & antMask)
        {
			PgcAdaptiveGain[ant]=20;//((PGC_Gain + TargetPWR - Calc_PWR[ant])/2)*2;//make it even work around

			if (PgcAdaptiveGain[ant]>20)
			{
#ifdef WRX600_BU_LOGS
				ILOG0_DDD("glick Error!!!! PgcAdaptiveGain[%d]:%d is big,Calc_PWR:%d ",ant,PgcAdaptiveGain[ant],Calc_PWR[ant]);
#endif
				PgcAdaptiveGain[ant] = 20;
			}
			else if (PgcAdaptiveGain[ant]<0)
			{
#ifdef WRX600_BU_LOGS
				ILOG0_DDD("glick Error!!!! PgcAdaptiveGain[%d]:%d is small,Calc_PWR:%d",ant,PgcAdaptiveGain[ant],Calc_PWR[ant]);
#endif
				PgcAdaptiveGain[ant] = 0;//to change to 0
			}
#ifdef WRX600_BU_LOGS
				ILOG0_DDD("calcAdaptGain PgcAdaptiveGain[%d]:%d,Calc_PWR:%d",ant,PgcAdaptiveGain[ant],Calc_PWR[ant]);
#endif
		}
	}
}



static void findAdaptiveGain(uint8 antMask)
{
	uint32 nos[MAX_NUM_OF_ANTENNAS] 	  = {RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES, RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES,RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES,RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES};
	uint8 DCMode[MAX_NUM_OF_ANTENNAS]	  = {RXIQ_ACCUM_DC_MODE, RXIQ_ACCUM_DC_MODE, RXIQ_ACCUM_DC_MODE, RXIQ_ACCUM_DC_MODE};
	uint8 RssiMode[MAX_NUM_OF_ANTENNAS]   = {RXIQ_ACCUM_RSSI_MODE, RXIQ_ACCUM_RSSI_MODE, RXIQ_ACCUM_RSSI_MODE, RXIQ_ACCUM_RSSI_MODE};
	uint8 Rate[MAX_NUM_OF_ANTENNAS] 	  = {RXIQ_ACCUM_RATE, RXIQ_ACCUM_RATE, RXIQ_ACCUM_RATE, RXIQ_ACCUM_RATE};
	uint8 AccumShift[MAX_NUM_OF_ANTENNAS] = {RXIQ_ACCUM_SHIFT, RXIQ_ACCUM_SHIFT, RXIQ_ACCUM_SHIFT, RXIQ_ACCUM_SHIFT};
	uint8 ant;
	uint8 bw = HDK_getChannelWidth();
#ifdef ENET_INC_ARCH_WAVE600B
	uint8 band =  HDK_getBand();
#endif
	/*int32 Calc_PWR[MAX_NUM_OF_ANTENNAS] = {0};
	int32 PgcAdaptiveGain[MAX_NUM_OF_ANTENNAS];
	CorrResRxIq_t Results[MAX_NUM_OF_ANTENNAS] = {0};
	CorrOverflow_t corrOf[MAX_NUM_OF_ANTENNAS] = {0};
	int16 numerator;
	int16 denominator;
	uint8 bw = HDK_getChannelWidth(); 

	// Accumulator config 
	PhyCalDrv_CorrInit(antMask, nos, DCMode, RssiMode, Rate, AccumShift);
	MT_DELAY(800/(20 << bw));

	//TBD - Calc_PWR=getAccum();//PhyCalDrv_CorrMeasure
	PhyCalDrv_CorrMeasure(antMask, RXIQ_VERIFICATION_ACCUM_TIMEOUT, Results, corrOf);

	//Calc_PWR//doesnt work yet
    for (ant=0;ant<MAX_NUM_OF_ANTENNAS;ant++)
    {  
        if(1<<ant & antMask)
        {
            if(Results[ant].II<0)
                return;
            numerator = MATH_10Log10Res((uint32)Results[ant].II, ADAPTIVE_GAIN_LOG_RESOLUTION);
            denominator = THREE_DB_FACTOR*DERESOLUTION_NUM_BITS*(1<<ADAPTIVE_GAIN_LOG_RESOLUTION)+ MATH_10Log10Res(ADAPTIVE_GAIN_DENOMINATOR_VALUE,ADAPTIVE_GAIN_LOG_RESOLUTION);//12=3dB*4
            Calc_PWR[ant] = (numerator-denominator);
            //DBGPwr = Pwr;
            Calc_PWR[ant] = ((Calc_PWR[ant] +ADAPTIVE_GAIN_LOG_ROUND)>>ADAPTIVE_GAIN_LOG_RESOLUTION)+ ADAPTIVE_GAIN_OFFSET;//-Difi_GAIN;// Factor of -3db needed to compensate wave504 DiFi gain of 3dB
           // Pwr = -(Pwr+10);//Additional 3dB backoff due to wave504 ADC clipping problem
            //DBGtest = Pwr;
            //Pwr = PWR_TO_GAIN_INDEX(Pwr);//need to open this
        }

	}
	//no need for this:
	calcAdaptGain(antMask, PgcAdaptiveGain,Calc_PWR, RXIQ_TARGET_POWER, RXIQ_PGC_GAIN_DB);//out PgcAdaptiveGain, in Calc_PWR
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
#ifdef WRX600_BU_LOGS
		ILOG0_DD("findAdaptiveGain. PgcAdaptiveGain[%d]:%d",ant, PgcAdaptiveGain[ant]);
#endif	
		if (antMask & (1 << ant))
		{
			RficDriver_SetRxGains((antMask & (1 << ant)), 0, PgcAdaptiveGain[ant]);
		}
	}
	
	MT_DELAY(800/(20 << bw));	*/
	//prepare for real measure
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		nos[ant] = rxiqParams.numberOfSamplesToCalibrate;
	}
#ifdef ENET_INC_ARCH_WAVE600B
	if (BAND_2_4_GHZ == band )
	{
		for (ant=0; ant<MAX_NUM_OF_ANTENNAS;ant++)
		{
			AccumShift[ant] = RXIQ_ACCUM_SHIFT_600B;
		}
	}
	if (BANDWIDTH_EIGHTY == bw)
	{
		for (ant=0; ant<MAX_NUM_OF_ANTENNAS;ant++)
		{
			AccumShift[ant] = RXIQ_ACCUM_SHIFT_160;
		}
	}
#endif
	if (BANDWIDTH_ONE_HUNDRED_SIXTY == bw)
	{
		for (ant=0; ant<MAX_NUM_OF_ANTENNAS;ant++)
		{
			AccumShift[ant] = RXIQ_ACCUM_SHIFT_160;
		}
	}
	PhyCalDrv_CorrInit(antMask, nos, DCMode, RssiMode, Rate, AccumShift);

}
#endif

static void RxIq_CorrInit(uint8 antMask)
{
		uint32 nos[MAX_NUM_OF_ANTENNAS] 	  = {RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES, RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES,RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES,RXIQ_ADAPTIVE_GAIN_NUM_OF_SAMPLES};
		uint8 DCMode[MAX_NUM_OF_ANTENNAS]	  = {RXIQ_ACCUM_DC_MODE, RXIQ_ACCUM_DC_MODE, RXIQ_ACCUM_DC_MODE, RXIQ_ACCUM_DC_MODE};
		uint8 RssiMode[MAX_NUM_OF_ANTENNAS]   = {RXIQ_ACCUM_RSSI_MODE, RXIQ_ACCUM_RSSI_MODE, RXIQ_ACCUM_RSSI_MODE, RXIQ_ACCUM_RSSI_MODE};
		uint8 Rate[MAX_NUM_OF_ANTENNAS] 	  = {RXIQ_ACCUM_RATE, RXIQ_ACCUM_RATE, RXIQ_ACCUM_RATE, RXIQ_ACCUM_RATE};
		uint8 AccumShift[MAX_NUM_OF_ANTENNAS] = {RXIQ_ACCUM_SHIFT, RXIQ_ACCUM_SHIFT, RXIQ_ACCUM_SHIFT, RXIQ_ACCUM_SHIFT};
		uint8 ant;
		uint8 bw = HDK_getChannelWidth();
#ifdef ENET_INC_ARCH_WAVE600B
		uint8 band =  HDK_getBand();
#endif
		
		//prepare for real measure
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			nos[ant] = rxiqParams.numberOfSamplesToCalibrate;
		}
#ifdef ENET_INC_ARCH_WAVE600B
		if (BAND_2_4_GHZ == band )
		{
			for (ant=0; ant<MAX_NUM_OF_ANTENNAS;ant++)
			{
				AccumShift[ant] = RXIQ_ACCUM_SHIFT_600B;
			}
		}
		if (BANDWIDTH_EIGHTY == bw)
		{
			for (ant=0; ant<MAX_NUM_OF_ANTENNAS;ant++)
			{
				AccumShift[ant] = RXIQ_ACCUM_SHIFT_160;
			}
		}
#endif
		if (BANDWIDTH_ONE_HUNDRED_SIXTY == bw)
		{
			for (ant=0; ant<MAX_NUM_OF_ANTENNAS;ant++)
			{
				AccumShift[ant] = RXIQ_ACCUM_SHIFT_160;
			}
		}
		PhyCalDrv_CorrInit(antMask, nos, DCMode, RssiMode, Rate, AccumShift);

}

static void configureRficForNLMSCalibration(uint8 antMask)
{
	// RFIC Tx off, Rx on
	RficDriver_DeactivateTxAntennas(antMask);	
	RficDriver_ActivateRxAntennas(antMask);
	RficDriver_setAntennaFectlMan(antMask, RXIQ_NLMS_FRCTL);
}

static void configurePhyForNLMSCalibration(uint8 antMask, uint8* storedDifi2Gain)
{
	uint8 difi2Gain[MAX_NUM_OF_ANTENNAS] = {RXIQ_NLMS_DIFI_2_GAIN, RXIQ_NLMS_DIFI_2_GAIN, RXIQ_NLMS_DIFI_2_GAIN, RXIQ_NLMS_DIFI_2_GAIN};
	uint32 zeros[MAX_NUM_OF_BW][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS]={0};
	uint8 bw = HDK_getChannelWidth();
	uint8 iirShift = RXIQ_IIR_SHIFT - bw;//to update the define

	AFE_RxOff(antMask);
	
	//AFE_RxOff
	PhyCalDrv_resetRxtd(TRUE);
	PhyCalDrv_resetRxtd(FALSE);
	PhyCalDrv_enableRxtdFifo(FALSE);
	PhyCalDrv_enableRxtdFifo(TRUE);
	
	PhyCalDrv_getDifi2Gain(antMask, storedDifi2Gain);
	PhyCalDrv_setDifi2Gain(antMask, difi2Gain);
	PhyCalDrv_enableDifiGain(antMask, FALSE);
	PhyCalDrv_enableADC(TRUE);
	PhyCalDrv_enableDetector(FALSE);
	PhyCalDrv_resetChannelFilter();
	PhyCalDrv_setFirMode(antMask, TRUE);
	PhyCalDrv_setBypassRamCoeffs (antMask, TRUE);
	PhyCalDrv_setIIRShift(antMask, iirShift);
	PhyCalDrv_setIIRMode(antMask, TRUE);

	// Bypass RxIQ blocks if they aren't calibrated
	PhyCalDrv_setXtalkMode(antMask, FALSE);
	PhyCalDrv_setDecorrelatorMode(antMask, FALSE);// Bypass W1W2 decorrelator
	PhyCalDrv_setFdlMode(antMask, FALSE);

	PhyCalDrv_setIqDelays(antMask, RXIQ_NLMS_EQ_LENGTH, RXIQ_NLMS_IQ_FIR_DELAY);
	PhyCalDrv_setFirCoeffsToProgmodel(antMask, zeros);
	AFE_RxOn(antMask);
	PhyCalDrv_EnableGclkBypass(TRUE);
	PhyCalDrv_LmsReset();
	AFE_TxOn(antMask);
}

static void configureRficForW1W2Calibration(uint8 antMask)
{	
	// RFIC Tx off, Rx on
	RficDriver_DeactivateTxAntennas(antMask);	
	RficDriver_ActivateRxAntennas(antMask);
	// Enable LNA noise, disable LNA
	RficDriver_EnableLnaNoise(antMask);	
	// Set FEM
	RficDriver_setRffeMode(T_STATE_MODE,antMask);
	// Set gains
	RficDriver_SetRxGains(antMask, RXIQ_LNA_INDEX, RXIQ_PGC_GAIN_DB);
}

static void configurePhyForW1W2Calibration(uint8 antMask)
{
	uint8 bw = HDK_getChannelWidth();
	uint32 pCoeffs[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS];

	uint8 iirDelay = MAX(RXIQ_IIR_MIN_DELAY, 40 - (DELAY_CHANGE_PER_BW * bw));
	uint8 iirShift = RXIQ_IIR_SHIFT - bw;

	PhyCalDrv_resetDifiGain(antMask);
	PhyCalDrv_enableDifiGain(antMask, FALSE);
	// AFE
	AFE_TxOff(antMask);
	AFE_RxOn(antMask);
	// Enable IIR
	PhyCalDrv_setIIRShift(antMask, iirShift);
	PhyCalDrv_setIIRMode(antMask, TRUE);

	//Wait for the IIR to settle
	MT_Delay(iirDelay);

	// Bypass RxIQ blocks if they aren't calibrated
	PhyCalDrv_setXtalkMode(antMask, FALSE);

	if (TRUE == rxiqNlmsParams.isCalibrated[bw])
	{
		PhyCalDrv_readRamFirCoeffs( antMask, pCoeffs, bw, RXIQ_PGC_GAIN_DB >> 1);
		PhyCalDrv_setFirCoeffsToProgmodel(antMask, pCoeffs);
		PhyCalDrv_setFirMode(antMask, TRUE);
		PhyCalDrv_setBypassRamCoeffs (antMask, TRUE);
	}
	else
	{
		PhyCalDrv_setFirMode(antMask, FALSE);
	}
	//PhyCalDrv_setFirMode(antMask, FALSE);
	PhyCalDrv_setFdlMode(antMask, FALSE);
	
	// Bypass W1W2 decorrelator
	PhyCalDrv_setDecorrelatorMode(antMask, FALSE);


}

static void restoreRficFromNLMSCalibration(uint8 antMask)
{
	RficDriver_EnableLna(antMask);
	RficDriver_disableRffeManMode(antMask);
	RficDriver_disableBbloop(antMask, HDK_getBand());
	RficDriver_ActivateRxAntennas(antMask);

}
static void restorePhyFromNLMSCalibration(uint8 antMask, uint8* storedDifi2Gain)
{
	AFE_RxOff(antMask);
	AFE_RxOn(antMask);
	PhyCalDrv_setDifi2Gain(antMask, storedDifi2Gain);
	PhyCalDrv_setIIRMode(antMask, FALSE);
	PhyCalDrv_enableDetector(TRUE);
	PhyCalDrv_EnableGclkBypass(FALSE);
	PhyCalDrv_setDecorrelatorMode(antMask, TRUE);// Bypass W1W2 decorrelator
}

static void restoreRficFromW1W2Calibration(uint8 antMask)
{
	// Disable LNA noise, enable LNA
	RficDriver_DisableLnaNoise(antMask);
	RficDriver_disableRffeManMode(antMask);
}
static void restorePhyFromW1W2Calibration(uint8 antMask, uint8 detectorResetTh, uint8 detector11b, bool* FrcStatus, bool* PhyFDLStatus)
{
	int ant;
	PhyCalDrv_enableDifiGain(antMask, TRUE);
	// Bypass IIR
	PhyCalDrv_setIIRMode(antMask, FALSE);
	PhyCalDrv_enableCalMode(FALSE);
	//PhyCalDrv_enableDetector(TRUE);
	//
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (antMask & (1 << ant))
		{
			PhyCalDrv_BypassFrc((1 << ant), FrcStatus[ant]);
			PhyCalDrv_BypassFdl((1 << ant), PhyFDLStatus[ant]);
		}
	}
	PhyCalDrv_SetDetectorResetTh(detectorResetTh);
	PhyCalDrv_Enable11bDetector(detector11b);
	PhyCalDrv_setBypassRamCoeffs (antMask, FALSE);
	//
}

static uint8 getNumberOfAnt(uint8 antMask)
{
	uint8 counter=0;
	int i;
	for (i=0; i<MAX_NUM_OF_ANTENNAS ; i++)
	{
		if( (1<<i) & antMask)
		{
			counter++;
		}
	}
	return counter;
}

static void NLMSAlgorithm(uint8 antMask, uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS])
{
	int NLMS_iter=0;
	uint32 startTime;
	uint32 timeDiff = 0;
	uint32 pErrorInd_rtrn[MAX_NUM_OF_ANTENNAS]={0};
	uint8 pErrorValid_rtrn[MAX_NUM_OF_ANTENNAS]={0};
	uint16 Steps[RXIQ_NLMS_ITERATIONS] = {8192, 8192, 4096, 2048, 2048};
	uint8 Mu[RXIQ_NLMS_ITERATIONS] = {12, 11, 10, 9, 8 };
	//uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS];
	uint8 NumOfAntToCalibrate = getNumberOfAnt(antMask);
	uint8 NumOfErrorValid=0;
	int i;
	uint8 FullAntMask, fullNumOfAnts;
	HDK_GetMaxActiveAntennasNumAndMask(&fullNumOfAnts, &FullAntMask);
	for ( NLMS_iter=0; NLMS_iter < RXIQ_NLMS_ITERATIONS; NLMS_iter++)
	{
		PhyCalDrv_setLmsParams(antMask, TRUE , Steps[NLMS_iter], Mu[NLMS_iter], RXIQ_NLMS_ALFA);
		PhyCalDrv_startLmsCycle(antMask);
		startTime = Pac_TimGetTsfLow();
		while ((NumOfAntToCalibrate != NumOfErrorValid) && (timeDiff < RXIQ_NLMS_TIMEOUT_LMS_OFFLINE))
		{
			NumOfErrorValid=0;
			timeDiff = Pac_TimGetTsfLow() - startTime;
			PhyCalDrv_getLmsErrorIndicator(antMask, pErrorInd_rtrn, pErrorValid_rtrn);
			for (i=0;i<MAX_NUM_OF_ANTENNAS;i++)
			{
				if (1 == pErrorValid_rtrn[i])
				{
					NumOfErrorValid++;
				}
			}
			ASSERT(NumOfErrorValid <= NumOfAntToCalibrate)
		}
		ASSERT((timeDiff < RXIQ_NLMS_TIMEOUT_LMS_OFFLINE))//maybe to enlarge RXIQ_TIMEOUT_LMS_OFFLINE
		//now lms setteled
		PhyCalDrv_getFirCoeffs(FullAntMask, pCoeffs_rtrn);
		PhyCalDrv_setFirCoeffsToProgmodel(FullAntMask, pCoeffs_rtrn);
		PhyCalDrv_setLmsCalMode(antMask,FALSE);
		PhyCalDrv_LmsReset();
	}	
}


static void verifyNLMSCalibrationResults(uint8* failedAntMask, int pgc_idx, uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS])
{	
	uint8 bw = HDK_getChannelWidth();
	uint8 bin = 30<<bw;
	uint32 goertzelLength[MAX_NUM_OF_ANTENNAS] = {RXIQ_NLMS_GRTZL_LENGTH, RXIQ_NLMS_GRTZL_LENGTH, RXIQ_NLMS_GRTZL_LENGTH, RXIQ_NLMS_GRTZL_LENGTH};
	uint8 goertzelCycles[MAX_NUM_OF_ANTENNAS] = {RXIQ_NLMS_GRTZL_NUM_OF_CYCLES, RXIQ_NLMS_GRTZL_NUM_OF_CYCLES, RXIQ_NLMS_GRTZL_NUM_OF_CYCLES, RXIQ_NLMS_GRTZL_NUM_OF_CYCLES};
	int16 digGain[MAX_NUM_OF_ANTENNAS] = {0};//{RXIQ_NLMS_DIGGAIN, RXIQ_NLMS_DIGGAIN, RXIQ_NLMS_DIGGAIN, RXIQ_NLMS_DIGGAIN};
	int16 digGainPerPgc[RXIQ_NUM_OF_PGC_GAINS] = {255,255,255,225,150,100,75,50,30,20,15};
	int16 goertzelBin[MAX_NUM_OF_ANTENNAS] = {0};
	GoertzelRes_t Results[MAX_NUM_OF_ANTENNAS];
	int16 imrDb[RXIQ_NLMS_VERIFY_NUM_OF_BINS][MAX_NUM_OF_ANTENNAS] = {0};
	uint8 passCriteria[RXIQ_NLMS_VERIFY_NUM_OF_BINS]={RXIQ_NLMS_PASS_CRITERIA,RXIQ_NLMS_PASS_CRITERIA,RXIQ_NLMS_PASS_CRITERIA,RXIQ_NLMS_PASS_CRITERIA,RXIQ_NLMS_PASS_CRITERIA};
	int ant;
	int binIndex;

	PhyCalDrv_enableToneGen(FALSE);
	for ( binIndex = 0; binIndex < RXIQ_NLMS_VERIFY_NUM_OF_BINS; binIndex++)
	{
		bin = ((20<<bw)>>1) + (((20<<bw)>>2)*binIndex);//for bw20 bins: 10,15,20,25,30 for bw40 bins: 20,30,40,50,60, for bw80 bins:40,60,80,100,120. for bw160 bins: 80,120,160,200,240
		//bin = 30<<bw;
		for ( ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			goertzelBin[ant]=bin;
			digGain[ant]=digGainPerPgc[pgc_idx];
		}
		
		PhyCalDrv_RunToneGen(*failedAntMask, bin, RXIQ_NLMS_SCALE, digGain);
		// Configure Goertzel
		PhyCalDrv_GoertzelConfig(*failedAntMask, goertzelLength, goertzelCycles, goertzelBin, goertzelBin);
		MT_Delay(500);//to settel goertzel 100 micro is not enough
		PhyCalDrv_GoertzelMeasure(*failedAntMask, RXIQ_NLMS_GRTZL_TIMEOUT, Results);

		PhyCalDrv_enableToneGen(FALSE);
		calcIMRAllGoertzel(*failedAntMask, &imrDb[binIndex][0], Results);
	}
//debug

	for (ant=0; ant<MAX_NUM_OF_ANTENNAS; ant++)
	{
		if ((*failedAntMask) & (1 << ant))
		{
			MEMCPY(&DebugNLMS[DebugNLMS_index].Results[ant], &Results[ant], sizeof(GoertzelRes_t)); //KW_FIX_FW_G
			DebugNLMS[DebugNLMS_index].imrDb[ant] = imrDb[0][ant];
			for (binIndex=0; binIndex<RXIQ_NLMS_VERIFY_NUM_OF_BINS; binIndex++)
			{
				imrDbAll[DebugNLMS_index][binIndex][ant]=imrDb[binIndex][ant];
			}
		}
	}
//end debug
	if  (3==bw)
	{
		passCriteria[0] = RXIQ_NLMS_PASS_CRITERIA_160;
		passCriteria[1] = RXIQ_NLMS_PASS_CRITERIA_160;
		passCriteria[2] = RXIQ_NLMS_PASS_CRITERIA_160;
		passCriteria[3] = RXIQ_NLMS_PASS_CRITERIA_160;
		//passCriteria[4] = 43;
	}
	for ( ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if ((*failedAntMask) & (1 << ant))
		{

			if ((imrDb[0][ant] > passCriteria[0]) && (imrDb[1][ant] > passCriteria[1]) && (imrDb[2][ant] > passCriteria[2]) && (imrDb[3][ant] > passCriteria[3]))
			{
				// Calibration passed. remove antenna from failed mask 		
				PhyCalDrv_writeRamFirCoeffs( 1<<ant, pCoeffs_rtrn, bw, pgc_idx);//write to ram
				*failedAntMask &= (~(1 << ant));
#ifdef WRX600_BU_LOGS
				ILOG0_DD("NLMS ant %d passed.  imrDb %d",ant,imrDb[ant]);
#endif				
			}
			else
			{
#ifdef WRX600_BU_LOGS
				ILOG0_DD("NLMS ant %d fail.  imrDb %d",ant,imrDb[ant]);
#endif	
			}
		}
	}
	
}

static void calibrateNLMS(uint8* antMask)
{
	uint8 tryCounter = 0;

	uint8 bw = HDK_getChannelWidth();
	uint8 iirDelay = MAX(RXIQ_IIR_MIN_DELAY, 40 - (DELAY_CHANGE_PER_BW * bw));
	uint32 zeros[MAX_NUM_OF_BW][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS]={0};
	int16 digGain[MAX_NUM_OF_ANTENNAS] = {0};//{RXIQ_NLMS_DIGGAIN, RXIQ_NLMS_DIGGAIN, RXIQ_NLMS_DIGGAIN, RXIQ_NLMS_DIGGAIN};
	int16 digGainPerPgc[RXIQ_NUM_OF_PGC_GAINS] = {255,255,255,225,150,100,75,50,30,20,15};
	uint8 failedAntMask=*antMask;
	uint32 pCoeffs_rtrn[MAX_NUM_OF_ANTENNAS][RXIQ_NLMS_NUM_OF_ENABLED_COEFFS];
	int pgc_idx = 0;
	int16 bins[RXIQ_NLMS_NUM_OF_BINS]={-256,-225,-193,-161,-129,-97,-65,-33,-1,31,63,94,126,158,190,222,254};
	int ant;
	/*for ( i = 0; i < RXIQ_NLMS_NUM_OF_BINS; i++)
	{
		bins[i] = (-(20<<bw)*16)/10 + ((i*319)/(1<<(3-bw)))/10;
	}*/
	for( pgc_idx = 0; pgc_idx < RXIQ_NUM_OF_PGC_GAINS; pgc_idx++)
	{
		for ( ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			digGain[ant]=digGainPerPgc[pgc_idx];
		}
		RficDriver_SetRxGains(*antMask, RXIQ_NLMS_LNA_GAIN_INDEX, 2*pgc_idx);
		AFE_RxOff(*antMask);
		RficDriver_DeactivateRxAntennas(*antMask);
		RficDriver_enableBbloop(*antMask, HDK_getBand(), RXIQ_NLMS_LOOP_TYPE, RXIQ_NLMS_IQ_SELECTION);
		AFE_RxOn(*antMask);
		PhyCalDrv_EnableGclkBypass(TRUE);
		
		//Wait for the IIR to settle
		MT_Delay(iirDelay);
		PhyCalDrv_EnableTpcAccelerator(*antMask, FALSE);

		failedAntMask=*antMask;
		tryCounter = 0;
		while((failedAntMask != 0) && (tryCounter < RXIQ_NLMS_OFFLINE_MAX_NUM_OF_TRIES))
		{
#ifdef WRX600_BU_LOGS
			ILOG0_DDD("failedAntMask 0x%x, tryCounter %d, pgc_idx:%d",failedAntMask, tryCounter, pgc_idx);
#endif	

			//nlms algorithm
			PhyCalDrv_setFirCoeffsToProgmodel(failedAntMask, zeros);

			PhyCalDrv_RunMultiToneGen(bins, RXIQ_NLMS_NUM_OF_BINS, RXIQ_NLMS_SCALE, digGain, failedAntMask);
			
			//Enable Coeffs
			PhyCalDrv_setValidCoeffs(*antMask,RXIQ_NLMS_NUM_OF_ENABLED_COEFFS);
			//Set Ram Bypass
			PhyCalDrv_setBypassRamCoeffs (*antMask,TRUE);
			/* Calibrate */
			NLMSAlgorithm(failedAntMask, pCoeffs_rtrn);
			verifyNLMSCalibrationResults(&failedAntMask, pgc_idx, pCoeffs_rtrn);
			tryCounter++;
		}
		DebugNLMS[DebugNLMS_index].pgcIdx=pgc_idx;
		DebugNLMS[DebugNLMS_index].antMask=failedAntMask;
		DebugNLMS[DebugNLMS_index].bw = HDK_getChannelWidth();
		DebugNLMS[DebugNLMS_index].channel = HDK_getLowChannel();
		DebugNLMS[DebugNLMS_index].reserved= tryCounter;
		DebugNLMS_index++;
		if (DebugNLMS_index == DEBUG_NLMS_SIZE)
		{
			DebugNLMS_index = 0;
		}
		rxiqNlmsParams.p_failedAntMask[bw][pgc_idx]=failedAntMask;//global dump debug
	}
}

static void calibrateW1W2(uint8* antMask, RxIQWs_t* prevWs)
{
	CorrResRxIq_t Results[MAX_NUM_OF_ANTENNAS] = {0};
	CorrOverflow_t corrOf[MAX_NUM_OF_ANTENNAS] = {0};
	RxIQWs_t Ws = {0};
	uint8 antMaskOf = 0;
	uint8 ant;
	uint8 bw = HDK_getChannelWidth();
	//RxIQWs_t nominalWs;
	uint8 ch = HDK_getLowChannel();
#ifdef WRX600_BU_LOGS
	ILOG0_DD("calibrateW1W2. antMask 0x%x bw %d",*antMask, bw);
#endif	
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (*antMask & (1 << ant))
		{
			if ((ch == 100) && (bw == BANDWIDTH_ONE_HUNDRED_SIXTY))
			{
				rxiqParams.nominalWs.w1[ant] = rxIqDefaultFromPSD.rxIqDefaultCh100.w1[ant]; 		
				rxiqParams.nominalWs.w2[ant] = rxIqDefaultFromPSD.rxIqDefaultCh100.w2[ant];
			}
			else
			{
				rxiqParams.nominalWs.w1[ant] = rxIqDefaultFromPSD.rxIqDefaultCh36.w1[ant]; 		
				rxiqParams.nominalWs.w2[ant] = rxIqDefaultFromPSD.rxIqDefaultCh36.w2[ant];
			}
		}
	}
	RxIq_CorrInit(*antMask);
	//Set nominalWs W1,W2 and enable decorrelator 
	PhyCalDrv_RxIQSetWCoeffs(*antMask, bw, rxiqParams.nominalWs.w1, rxiqParams.nominalWs.w2);
	PhyCalDrv_CorrMeasureRxIq(*antMask, rxiqParams.accumTimeout, Results, corrOf);
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (*antMask & (1 << ant))
			{
			Results_debug_first_measure[index_debug][ant].II=Results[ant].II;
			Results_debug_first_measure[index_debug][ant].QQ=Results[ant].QQ;
			Results_debug_first_measure[index_debug][ant].IQ=Results[ant].IQ;
			if ((rxiqParams.iterationType == CLBR_ITERATION_FIRST_ONLINE) || (rxiqParams.iterationType == CLBR_ITERATION_OFFLINE))
			{
				rxiqParams.lastAccumResults[ant].II = Results[ant].II;
				rxiqParams.lastAccumResults[ant].QQ = Results[ant].QQ;
				rxiqParams.lastAccumResults[ant].IQ = Results[ant].IQ;
			}
			else if (rxiqParams.iterationType == CLBR_ITERATION_SECOND_ONLINE)
			{
				Results[ant].II += rxiqParams.lastAccumResults[ant].II;
				Results[ant].QQ += rxiqParams.lastAccumResults[ant].QQ;
				Results[ant].IQ += rxiqParams.lastAccumResults[ant].IQ;
			}
			// Check for overflow
			if ((corrOf[ant].iiOf) || (corrOf[ant].qqOf) || (corrOf[ant].iqOf))
			{
				antMaskOf |= (1 << ant);
			}
		}
	}
#ifdef WRX600_BU_LOGS
	ILOG0_D("overflowed mask 0x%x",antMaskOf);
#endif	
	// In first online period, just measure and quit
	if (rxiqParams.iterationType == CLBR_ITERATION_FIRST_ONLINE)
	{
		*antMask = 0;
		return;
	}

	// Clear overflowed antennas from mask in order to ignore them in rest of the calibration
	*antMask &= (~antMaskOf);
	// Calculate W1 and W2 coeffs
	calcWs(*antMask, Results, &Ws);

	//Set W1,W2 and enable decorrelator	
	PhyCalDrv_RxIQSetWCoeffs(*antMask, bw, Ws.w1, Ws.w2);

	PhyCalDrv_setDecorrelatorMode(*antMask, TRUE);

	verifyW1W2CalibrationResults(antMask, prevWs, &Ws);

	// Return overflowed antennas to mask in order to recalibrate them in the next trial
	*antMask |= antMaskOf;
}

static RetVal_e finishNLMSCalibration(uint8 antMask, uint8 failedMask,uint8* storedDifi2Gain)
{
	
	RetVal_e ret = RET_VAL_SUCCESS;

	UNUSED_PARAM(failedMask);
	/*if (failedMask != 0)//it is not true here, since there is verifier per pgc
	{
		ret = RET_VAL_FAIL;
	}*/
	
	/* Restore BBIC */
	restorePhyFromNLMSCalibration(antMask, storedDifi2Gain);
	
	/* Restore RFIC */
	restoreRficFromNLMSCalibration(antMask);
	return ret;
}


static RetVal_e finishW1W2Calibration(uint8 antMask, uint8 failedMask, RxIQWs_t* prevWs, uint8 detectorResetTh, uint8 detector11b, bool* FrcStatus,bool* PhyFDLStatus)
{

	RetVal_e ret = RET_VAL_SUCCESS;
	
	if (failedMask != 0)
	{
		ret = RET_VAL_FAIL;
		handleFailure(failedMask, prevWs);
	}
	if (rxiqParams.iterationType == CLBR_ITERATION_FIRST_ONLINE)
	{
		ret = RET_VAL_FRAGMENTED;
	}

	/* Increase iteration type */
	rxiqParams.iterationType++;
	if (rxiqParams.iterationType == CLBR_ITERATION_MAX_ONLINE)
	{
		// End of second online fragment
		rxiqParams.iterationType = CLBR_ITERATION_FIRST_ONLINE;
	}

	/* Set status in DB */
	RxIQ_SetStatus(antMask & failedMask, CAL_STATUS_FAIL);
	RxIQ_SetStatus(antMask & (~failedMask), CAL_STATUS_PASS);
	
	/* Restore BBIC */
	restorePhyFromW1W2Calibration(antMask,detectorResetTh,detector11b,FrcStatus,PhyFDLStatus);
	
	/* Restore RFIC */
	restoreRficFromW1W2Calibration(antMask);

	return ret;
}

/*************************************************************************************

Method: verifyW1W2CalibrationResults

Input:
	inRxAntMask

Output: 
	outElements_p

Return:
	RetVal_e - 
		success(RET_VAL_SUCCESS) - if the the W1,W2 coeff are good (the deflection si less than errorPercentageW)
		fail(RET_VAL_FAIL) - if coefficients are not good

Description:	this function compares the W1,W2 after cal (supposed to be W1 =1 ,W2 = 0)
				in deflection of errorPercentageW and returns status respectively .

*************************************************************************************/
static void verifyW1W2CalibrationResults(uint8* antMask, RxIQWs_t* prevWs, RxIQWs_t* setWs)
{		
	CorrResRxIq_t Results[MAX_NUM_OF_ANTENNAS];
	CorrOverflow_t corrOf[MAX_NUM_OF_ANTENNAS];
	RxIQWs_t Ws = {0};
	RxIQWs_t nominalWs;
	int16 imrDb[MAX_NUM_OF_ANTENNAS] = {0};		
	int16 onlineImrr[MAX_NUM_OF_ANTENNAS];	
	uint8 ant;
	int bug= 0;
	int i;
	int j;
	UNUSED_PARAM(prevWs);	
#ifdef WRX600_BU_LOGS
	ILOG0_DD("verifyW1W2CalibrationResults. iterationType %d antMask 0x%x",rxiqParams.iterationType, *antMask);
	//DEBUG_ASSERT(rxiqParams.iterationType != CLBR_ITERATION_FIRST_ONLINE);
#endif
	/* Initialize nominal Ws */
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (*antMask & (1 << ant))
		{
			nominalWs.w1[ant] = RXIQ_INITIAL_W1_VALUE;			
			nominalWs.w2[ant] = RXIQ_INITIAL_W2_VALUE;
		}
	}
		
	/* Accumulator config */
	PhyCalDrv_SetCorrNos(*antMask,RXIQ_VERIFICATION_ACCUM_NUM_OF_SAMPLES);//maybe to change with: void PhyCalDrv_CorrInit(uint8 antMask, uint32* nos, uint8* dcMode, uint8* rssiMode, uint8* rate, uint8* shift)
	/* Accumulator measurement */
	PhyCalDrv_CorrMeasureRxIq(*antMask, RXIQ_VERIFICATION_ACCUM_TIMEOUT, Results, corrOf);

	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if ((*antMask) & (1 << ant))
		{

			Results_debug_verify[index_debug][ant].II=Results[ant].II;
			Results_debug_verify[index_debug][ant].QQ=Results[ant].QQ;
			Results_debug_verify[index_debug][ant].IQ=Results[ant].IQ;
		}
	}
	index_debug++;
	if (index_debug == DEBUG_NLMS_RESULT_SIZE)
	{
		index_debug = 0;
	}
	
	/* Calc W1, W2 */
	calcWs(*antMask, Results, &Ws);
	/* Calc IMRR */
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{		
		if ((*antMask) & (1 << ant))
		{
			if ((Results[ant].II < DEBUG_THRESHOLD) || (Results[ant].QQ < DEBUG_THRESHOLD))
			{
				if (0==index_bug)//to save abb registers
				{
					for (j=0; j<32;j++)
					{
						AFE_ReadRegister(0x40+j,AFE_regVal[j]);
					}
				}
				bug=1;
				rxIq_bug_global=1;
				index_channel[index_bug]=HDK_getLowChannel();
				index_bug++;
				if (index_bug == DEBUG_NLMS_RESULT_SIZE)
				{
					index_bug = 0;
				}
				//ASSERT(0);
			}
		}
	}
	if (bug==0)
	{
		calcIMRAll(*antMask, imrDb, Results);
		DebugRxIq1[DebugRxIq1_index].antMask=*antMask;
		DebugRxIq1[DebugRxIq1_index].bw = HDK_getChannelWidth();
		DebugRxIq1[DebugRxIq1_index].channel = HDK_getLowChannel();
		for (i=0;i<4;i++)
			DebugRxIq1[DebugRxIq1_index].imrDb[i] = imrDb[i];
		DebugRxIq1_index++;
		if (DebugRxIq1_index == DEBUG_RXIQ_SIZE)
		{
			DebugRxIq1_index = 0;
		}
	}
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{		
		if ((*antMask) & (1 << ant))
		{
			ILOG0_DD("+++,ant:%d w1:%d ",ant,setWs->w1[ant]);
			ILOG0_D("threshold low: %d",RXIQ_INITIAL_W1_VALUE-rxIqDefaultFromPSD.threshold);
			ILOG0_D("threshold high: %d",RXIQ_INITIAL_W1_VALUE+rxIqDefaultFromPSD.threshold);
			if ((Results[ant].II < DEBUG_THRESHOLD) || (Results[ant].QQ < DEBUG_THRESHOLD))
			{

			}
			else if ((setWs->w1[ant] < (RXIQ_INITIAL_W1_VALUE-rxIqDefaultFromPSD.threshold)) || (setWs->w1[ant] > (RXIQ_INITIAL_W1_VALUE+rxIqDefaultFromPSD.threshold)))
			{
				rxiqParams.imrDbLast[ant] = imrDb[ant];
#ifdef WRX600_BU_LOGS
				ILOG0_DD("ant %d failed. imrDb %d",ant,imrDb[ant]);
				ILOG0_DD("!!!!threshold from psd failed,ant:%d w1:%d ",ant,setWs->w1[ant]);
#endif
			}
			else if (imrDb[ant] <= rxiqParams.successThreshold)
			{
				if (rxiqParams.iterationType == CLBR_ITERATION_SECOND_ONLINE)
				{
					/* Calc IMRR relative to previous Ws */
					calcIMRAll(*antMask, onlineImrr, Results);
					//calcImrr(*antMask, &Ws, prevWs, onlineImrr);//should be relative to prevWs
					if (onlineImrr[ant] < rxiqParams.successThreshold)
					{						
						// Fail
#ifdef WRX600_BU_LOGS
						ILOG0_DD("ant %d failed in relative test. imrDb %d",ant,imrDb[ant]);
#endif				
						continue;
					}
				}
				/* Calibration passed. remove antenna from failed mask */
				*antMask &= (~(1 << ant));

#ifdef WRX600_BU_LOGS
				ILOG0_DD("ant %d passed.  imrDb %d",ant,imrDb[ant]);
#endif				
			}
			else
			{
				rxiqParams.imrDbLast[ant] = imrDb[ant];
#ifdef WRX600_BU_LOGS
				ILOG0_DD("ant %d failed. imrDb %d",ant,imrDb[ant]);
#endif				
			}
		}
	}
}
static void calcWs(uint8 antMask, CorrResRxIq_t* corrRes, RxIQWs_t* Ws)
{ 	
	int32 W1[MAX_NUM_OF_ANTENNAS];
	int32 W2[MAX_NUM_OF_ANTENNAS];
	uint8 ant;
	
#ifdef WRX600_BU_LOGS
	ILOG0_D("calcWs. antMask(without oveflowed antennas): 0x%x",antMask);
#endif
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (antMask & (1 << ant))
		{
			MATH_LongDivision_DenomUint(corrRes[ant].IQ, corrRes[ant].QQ, RXIQ_W2_NUM_RES_BITS, &W2[ant]);
			
			calcW1(&corrRes[ant], W2[ant], &W1[ant]);
			Ws->w1[ant] = (uint16)W1[ant];
			Ws->w2[ant] = (int16)W2[ant];
		}
	}
#ifdef WRX600_BU_LOGS
	SLOG0(0, 0, RxIQWs_t, Ws);
#endif
}
static void calcW1(CorrResRxIq_t* corrRes,int32 inW2, int32 *outW1_p)
{
	int16 i,Delta;
	int64 a,b,denominator,Result;
	int32 prev_step,curr_step,next_step;
	int64 W2_64b,expected_IQ_64b;
	int32 num_of_frac_bits,num_res_bits;
	uint32 numerator;

	num_of_frac_bits = RXIQ_W1_NUM_FRAC_BITS;
	num_res_bits = RXIQ_W2_NUM_RES_BITS;

	numerator = corrRes->QQ;
	W2_64b = inW2;				   	// extension from 32bit -> 64 bit.
	expected_IQ_64b = corrRes->IQ; 		// extension from 32bit -> 64 bit.

	denominator = corrRes->II - ((W2_64b*expected_IQ_64b+(1<<(num_res_bits-1)))>>num_res_bits); // must add the normalized factor !!!
										//,and before the shifting,need to add half from the division resolution(round)
	Result = 1<<(num_of_frac_bits);		// requested value is between 0-2,and in fixed point (12bit) its between 0-8192,so we will start in the middle 2^12(4096)
	Delta   = 1<<(num_of_frac_bits-1);	//2048 is the first step that we need if we start from 4096 and our range is 8192 
	i = 0;	

	b=numerator;
	b<<=(2*num_of_frac_bits); 			// this is the right side of the equation
							  			//must split this action in two ,because "numerator" is just 32 bit and "b" is 64.

	while (i < num_of_frac_bits)
	{   
		a=Result*Result*denominator;
				
		if (a<b) 
		{
			Result += Delta; 			//'b' bigger than 'a', need to add a value to 'a'
		} 
		else
		{
			Result -= Delta;
		}
		Delta >>= 1;
		++i;  
	}
	
	// check if the best value is one step near	
	prev_step = Abs((int32)((Result-1)*(Result-1)*denominator-b));
	curr_step = Abs((int32)(Result*Result*denominator-b));
	next_step = Abs((int32)((Result+1)*(Result+1)*denominator-b));

	if (curr_step > next_step)
	{
		Result+=1;
	} 
	else if (curr_step > prev_step)
	{
		Result-=1;
	}
	
	*outW1_p =  (int32)Result;
}


#define TX_IQ_ENERGY_LOG_RESOLUTION			(5)
#define IMR_RESOLUTION_BITS					(26)
#define IMR_RESOLUTION_dB	  				(3 * IMR_RESOLUTION_BITS)

static void calcIMRAll(uint8 antMask, int16* IMRdB, CorrResRxIq_t* Results)
{ 	
	// TBD
	int ant;
	int32 imr;
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (antMask & (1 << ant))
		{
			imr = calcIMR(&Results[ant]);
			IMRdB[ant] = MATH_10Log10Res((uint32)imr, TX_IQ_ENERGY_LOG_RESOLUTION);
			IMRdB[ant] -= (IMR_RESOLUTION_dB << TX_IQ_ENERGY_LOG_RESOLUTION);
			IMRdB[ant] >>= TX_IQ_ENERGY_LOG_RESOLUTION;
			ILOG0_DD("IMRdB[%d]: %d",ant,IMRdB[ant]);

		}
	}
}

static int32 calcIMR(CorrResRxIq_t* Result_out)
{              
    int32 phiSquared, IMR, a;
	CorrResRxIq_t Result_temp;
	CorrResRxIq_t* Result = &Result_temp;
	Result->QQ = Result_out->QQ;
	Result->II = Result_out->II;
	Result->IQ= Result_out->IQ;
	
    uint8 res = IMR_RESOLUTION_BITS;
    int64 IMR_num,IMR_denom, iRes;		                
    if ((Result->QQ > (1 << I_Q_TRUNCATION_BITS)) && ((Result->II > (1 << I_Q_TRUNCATION_BITS))))
    {
        Result->QQ >>= I_Q_TRUNCATION_BITS;
        Result->II >>= I_Q_TRUNCATION_BITS;
    }
    iRes = (int64)Result->II << res;
    
    DEBUG_ASSERT(Result->QQ > 0);

    // a = sqrt(II/QQ)
    a = MATH_Sqrt(iRes / Result->QQ);

    // Phi^2 = IQ^2/(II*QQ)
    phiSquared = ((int64)(Result->IQ << (res - (2 * I_Q_TRUNCATION_BITS))) * Result->IQ) / ((int64)Result->II * (int64)Result->QQ);

    // IMR_num = (a-1)^2 +a*Phi^2
    IMR_num = (((((int64)a << (res >> 1))- (1 << res))) * ((((int64)a << (res >> 1))- (1 << res)))) + ( ((int64)a << (res >> 1))) * phiSquared;
    
    // IMR_denom = (a+1)^2 -a*Phi^2
    IMR_denom = ((((int64)a + (1 << (res >> 1)))) * (a + (1 << (res >> 1)))) - (((int64)a * (phiSquared >> res)));

    // IMR = IMR_num/IMR_denom
    IMR = IMR_num/IMR_denom;

    ILOG0_DDD("a: %d phiSquared: %d IMR(should be positive!!): %d",a, phiSquared, IMR);
	
    return (IMR);
}

static void calcIMRAllGoertzel(uint8 antMask, int16* IMRdB, GoertzelRes_t* Results)
{ 	
	// TBD
	int ant;
	uint32 imr_inverse;
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (antMask & (1 << ant))
		{
			imr_inverse = calcIMRGoertzel(&Results[ant]);
			IMRdB[ant] = MATH_10Log10Res(imr_inverse, RXIQ_NLMS_IMR_RES);
			ILOG0_DDD("imr_inverse:%d NLMS IMRdB[%d]: %d",imr_inverse,ant,IMRdB[ant]);
			IMRdB[ant] = DIVIDE_AND_ROUND(IMRdB[ant],1<<RXIQ_NLMS_IMR_RES);
			ILOG0_DD("NLMS IMRdB[%d]: %d",ant,IMRdB[ant]);

		}
	}
}

static uint32 calcIMRGoertzel(GoertzelRes_t* Result_out)
{              
    uint64 amp, amp_squre;
	uint64 amp_num, amp_denum;
	int64 phi_num, phi_denum;
	int32 phi;
	int64 IMR_inverse_64;
	uint32 IMR_inverse_32;
	int32 arcTanInput32, cosPhi;
	int64 num,denum;
	GoertzelRes_t Result_temp;
	GoertzelRes_t* Result_p = &Result_temp;
	Result_p->Res_I_Real= Result_out->Res_I_Real;
	Result_p->Res_I_Im = Result_out->Res_I_Im;
	Result_p->Res_Q_Real= Result_out->Res_Q_Real;
	Result_p->Res_Q_Im= Result_out->Res_Q_Im;
	
	//should enter 32 bit number, should verufy not too large
	//amp  = abs(I)/abs(Q) =sqrt(Ireal^2+Iim^2)/sqrt(Qreal^2+Qim^2) = sqrt((Ireal^2+Iim^2)/(Qreal^2+Qim^2))
	amp_num = (int64)Result_p->Res_I_Real*(int64)Result_p->Res_I_Real + (int64)Result_p->Res_I_Im*(int64)Result_p->Res_I_Im;
	if ( amp_num >= ((uint64)1<<(64-RXIQ_NLMS_AMP_SQUARE_FIRST_SHIFT_RES)))
	{
		ASSERT(0);//amp_num will be overflow after shift RXIQ_NLMS_AMP_SQUARE_FIRST_SHIFT_RES
	}
	amp_num = amp_num << RXIQ_NLMS_AMP_SQUARE_FIRST_SHIFT_RES ;
	amp_denum = (int64)Result_p->Res_Q_Real*(int64)Result_p->Res_Q_Real + (int64)Result_p->Res_Q_Im*(int64)Result_p->Res_Q_Im;
	amp_squre = amp_num/amp_denum;
	if ( amp_squre >= ((uint64)1<<(64-(RXIQ_NLMS_AMP_SQUARE_RES-RXIQ_NLMS_AMP_SQUARE_FIRST_SHIFT_RES))))
	{
		ASSERT(0);//amp_squre will be overflow after shift (RXIQ_NLMS_AMP_SQUARE_RES-RXIQ_NLMS_AMP_SQUARE_FIRST_SHIFT_RES)
	}
	amp_squre = amp_squre<<(RXIQ_NLMS_AMP_SQUARE_RES-RXIQ_NLMS_AMP_SQUARE_FIRST_SHIFT_RES);
	
	amp = MATH_Sqrt_64(amp_squre);// <<7  RXIQ_NLMS_AMP_RES
	//phi = atan((-Ire*Qim + Iim*Qre)/(Ire*Qre + Iim*Qim))
	phi_num = -1*(int64)Result_p->Res_I_Real*(int64)Result_p->Res_Q_Im+(int64)Result_p->Res_I_Im*(int64)Result_p->Res_Q_Real;
	phi_num = phi_num <<RXIQ_NLMS_PHI_RES;
	phi_denum = (int64)Result_p->Res_I_Real*(int64)Result_p->Res_Q_Real+(int64)Result_p->Res_I_Im*(int64)Result_p->Res_Q_Im;
	//should verify int 16 num
	arcTanInput32 = phi_num/phi_denum;
	phi = MATH_ArctanRes_32(arcTanInput32, RXIQ_NLMS_PHI_RES);
	cosPhi = MATH_Cos_64(phi, RXIQ_NLMS_PHI_RES);// <<16
	if ( ((int64)amp*amp) >= ((uint64)1<<(64-(RXIQ_NLMS_NUM_RES-RXIQ_NLMS_AMP_SQUARE_RES))))
	{
		ASSERT(0);//amp_squre will be overflow after shift (RXIQ_NLMS_NUM_RES-RXIQ_NLMS_AMP_SQUARE_RES)
	}
	//num=1+amp^2-2*amp*cos(phi)
	num = (1<<RXIQ_NLMS_NUM_RES)+((int64)amp*amp<<(RXIQ_NLMS_NUM_RES-RXIQ_NLMS_AMP_SQUARE_RES))-(2*(int64)amp*cosPhi);
	//denum=1+amp^2+2*amp*cos(phi)
	denum = (1<<RXIQ_NLMS_NUM_RES)+((int64)amp*amp<<(RXIQ_NLMS_NUM_RES-RXIQ_NLMS_AMP_SQUARE_RES))+(2*(int64)amp*cosPhi);
	if (num == 0)
	{
		num = 1;
	}
	//IMRR Before Log = num/denum, here i am calculation the inverse and imr will be positive but not negative
	IMR_inverse_64 = denum/num;
	//return not greater than MAX_UINT32
	IMR_inverse_64 = MIN(IMR_inverse_64,MAX_UINT32);
	IMR_inverse_32=(uint32)IMR_inverse_64;
#ifdef WRX600_BU_LOGS
	ILOG0_V("calcIMRGoertzel");
	ILOG0_DDDD("Ireal:0x%x,Iim:0x%x,Qreal:0x%x,Qim:0x%x",Result_p->Res_I_Real,Result_p->Res_I_Im,Result_p->Res_Q_Real,Result_p->Res_Q_Im);
	ILOG0_DDD("amp_num:0x%x,amp_denum:0x%x, amp_temp:0x%x",amp_num,amp_denum,amp_squre);
	ILOG0_DDDD("amp_num high:0x%x,amp_denum high:0x%x,amp:0x%x, amp high:0x%x",amp_num>>32,amp_denum>>32,amp,amp>>32);
	ILOG0_DDD("phi_num:0x%x, phi_denum:0x%x, arcTanInput32:0x%x",phi_num, phi_denum,arcTanInput32);
	ILOG0_DD("phi_num high:0x%x, phi_denum high:0x%x,",phi_num>>32, phi_denum>>32);
	ILOG0_DD("phi:0x%x, cosPhi:%d",phi,cosPhi);
	ILOG0_DDDD("num high:0x%x, num:0x%x, denum high:0x%x, denum:0x%x",num>>32,num,denum>>32,denum);
	ILOG0_D("IMR64:0x%x",IMR_inverse_64);
	ILOG0_D("IMR:0x%x",IMR_inverse_32);
	ILOG0_DDD("denum1:%d, denum2:%d, denum3:%d",(1<<RXIQ_NLMS_NUM_RES),((int64)amp*amp<<(RXIQ_NLMS_NUM_RES-RXIQ_NLMS_AMP_SQUARE_RES)),(2*(int64)amp*cosPhi));
#endif
    return (IMR_inverse_32);
}

static void setRxIQParams(ClbrType_e inCalibType)
{
	int ant;
	if (inCalibType == CLBR_TYPE_ONLINE)
	{
		rxiqParams.successThreshold = RXIQ_SUCCESS_TH_DB_ONLINE;
		rxiqParams.numberOfSamplesToCalibrate = RXIQ_ONLINE_ACCUM_NUM_OF_SAMPLES;
		rxiqParams.accumTimeout = RXIQ_ONLINE_ACCUM_TIMEOUT;
		rxiqParams.maxNumOfTries = RXIQ_ONLINE_MAX_NUM_OF_TRIES;
	}
	else
	{		
		rxiqParams.iterationType = CLBR_ITERATION_OFFLINE;		
		rxiqParams.successThreshold = RXIQ_SUCCESS_TH_DB_OFFLINE;
		rxiqParams.numberOfSamplesToCalibrate = RXIQ_OFFLINE_ACCUM_NUM_OF_SAMPLES;
		rxiqParams.accumTimeout = RXIQ_OFFLINE_ACCUM_TIMEOUT;
		rxiqParams.maxNumOfTries = RXIQ_OFFLINE_MAX_NUM_OF_TRIES;
	}

	if (rxIqDefaultFromPSD.paramsAreInitialized != TRUE)
	{
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			rxIqDefaultFromPSD.rxIqDefaultCh36.w1[ant]  = RXIQ_INITIAL_W1_VALUE;
			rxIqDefaultFromPSD.rxIqDefaultCh36.w2[ant]  = RXIQ_INITIAL_W2_VALUE;
			rxIqDefaultFromPSD.rxIqDefaultCh100.w1[ant] = RXIQ_INITIAL_W1_VALUE;
			rxIqDefaultFromPSD.rxIqDefaultCh100.w2[ant] = RXIQ_INITIAL_W2_VALUE;
		}
		rxIqDefaultFromPSD.threshold = RXIQ_INITIAL_W1_VALUE;
		rxIqDefaultFromPSD.paramsAreInitialized = TRUE;
	}
	
#ifdef WRX600_BU_LOGS
		ILOG0_V("setRxIQParams");
		SLOG0(0, 0, RxIQParams_t, &rxiqParams);
#endif
}

static void handleFailure(uint8 failedMask, RxIQWs_t* prevWs)
{

	RxIQWs_t ws;
	uint8 ant;
	int16 imrDbNominal[MAX_NUM_OF_ANTENNAS] = {0};
	uint8 calc = TRUE;
	if (rxiqParams.iterationType == CLBR_ITERATION_OFFLINE)
	{
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			if (failedMask & (1 << ant))
			{
				if ((rxiqParams.lastAccumResults[ant].II < DEBUG_THRESHOLD) || (rxiqParams.lastAccumResults[ant].QQ < DEBUG_THRESHOLD))
				{
					calc = FALSE;
				}
			}
		}
		if (calc == TRUE)
		{
			calcIMRAll(failedMask, imrDbNominal, rxiqParams.lastAccumResults);
		}
		/* Initialize nominal Ws */
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{
			if (failedMask & (1 << ant))
			{
#ifdef WRX600_BU_LOGS
		ILOG0_DDD("ant %d failed. imrDbNominal %d, imrDbLast:%d",ant,imrDbNominal[ant],rxiqParams.imrDbLast[ant]);
#endif
				ws.w1[ant] = rxiqParams.nominalWs.w1[ant];			
				ws.w2[ant] = rxiqParams.nominalWs.w2[ant];
				PhyCalDrv_RxIQSetWCoeffs((1 << ant), HDK_getChannelWidth(), ws.w1, ws.w2);

			}
		}
	}
	else
	{
		// We shouldn't get here in first online iteration
		DEBUG_ASSERT(rxiqParams.iterationType == CLBR_ITERATION_SECOND_ONLINE);
	
		// set last Ws in PHY registers for failed antennas
		PhyCalDrv_RxIQSetWCoeffs(failedMask, HDK_getChannelWidth(), prevWs->w1, prevWs->w2);
	}
}

/********************************************************************************

Method:	RxIQ_Calibrate

Description:
------------
    
    Calibrate RxIQ mismatch - main calibration function
  
Input:
-----
    ClbrType_e inCalibType - OFFLINE or ONLINE (not used)	
			
Output:
-------
	return status - Success(RET_VAL_SUCCESS) Fail(RET_VAL_FAIL)

********************************************************************************/
RetVal_e RxIQ_Calibrate(IN ClbrType_e inCalibType)
{
	return run(inCalibType);
}

RetVal_e RxIQ_Calibrate_NLMS(IN ClbrType_e inCalibType)//and crosstalk temporary
{
	//runXTalkCalibration(inCalibType);
	return run_NLMS(inCalibType);
}
/********************************************************************************

Method:	RxIQ_SetStatus

Description:
------------
    
    Set calibration status of given antenna
  
Input:
-----
			
Output:
-------

********************************************************************************/
void RxIQ_SetStatus(uint8 antMask, IN CalStatus_e inStatus)
{
	uint8 ant;
	
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (antMask & (1 << ant))
		{
			rxiqParams.status[ant] = inStatus;
		}
	}
}

/********************************************************************************

Method:	RxIQ_GetStatus

Description:
------------
    
    Get calibration status of given antenna
  
Input:
-----
			
Output:
-------
	status - CAL_STATUS_FAIL or CAL_STATUS_PASS
	

********************************************************************************/
 CalStatus_e RxIQ_GetStatus( IN uint32 inAntenna )
{
	return rxiqParams.status[inAntenna];
}

/********************************************************************************

Method:	RxIQ_GetLastRunTime

Description:
------------
    
    Get last RXIQ mismatch calibration run time duration
  
Input:
-----
    
			
Output:
-------
	return - run time duration	

********************************************************************************/
 uint32 RxIQ_GetLastRunTime(void)
{
	return rxiqParams.lastRunTime;
}

void RxIQ_LoadResults(void)
{
	uint8 antMask, maxAnts;
	uint8 ant;
	RxIQWs_t Ws = {0};
	uint8 bw = HDK_getChannelWidth();
	ILOG0_D("RxIQ_LoadResults bw:%d",bw);
	HDK_GetMaxActiveAntennasNumAndMask(&maxAnts, &antMask);

	for(ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		if (antMask & (1 << ant))
		{
			Ws.w1[ant] = ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxIqData.w1;			
			Ws.w2[ant] = ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxIqData.w2;			
			RxIQ_SetStatus(1 << ant, ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxIqData.calStatus);
		}
	}	
	PhyCalDrv_RxIQSetWCoeffs(antMask, bw, Ws.w1, Ws.w2);
	PhyCalDrv_setDecorrelatorMode(antMask, TRUE);
}
void RxIQ_NLMS_LoadResults(void)
{
	uint8 antMask, maxAnts;
	ILOG0_V("RxIQ_NLMS_LoadResults");
	HDK_GetMaxActiveAntennasNumAndMask(&maxAnts, &antMask);
	PhyCalDrv_setFirMode(antMask, TRUE);
	PhyCalDrv_setBypassRamCoeffs (antMask, FALSE);
	//RxIQ_Xtalk_LoadResults();
}
void RxIQ_Xtalk_LoadResults(void)
{
	uint8 antMask, maxAnts;
	ILOG0_V("RxIQ_Xtalk_LoadResults");
	HDK_GetMaxActiveAntennasNumAndMask(&maxAnts, &antMask);
	
}

/********************************************************************************
Method:	        RxIQ_StoreResults
Description:     Stores RXIQ calibration data to a buffer
Input:              param None		
Output:            return None
********************************************************************************/
static void RxIQ_NLMS_StoreResults(uint8 antMask)
{
	bool CalState = TRUE;

	UNUSED_PARAM(antMask);
	ClbrHndlr_UpdateCalState(CLBR_PROC_TYPE_RX_IQ_NLMS, CalState);
}


static void RxIQ_StoreResults(uint8 antMask)
{
	RxIQWs_t Ws;
	uint8 ant;
    bool CalState = TRUE;
    CalStatus_e antStatus;

	PhyCalDrv_RxIQGetWCoeffs(antMask, HDK_getChannelWidth(), Ws.w1, Ws.w2);
    for (ant = ANTENNA_0; ant < MAX_NUM_OF_ANTENNAS; ant++)
    {
		if (antMask & (1 << ant))
		{
	    	antStatus = RxIQ_GetStatus(ant);
	    	ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxIqData.calStatus = antStatus;
	   		ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxIqData.w1 = Ws.w1[ant];
	   		ShramClbrDataBufferStoreChanData.clbrStoreChanDataPerAnt[ant].rxIqData.w2 = Ws.w2[ant];
	    	if ((antStatus == CAL_STATUS_FAIL) || (antStatus == CAL_STATUS_IN_PROCESS))
	    	{
	        	CalState = FALSE;
	    	}			
		}
	}

	ClbrHndlr_UpdateCalState(CLBR_PROC_TYPE_RX_IQ_MISMATCH, CalState);
}


#ifdef SDL_IGNORE_UNUSED_FUNCTION
static RetVal_e runXTalkCalibration( ClbrType_e inCalibType)
{
		uint8 antMask, numOfAnts;
		uint8 failedAntMask;
		RetVal_e ret = RET_VAL_SUCCESS;
		uint8 tryCounter = 0;
		uint8 storedDifi2Gain[MAX_NUM_OF_ANTENNAS];
		HDK_GetMaxActiveAntennasNumAndMask(&numOfAnts, &antMask);

#ifdef WRX600_BU_LOGS
		ILOG0_D("runXTalkCalibration. antMask 0x%x",antMask);
#endif	
		/* Initialize */
		
		initXTalkCalibration(antMask, inCalibType, storedDifi2Gain);
		failedAntMask = antMask;
		while((failedAntMask != 0) && (tryCounter < xTalkParamas.maxNumOfTries))
		{

			/* Calibrate */
			calibrateXTalk(&failedAntMask);
			tryCounter++;
		}
		
		/* Finish */	
		ret = finishXTalkCalibration(antMask, failedAntMask, storedDifi2Gain);
	
		return ret;

}

static void initXTalkCalibration(uint8 antMask, ClbrType_e inCalibType, uint8* storedDifi2Gain)
{
	/* Set RxIQ Database */
	setXTalkParams(inCalibType);
	/*
	//AFE_RxOff
	PhyCalDrv_enableRxtdFifo(FALSE);
	PhyCalDrv_enableRxtdFifo(TRUE);

	//PhyCalDrv_enableDetector(FALSE);
	
	PhyCalDrv_GetBypassFrcStatus(antMask, FrcStatus);
	PhyCalDrv_BypassFrc(antMask, TRUE);
	PhyCalDrv_GetBypassFdlStatus(antMask, PhyFDLStatus);
	PhyCalDrv_BypassFdl(antMask, TRUE);
	*detectorResetTh = PhyCalDrv_GetDetectorResetTh();
	PhyCalDrv_SetDetectorResetTh(DETECTOR_THRESHOLD);
	*detector11b = PhyCalDrv_Get11bDetectorState();
	PhyCalDrv_Enable11bDetector(FALSE);

	PhyCalDrv_enableCalMode(TRUE);
	*/
	
	/* Configure RFIC */
	configureRficForXTalkCalibration(antMask);

	/* Configure BBIC */
	PhyCalDrv_resetRxtd(TRUE);
	PhyCalDrv_resetRxtd(FALSE);	
	configurePhyForXTalkCalibration(antMask, storedDifi2Gain);
		
}


static void configureRficForXTalkCalibration(uint8 antMask)
{	
	// RFIC Tx off, Rx off
	RficDriver_DeactivateTxAntennas(antMask);	
	RficDriver_DeactivateRxAntennas(antMask);
	//disable LNA
	RficDriver_DisableLna(antMask);
	// Set FEM
	RficDriver_setRffeMode(T_STATE_MODE,antMask);
	// Set bw
	RficDriver_SetBandWidth(antMask);
}

static void configurePhyForXTalkCalibration(uint8 antMask, uint8* storedDifi2Gain)
{
	uint8 bw = HDK_getChannelWidth();

	uint8 iirDelay = MAX(RXIQ_IIR_MIN_DELAY, 40 - (DELAY_CHANGE_PER_BW * bw));
	uint8 iirShift = RXIQ_IIR_SHIFT - bw;


	/* Store current difi 2 gain, use RXDC_DIFI_2_GAIN for calibration */
	PhyCalDrv_getDifi2Gain(antMask, storedDifi2Gain);
	PhyCalDrv_resetDifiGain(antMask);
	PhyCalDrv_enableDifiGain(antMask, FALSE);
	PhyCalDrv_setAdc(TRUE);
	PhyCalDrv_enableDetector(FALSE);

	// Enable IIR
	PhyCalDrv_setIIRShift(antMask, iirShift);
	PhyCalDrv_setIIRMode(antMask, TRUE);
	//Wait for the IIR to settle
	MT_Delay(iirDelay);
	
	// Bypass RxIQ blocks if they aren't calibrated
	PhyCalDrv_setXtalkMode(antMask, FALSE);
	PhyCalDrv_setFirMode(antMask, FALSE);
	PhyCalDrv_setFdlMode(antMask, FALSE);
	
	// Bypass W1W2 decorrelator
	PhyCalDrv_setDecorrelatorMode(antMask, FALSE);

	// AFE
	AFE_RxOn(antMask);
	PhyCalDrv_EnableGclkBypass(TRUE);
	AFE_TxOn(antMask);


}

static void restoreRficFromXTalkCalibration(uint8 antMask)
{
	// enable LNA
	RficDriver_EnableLna(antMask);
	//RficDriver_disableRffeManMode(antMask);
	RficDriver_disableBbloop(antMask,HDK_getBand());
}
static void restorePhyFromXTalkCalibration(uint8 antMask, uint8* storedDifi2Gain)
{
	//PhyCalDrv_setDifi2Gain(antMask, storedDifi2Gain);
	// Bypass IIR
	PhyCalDrv_setIIRMode(antMask, FALSE);
	//PhyCalDrv_enableCalMode(FALSE);
	PhyCalDrv_enableDetector(TRUE);
	PhyCalDrv_EnableGclkBypass(FALSE);
	PhyCalDrv_enableDifiGain(antMask, FALSE);
	PhyCalDrv_enableToneGen(FALSE);
}

/*static void verifyXTalkCalibrationResults(uint8* antMask, uint8 kFixed[RFIC_PATH_TYPE_MAX][MAX_NUM_OF_ANTENNAS])
{
//loop on pgc index (20 - 0), -2 every loop.
	RficPathTypeIndex_e rficPath;
	GoertzelRes_t goertzelResult[MAX_NUM_OF_ANTENNAS];
	uint8 ant;
	int32 signal[MAX_NUM_OF_ANTENNAS];
	int32 leakage[MAX_NUM_OF_ANTENNAS];
	//int32 xTalkInverse[RFIC_PATH_TYPE_MAX][MAX_NUM_OF_ANTENNAS];
	//uint8 bw = HDK_getChannelWidth();
	//int filter_rej[MAX_NUM_OF_ANTENNAS] = {1280,640,307,128}; //[10 5 2.4 1]*(2^7)//to change to max num of bandwidths

	uint8 scale[RXIQ_NUM_OF_PGC_GAINS]={0,0,1,1,1,2,2,2,3,3,3};
	int pgc_idx = 0;
	int pgc_gain = RXIQ_MAX_PGC_GAIN;
	
	for( pgc_idx = 0; pgc_idx < RXIQ_NUM_OF_PGC_GAINS; pgc_idx++)
	{
		RficDriver_SetRxPgcGain(*antMask, pgc_gain);
		RficDriver_SetRxGains(*antMask, scale[pgc_idx], pgc_gain);
		PhyCalDrv_setXTalkCoeffs(*antMask,kFixed[RFIC_PATH_TYPE_I],kFixed[RFIC_PATH_TYPE_Q]);
		for (rficPath = RFIC_PATH_TYPE_I; rficPath < RFIC_PATH_TYPE_MAX; rficPath++)
		{
			RficDriver_enableBbloop(*antMask, HDK_getBand(), RXIQ_XTALK_LOOP_TYPE, rficPath+1);
			PhyCalDrv_GoertzelMeasure(*antMask, RXIQ_XTALK_GRTZL_TIMEOUT, goertzelResult);
			for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
			{
				if (*antMask & (1 << ant))
				{	
					if (rficPath == RFIC_PATH_TYPE_I)
					{
						signal[ant] = (Abs(goertzelResult[ant].Res_I_Real) + Abs(goertzelResult[ant].Res_I_Im));
						leakage[ant] = (Abs(goertzelResult[ant].Res_Q_Real) + Abs(goertzelResult[ant].Res_Q_Im));
					}
					else
					{
						signal[ant] = (Abs(goertzelResult[ant].Res_Q_Real) + Abs(goertzelResult[ant].Res_Q_Im));
						leakage[ant] = (Abs(goertzelResult[ant].Res_I_Real) + Abs(goertzelResult[ant].Res_I_Im));
					}
					//should verify leakage is small enough
					//calibration pass for this ant:
					//should do here pass/fail per pgc!!!!!!!!!!!!!!!!!!!!!!!!!!!
					*antMask &= (~(1 << ant));
#ifdef WRX600_BU_LOGS
					ILOG0_DD("verifyXTalk signal:%d, leakage:%d",signal[ant], leakage[ant]);
					//ILOG0_V("verifyXTalk k:");//to add k!!!!!
					//ILOG0_DDD("verifyXTalk rficPath:%d, ant:%d, xTalk:%d", rficPath, ant, xTalkInverse[rficPath][ant]);
#endif
				}
			}
		}
		pgc_gain = pgc_gain - 2;
	}
}*/

static void calibrateXTalk(uint8* antMask)
{
	/*Scale = 0; % 6dB step
	Diggain = 128; % 0...511 or [0...2)
	Bin = (256./(2.^(4-BWindex)))-(2.^BWindex);*/

	int16 digGain[MAX_NUM_OF_ANTENNAS] = {RXIQ_XTALK_TONE_DIGGAIN, RXIQ_XTALK_TONE_DIGGAIN, RXIQ_XTALK_TONE_DIGGAIN, RXIQ_XTALK_TONE_DIGGAIN};
	uint32 goertzelLength[MAX_NUM_OF_ANTENNAS] = {RXIQ_XTALK_GRTZL_LENGTH, RXIQ_XTALK_GRTZL_LENGTH, RXIQ_XTALK_GRTZL_LENGTH, RXIQ_XTALK_GRTZL_LENGTH};//glick to change define
	uint8 goertzelCycles[MAX_NUM_OF_ANTENNAS] = {RXIQ_XTALK_GRTZL_NUM_OF_CYCLES, RXIQ_XTALK_GRTZL_NUM_OF_CYCLES, RXIQ_XTALK_GRTZL_NUM_OF_CYCLES, RXIQ_XTALK_GRTZL_NUM_OF_CYCLES};
	int16 goertzelBin[MAX_NUM_OF_ANTENNAS] = {0, 0, 0, 0};
	int8 kFixed_ram[RFIC_PATH_TYPE_MAX][RXIQ_NUM_OF_PGC_GAINS][MAX_NUM_OF_ANTENNAS];
	uint8 bw = HDK_getChannelWidth();
	uint8 bwIndex = bw + 1;
	int16 bin = (256/(1 << (4-bwIndex)))-(1 << bwIndex);
	int ant;
	uint8 scale[RXIQ_NUM_OF_PGC_GAINS]={3,3,3,2,2,2,1,1,1,0,0};//{0,0,1,1,1,2,2,2,3,3,3};
	int pgc_idx = 0;
	//int pgc_gain = RXIQ_MAX_PGC_GAIN;
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		goertzelBin[ant] = bin;

	}
#ifdef WRX600_BU_LOGS
	ILOG0_DD("bw:%d bin:%d (for bw 0 1 2 3 should be bin 30 60 120 240",bw, bin);
#endif
	
	// Configure Goertzel
	PhyCalDrv_GoertzelConfig(*antMask, goertzelLength, goertzelCycles, goertzelBin, goertzelBin);
//loop on pgc index (20 - 0), -2 every loop.
	for( pgc_idx = 0; pgc_idx < RXIQ_NUM_OF_PGC_GAINS; pgc_idx++)
	{
		//pgc_idx = 1; 
		//pgc_gain = 0;
		PhyCalDrv_RunToneGen(*antMask, bin, scale[pgc_idx], digGain);//maybe duplicate call
		RficDriver_SetRxPgcGain(*antMask, 2*pgc_idx);
		RficDriver_SetRxGains(*antMask, scale[pgc_idx], 2*pgc_idx);
		MT_Delay(400/(20 << bw));
		
		xTalkMeasureEnergy(*antMask, pgc_idx, kFixed_ram);
		//pgc_gain = pgc_gain - 2;
	//end loop	
	}
	PhyCalDrv_writeRamXtalk(*antMask,bw, kFixed_ram[RFIC_PATH_TYPE_I], kFixed_ram[RFIC_PATH_TYPE_Q]);
	PhyCalDrv_setXtalkMode(*antMask, TRUE);//to verify no one turn it off after here.

	//verifyXTalkCalibrationResults(antMask, pgc_gain, kFixed);
	//to fix this: only verified ants are removed from mask!!!!!!!!!!!!!!!!!!!!
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{		
		if (*antMask & (1 << ant))
		{
			*antMask &= (~(1 << ant));
		}
	}
	
}


static void xTalkMeasureEnergy(uint8 antMask, int pgc_idx, int8 kFixed_ram[RFIC_PATH_TYPE_MAX][RXIQ_NUM_OF_PGC_GAINS][MAX_NUM_OF_ANTENNAS])
{
	GoertzelRes_t goertzelResult[MAX_NUM_OF_ANTENNAS];
	int32 signal[MAX_NUM_OF_ANTENNAS];
	int32 leakage[MAX_NUM_OF_ANTENNAS];
	int32 numerator[MAX_NUM_OF_ANTENNAS];
	//int32 deltaToCorrect[MAX_NUM_OF_ANTENNAS];
	int32 kFixedHelper;
	uint8 kFixed[RFIC_PATH_TYPE_MAX][RXIQ_NUM_OF_PGC_GAINS][MAX_NUM_OF_ANTENNAS];
	int filter_rej[MAX_NUM_OF_ANTENNAS] = {1280,640,307,128}; //[10 5 2.4 1]*(2^7)//to change to max num of bandwidths
	//int32 xTalkInverse[RFIC_PATH_TYPE_MAX][MAX_NUM_OF_ANTENNAS];
	RficPathTypeIndex_e rficPath;
	uint8 bw = HDK_getChannelWidth();
	uint8 ant;
	int32 xtalk[MAX_NUM_OF_ANTENNAS] = {0};
	int32 xtalkVerify[MAX_NUM_OF_ANTENNAS] = {0};
#ifdef WRX600_BU_LOGS
	ILOG0_V("xTalkMeasureEnergy");
#endif

	// Measure Goertzel
	for (rficPath = RFIC_PATH_TYPE_I; rficPath < RFIC_PATH_TYPE_MAX; rficPath++)
	{
		RficDriver_enableBbloop(antMask, HDK_getBand(), RXIQ_XTALK_LOOP_TYPE, rficPath+1);
		PhyCalDrv_GoertzelMeasure(antMask, RXIQ_XTALK_GRTZL_TIMEOUT, goertzelResult);
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{		
			if (antMask & (1 << ant))
			{
				if (rficPath == RFIC_PATH_TYPE_I)
				{
					signal[ant] = (Abs(goertzelResult[ant].Res_I_Real) + Abs(goertzelResult[ant].Res_I_Im));
					leakage[ant] = (Abs(goertzelResult[ant].Res_Q_Real) + Abs(goertzelResult[ant].Res_Q_Im));
				}
				else
				{
					signal[ant] = (Abs(goertzelResult[ant].Res_Q_Real) + Abs(goertzelResult[ant].Res_Q_Im));
					leakage[ant] = (Abs(goertzelResult[ant].Res_I_Real) + Abs(goertzelResult[ant].Res_I_Im));
				}
				numerator[ant]=leakage[ant]*filter_rej[bw];
				ILOG0_D("numinator:%d",numerator[ant]);
				MATH_LongDivision(numerator[ant],signal[ant],RXIQ_XTALK_NUM_RES_BITS,&kFixedHelper);//output should be int32
				MATH_LongDivision(signal[ant],leakage[ant],0,&xtalk[ant]);
				if (bw == BANDWIDTH_TWENTY)
				{
					//k[ant] = 0;
					kFixed[rficPath][pgc_idx][ant]=0;
					kFixed_ram[rficPath][pgc_idx][ant]=0;
					//kFixedHelper[rficPath][pgc_idx][ant]=0
				}
				else
				{
					//k[ant] = 0;//-(10
					kFixed_ram[rficPath][pgc_idx][ant]=(int8)(-kFixedHelper);//ram matrix is int8 values
					if (kFixed_ram[rficPath][pgc_idx][ant]<0)
					{
						kFixedHelper = kFixed_ram[rficPath][pgc_idx][ant] + 64;
					}					
					kFixed[rficPath][pgc_idx][ant]=(uint8)(kFixedHelper);//input to PhyCalDrv_setXTalkCoeffs
					ILOG0_DD("kFixed:%d,kFixed_ram:%d(can be neg -32->31) ",kFixed[rficPath][pgc_idx][ant],kFixed_ram[rficPath][pgc_idx][ant] );
					//k = -10.^(-delta_to_correct/20);//????????????????????????
				}
				
#ifdef WRX600_BU_LOGS
				ILOG0_DDDD("xTalkMeasureEnergy rficPath:%d, ant:%d, kFixedHelper:%d, kFixed:%d", rficPath, ant,kFixedHelper, kFixed[rficPath][pgc_idx][ant]);
				ILOG0_DDD("xTalkMeasureEnergy signal:%d, leakage:%d, pgcindex:%d",signal[ant], leakage[ant],pgc_idx);
				
#endif

			}
		}

		//verification
		PhyCalDrv_setXtalkMode(antMask, TRUE);
		PhyCalDrv_setXTalkCoeffs(antMask,kFixed[RFIC_PATH_TYPE_I][pgc_idx],kFixed[RFIC_PATH_TYPE_Q][pgc_idx]);
		PhyCalDrv_GoertzelMeasure(antMask, RXIQ_XTALK_GRTZL_TIMEOUT, goertzelResult);
		for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
		{		
			if (antMask & (1 << ant))
			{
				if (rficPath == RFIC_PATH_TYPE_I)
				{
					signal[ant] = (Abs(goertzelResult[ant].Res_I_Real) + Abs(goertzelResult[ant].Res_I_Im));
					leakage[ant] = (Abs(goertzelResult[ant].Res_Q_Real) + Abs(goertzelResult[ant].Res_Q_Im));
				}
				else
				{
					signal[ant] = (Abs(goertzelResult[ant].Res_Q_Real) + Abs(goertzelResult[ant].Res_Q_Im));
					leakage[ant] = (Abs(goertzelResult[ant].Res_I_Real) + Abs(goertzelResult[ant].Res_I_Im));
				}
				MATH_LongDivision(signal[ant],leakage[ant],0,&xtalkVerify[ant]);
				

#if (XTALK_DEBUG_FLAG)
				Debugxtalk[Debugxtalk_index].xtalk[rficPath][ant]=xtalk[ant];
				Debugxtalk[Debugxtalk_index].xtalkVerify[rficPath][ant]=xtalkVerify[ant];
#endif
#ifdef WRX600_BU_LOGS
				ILOG0_DDD("verification ant:%d, xtalkVerify:%d, xtalk:%d",ant, xtalkVerify[ant], xtalk[ant]);
				ILOG0_DDD("verification signal:%d, leakage:%d, pgcindex:%d",signal[ant], leakage[ant],pgc_idx);
#endif

			}
		}
		PhyCalDrv_setXtalkMode(antMask, FALSE);
		
	}
#if (XTALK_DEBUG_FLAG)
	Debugxtalk_index++;
	if (Debugxtalk_index == MAX_INDEX)
	{
		Debugxtalk_index = 0;
	}
#endif
}

static RetVal_e finishXTalkCalibration(uint8 antMask, uint8 failedMask, uint8* storedDifi2Gain)
{
	RetVal_e ret = RET_VAL_SUCCESS;

	if (failedMask != 0)
	{
		ret = RET_VAL_FAIL;
	}
	if (rxiqParams.iterationType == CLBR_ITERATION_FIRST_ONLINE)
	{
		ret = RET_VAL_FRAGMENTED;
	}
	
	/* Restore BBIC */
	restorePhyFromXTalkCalibration(antMask, storedDifi2Gain);
	
	/* Restore RFIC */
	restoreRficFromXTalkCalibration(antMask);
	return ret;
}

static void setXTalkParams(ClbrType_e inCalibType)
{
	xTalkParamas.maxNumOfTries = RXIQ_XTALK_OFFLINE_MAX_NUM_OF_TRIES;
	
}
#endif
