#ifndef __TpcClbrHndlr_h__
#define __TpcClbrHndlr_h__

//#if (ENET_REAL_PHY ==  PHY_REAL_MT_11A_11N)

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "PhyDriver_API.h"
#include "OSAL_Api.h"
#include "PhyCalDriver_API.h"
#include "CalibrationDefs.h"
#include "mhi_mib_id.h"
#include "SharedDbTypes.h"
#include "PhyDriver.h"

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
// tpc vector
#define NUM_OF_TX_PACKET_POWER			(16)

// Maximal and minimal number of points in channel info structs
#define TPC_CHAN_INFO_MIN_NUM_OF_POINTS			(2)
#define TPC_CHAN_INFO_MAX_NUM_OF_POINTS			(5)


#define MAX_TX_POWER                    23

// Digital vector Variables
#define DIGITAL_GAIN_4DB				406
#define	DIGITAL_GAIN_3DB				362
#define DIGITAL_GAIN_2DB				322
#define DIGITAL_GAIN_1DB				287
#define	DIGITAL_GAIN_0DB				256
#define SIZE_DIGITAL_GAIN_VEC			29

//#define NUM_BITS_A_SHIFTED				9			// a is saved 9 bits shifted 
//#define NUM_BITS_B_SHIFTED				3			// b is saved 3 bits shifted 

/* TPC Database Values - The database is downloaded using the progmodel*/
#define DB_RFIC_TRSW_PAON                       8	/* Not Used */
#define DB_PA_POWER_LOWER_LIMIT_5GHz            9
#define DB_PA_POWER_LOWER_LIMIT_2_4GHz          10
#define	DB_PA_TEMP_BACKOFF_5GHz                 11
#define	DB_PA_TEMP_BACKOFF_2_4GHz               12
#define	DB_PA_CB_nCB_BACKOFF_5GHz               13
#define	DB_PA_Cb_nCB_BACKOFF_2_4GHz             14 
#define	DB_PA_BETWEEN_FREQ_BACKOFF_5GHz         15
#define	DB_PA_BETWEEN_FREQ_BACKOFF_2_4GHz       16   
#define	DB_PA_GENERAL_PURPOSE_5GHz              17 
#define	DB_PA_GENERAL_PURPOSE_2_4GHz            18
#define DB_PA_BETWEEN_FREQ_BACKOFF_DIST_5GHz    19
#define DB_PA_BETWEEN_FREQ_BACKOFF_DIST_2_4GHz  20
#define DB_RFIC_TPC_PER_RATE                    21
#define DB_PA_nCB_CB_BACKOFF_5GHz               22
#define DB_PA_nCB_CB_BACKOFF_2_4GHz             23
#define DB_PA_ANT_CABLE_BACKOFF_5GHz            24 
#define DB_PA_ANT_CABLE_BACKOFF_2_4GHz          25 
#define DB_PA_EXTERNAL_PA						26 //W400: external PA exists or not


//TPC backoff calculation defines
#define TPC_BACK_OFF_MAX_INDEX                 (23)
#define TPC_BACK_OFF_VALUE                     (6)
#define TPC_BACK_OFF_MID_INDEX                 (20)


// Option for power limit offsets 
#define TPC_LIMIT_OPTION_0              0
#define TPC_LIMIT_OPTION_1              1
#define TPC_LIMIT_OPTION_2              2
#define TPC_LIMIT_OPTION_3              3
#define TPC_LIMIT_OPTION_4              4
#define TPC_LIMIT_OPTION_5              5
#define TPC_LIMIT_OPTION_NONE    (0xFF)

typedef enum
{     
	ANTENNA_GAIN = 0,
	TPC_DEBUG_MODE,
	TPC_DEBUG_MODE_TX_POWER,
	TPC_POWER_BOOST,
	REGULATION_CB_TX_POWER_LIMITS,
	REGULATION_NCB_TX_POWER_LIMITS,
	TPC_MAX_POWER_ANT0,
	TPC_MAX_POWER_INDEX_ANT0,
	TPC_FORCE_POWER_ANT0,
	TPC_MAX_POWER_ANT1,
	TPC_MAX_POWER_INDEX_ANT1,
	TPC_FORCE_POWER_ANT1,
	TPC_MAX_POWER_ANT2,
	TPC_MAX_POWER_INDEX_ANT2,
	TPC_FORCE_POWER_ANT2,
	TPC_STAT_SIZE    
} TpcStat_E;

/******************************************************************************/
/***						Type Definition									***/
/******************************************************************************/
typedef struct
{
	int16	digitalMinGain;
	int16	preDrvMinGain;
	int16	pgc2step;
	int16	pgc2lowerLimit;
	int16	pgc2upperLimit;
	int16	preDrvStep;
	int16	preDrvUpperLimit;
	int16	digGainStep;
	int16	digGainMax;
	int16	digGainUpperLimit;
	int16	digGainMin;
	uint16	GainTableLen;
	uint8	powerVectorLen;
	int16	minPower[MAX_NUM_OF_ANTENNAS][MAX_NUM_OF_BW];
	uint8	minPowerGain[MAX_NUM_OF_ANTENNAS][MAX_NUM_OF_BW];
	uint8	maxEvmLimit[MAX_NUM_OF_ANTENNAS][MAX_NUM_OF_BW];
	int16	maxPower[MAX_NUM_OF_ANTENNAS][MAX_NUM_OF_BW];
	int16	powerVectorStep;
	uint8	numberOfTssiCutPts;
	uint8	tssiCharacteriztionType;
	int16	pgcWordOffset;
	int16	preDrvWordOffset;
	int16	digWordOffset;
	uint8	pgcWordShift;
	uint8	preDrvWordShift;
	uint8	digWordShift;
	uint8	antPowerBoost[MAX_NUM_OF_ANTENNAS][MAX_NUM_OF_BW];
	uint8	minBoostAntIndex[MAX_NUM_OF_BW];
	uint8	gainStepsInPowerStep;
	uint8	tpcFreqLen;
	uint8	tpcLoopType;
	uint8	fixedGain;
	uint8 	powerLimitOffset;
} tpc_params_t;

typedef struct TPC_channel_info{
	uint16	freq;
	int16	slope[MAX_NUM_OF_TX_ANTENNAS][TPC_CHAN_INFO_MAX_NUM_OF_POINTS - 1];
	int16	bias[MAX_NUM_OF_TX_ANTENNAS][TPC_CHAN_INFO_MAX_NUM_OF_POINTS - 1];
	uint16	lower_boundaries[MAX_NUM_OF_TX_ANTENNAS][TPC_CHAN_INFO_MAX_NUM_OF_POINTS - 1];
	uint8	backoff[MAX_NUM_OF_TX_ANTENNAS][TPC_CHAN_INFO_MAX_NUM_OF_POINTS - 1];
}TPC_channel_info;

typedef	struct Tpc_Backoff 
{	
	int16	Tpc_offset_frequency_backoff;
	int16	pa_backoff_CB_nCB_close;
	int16	pa_backoff_nCB_CB_close;
	int16	pa_backoff_CB_nCB_2_close;
	int16	pa_backoff_nCB_CB_2_close;
	int16	pa_backoff_temp;
	//	int8		cable_loss;
}Tpc_Backoff;

typedef struct TPC_General_purpose{
	uint32		Flo;
	uint8	num_points;
	uint8	num_points_actual[MAX_NUM_OF_TX_ANTENNAS][TPC_FREQ_STR_NUM];
	Tpc_Backoff	backoff_all;
}TPC_General_purpose;

typedef struct sPHY_TPC_CTRL
{
	uint32	u32Even		  ;		
	uint32	u32Odd		  ;		
}sPHYTpcCtrl;

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/
#define PHY_TPC_DEFAULT_LIMITS  30
#define PHY_SET_TPC_THRESHOLDS(T)     (T = ((T<=0)? PHY_TPC_DEFAULT_LIMITS:T))
#define UPDATE_TPC_GAIN()

// equal to 12.75 = 255(8 bit)/20dB(working range), 1dB=12.75
#define ADJUST_TO_FLOATING_POINT(x) ((51*(x)+2) >> 2)
// inverse macro of the above ADJUST_TO_FLOATING_POINT(x)
#define INV_ADJUST_TO_FLOATING_POINT(x) ((((x)<<3) + 51) / 102)

/******************************************************************************/
/***						external Public Variables							***/
/******************************************************************************/
extern TPC_General_purpose	TPC_GP_help;
extern TPC_channel_info TPC_gChannelInfo[TPC_FREQ_STR_NUM];

/******************************************************************************/
/***					Automatic Tests Section									***/
/******************************************************************************/
#undef TPC_SCAN_TEST_ENABLE 
//#define TPC_SCAN_TEST_ENABLE   // only for automatic tests 

#ifdef  TPC_SCAN_TEST_ENABLE

#define TPC_SCAN_DB_INDEX_MAX    50

typedef struct TPC_ScanDB_T
{
	uint8 chID;
	uint8 band;

	uint8 u8MaxTxPowerAnt0;
	uint8 u8MaxTxPowerIndexAnt0;

	uint8 u8MaxTxPowerAnt1;
	uint8 u8MaxTxPowerIndexAnt1;

} TPC_ScanDB_T;

#endif // #ifdef TPC_SCAN_TEST_ENABLE






/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/


#define TPC_MAX_POWER_LEVELS	64
#if defined (ENET_INC_ARCH_WAVE600)
#define TPC_GAIN_TABLE_MAX_ROWS 192
#else
#define TPC_GAIN_TABLE_MAX_ROWS 128
#endif
#define TPC_MAX_GAIN_LEVELS		3
#define TPC_PGC2_GAIN_COL		0
#define TPC_PRE_DRV_GAIN_COL	1
#define TPC_DIG_GAIN_COL		2
#define TPC_MAX_BOOST			3
#define TPC_LA_POWER_RESOLUTION	1
#define TPC_INVALID_CHID		0
#define TPC_INTERPOLATION_RES	7
#define TPC_INTERPOLATION_ROUND_FACTOR (1 << (TPC_INTERPOLATION_RES - 1))

//************************************
// Method:    
// Purpose:  fill TPC structure
// Parameter: void
// Returns:   void
//************************************
void TPC_fillDefines(void);
//************************************
// Method:    
// Purpose:   init static variables and load data
// Parameter: void
// Returns:   void
//************************************
void TPC_init(uint8 tpcType);
//************************************
// Method:    
// Purpose:   allocated memory from initialization
// Parameter: void
// Returns:   void
//************************************
#if !defined (ENET_INC_ARCH_WAVE600)
void TPC_PostInit(void);
#endif
//************************************
// Method:    
// Purpose:  init antenna parameters
// Parameter: void
// Returns:   void
//************************************
void TPC_initAntParams(tpcAntParams_t* params);
//************************************
// Method:    
// Purpose:  configure TPC
// Parameter: 
// Returns:   void
//************************************
void TPC_configReq(tpcConfig_t* cfgParams);
//************************************
// Method:    
// Purpose:   load TPC data of selected channel and bandwidth
// Parameter: 
// Returns:   void
//************************************
void TPC_loadChannelData(uint16 chID, uint8 bandwidth);

//************************************
// Method:    
// Purpose:   build and load gain table
// Parameter: void
// Returns:   void
//************************************
void TPC_buildGainTable(void);
//************************************
// Method:    
// Purpose:   build and load Power out vector
// Parameter: void
// Returns:   void
//************************************
void TPC_buildPout(void);
//************************************
// Method:    
// Purpose:   read TPC freq array and extract from it relevent data 
//			of current channel
// Parameter: void
// Returns:   void
//************************************
void TPC_extractTpcFreqParams(uint8 ant, uint16 channel, uint8 bandwidth);
//************************************
// Method:    
// Purpose:   calculate antennas boosts
// Parameter: void
// Returns:   void
//************************************
void TPC_calcAntennaBoosts(void);
//************************************
// Method:    
// Purpose:   interpolate TPC frequency parameters of 2 adjacent frequencies (Linear interpolation)
// Parameter: void
// Returns:   void
//************************************
void TPC_interpolateFrequencies(TPC_FREQ* outTpcFreq, TPC_FREQ* tpcFreq1, TPC_FREQ* tpcFreq2);
//************************************
// Method:    
// Purpose:   utility functions to interpolate TPC frequency over frequencies according TPC FREQ type
// Parameter: void
// Returns:   void
//************************************
void TPC_FreqInterpolation_1s2d_no_cal(TPC_FREQ_1S2D_NO_CALIB* outTpcFreq, TPC_FREQ_1S2D_NO_CALIB* tpcFreq1, TPC_FREQ_1S2D_NO_CALIB* tpcFreq2);
void TPC_FreqInterpolation_2s2d_no_cal(TPC_FREQ_2S2D_NO_CALIB* outTpcFreq, TPC_FREQ_2S2D_NO_CALIB* tpcFreq1, TPC_FREQ_2S2D_NO_CALIB* tpcFreq2);
void TPC_FreqInterpolation_3s2d_no_cal(TPC_FREQ_3S2D_NO_CALIB* outTpcFreq, TPC_FREQ_3S2D_NO_CALIB* tpcFreq1, TPC_FREQ_3S2D_NO_CALIB* tpcFreq2);
#if defined (ENET_INC_ARCH_WAVE600)
void TPC_FreqInterpolation_1s2d(TPC_FREQ_1_REGION* outTpcFreq, TPC_FREQ_1_REGION* tpcFreq1, TPC_FREQ_1_REGION* tpcFreq2);
void TPC_FreqInterpolation_2s2d(TPC_FREQ_2_REGION* outTpcFreq, TPC_FREQ_2_REGION* tpcFreq1, TPC_FREQ_2_REGION* tpcFreq2);
void TPC_FreqInterpolation_3s2d(TPC_FREQ_3_REGION* outTpcFreq, TPC_FREQ_3_REGION* tpcFreq1, TPC_FREQ_3_REGION* tpcFreq2);
#else
void TPC_FreqInterpolation_1s2d(TPC_FREQ_1S2D* outTpcFreq, TPC_FREQ_1S2D* tpcFreq1, TPC_FREQ_1S2D* tpcFreq2);
void TPC_FreqInterpolation_2s2d(TPC_FREQ_2S2D* outTpcFreq, TPC_FREQ_2S2D* tpcFreq1, TPC_FREQ_2S2D* tpcFreq2);
void TPC_FreqInterpolation_3s2d(TPC_FREQ_3S2D* outTpcFreq, TPC_FREQ_3S2D* tpcFreq1, TPC_FREQ_3S2D* tpcFreq2);
#endif
//************************************
// Method:    
// Purpose:   interpolate TPC frequency parameters of 2 adjacent bandwidths (average interpolation)
// Parameter: void
// Returns:   void
//************************************
void TPC_interpolateBandwidths(TPC_FREQ* outTpcFreq, TPC_FREQ* tpcFreq1, TPC_FREQ* tpcFreq2);
//************************************
// Method:    
// Purpose:   utility functions to interpolate TPC frequency over bandwidth according TPC FREQ type
// Parameter: void
// Returns:   void
//************************************
void TPC_bwInterpolation_1s2d_no_cal(TPC_FREQ_1S2D_NO_CALIB* outTpcFreq, TPC_FREQ_1S2D_NO_CALIB* tpcFreq1, TPC_FREQ_1S2D_NO_CALIB* tpcFreq2);
void TPC_bwInterpolation_2s2d_no_cal(TPC_FREQ_2S2D_NO_CALIB* outTpcFreq, TPC_FREQ_2S2D_NO_CALIB* tpcFreq1, TPC_FREQ_2S2D_NO_CALIB* tpcFreq2);
void TPC_bwInterpolation_3s2d_no_cal(TPC_FREQ_3S2D_NO_CALIB* outTpcFreq, TPC_FREQ_3S2D_NO_CALIB* tpcFreq1, TPC_FREQ_3S2D_NO_CALIB* tpcFreq2);
#if defined (ENET_INC_ARCH_WAVE600)
void TPC_bwInterpolation_1s2d(TPC_FREQ_1_REGION* outTpcFreq, TPC_FREQ_1_REGION* tpcFreq1, TPC_FREQ_1_REGION* tpcFreq2);
void TPC_bwInterpolation_2s2d(TPC_FREQ_2_REGION* outTpcFreq, TPC_FREQ_2_REGION* tpcFreq1, TPC_FREQ_2_REGION* tpcFreq2);
void TPC_bwInterpolation_3s2d(TPC_FREQ_3_REGION* outTpcFreq, TPC_FREQ_3_REGION* tpcFreq1, TPC_FREQ_3_REGION* tpcFreq2);
#else 
void TPC_bwInterpolation_1s2d(TPC_FREQ_1S2D* outTpcFreq, TPC_FREQ_1S2D* tpcFreq1, TPC_FREQ_1S2D* tpcFreq2);
void TPC_bwInterpolation_2s2d(TPC_FREQ_2S2D* outTpcFreq, TPC_FREQ_2S2D* tpcFreq1, TPC_FREQ_2S2D* tpcFreq2);
void TPC_bwInterpolation_3s2d(TPC_FREQ_3S2D* outTpcFreq, TPC_FREQ_3S2D* tpcFreq1, TPC_FREQ_3S2D* tpcFreq2);
#endif
//************************************
// Method:    
// Purpose:   read TPC freq array to construct TPC limits in tpcData
// Parameter: void
// Returns:   void
//************************************
void TPC_buildTpcLimitsFromTpcFreq(uint8 ant, TPC_FREQ* tpcList);
//************************************
// Method:    
// Purpose:   load TSSI parameters
// Parameter: void
// Returns:   void
//************************************
void TPC_loadTSSIparams(uint8 ant, TPC_FREQ* tpcList);
//************************************
// Method:    
// Purpose:   calibrate gain
// Parameter: 
// Returns:   void
//************************************
bool TPC_calibrateGain(uint8 ant, uint8 bw, uint8 TpcIndex);
//************************************
// Method:    
// Purpose:   set TPC timer for time period in tpcClosedLoop DB
// Parameter: 
// Returns:   void
//************************************
void TPC_setTimer(void);
//************************************
// Method:    
// Purpose:   stops TPC timer
// Parameter: 
// Returns:   void
//************************************
void TPC_stopTimer(void);
//************************************
// Method:    
// Purpose:   TPC ISR
// Parameter: 
// Returns:   void
//************************************
void ISR_TPC(void);

//************************************
// Method:    
// Purpose:   write gain table to PHY RAM
// Parameter: void
// Returns:   void
//************************************
void TPC_writeGainTable(int8 gainTable[TPC_GAIN_TABLE_MAX_ROWS][TPC_MAX_GAIN_LEVELS]);
//************************************
// Method:    
// Purpose:   write power out vector for a specific ant and bandwidth
// Parameter: void
// Returns:   void
//************************************
void TPC_writePout(uint8* pOutVec, uint8 ant, uint8 bandwidth);

//************************************
// Method:    
// Purpose:   write power out vector for a specific ant and bandwidth
// Parameter: void
// Returns:   void
//************************************
int16 TPC_calcPowerFromFeedback(uint8 ant, uint8 bw, uint16 feedback);

//************************************
// Method:    
// Purpose:   return regulation limit
// Parameter: void
// Returns:   void
//************************************
int16 TPC_getRegulationLimit(uint8 bandwidth);
int16 TPC_getRegulationLimitMU(uint8 bandwidth);
int16 TPC_getRegulationLimitBF(uint8 bandwidth);

//************************************
// Method:    
// Purpose:   return 11b regulation limit
// Parameter: void
// Returns:   void
//************************************
int16 TPC_get11bRegulationLimit(void);

//************************************
// Method:    
// Purpose:   return max EVM power (maximum power that achieves target EVM)
// Parameter: void
// Returns:   void
//************************************
int16 TPC_getMaxEVMpower(uint8 ant, uint8 bandwidth);

//************************************
// Method:    
// Purpose:   return minimum allowed power
// Parameter: void
// Returns:   void
//************************************
int16 TPC_getMinPower(uint8 ant, uint8 bandwidth);

//************************************
// Method:    
// Purpose:   return array of antennas' boosts
// Parameter: void
// Returns:   void
//************************************
void TPC_runClosedLoop(K_MSG* psMsg);
//************************************
// Method:    
// Purpose:   set fixed gain word for all power out vectors
// Parameter: void
// Returns:   void
//************************************
void TPC_setFixedGain(void);
//************************************
// Method:    
// Purpose:   set fixed power and gain words
// Parameter: dutPowerOutVecParams_t
// Returns:   void
//************************************
void TPC_setFixedPowerAndGain(dutPowerOutVecParams_t* params);

//************************************
// Method:    
// Purpose:   return LUT from power value (in 0.5 dBm resolution) to power index
// Parameter: void
// Returns:   void
//************************************
void TPC_getPowerToIndexLUT(LA_SET_TPC_DATA_t* tpcInfo);
//************************************
// Method:    
// Purpose:   shift entire power out vector for ant and bw by shift
// Parameter: 
// Returns:   void
//************************************
void TPC_shiftPowerOutVector(uint8 ant, uint8 bw, uint8 startIndex, uint8 startGain);


uint8 TPC_getLoopType(void);
//************************************
// Method:    
// Purpose:   shift entire power out vector for ant and bw by shift
// Parameter: 
// Returns:   void
//************************************




/******************************************************************************/
/***						Public Function Declaration						***/
/******************************************************************************/


//************************************
// Method:    TPC_DataBaseHandler
// Purpose:   TBD
// Parameter: uint32 minorID
// Parameter: uint32 * u32SrcAddress
// Parameter: uint32 u32Length
// Returns:   void
//************************************

/* Set the */
void TPC_SetHwTxGain(IN uint8 index, IN uint32 even, IN uint32 odd);

/* Get the */
void TPC_GetHwTxGain(IN uint8 index, OUT uint32* even, OUT uint32* odd);

void TPC_GetTxPowerIndex(IN uint8 spectrumMode, OUT uint8* powerIndex);

uint8 TPC_getPowerIndexValue(uint8 powerIndex, Antenna_e ant, Bandwidth_e bw);

void TPC_checkExtPA(void);
void TPC_configureS2DGainAndOffset(tpcS2dParams_t *s2dParams);
uint8 TPC_getMinAntBoostOverBws(uint8 ant);

void TPC_setTxPowerTableOffset(uint8 ant, TPC_FREQ* tpcFreqParams);

void TPC_setGetTxTableOffset(uint8 antIdx, uint8 bwIdx, short* rf_power_offset_val, uint8 setGet );


//#endif /* #if (ENET_REAL_PHY ==  PHY_REAL_MT_11A_11N)  */
#endif // __TpcClbrHndlr_h__


