#ifndef __TPC_DEFINITIONS_H__
#define __TPC_DEFINITIONS_H__

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/

#define DIGITAL_INDEX_MIN	DIGITAL_INDEX_MINUS_1_25dB
#define DIGITAL_INDEX_MAX	DIGITAL_INDEX_1_25dB

/******************************************************************************/
/***						Definitions								***/
/******************************************************************************/
//Indexes: HI - high value (-3), LOW - low value (-15)
#define TPC_MIXER_IDX_HI	(0)										// default: -3
#define TPC_MIXER_IDX_LOW	(1)		
#define TPC_MIXER_VAL_HI	(TpcMixerGainValues[TPC_MIXER_IDX_HI])	// default: -3
#define TPC_MIXER_VAL_LOW	(TpcMixerGainValues[TPC_MIXER_IDX_LOW])	// -15

//Indexes: HI - high value (8), LOW - low value (-4)
#define TPC_PA_IDX_HI		(0)										// default: 8
#define TPC_PA_IDX_LOW		(1)		
#define TPC_PA_VAL_HI		(TpcPaGainValues[TPC_PA_IDX_HI])		// default: 8
#define TPC_PA_VAL_LOW		(TpcPaGainValues[TPC_PA_IDX_LOW])		// -4

#define TPC_ATPC_MIN_INDEX				(0)	//-6 dB in 2dB steps
#define TPC_ATPC_MAX_INDEX				(7)	//8 dB in 2dB steps
#define TPC_MAX_ATPC_STEPS_ALLOWED		(1)	//Up and DOWN direction: 1 step = 2dB
#define TPC_SWITCH_DB_BACKOFF			(2)	//backoff in dB 

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/

/******************************************************************************/
/***					Static Variables Declarations						***/
/******************************************************************************/
//Indexes according to PHY register
//static int8 TpcGainValues[] = { -6, -4, -2, 0, 2, 4, 6, 8 };	//dB - indexes according to PHY register
static int16 TpcMixerGainValues[] = {ADJUST_TO_FLOATING_POINT(-3), ADJUST_TO_FLOATING_POINT(-12)};		//dB - indexes according to PHY register
static int16 TpcPaGainValues[]    = {ADJUST_TO_FLOATING_POINT(8),  ADJUST_TO_FLOATING_POINT(-4) };		//dB - indexes according to PHY register

/******************************************************************************/
/***					Static Function Declarations						***/
/******************************************************************************/

static void	adjustTpcDigGains(int8 *Dig_gain_index, uint8 *Tpc_gain_index);


#endif // __TPC_DEFINITIONS_H__
