#ifndef __TxIQMismatchClbrHndlr_h__
#define __TxIQMismatchClbrHndlr_h__

#include "System_GlobalDefinitions.h"
#include "CalibrationDefs.h"
#include "PhyCalDriver_API.h"

#ifndef ENET_INC_ARCH_WAVE600
#define	DIGITAL_GAIN_0DB	256
#endif

/******************************************************************************/
/***					Public Function Declarations						***/
/******************************************************************************/

//************************************
// Method:    TxIQClbr_Calibrate
// FullName:  TxIQClbr_Calibrate
// Access:    public 
// Returns:   RetVal_e
// Qualifier:
// Parameter: IN ClbrType_e inCalibType
//************************************
RetVal_e TxIQClbr_Calibrate(IN ClbrType_e inCalibType);

void TxIQClbr_SetStatus(IN uint32 inAntenna, IN CalStatus_e inStatus);
CalStatus_e TxIQClbr_GetStatus( IN uint32 inAntenna );

uint32 TxIQClbr_GetLastRunTime(void);


#ifndef ENET_INC_ARCH_WAVE600
//************************************
// Method:    TxIQ_LoadResults
// Purpose:   Loads Tx IQ calibration data from a buffer
// Parameter: 
// Returns: 
//************************************
void TxIQClbr_LoadResults(void);
uint32* TxIQClbr_GetElement(void);
#endif

#endif // __TxIQMismatchClbrHndlr_h__
