#ifndef __TxLOLeakageClbrHndlr_h__
#define __TxLOLeakageClbrHndlr_h__

#include "System_GlobalDefinitions.h"
#include "CalibrationDefs.h"
#include "HdkGlobalDefs.h"


/******************************************************************************/
/***						Type Definitions								***/
/******************************************************************************/

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/
#ifndef ENET_INC_ARCH_WAVE600
#define LO_TPC_MASK_IS_BIT_ON(tpcMask,tpcIdx)		((tpcMask) & ANTENNA_BIT(tpcIdx))	// Is TPC bit on in TPC mask
#endif

//************************************
// Method:    TxLoLeakage_Calibrate
// FullName:  TxLoLeakage_Calibrate
// Access:    public 
// Returns:   RetVal_e
// Qualifier:
// Parameter: IN ClbrType_e inCalibType
//************************************
RetVal_e TxLoLeakage_Calibrate(IN ClbrType_e inCalibType);


#ifdef ENET_INC_ARCH_WAVE600
void TxLoLeakage_SetStatus(uint8 antMask, CalStatus_e inStatus);
#else
void TxLoLeakage_SetStatus(IN uint32 inAntenna, IN CalStatus_e inStatus);

//************************************
// Method:    TxLoLeakage_LoadResults
// Purpose:   Loads LO Leakage data from a buffer
// Parameter: uint8 * in_puBuffer - Buffer containing calibration information
// Returns:   uint32 - Amount of bytes read from buffer
//************************************
void TxLoLeakage_LoadResults( void );

#endif
CalStatus_e TxLoLeakage_GetStatus(IN uint32 inAntenna);
uint32 TxLoLeakage_GetLastRunTime(void);

#endif // __TxLOLeakageClbrHndlr_h__
