#include "CalibrationHandler.h"
#include "CalibrationHandlerUtils.h"
#include "CalibrationHandlerStatistics.h"
#include "System_GlobalDefinitions.h"
#include "HdkGlobalDefs.h"
#include "stringLibApi.h"
#include "RficDriver_API.h"
#include "mhi_mac_event.h"
#include "shram_man_queues.h"
#include "int_gen.h"
#include "BeamFormingClbrHndlr.h"
#include "LpfClbrHndlr_API.h"
#include "MsSsiAdcClbrHndlr.h"
#include "RficBiasClbrHndlr.h"
#include "RssiPathClbrHndlr.h"
#include "RssiDcOffsetClbrHndlr.h"
#include "RssiFilterClbrHndlr.h"
#include "RxDcOffsetClbrHndlr.h"
#include "RxIQMismatchClbrHndlr.h"
#include "TpcClbrHndlr.h"
#include "TxIQMismatchClbrHndlr.h"
#include "TxLOLeakageClbrHndlr.h"
#include "ErrorHandler_Api.h"
#include "CalibrationManager.h"
#include "mt_sysdefs.h"
#include "Shram_ClbrDataBuffer.h"
#include "calibrationsParamsOtf.h"
#include "LpfDefinitions.h"
#include "RssiPathDefinitions.h"
#include "System_Timers.h"
#include "loggerAPI.h"
#include "CalibrationsDefines.h"
#include "ChannelSwitchManager_Api.h"
#include "PSD.h"
#include "Pac_Api.h"
#include "CoC_Api.h"
#include "Utils_Api.h"
#include "Afe_API.h"
#include "HdkCdbManagerTask_api.h"
#include "queue_utility.h"
#include "PhyRxTdRegs.h"
#include "RegAccess_Api.h"
#include "Dut_Api.h"


#define LOG_LOCAL_GID   GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 0


////////////////////////
// Definitions
////////////////////////
//#define CALIBRATION_HANDLER_LOGS

typedef RetVal_e (*clbrProcFuncPtr_t)(IN ClbrType_e calibType);
typedef void (*clbrLoadFuncPtr_t)(void);
#define CAL_STATE_SHOULD_SAVE_MASK	(0x1)
#define CAL_STATE_SHOULD_SAVE_SHIFT	0
#define CAL_STATE_CAL_PASSED_MASK	(0x2)
#define CAL_STATE_CAL_PASSED_SHIFT	1
#define CAL_STATE_IS_CAL_MASK	(0x4) //state that calibration was done and saved
#define CAL_STATE_IS_CAL_SHIFT	2


#define CAL_STATE_DONT_SAVE	  0
#define CAL_STATE_SHOULD_SAVE 1

#define CAL_STATE_FAILED 0
#define CAL_STATE_PASSED 1

#define CAL_STATE_NOT_CALIBRATED 0
#define CAL_STATE_CALIBRATED 1

uint8 initCalStates[CLBR_PROC_TYPE_NUM];
#ifdef ENET_INC_ARCH_WAVE600

extern int rxIq_bug_global;
#endif
const uint32 OfflineCalModes[ST_LAST] = 
{
	OFFLINE_CAL_MODE_SKIP,
	OFFLINE_CAL_MODE_SKIP,
	OFFLINE_CAL_MODE_SKIP,
	OFFLINE_CAL_MODE_SKIP,
	OFFLINE_CAL_MODE_SKIP,
	OFFLINE_CAL_MODE_FULL
};

////////////////////////
// Forward Declarations
////////////////////////
void updateHandlersStatus(IN uint32 procMask);

void loadCalibrationResults(void);
uint32 getUpdateOfflineStatus(IN uint32 procMask);
void ClbrHndlr_initCalibrationsStates(void);
void preCal(void);
void postCal(void);
static RetVal_e setVco(void);
static RetVal_e  handleVco(void);
////////////////////////
// Private Members
////////////////////////
static uint32 m_supportedClbrMask = 0;
static clbrProcFuncPtr_t m_clbrMethodsArray[CLBR_PROC_TYPE_NUM] = {0};
static clbrLoadFuncPtr_t m_clbrLoadFuncsArray[CLBR_PROC_TYPE_NUM] = {0};
static CalibrSchedData_t* m_pClbrData;

////////////////////////
// Public Members
////////////////////////

#ifndef ENET_INC_ARCH_WAVE600
Calibration_params_otf_t Calibration_params_otf = {
	{//RxIQ
		{   //RxIQ_Elements results
    		{CAL_STATUS_INIT,CAL_STATUS_INIT,CAL_STATUS_INIT,CAL_STATUS_INIT},		//status[MAX_NUM_OF_ANTENNAS],
    		{0,0,0,0},{0,0,0,0},				//w1[MAX_NUM_OF_ANTENNAS],w2[MAX_NUM_OF_ANTENNAS]
    		{0,0,0,0},{0,0,0,0},				//w1_err[MAX_NUM_OF_ANTENNAS],w2_err[MAX_NUM_OF_ANTENNAS]
    		0									//lastRunTime
    	},
    	{   //RxIQ_Elements params
    		RX_IQ_NUM_SAMPLES_OFFLINE,W_ERROR_PERCENTAGE,
    		(HdkLnaIndex_e)RX_IQ_LNA,RX_IQ_PGC1,RX_IQ_PGC2,RX_IQ_PGC3,RX_IQ_ROUND,RX_IQ_IIR_MU
    	}
	},

    {//RxDC
		{   //RxDC_Elements results
			{0}, // minReference
			{0}, // minReference1stGain
			{0}, // minReference2ndGain
			{1,1,1,1,1,1}, // Linear direction default is positive
			0, // numOfSamples
			0, // maxDcOffsetDuringCalibration;
			0, // maxDcOffsetAfterTxVerify;
			0, // maxDcOffsetAfterTxVerifyWithHighPgc3;
			0, // maxDcOffsetAfterRxVerify;
			0, // maxDcOffsetAtOnline;
			0, // numOfDeviationFromMaxAfterTxVerify;
			0, // calState;
			FALSE, // isIqSwapped
		},
	    {
		    0, // lastRunTime
		    0,0,0,0,//errorBitmap
		    0,0,0,0,//errorBitmap
			CAL_STATUS_INIT, CAL_STATUS_INIT, CAL_STATUS_INIT,CAL_STATUS_INIT, // calStatusI
			CAL_STATUS_INIT, CAL_STATUS_INIT, CAL_STATUS_INIT,CAL_STATUS_INIT  // calStatusQ
		},
		{   //RxDC_Elements data set
			0 
		}
	},
	
    {//Lpf
        {
            PGC1_GAIN,
            PGC2_GAIN,
            PGC3_GAIN,
            TONE_GEN_AMPLITUDE,
            NUM_OF_GOERTZEL_CYCLES,
            INITIAL_LPF_WORD,
            MAX_NUM_OF_STEPS_EDGE_BAND,
            RX_CB_STOP_BIN,
            RX_NCB_STOP_BIN,
            FIRST_PASS_BAND_REF_BIN
        },
        {//lpfResults
            0, // lastRunTime
            CAL_STATUS_INIT, // LPF_Status[0]
            CAL_STATUS_INIT, // LPF_Status[1]
            CAL_STATUS_INIT, // LPF_Status[2]
            CAL_STATUS_INIT, // LPF_Status[3]
            0, // edge_band_error[0]
            0, // edge_band_error[1]
            0, // edge_band_error[2]
            0, // edge_band_error[3]
            0, // stop_band_error[0]
            0, // stop_band_error[1]
            0, // stop_band_error[2]
            0,  // stop_band_error[3]
            {0},
			{0},
			{0}
        }, 
        {
            0 // DataSet is reset at every run anyways - it is a scratchpad for the process
        }
    }, 
    
    {//Rssi
        {
            {CAL_STATUS_INIT, CAL_STATUS_INIT, CAL_STATUS_INIT, CAL_STATUS_INIT}, 
            0,
            0,
            0,
            0,
            {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}
        },
        {
            RSSI_PATH_SECTION_SIZE, RSSI_PATH_SECTION_SIZE_AFTER_PARTITION, RSSI_PATH_NUM_SECTION_PARTITION,
            RSSI_PATH_NUM_OF_SAMPLES_TO_AVERAGE_CB, RSSI_PATH_NUM_OF_SAMPLES_TO_AVERAGE_NCB,
            LOW_PATITION_THRESHOLD, HIGH_PATITION_THRESHOLD, EDGE_THRESHOLD,
            RUN_OVER_NUM_CELLS_HIGH_TABLE_ZONE, RUN_OVER_NUM_CELLS_LOW_TABLE_ZONE,
            RSSI_PATH_TONE_FOR_MEASUREMENT,RSSI_PATH_TONE_INIT_AMPLITUDE,
            RSSI_PATH_TONE_POWER_OFFSET, RSSI_PATH_TONE_CAL_GAIN_LIMIT,
            RSSI_PATH_TONE_MIN_POWER,RSSI_PATH_TONE_MAX_POWER,
            RSSI_PATH_TABLE_OFFSET,RSSI_PATH_NCB_TABLE_OFFSET,
            VERIFY_RESOLUTION, MAX_RSSI_POWER_DIFF, MIN_RSSI_DYNAMIC_RANGE, 
            RSSI_PATH_NUM_VARIATION_SAMPLES, RSSI_PATH_VARIATION_POWER, RSSI_PATH_MAX_MEASUREMENT_VARIATION,
            RSSI_PATH_LNA,RSSI_PATH_PGC1,RSSI_PATH_PGC2,RSSI_PATH_PGC3,
        }
    },
    
    {//TxIq
	    {
		    {//binStatus[][]													
			    { BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE },
			    { BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE },
				{ BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE },
			    { BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE,BIN_CALIB_NONE }
		    },	
		    {//energyOffset[][]    
                { 0,0,0,0,0,0 },{ 0,0,0,0,0,0 },{ 0,0,0,0,0,0 },{ 0,0,0,0,0,0 }
            },   
		    {//a[][]
                { 0,0,0,0,0,0 },{ 0,0,0,0,0,0 },{ 0,0,0,0,0,0 },{ 0,0,0,0,0,0 }
            },   
		    {//b[][]   
                { 0,0,0,0,0,0 },{ 0,0,0,0,0,0 },{ 0,0,0,0,0,0 },{ 0,0,0,0,0,0 }
            },    
            {//SSB_F_20M[2][2]  
                {0,0},{0,0}
            },
            {//SSB_F_40M[2][2]
                {0,0},{0,0}
            },
		    {CAL_STATUS_INIT,CAL_STATUS_INIT,CAL_STATUS_INIT,CAL_STATUS_INIT},	//status[MAX_NUM_OF_ANTENNAS]
					
					
		    0,//lastRunTime
		    0,//singleBinCalibRunTime
		    0,//SingleBinVerifyRunTime
		    0,//singleBinPairInterpolationRunTime 
		    0,//fixBinsRunTime
		    0 //restorePhyRegistersRunTime	
	    },
	    {
		    {//mat_A[2][PFIT_MAX_PNTS] 																	
			    { 407, 102, -116, -247, -291, -247, -116, 102, 407},
			    { -22370, -16777, -11185, -5592, 0, 5592, 11185, 16777, 22370},	
		    },
		    {//x[PFIT_MAX_PNTS] 
               -100, -75, -50, -25, 0, 25, 50, 75, 100 
            },                      
		    {//CalibratedBinsCb[]
                TXIQ_CB_FIRST_CALIBRATED_BIN,TXIQ_CB_SECOND_CALIBRATED_BIN,TXIQ_CB_LAST_CALIBRATED_BIN
            },   
		    {//CalibratedBinsNCb[]
                TXIQ_NCB_FIRST_CALIBRATED_BIN,TXIQ_NCB_SECOND_CALIBRATED_BIN,TXIQ_NCB_LAST_CALIBRATED_BIN
            },
            {//CalibratedBinsCb80[]
                TXIQ_CB80_FIRST_CALIBRATED_BIN,TXIQ_CB80_SECOND_CALIBRATED_BIN,TXIQ_CB80_LAST_CALIBRATED_BIN
            },
		    TX_IQ_MAX_VERIFY_ENERGY,											//maxVerifyEnergy
		    TX_IQ_PFIT_MAX_PNTS,												//numPointsX (actual)
  		    TX_IQ_MAX_CALIB_BINS_SINGLE_POLARITY,								//numBinsCb80SinglePolarity (actual)
		    TX_IQ_MAX_CALIB_BINS_SINGLE_POLARITY,								//numBinsCbSinglePolarity (actual)
		    TX_IQ_MAX_CALIB_BINS_SINGLE_POLARITY,								//numBinsNCbSinglePolarity (actual)
		    TX_IQ_ONLINE_NUM_BINS_CALIBRATED,									//numBinsOnlineIteration
		    TX_IQ_PGC3,															//pgc3
		    TX_IQ_TONE_AMPLITUDE, TX_IQ_TONE_AMPLITUDE_DBV_CB, TX_IQ_TONE_AMPLITUDE_DBV_NCB,
		    TX_IQ_GRTZL_NUM_OF_CYCLES,TX_IQ_NUM_VERIFICATION_MEASUREMENTS,
		    TXIQ_LSB40_LSB20_20M,    					
		    TXIQ_LSB40_USB20_20M,    					
		    TXIQ_USB40_LSB20_20M,   						
		    TXIQ_USB40_USB20_20M,
		    TXIQ_LSB40_LSB20_40M,    					
		    TXIQ_LSB40_USB20_40M,    					
		    TXIQ_USB40_LSB20_40M,   						
		    TXIQ_USB40_USB20_40M,
		    TXIQ_LSB_20,
		    TXIQ_USB_20
	    }
    },	
	
    {//TxLo
        {
            {0},	//tpcEnergy[][] 
			{0},	//diffEnergy[][] 
			{0},
			{CAL_STATUS_INIT,CAL_STATUS_INIT,CAL_STATUS_INIT,CAL_STATUS_INIT},	//status
			{0},					//refEnergy
			0,							//lastRunTime
			0,							//restoreHwRegistersRunTime;
			0,							//singleTpcCalibRunTime 
			0,							//singleTpcVerifyRunTime
			{0,0,0},					//digitalDac I
			{0,0,0}						//digitalDac Q
		},
		//params
		{
			LO_MAX_VERIFY_ENERGY_DIFF,  //maxVerifyEnergyDiff
			LO_CALIB_BIN,				//calibBin
			LO_VERIFY_REFERENCE_BIN,	//verifyRefBin
			LO_DAC_NUM_ITER_OFFLINE,	//numIter
			LO_PGC2,LO_PGC3,			
			LO_TONE_AMPLITUDE,
			LO_MAX_BINARY_SEARCH_STEPS,LO_MAX_LINEAR_SEARCH_STEPS,
			LO_GRTZL_NUM_OF_CYCLES,LO_NUM_VERIFICATION_MEASUREMENTS,LO_DIGITAL_DAC_NUM_ITER,
			LO_DAC_MIN,LO_DAC_MAX,LO_CLIP_MIN,LO_CLIP_MAX,
			LO_ONLINE_NUM_TPCS_CALIBRATED,
			LO_DIGITAL_DAC_TPC_IDX,
			LO_VERIFY_REFERENCE_TPC_IDX,
			LO_BINARY_PIVOT
        }
    }
};

#endif
////////////////////////
// Private Methods
////////////////////////
//
// Function name	: loadCalibrationResults
//
// Description	    : Loads calibration cached results
//
// Return type		: void
//

void loadCalibrationResults(void)
{
	
    ClbrProcType_e proc;

	do
    {
        proc = GetNextProc(m_pClbrData->loadCalBitmap);
		m_pClbrData->loadCalBitmap &= ~(1<<proc);
		m_clbrLoadFuncsArray[proc]();
    }
    while (m_pClbrData->loadCalBitmap);

}

/***************************************************************************
**
** NAME         resetStatus
**
** PARAMETERS   **
** DESCRIPTION  Reset CalDB statuses
**
****************************************************************************/
void ClbrHndlr_ResetStatus(void)
{
#ifndef ENET_INC_ARCH_WAVE600	
	uint8	i = 0;

	for(i=0;i< MAX_NUM_OF_ANTENNAS ;i++)
	{
		RxDcOffset_SetStatus(i, RFIC_PATH_TYPE_I, CAL_STATUS_INIT);
		RxDcOffset_SetStatus(i, RFIC_PATH_TYPE_Q, CAL_STATUS_INIT);
		RssiPath_SetStatus(i, CAL_STATUS_INIT);
		RxIQ_SetStatus(i, CAL_STATUS_INIT);
		//LPF_SetStatus(i, CAL_STATUS_INIT);
		TxLoLeakage_SetStatus(i, CAL_STATUS_INIT);
		TxIQClbr_SetStatus(i, CAL_STATUS_INIT);
	}
#else
	uint8 antsNum, antsMask;
	HDK_GetMaxActiveAntennasNumAndMask(&antsNum, &antsMask);

	RxDcOffset_SetStatus(antsMask, CAL_STATUS_INIT);
//	RssiPath_SetStatus(antsMask, CAL_STATUS_INIT);
	RxIQ_SetStatus(antsMask, CAL_STATUS_INIT);
	//LPF_SetStatus(i, CAL_STATUS_INIT);
	TxLoLeakage_SetStatus(antsMask, CAL_STATUS_INIT);
	TxIQClbr_SetStatus(antsMask, CAL_STATUS_INIT);
#endif
}

/***************************************************************************
**
** NAME         updateHandlersStatus
**
** PARAMETERS   **
** DESCRIPTION  
**
****************************************************************************/
void updateHandlersStatus( IN uint32 procMask )
{
	if (ClbrHndlr_GetClbrType() == CLBR_TYPE_ONLINE) // update BBstudio form only for Offline Calibration  
	{
		return;
	}

	offlineStatistics.calibrationOfflineStatus.Rxiq_Ant_1   =   RxIQ_GetStatus(ANTENNA_0);
	offlineStatistics.calibrationOfflineStatus.Rxiq_Ant_2   =   RxIQ_GetStatus(ANTENNA_1);
	offlineStatistics.calibrationOfflineStatus.Rxiq_Ant_3   =   RxIQ_GetStatus(ANTENNA_2);
	offlineStatistics.calibrationOfflineStatus.Rxiq_Ant_4   =   RxIQ_GetStatus(ANTENNA_3);

	offlineStatistics.calibrationOfflineStatus.TXLL_Ant_1   =   TxLoLeakage_GetStatus(ANTENNA_0);
	offlineStatistics.calibrationOfflineStatus.TXLL_Ant_2   =   TxLoLeakage_GetStatus(ANTENNA_1);
	offlineStatistics.calibrationOfflineStatus.TXLL_Ant_3   =   TxLoLeakage_GetStatus(ANTENNA_2);
	offlineStatistics.calibrationOfflineStatus.TXLL_Ant_4   =   TxLoLeakage_GetStatus(ANTENNA_3);

	offlineStatistics.calibrationOfflineStatus.TXMM_Ant_1   =   TxIQClbr_GetStatus(ANTENNA_0);
	offlineStatistics.calibrationOfflineStatus.TXMM_Ant_2   =   TxIQClbr_GetStatus(ANTENNA_1);
	offlineStatistics.calibrationOfflineStatus.TXMM_Ant_3   =   TxIQClbr_GetStatus(ANTENNA_2);
	offlineStatistics.calibrationOfflineStatus.TXMM_Ant_4   =   TxIQClbr_GetStatus(ANTENNA_3);
	
#ifndef ENET_INC_ARCH_WAVE600
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_1_I	=	RxDcOffset_GetStatus(ANTENNA_0, RFIC_PATH_TYPE_I);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_2_I	=	RxDcOffset_GetStatus(ANTENNA_1, RFIC_PATH_TYPE_I);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_3_I	=	RxDcOffset_GetStatus(ANTENNA_2, RFIC_PATH_TYPE_I);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_4_I	=	RxDcOffset_GetStatus(ANTENNA_3, RFIC_PATH_TYPE_I);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_1_Q	=	RxDcOffset_GetStatus(ANTENNA_0, RFIC_PATH_TYPE_Q);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_2_Q	=	RxDcOffset_GetStatus(ANTENNA_1, RFIC_PATH_TYPE_Q);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_3_Q	=	RxDcOffset_GetStatus(ANTENNA_2, RFIC_PATH_TYPE_Q);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_4_Q	=	RxDcOffset_GetStatus(ANTENNA_3, RFIC_PATH_TYPE_Q);

	offlineStatistics.calibrationOfflineStatus.Rssi_Ant_1	=	RssiPath_GetStatus(ANTENNA_0);
	offlineStatistics.calibrationOfflineStatus.Rssi_Ant_2	=	RssiPath_GetStatus(ANTENNA_1);
	offlineStatistics.calibrationOfflineStatus.Rssi_Ant_3	=	RssiPath_GetStatus(ANTENNA_2);
	offlineStatistics.calibrationOfflineStatus.Rssi_Ant_4	=	RssiPath_GetStatus(ANTENNA_3);
	
	offlineStatistics.calibrationOfflineStatus.BF_afe		=	BeamForming_GetStatus(AFE);
	offlineStatistics.calibrationOfflineStatus.BF_agcGain	=	BeamForming_GetStatus(AGC_GAIN);
	offlineStatistics.calibrationOfflineStatus.BF_K 		=	BeamForming_GetStatus(K_CALIBRATION);
	offlineStatistics.calibrationOfflineStatus.BF_agcOffset =	BeamForming_GetStatus(AGC_OFFSET);
	offlineStatistics.calibrationOfflineStatus.BF_txOffset	=	BeamForming_GetStatus(TX_OFFSET);
	offlineStatistics.calibrationOfflineStatus.BF_modType	=	BeamForming_GetofflineModulationType();

	offlineStatistics.calibrationOfflineStatus.Rssi_DC_Ant_1   =   RssiDcOffset_GetStatus(ANTENNA_0);
	offlineStatistics.calibrationOfflineStatus.Rssi_DC_Ant_2   =   RssiDcOffset_GetStatus(ANTENNA_1);
	offlineStatistics.calibrationOfflineStatus.Rssi_DC_Ant_3   =   RssiDcOffset_GetStatus(ANTENNA_2);
	offlineStatistics.calibrationOfflineStatus.Rssi_DC_Ant_4   =   RssiDcOffset_GetStatus(ANTENNA_3);
#else
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_1_I	=	RxDcOffset_GetStatus(ANTENNA_0);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_2_I	=	RxDcOffset_GetStatus(ANTENNA_1);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_3_I	=	RxDcOffset_GetStatus(ANTENNA_2);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_4_I	=	RxDcOffset_GetStatus(ANTENNA_3);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_1_Q	=	RxDcOffset_GetStatus(ANTENNA_0);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_2_Q	=	RxDcOffset_GetStatus(ANTENNA_1);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_3_Q	=	RxDcOffset_GetStatus(ANTENNA_2);
	offlineStatistics.calibrationOfflineStatus.Dc_Ant_4_Q	=	RxDcOffset_GetStatus(ANTENNA_3);

#endif

	// Update the structure returned to the CM
	m_pClbrData->errors.u32calibrAlgoType = HDK_getLowChannel();
	m_pClbrData->errors.u32ErrCode = 	getUpdateOfflineStatus(procMask);

	offlineStatistics.RunTime[CLBR_PROC_TYPE_MS_REPLICA_TUNING]=0;	
	offlineStatistics.RunTime[CLBR_PROC_TYPE_RX_DC_OFFSET]=RxDcOffset_GetLastRunTime();
	offlineStatistics.RunTime[CLBR_PROC_TYPE_LPF]= 0;//LPF_GetLastRunTime();
	offlineStatistics.RunTime[CLBR_PROC_TYPE_RX_IQ_NLMS]=0;
	offlineStatistics.RunTime[CLBR_PROC_TYPE_TX_LO_LEAKAGE]=TxLoLeakage_GetLastRunTime();
	offlineStatistics.RunTime[CLBR_PROC_TYPE_RX_IQ_MISMATCH]=RxIQ_GetLastRunTime();
	offlineStatistics.RunTime[CLBR_PROC_TYPE_TX_IQ_MISMATCH]=TxIQClbr_GetLastRunTime();
	offlineStatistics.RunTime[CLBR_PROC_TYPE_TPC]=0;
#ifndef ENET_INC_ARCH_WAVE600
	offlineStatistics.RunTime[CLBR_PROC_TYPE_RSSI_DC_OFFSET]=RssiDcOffset_GetLastRunTime();	
	offlineStatistics.RunTime[CLBR_PROC_TYPE_RSSI_PATH_CALIB]=RssiPath_GetLastRunTime();	
	offlineStatistics.RunTime[CLBR_PROC_TYPE_BEAM_FORMING]=BeamForming_GetLastRunTime();
#endif
}


static RetVal_e setVco(void)
{
	RetVal_e vcoStatus = RET_VAL_UNINITIALIZED;
#if !defined(HDK_RF_EMULATOR)
	uint8 antennaMask;
	PowerSaveStates_e powerSaveState = RADIO_ON;
#endif
	vcoStatus = RficDriver_SetFrequency(HDK_getSetChannelParams());
#if !defined ENET_INC_ARCH_WAVE600
	hdk_clippingTrigger();	// we dont have clipping option in GEN6 
#endif
#if !defined(HDK_RF_EMULATOR)
	antennaMask = Hdk_GetTxAntMask();
	AFE_EnableDisableAntennas(antennaMask,powerSaveState);
#endif
	return vcoStatus;
}

static RetVal_e  handleVco()
{
	RetVal_e status;

	status = setVco();
#if !defined(HDK_RF_EMULATOR)
	ASSERT(status == RET_VAL_SUCCESS);
#endif	
	return status;
}
void ClbrHndlr_setFrequency(void)
{
	handleVco();
}

RetVal_e runCalibration(void)
{
	uint32     procBitmap = m_pClbrData->calBitmap;
	ClbrType_e clbrType = (ClbrType_e)(m_pClbrData->calibrSMState);
	RetVal_e   rc = RET_VAL_SUCCESS; 
	bool setDMA = FALSE;
	uint8 *pCalState;
	bool shouldSave, isPassed;
#ifdef ENET_INC_ARCH_WAVE600
	if ((ST_NORMAL == hdkGetChannelSwitchType()) && (1 == rxIq_bug_global))//debug to catch rxiq bug - accumolater measures low results
	{
		ILOG0_V("RxIq got wrong measurments");
		//ASSERT(0);
	}
#endif

#ifdef CALIBRATION_HANDLER_LOGS
	ILOG2_DD("runCalibration. clbrType: %d dataStoreState: %d", clbrType, m_pClbrData->dataStoreState);	
#endif	
	// Store RF DataBase before starting Calibration 
	RficDriver_StoreRegDB();
	
	// If Loading data from host
	if((clbrType == CLBR_TYPE_OFFLINE ) && (m_pClbrData->loadCalBitmap != 0) )
	{ 
		loadCalibrationResults();
	}
	while (m_pClbrData->calBitmap)
	{
		ClbrProcType_e proc = GetNextProc(m_pClbrData->calBitmap);
		pCalState = &ShramClbrDataBufferStoreChanData.stateArray[proc];
		shouldSave = (*pCalState & CAL_STATE_SHOULD_SAVE_MASK) >> CAL_STATE_SHOULD_SAVE_SHIFT;
		ILOG0_D("runCalibration. proc %d",proc);
		m_pClbrData->calBitmap &= ~(1<<proc);
        m_pClbrData->dataStoreState = CAL_DATA_STATE_STORE;
		DEBUG_ASSERT(m_clbrMethodsArray[proc] != NULL);
		rc = m_clbrMethodsArray[proc](clbrType);
		isPassed = (*pCalState & CAL_STATE_CAL_PASSED_MASK) >> CAL_STATE_CAL_PASSED_SHIFT;
		m_pClbrData->dataStoreState = CAL_DATA_STATE_LOAD;
		if ((shouldSave == CAL_STATE_SHOULD_SAVE) && (isPassed == CAL_STATE_PASSED))
		{
			setDMA = TRUE;
		}	
	}
	if (setDMA == TRUE)
	{
		m_pClbrData->dataStoreState = CAL_DATA_STATE_STORE; 
	}	
	
	if(clbrType == CLBR_TYPE_ONLINE )
	{
		// Was entire calibration process finished. NOTE: this is set for the LAST procedure run!
		m_pClbrData->isOnlineProcComplete = (rc == RET_VAL_FRAGMENTED ? FALSE : TRUE);

#ifdef CALIBRATION_HANDLER_LOGS
		if(rc == RET_VAL_FRAGMENTED)
        {
		    ILOG2_V("Calibrations fragmented");
        }
        else
        {
            ILOG2_V("Finished Calibrations");
        }
#endif
	}
	// Store the calibration results status for the host
	updateHandlersStatus(procBitmap);
	
	return rc;
}

/***************************************************************************
**
** NAME          getUpdateOfflineStatus
**
** PARAMETERS   **
** DESCRIPTION : This function sends calibration status to the driver 
**               in case one of the calibrations failed.  
**
****************************************************************************/
uint32 getUpdateOfflineStatus( IN uint32 procMask )
{
	uint32 StatusVector = 0;
#ifndef ENET_INC_ARCH_WAVE600	
	uint32 i            = 0;
	CalStatus_e stat    = CAL_STATUS_INIT;
	QBF_CalibrationType_e bfType;

	if (procMask & CLBR_PROC_BIT_BEAM_FORMING)
	{
		for(bfType = AFE; bfType < MAX_NUMBER_OF_BF_CALS ; bfType++)
		{
			stat = BeamForming_GetStatus(bfType);
			if ((stat == CAL_STATUS_FAIL) || (stat == CAL_STATUS_STUCK))
			{
				StatusVector |= (1<<(bfType));
			}
		}
	}
	for(i=0;i< MAX_NUM_OF_ANTENNAS ;i++)
	{
		if (procMask & CLBR_PROC_BIT_RX_DC_OFFSET)
		{
			stat = RxDcOffset_GetStatus(i, RFIC_PATH_TYPE_I);
			if ((stat == CAL_STATUS_FAIL) || (stat == CAL_STATUS_STUCK))
			{
				StatusVector |= (1 << (i + MAX_NUMBER_OF_BF_CALS));
			}
			stat = RxDcOffset_GetStatus(i, RFIC_PATH_TYPE_Q);
			if ((stat == CAL_STATUS_FAIL) || (stat == CAL_STATUS_STUCK))
			{
				StatusVector |= (1 << (i + MAX_NUMBER_OF_BF_CALS + MAX_NUM_OF_ANTENNAS));
			}
		}

		stat = RssiPath_GetStatus(i);
		if ((procMask & CLBR_PROC_BIT_RSSI_PATH) && ((stat == CAL_STATUS_FAIL) || (stat == CAL_STATUS_STUCK)))
		{
			StatusVector |= (1<<(i + MAX_NUMBER_OF_BF_CALS + (2*MAX_NUM_OF_ANTENNAS)));
		}

		//stat = LPF_GetStatus(i);
		//if ((procMask & CLBR_PROC_BIT_LPF) && ((stat == CAL_STATUS_FAIL) || (stat == CAL_STATUS_STUCK)))
		//{
		//	StatusVector |= (1<<(i+9));
		//}

		stat = RxIQ_GetStatus(i);
		if ((procMask & CLBR_PROC_BIT_RX_IQ_MISMATCH) && ((stat == CAL_STATUS_FAIL) || (stat == CAL_STATUS_STUCK)))
		{
			StatusVector |= (1<<(i + MAX_NUMBER_OF_BF_CALS + (3*MAX_NUM_OF_ANTENNAS)));
		}

		stat = TxIQClbr_GetStatus(i);
		if ((procMask & CLBR_PROC_BIT_TX_IQ_MISMATCH) && ((stat == CAL_STATUS_FAIL) || (stat == CAL_STATUS_STUCK)))
		{
			StatusVector |= (1<<(i + MAX_NUMBER_OF_BF_CALS + (4*MAX_NUM_OF_ANTENNAS)));
		}

		stat = TxLoLeakage_GetStatus(i);
		if ((procMask & CLBR_PROC_BIT_TX_LO_LEAKAGE) && ((stat == CAL_STATUS_FAIL) || (stat == CAL_STATUS_STUCK)))
		{
			StatusVector |= (1<<(i + MAX_NUMBER_OF_BF_CALS + (5*MAX_NUM_OF_ANTENNAS)));
		}

	}
#ifdef CALIBRATION_HANDLER_LOGS

	ILOG2_DD("CalibrationHandler getUpdateOfflineStatus(). StatusVector = 0x%x %d",StatusVector, StatusVector);
#endif
#else
	UNUSED_PARAM(procMask);	
#endif
	return StatusVector;
}

static void setAvailProcs(IN clbrHndlrResetConf_t* pConf)
{
	UNUSED_PARAM(pConf);	
	m_supportedClbrMask = SUPPORTED_OFFLINE_CALIBRATION_MASK | SUPPORTED_ONLINE_CALIBRATION_MASK;

	// Init the handlers running funcs pointers
	m_clbrMethodsArray[CLBR_PROC_TYPE_LPF] =				NULL;//(m_supportedClbrMask & CLBR_PROC_BIT_LPF)? LPF_Calibrate:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_MS_REPLICA_TUNING] =	NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_RSSI_PATH_CALIB] =	(m_supportedClbrMask & CLBR_PROC_BIT_RSSI_PATH)? RssiPath_Calibrate:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_RX_DC_OFFSET] =		(m_supportedClbrMask & CLBR_PROC_BIT_RX_DC_OFFSET)? RxDcOffset_Calibrate:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_RX_IQ_MISMATCH] =		(m_supportedClbrMask & CLBR_PROC_BIT_RX_IQ_MISMATCH)? RxIQ_Calibrate:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_TX_IQ_MISMATCH] =		(m_supportedClbrMask & CLBR_PROC_BIT_TX_IQ_MISMATCH)? TxIQClbr_Calibrate:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_TX_LO_LEAKAGE] =		(m_supportedClbrMask & CLBR_PROC_BIT_TX_LO_LEAKAGE)? TxLoLeakage_Calibrate:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_RFIC_BIAS] =			(m_supportedClbrMask & CLBR_PROC_BIT_RFIC_BIAS)? RficBias_Calibrate :NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_BEAM_FORMING] =		(m_supportedClbrMask & CLBR_PROC_BIT_BEAM_FORMING)? BeamForming_run:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_RSSI_DC_OFFSET] =		(m_supportedClbrMask & CLBR_PROC_BIT_RSSI_DC_OFFSET)? RssiDcOffset_Calibrate:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_MS_SSI_ADC] =			(m_supportedClbrMask & CLBR_PROC_BIT_MS_SSI_ADC)? MsSsiAdc_Calibrate:NULL;
	m_clbrMethodsArray[CLBR_PROC_TYPE_RX_IQ_NLMS] =			(m_supportedClbrMask & CLBR_PROC_BIT_RX_IQ_NLMS)? RxIQ_Calibrate_NLMS:NULL;
    //Init the load results funcs pointers
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_LPF]                =   NULL;//(m_supportedClbrMask & CLBR_PROC_BIT_LPF)? LPF_LoadResults:NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_MS_REPLICA_TUNING]  =   NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_RSSI_PATH_CALIB]    =   (m_supportedClbrMask & CLBR_PROC_BIT_RSSI_PATH)? RssiPath_LoadResults:NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_BEAM_FORMING]       =   NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_RX_DC_OFFSET]       =   (m_supportedClbrMask & CLBR_PROC_BIT_RX_DC_OFFSET)? RxDcOffset_LoadResults:NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_RX_IQ_MISMATCH]     =   (m_supportedClbrMask & CLBR_PROC_BIT_RX_IQ_MISMATCH)? RxIQ_LoadResults:NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_TX_IQ_MISMATCH]     =   NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_TX_LO_LEAKAGE]      =   NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_RFIC_BIAS]          =   (m_supportedClbrMask & CLBR_PROC_BIT_RFIC_BIAS)? RficBias_LoadResults :NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_RSSI_DC_OFFSET]     =   (m_supportedClbrMask & CLBR_PROC_BIT_RSSI_DC_OFFSET)? RssiDcOffset_LoadResults:NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_MS_SSI_ADC]         =   (m_supportedClbrMask & CLBR_PROC_BIT_MS_SSI_ADC)? MsSsiAdc_LoadResults:NULL;
	m_clbrLoadFuncsArray[CLBR_PROC_TYPE_RX_IQ_NLMS]         =   (m_supportedClbrMask & CLBR_PROC_BIT_RX_IQ_NLMS)? RxIQ_NLMS_LoadResults:NULL;

	// Init the calibrations states
	initCalStates[CLBR_PROC_TYPE_LPF]				= CAL_STATE_SHOULD_SAVE;
	initCalStates[CLBR_PROC_TYPE_MS_REPLICA_TUNING] = CAL_STATE_SHOULD_SAVE;
	initCalStates[CLBR_PROC_TYPE_RSSI_PATH_CALIB]   = CAL_STATE_SHOULD_SAVE;
	initCalStates[CLBR_PROC_TYPE_RX_IQ_NLMS] 		= CAL_STATE_SHOULD_SAVE;
	initCalStates[CLBR_PROC_TYPE_BEAM_FORMING] 		= CAL_STATE_DONT_SAVE;
	initCalStates[CLBR_PROC_TYPE_RFIC_BIAS] 		= CAL_STATE_SHOULD_SAVE;
	initCalStates[CLBR_PROC_TYPE_RSSI_DC_OFFSET] 	= CAL_STATE_SHOULD_SAVE;
	initCalStates[CLBR_PROC_TYPE_MS_SSI_ADC] 		= CAL_STATE_SHOULD_SAVE;
	initCalStates[CLBR_PROC_TYPE_RX_DC_OFFSET] 		= CAL_STATE_SHOULD_SAVE;
	initCalStates[CLBR_PROC_TYPE_RX_IQ_MISMATCH]	= CAL_STATE_SHOULD_SAVE;//work around to force actual calibration after set channel
	initCalStates[CLBR_PROC_TYPE_TX_IQ_MISMATCH] 	= CAL_STATE_DONT_SAVE;
	initCalStates[CLBR_PROC_TYPE_TX_LO_LEAKAGE] 	= CAL_STATE_DONT_SAVE;
}
void preCal(void)
{
	PhyDrv_preCal();
	PhyDrv_ResetBB();
	PhyDrv_preCal();
}

void postCal(void)
{
	PhyDrv_postCal();
	PhyDrv_ReActivateBB();
}

////////////////////////
// Public Methods
////////////////////////
void ClbrHndlr_Init()
{
	ClbrHndlrStat_Init();
}

void ClbrHndlr_Reset(IN clbrHndlrResetConf_t* pConf)
{
	if (pConf != NULL)
	{
		setAvailProcs(pConf);
	}
}

ClbrType_e ClbrHndlr_GetClbrType(void)
{
	return (ClbrType_e)(m_pClbrData->calibrSMState);
}
uint32 ClbrHndlr_GetClbrBitmap(void)
{
	return (uint32)(m_pClbrData->calBitmap);
}

void ClbrHndlr_Calibrate(void)
{
	m_pClbrData = ClbrMngr_GetCalibDataPtr();
	if ((m_pClbrData->calBitmap != 0) || (m_pClbrData->loadCalBitmap!= 0))
	{
		preCal();
		// Calibrate
		runCalibration();
		postCal();
	}
}

void ClbrHndlr_GetCalibrationDataState(OUT CalDataState_e *calDataState)
{
    if (m_pClbrData != NULL)
    {
        *calDataState = (CalDataState_e)m_pClbrData->dataStoreState;
    }
    else
    {
        *calDataState = CAL_DATA_STATE_NONE;
    }
}

void ClbrHndlr_UpdateCalState(uint8 calIndex,bool calState)
{
	uint8 *pCalState;
	pCalState = &(ShramClbrDataBufferStoreChanData.stateArray[calIndex]);
	*pCalState |=(CAL_STATE_IS_CAL_MASK);
	if (((((*pCalState) & CAL_STATE_SHOULD_SAVE_MASK) >> CAL_STATE_SHOULD_SAVE_SHIFT) == CAL_STATE_SHOULD_SAVE) &&
		(calState == TRUE))
		// updating state array if calibration succeeded and should be stored
	{
		*pCalState |= (CAL_STATE_CAL_PASSED_MASK);
	}
}

void ClbrHndlr_initCalibrationsStates()
{
	uint8 i;
	//state array init
	for (i=0; i<CLBR_PROC_TYPE_NUM; i++)
	{
		ShramClbrDataBufferStoreChanData.stateArray[i] |= initCalStates[i];
	}	
}

void setNextOfflineCalibrationsBitmaps (CalibrSchedData_t* m_clbrSchedDataPtr, bool forceLoad)
{
    ClbrProcType_e proc;
	uint8 *pCalState;
	bool shouldSave, isPassed,isCalibrated;
	uint32 calBitmap = m_clbrSchedDataPtr->calBitmap;
	bool setLoadBit = FALSE;
	uint8 OfflineCalMode = OfflineCalModes[hdkGetChannelSwitchType()];
	dutDB_t * dutDb = Dut_getDB();

	m_clbrSchedDataPtr->loadCalBitmap = 0;
	m_clbrSchedDataPtr->calBitmap = 0;

	if (calBitmap != 0)
	{
		if(m_clbrSchedDataPtr->dataStoreState == CAL_DATA_STATE_LOAD) // data available only when dataStoreState == CAL_DATA_STATE_LOAD
		{
			ClbrHndlr_initCalibrationsStates();
		}
		do
	    {
			setLoadBit = FALSE;
			proc = GetNextProc(calBitmap);
	        calBitmap &= ~(1<<proc);
			
			if((m_clbrSchedDataPtr->dataStoreState == CAL_DATA_STATE_LOAD) && (OPERATION_MODE_DUT != dutDb->operationMode))
			{
				pCalState = &ShramClbrDataBufferStoreChanData.stateArray[proc];
				ASSERT(*pCalState <= (CAL_STATE_SHOULD_SAVE_MASK | CAL_STATE_CAL_PASSED_MASK | CAL_STATE_IS_CAL_MASK));

				shouldSave = (*pCalState & CAL_STATE_SHOULD_SAVE_MASK) >> CAL_STATE_SHOULD_SAVE_SHIFT;
				isPassed = (*pCalState & CAL_STATE_CAL_PASSED_MASK) >> CAL_STATE_CAL_PASSED_SHIFT;
				isCalibrated = (*pCalState & CAL_STATE_IS_CAL_MASK) >> CAL_STATE_IS_CAL_SHIFT;
				if(	(shouldSave == CAL_STATE_SHOULD_SAVE) && 
					((isPassed == CAL_STATE_PASSED)||((isCalibrated == CAL_STATE_CALIBRATED) && (OfflineCalMode == OFFLINE_CAL_MODE_SKIP))))
				{
					m_clbrSchedDataPtr->loadCalBitmap |= (1<<proc); //set calibrations to load bits
					setLoadBit = TRUE;

				}
				
			}
			//if force load  == TRUE we should ony load if data exist, without run calibration at aany case
			if (((setLoadBit == FALSE) && (forceLoad != TRUE) && (OfflineCalMode == OFFLINE_CAL_MODE_FULL)) || (OPERATION_MODE_DUT == dutDb->operationMode)) 
			{
				m_clbrSchedDataPtr->calBitmap |= (1<<proc); //set calibrations to calibrate bits
			}
	    }
	    while (calBitmap);
	}
}





