#include "CalibrationHandlerStatistics.h"
#include "stringLibApi.h"
#include "LpfClbrHndlr_API.h"
#include "TxIQMismatchClbrHndlr.h"
#include "RssiPathClbrHndlr.h"
#include "RxIQMismatchClbrHndlr.h"
#include "RficBiasClbrHndlr.h"
#include "RxDcOffsetClbrHndlr.h"
#include "MsSsiAdcClbrHndlr.h"
#include "RssiDcOffsetClbrHndlr.h"



/******************************************************/
/***		Global Variables			      		***/
/******************************************************/

offlineStatistics_t offlineStatistics = {0};
uint32* CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_NUM];

/*********************************************
	    Function       
**********************************************/

void ClbrHndlrStat_Init()
{
#ifndef ENET_INC_ARCH_WAVE600
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RX_DC_OFFSET]=RxDc_GetElement();			  //1-  RX_DC_OFFSET
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RSSI_PATH_CALIB]=RssiPath_GetElement();            //2-  RSSI
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_TX_LO_LEAKAGE]=NULL;					  //3-  TX_LO_LEAKAGE
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_TX_IQ_MISMATCH]=TxIQClbr_GetElement();		  //4-  TX_IQ_MISMATCH
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RX_IQ_MISMATCH]=RxIQ_GetElement();  //5-  RX_IQ_MISMATCH
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_LPF]= NULL;//LPF_GetElement();					  //6-  Lpf 
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_TPC]=NULL;								  //7-  TPC
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RSSI_DC_OFFSET]=RssiDcOffse_GetElement();	  //8-  RSSI_DC_OFFSET
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RX_IQ_NLMS]=NULL;					      //9-  RSSI_FILTER
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_MS_REPLICA_TUNING]=NULL;				  //10- MS_REPLICA_TUNING
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_MS_SSI_ADC]=MsSsiAdc_GetElement();            //11- MS_SSI_ADC
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_BEAM_FORMING]=NULL;						  //12- BEAM_FORMING
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RFIC_BIAS]=RficBias_GetElement();          //13- RFIC_BIAS
#else
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RX_DC_OFFSET]= NULL;			  //1-	RX_DC_OFFSET
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RSSI_PATH_CALIB]=NULL; 		   //2-  RSSI
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_TX_LO_LEAKAGE]=NULL;					  //3-	TX_LO_LEAKAGE
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_TX_IQ_MISMATCH]=NULL;	  //4-	TX_IQ_MISMATCH
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RX_IQ_MISMATCH]=NULL;	//5-  RX_IQ_MISMATCH
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_LPF]= NULL;//LPF_GetElement();					  //6-	Lpf 
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_TPC]=NULL;								  //7-	TPC
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RSSI_DC_OFFSET]=NULL;	  //8-	RSSI_DC_OFFSET
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RX_IQ_NLMS]=NULL;						  //9-	RSSI_FILTER
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_MS_REPLICA_TUNING]=NULL;				  //10- MS_REPLICA_TUNING
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_MS_SSI_ADC]=NULL;			  //11- MS_SSI_ADC
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_BEAM_FORMING]=NULL; 					  //12- BEAM_FORMING
	CalibrationHandlersStatisticsPointer[CLBR_PROC_TYPE_RFIC_BIAS]=NULL;		   //13- RFIC_BIAS
#endif

}





