#include "RegAccess_Api.h"
#include "stringLibApi.h"
#include "PhyDriver_API.h"
#include "RficDriver_API.h"
#include "PhyCalDriver_API.h"
#include "lm.h"
#include "CalibrationHandlerUtils.h"
#include "ErrorHandler_Api.h"
#include "mt_sysdefs.h"


#include "LmHdk_API.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_CALIBRATIONS
#define LOG_LOCAL_FID 1


ClbrProcType_e GetNextProc(uint32 x)
{
	uint32 index = 0;

	while(!(x & 1<<index))
	{
		DEBUG_ASSERT(index < CLBR_PROC_TYPE_NUM);
		index++;
	}

	return (ClbrProcType_e)index;
}

/********************************************************************************

FindTxEnabledAntenna

Description:
------------
    Find the next or previous enabled antenna.

Input:
-----
    inCurrentAntenna    - The current calibrated antenna. 
    inPreviousOrNext    - The search type required

Output:
-------
    outEnabledAntenna_p - 
********************************************************************************/
void FindTxEnabledAntenna(uint8 inCurrentAntenna,int8 inPreviousOrNext,uint8 *outEnabledAntenna_p)
{
    uint8 enabledAntenna,iterationNum;
	uint8 antMask, numOfAnts;
	
    HDK_GetMaxActiveAntennasNumAndMask(&numOfAnts, &antMask);
	enabledAntenna = inCurrentAntenna;
	
    for (iterationNum = 0; iterationNum < MAX_NUM_OF_ANTENNAS; iterationNum++)
    {
        enabledAntenna = (enabledAntenna  + inPreviousOrNext) % MAX_NUM_OF_ANTENNAS;        
		if(TX_ANTENNA_ENABLED(antMask,enabledAntenna)) 
			break;            
    }

    *outEnabledAntenna_p = enabledAntenna;

    return ;
}


