/********************************************************************
	created:	2011/02/24
	filename: 	CalibrationManager
	file ext:	h
	author:		Amir RIx
	
	purpose:	
*********************************************************************/
#ifndef __CalibrationManager_h__
#define __CalibrationManager_h__

#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "mhi_umi_propr.h"
#include "CalibrationDefs.h"
#include "HdkGlobalDefs.h"
#include "lmi.h"
#include "Shram_ClbrDataBuffer.h"
#include "HdkCdbManagerTask_api.h"
/************************************/
/*******	 Definitions   & Macros 	 *******/
#define INVALID_INDEX 						0xFF
#define FIRST_5GHZ_CHANNEL					36
#define NUM_OF_CHANNELS_IN_ALL_BANDS 		69
#define NUM_OF_SPARE_CHANNELS				3
#define CALIBR_HOST_BUFFER_SIZE            ((NUM_OF_CHANNELS_IN_ALL_BANDS+NUM_OF_SPARE_CHANNELS)* CHANNEL_CALIBRATION_DATA_SIZE )
#define IMR_RESOLUTION_BITS					(26)
#define I_Q_TRUNCATION_BITS					(12)



typedef struct CalibrSchedData
{
	CALIBR_ALGO_EVENT	errors;
	uint32				calBitmap; // What calibration process to run
	uint32				loadCalBitmap; // What calibration process to run
    uint8	            calibrSMState; // Online/offline mode
    uint8	            dataStoreState; // none/store/load;
	bool				isOnlineProcComplete; // flag for completion of online process - can move to next
} CalibrSchedData_t;

typedef struct ClbrMngr_TemperatureDB
{
	int32	antPreviousTemperature;
	int32	antCurrentTemperature;
	uint8   temperatureDeltaParam;
	bool 	toCalibrate;
}ClbrMngr_TemperatureDB_t;

typedef struct ClbrMngr_CalibrateDB
{
	uint8 chandWidth;
	uint8 numberOfChannels;
	uint8 channels[MAX_CALIB_CHANS];
	uint8 currentCalibratedChannelIndex;
	bool  forceOnlineCal;
	bool  moreFrags;
}ClbrMngr_CalibrateDB_t;


//************************************
// Method:    ClbrMngr_Init
// Purpose:   Initialization of the Calibration Manager module
// Parameter: bool isNeedLoad - are the calibration procedures code need to be loaded from the host
// Returns:   void
//************************************
void ClbrMngr_Init(bool isNeedLoad);
//************************************
// Method:    ClbrMngr_CalibrateParamsInit
// Purpose:   Initialization of the online calibrations scheduling params
// Returns:   void
//********************************
void ClbrMngr_CalibrateParamsInit(void);

//************************************
// Method:    ClbrMngr_TemperatureDbInit
// Purpose:   Initialization of the temperature sensor database
// Returns:   void
//********************************
void ClbrMngr_TemperatureDbInit(void);

//************************************
// Method:    ClbrMngr_Reset
// Purpose:	  Bringing down of the Calibration Manager module
// Returns:   void
//************************************
void ClbrMngr_Reset(clbrHndlrResetConf_t* pResetConf);

//************************************
// Method:    ClbrMngr_SetCalibProcMask
// Purpose:   Set the procedures assigned to the specified calibration type
// Parameter: IN ClbrType_e calibrationType - The calibration type to assign the procedures to (on-line, off-line)
// Parameter: IN uint32 mask - A bit mask representing the available calibration procedures in the system
// Returns:   void
//************************************
void ClbrMngr_SetCalibProcMask(IN ClbrType_e calibrationType, IN uint32 mask);
//************************************
// Method:    ClbrMngr_GetCalibProcMask
// Purpose:   Get the procedures assigned to the specified calibration type
// Parameter: IN ClbrType_e calibrationType - The calibration type to assign the procedures to (on-line, off-line)
// Returns:   uint32 mask - A bit mask representing the available calibration procedures in the system
//************************************
uint32 ClbrMngr_GetCalibProcMask( IN ClbrType_e calibrationType);
//************************************
// Method:    ClbrMngr_EnableDisableOnlineCal
// Purpose:   Set online calibration timer
// Returns:   void
//************************************
void ClbrMngr_EnableDisableOnlineCal(bool enableCalibration, bool runImmediatly);
//************************************
// Method:    ClbrMngr_onlineCalibTimerExpired
// Purpose:   called when online calibration timer expired
// Returns:   void
//************************************

//************************************
// Method:    ClbrMngr_RunOnlineCalibration
// Purpose:   Begin a new on-line calibration process. This method is exposed for debug/RF-tool purposes only!
// Returns:   void
//************************************
void ClbrMngr_RunOnlineCalibration(void);
//************************************
// Method:    ClbrMngr_RunOfflineCalibration
// Purpose:   Begin a new off-line calibration process.
// Returns:   void
//************************************
void ClbrMngr_RunOfflineCalibration(void);
void ClbrMngr_ResetStatus(void);

//************************************
// Method:    ClbrMngr_RunCalibrationOnDemend
// Purpose:   Calibrate upon user demand
// Returns:   void
//************************************
void ClbrMngr_RunCalibrationOnDemand(uint32 calibrateMask, K_MSG* reqesterMsgPtr);

//************************************
// Method:    ClbrMngr_RunCocCalibrations
// Purpose:   Calibrate upon CoC request
// Returns:   void
//************************************
void ClbrMngr_RunCocCalibrations(K_MSG* pCocMsg);

//************************************
// Method:    ClbrMngr_RunRadioStateChangeCalibration
// Purpose:   Calibrate upon set channel request
// Returns:   void
//************************************
void ClbrMngr_RunRadioStateChangeCalibration(bool isUp);


//************************************
// Method:    ClbrMngr_handleOfflineCalibDone
// Purpose:   
// Returns:   void
//************************************
void ClbrMngr_handleOfflineCalibDone(void);
//************************************
// Method:    ClbrMngr_handleOnlineCalibDone
// Purpose:   
// Returns:   void
//************************************
void ClbrMngr_handleOnlineCalibDone(void);

//************************************
// Method:    ClbrMngr_ChunkDmaCompleteHandler
// Purpose:   TBD
// Parameter: K_MSG * in_psMsg
// Returns:   void
//************************************
void ClbrMngr_HostDataChunkDmaCompleteCb(K_MSG *in_psMsg);
//************************************
// Method:    ClbrMngr_CalibrateCfm
// Purpose:   
// Parameter: K_MSG* pMsg
// Returns:   void
//************************************
void ClbrMngr_CalibrateChannelDone(void);


//************************************
// Method:    ClbrMngr_FinalizeOnlineCAlbrationProcess
// Purpose:   
// Parameter: uint32 status
// Returns:   void
//************************************
void ClbrMngr_FinalizeOnlineCalibrationProcess(K_MSG *psMsg);

//************************************
// Method:    ClbrMngr_HandleCalibrateProcessStart
// Purpose:   Start Calibrate Process
// Parameter: void
// Returns:   void
//************************************
void ClbrMngr_HandleCalibrateProcessStart(K_MSG *psMsg);
//************************************
// Method:    ClbrMngr_RunCalibrationOnFirstChannel
// Purpose:   Start Calibrate Process on all channels (init)
// Parameter: void
// Returns:   void
//************************************

void ClbrMngr_RunCalibrationOnFirstChannel(K_MSG *psMsg);
//************************************
// Method:    ClbrMngr_RunCalibrationOnNextChannel
// Purpose:   Start Calibrate Process on all channels (init)
// Parameter: void
// Returns:   void
//************************************

void ClbrMngr_RunCalibrationOnNextChannel(K_MSG *psMsg);

//************************************
// Method:    ClbrMngr_HandleCalibrateProcessEnd
// Purpose:   End Calibrate Process
// Parameter: void
// Returns:   void
//************************************
void ClbrMngr_HandleCalibrateProcessEnd(K_MSG *psMsg);

//************************************
// Method:    ClbrMngr_ResetOfflineProcs
// Purpose:   Enable the entire set of calibrations (for example, after ProgModel loading) for the next cycle only
// Parameter: void
// Returns:   void
//************************************
void ClbrMngr_ResetOfflineProcs(void);

//************************************
// Method:    ClbrMngr_WatchDogTimerExpired
// Purpose:   Discover that calibration sequence hasn't ended properly
// Parameter: K_MSG* 
// Returns:   void
//************************************
void ClbrMngr_WatchDogTimerExpired(K_MSG *pMsg);

/**********************    Event Handlers - Load & Store SM    *****************************/

void loadStoreTriggerLoadEventHandler(void);
void loadStoreDmaDoneEventHandler(void);
void loadStoreTriggerStoreEventHandler(void);

/**********************    State Handlers - Load & Store SM    *****************************/
void loadStoreTriggerLoadStateHandler(void);
void loadStoreDmaDoneStateHandler(void);
void loadStoreTriggerStoreStateHandler(void);
void loadStoreInvalidEvent(void);
void loadStoreIgnoreEvent(void);

/**********************    State Setter  *****************************/
void setLoadStoreSmState(LoadStoreState_e state);

void sendDualBandOfflineCalReq(HdkCdbManagerOfflineCalRequester_e requester, uint32 calBitmap, K_MSG* pRequesterMsg);
void sendMsgToHdkCdbOfflineCalSm(K_MSG_TYPE msgType);
CalibrSchedData_t* ClbrMngr_GetCalibDataPtr(void);
void hdkRunOnlineCalibrationReqEventHandler(K_MSG* pMsg);
void ClbrMngr_SetForceOnlineCal(bool runForceCal);
void ClbrMngr_RunErpCalibration(HdkCdbManagerOfflineCalRequester_e offlineCalReqester);

#if defined ENET_INC_UMAC
void ClbrMngr_PostInitDmaInit(void);
#endif
#endif // __CalibrationManager_h__
