#ifndef __HdkCdbManagerTask_api_h__
#define __HdkCdbManagerTask_api_h__

#include "OSAL_Api.h"
#include "mhi_umi.h"
#include "Hdk_Api.h"
#include "ConfigurationManager_api.h"
#include "CalibrationDefs.h"
#include "lmtimerUtility.h"


#define HDK_NUM_OF_BANDS 2

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define HDK_CDB_MAN_INVALID_MSG 0xFFFF
#define HDK_CDB_MAN_INVALID_TASK 0xFF

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

/*Main SM*/

typedef enum HdkRadarDetectionSerialTrace
{
	RADAR_SERIAL_TRACE_TIMER_EXPIRED,
	RADAR_SERIAL_TRACE_RADAR_FILTERED,
	RADAR_SERIAL_TRACE_RADAR_NOT_FILERED,
	RADAR_SERIAL_TRACE_TYPES_NUM
}HdkRadarDetectionSerialTrace_e;

typedef enum HdkChangeStateCbTask
{
	HDK_RADIO_ON,
	HDK_RADIO_OFF,
	HDK_CHANNEL_NOTIFICATION_DONE_SEND_CFM_TO_CSM,
	HDK_ADD_VAP,
	HDK_REMOVE_VAP,
	HDK_LAST
}HdkChangeStateCbTask_e;

typedef enum HdkCdbManagerMainSmBandState
{
	HDK_CDB_MAN_MAIN_SM_STATE_IDLE,
	HDK_CDB_MAN_MAIN_SM_STATE_INIT,
	HDK_CDB_MAN_MAIN_SM_STATE_READY,
	HDK_CDB_MAN_MAIN_SM_STATE_ACTIVE,
	HDK_CDB_MAN_MAIN_SM_STATE_DISABLE,
	HDK_CDB_MAN_NUM_OF_STATES	
}HdkCdbManagerMainSmBandState_e;

typedef struct HdkCdbManagerBandChangeStateMsg
{
	K_TASKID retTask;
	K_MSG_TYPE retMsg;
	BandId_e band;
	HdkState_e bandState;
	K_MSG* storedCbMsg;
	HdkChangeStateCbTask_e cbTask;
}HdkCdbManagerBandChangeStateMsg_t;

typedef struct HdkCdbManagerConfigBandReq
{
	K_TASKID retTask;
	K_MSG_TYPE retMsg;
	K_MSG* requesterKmsg;
	uint32 param;
}HdkCdbManagerConfigBandReq_t;

typedef struct HdkCdbManagerAddVapSmMsg
{
	K_MSG* pAddRemoveVapMsg;
	K_TASKID retTask;
	K_MSG_TYPE retMsg;
}HdkCdbManagerAddVapSmMsg_t;
typedef enum HdkCdbManagerOfflineCalRequester
{
	OFFLINE_CAL_SET_CHANNEL_REQUESTER,
	OFFLINE_CAL_COC_REQUESTER,
	OFFLINE_CAL_ON_DEMAND_REQUESTER,
	OFFLINE_CAL_RADIO_STATE_REQUESTER,
	OFFLINE_CAL_CALIBRATE_REQUESTER,
	OFFLINE_CAL_ERP_ADD_STA_IN_RF_OFF_EVENT_REQUESTER,
	OFFLINE_CAL_ERP_RF_OFF_TIMER_EVENT_REQUESTER,
	OFFLINE_CAL_ERP_BSS_TX_IN_RF_OFF_EVENT_REQUESTER,
	OFFLINE_CAL_ERP_DISABLE_IN_RF_OFF_EVENT_REQUESTER,
	OFFLINE_CAL_INVALID_REQUESTER
}HdkCdbManagerOfflineCalRequester_e;

typedef enum dualBandOfflineCalType
{
	DUAL_BAND_OFFLINE_CAL,
	SINGLE_BAND_OFFLINE_CAL
}dualBandOfflineCalType_e;
typedef struct HdkCdbManagerOfflineCalSmMsg
{
	BandId_e band;
	K_TASKID retTask;
	K_MSG_TYPE retMsg;
	dualBandOfflineCalType_e dualBandOfflineCalType;
	HdkCdbManagerOfflineCalRequester_e requester;
	K_MSG* requesterKmsgPtr;
}HdkCdbManagerOfflineCalSmMsg_t;
typedef struct HdkCdbManagerOnlineCalSmMsg
{
	BandId_e band;
	bool moreFrags;
	bool wasCalibrated;
	ClbrProcType_e nextCalibration;
	bool enableDisableCal;
	bool runImmediateOnlineCal;
	bool runForceCal;
	uint8 ctsDurMode;
	bool processAbortBeforeRun;
	K_TASKID retTask;
	K_MSG_TYPE retMsg;
}HdkCdbManagerOnlineCalSmMsg_t;
typedef enum HdkCdbManagerSyncServiceType
{
	SYNC_SERVICE_PROCESS_SCHEDULED,
	SYNC_SERVICE_CTS_SENT,
}HdkCdbManagerSyncServiceType_e;
typedef struct HdkCdbManagerSyncServiceMsg
{
	BandId_e band;
	HdkCdbManagerSyncServiceType_e servicType;
}HdkCdbManagerSyncServiceMsg_t;
typedef struct HdkCdbManagerArmOnlineTimerMsg
{
	BandId_e band;
	bool enableCalibration;
}HdkCdbManagerEnDisOnlineCal_t;
typedef struct dmaParams
{

	uint32 source;
	uint32 destination;
	uint16 length;
	uint8 direction;
}dmaParams_t;

typedef struct HdkCdbManagerActivateDmaMsg
{
	BandId_e band;
	dmaParams_t	dmaParams;
}HdkCdbManagerActivateDmaMsg_t;
typedef struct HdkCdbManCalibrationErrorMsgToHost
{
	BandId_e band;
	uint32 calibrAlgoType;
	uint32 errCode;
	uint32 eventId;
	uint32 timeStamp;
}HdkCdbManCalibrationErrorMsgToHost_t;
typedef struct PsdProgmodelShramAddressIndMsg
{
	uint32* psdProgmodelSramAdd;
}PsdProgmodelShramAddressIndMsg_t;
typedef struct RadarSerialTraceMsg
{
	uint32 val1;
	uint32 val2;
	uint32 val3;
	HdkRadarDetectionSerialTrace_e serialTraceType;
	
}RadarSerialTraceMsg_t;
typedef struct radarSerialTraceEnable
{
	bool enableserialTrace;
}radarSerialTraceEnable_t;
typedef enum HdkCdbManConfigSmStages
{
	CONFIG_SM_STAGE_0,
	CONFIG_SM_STAGE_1,
	CONFIG_SM_STAGE_2,
	CONFIG_SM_NUM_OF_STAGES
}HdkCdbManConfigSmStages_e;

typedef struct HdkCdbManagerStageParams
{
	K_MSG_TYPE message;
	K_TASKID task;
	bool isDualBandMessgae;
	BandId_e band;
	
}HdkCdbManagerStageParams_t;
typedef struct HdkCdbManagerConfigMsg
 {
	 K_MSG_TYPE cbMessage;
	 K_TASKID cbTask;
	 uint8 cbVapId;
	 HdkCdbManagerStageParams_t stageDb[CONFIG_SM_NUM_OF_STAGES];
	 uint8 numberOfStages;
	 uint8 configureVapId;
	 K_MSG* hostMsgAddress;
	 uint32 param;
 } HdkCdbManagerConfigMsg_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

extern void HdkCdbManager_TaskEntry(K_MSG *HdkCdbManagerMsg);
#if defined ENET_INC_UMAC
void HdkCdbManager_PostInitDmaInit(void);
#endif
void  isr_HdkCdbManOnlineTimerExpired(uint32 param);
void HdkCdbManager_Init(void);
#endif // __HdkCdbManagerTask_api_h__

