#ifndef __HdkCdbManagerTask_h__
#define __HdkCdbManagerTask_h__

#include "OSAL_Api.h"
#include "mhi_umi.h"
#include "Hdk_Api.h"
#include "HdkCdbManager_AddVapSm.h"
#include "HdkCdbManager_ConfigSm.h"
#include "HdkCdbManager_MainSm.h"
#include "HdkCdbManager_OfflineCalSm.h"
#include "HdkCdbManager_OnlineCalSm.h"
#include "HdkCdbManager_AntConfigSm.h"
#include "BSSmanager_API.h"
#include "ErrorHandler_Api.h"
#include "ConfigurationManager_api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#if (defined ENET_INC_ARCH_WAVE600 && defined DEBUG_LOGGER_ENABLE)
#define HDK_CDB_DEBUG_LOGGER
#endif
#define TWO_BANDS_ACTIVE_MASK 0x3
#define INVALID_SM_EVENT 0xFF
#define DONT_CARE 0
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

#define CDB_MAN_SET_BIT_IN_BYTE(bit, byte) (byte|=(1<<bit))
#define CDB_IS_BIT_SET_IN_BYTE(bit, byte) (((byte >>bit)&0x1))
#define CDB_MAN_CLR_BIT_IN_BYTE(bit,byte) (byte &= (~(1<<bit)))
#define CDB_MODIFY_BITS_IN_BITMAP(bitmap,mask,shift,val) (bitmap = ((bitmap & (~(mask<<shift)))|(val<<shift)))
#define GET_OTHER_BAND(band) (band==CONFIGURATION_MANAGER_BAND_0 ? CONFIGURATION_MANAGER_BAND_1 : CONFIGURATION_MANAGER_BAND_0)

#define CDB_MAN_MASK_ONE_BIT 0x1

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct HdkCdbManagerDbStruct
{
	CdbManagerMainSmDb_t mainSmDb;
	CdbManagerAddVapSmDb_t addVapSm;
	CdbManagerConfigSmDb_t configSmDb;
	CdbManagerOfflineSmDb_t offlineCalSmDb;
	CdbManagerOnlineCalDb_t onlineCalSmDb;
	CdbManagerConfigAntsSmDb_t configAntsSmDb;
}HdkCdbManagerDbStruct_t;

typedef enum HdkCdbManSmType
{
	HDK_CDB_MAN_CONFIG_SM,
	HDK_CDB_MAN_ADD_VAP_SM, 
	HDK_CDB_MAN_ONLINE_CAL_SM,
	HDK_CDB_MAN_OFFLINE_CAL_SM,
	HDK_CDB_MAN_ANT_CONFIG_SM,
	NUM_OF_STATE_MACHINES
}HdkCdbManSmType_e;
typedef enum HdkCdbManagerSmEventType
{
	HDK_CDB_MAN_SINGLE_BAND_EVENT,
	HDK_CDB_MAN_DUAL_BAND_EVENT,
	HDK_CDB_MAN_INVALID_EVENT
}HdkCdbManagerSmEventType_e;

typedef struct HdkCdbManagerEventTypeTable
{
	HdkCdbManagerSmEventType_e HdkCdbManagerEventModeTable[HDK_CDB_MAN_NUM_OF_STATES][HDK_CDB_MAN_NUM_OF_STATES];
}HdkCdbManagerEventTypeTable_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void CdbManagerHandleReceivedMsgFromBand(uint8* pWaitForBandRspBitmap, BandId_e band);
void HdkCdbManager_onlineCalSmInit(void);
void HdkCdbManInit(void);
void hdkCdbManagerGetMainState(BandId_e currentBand, HdkCdbManSmType_e smType,HdkCdbManagerMainSmBandState_e* currentBandstate_p, HdkCdbManagerMainSmBandState_e* otherBandstate_p);
void sendEventToSm(K_MSG* pMsg, HdkCdbManSmType_e smFunction, uint8 singleBandEvent, uint8 dualBandEvent);

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

extern HdkCdbManagerDbStruct_t HdkCdbManagerDb;
extern uint8 hdkVapManagerAddVapId;
extern uint8 hdkVapManagerRemoveVapId;
extern HdkCdbManagerEventTypeTable_t HdkCdbManagerOnlineCalEventModeTable;
extern HdkCdbManagerEventTypeTable_t HdkCdbManagerOfflineCalEventModeTable;
extern HdkCdbManagerEventTypeTable_t HdkCdbManagerConfigSmEventModeTable;
extern HdkCdbManagerEventTypeTable_t HdkCdbManagerAddVapEventModeTable;
extern HdkCdbManagerEventTypeTable_t HdkCdbManagerAntConfigSmEventModeTable;

#endif // __HdkCdbManagerTask_h__

