/***********************************************************************************
 File:			Hdk_Api.h
 Module:		
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef __HdkCdbManager_AddVapSm_h__
#define __HdkCdbManager_AddVapSm_h__
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "CalibrationsDefines.h"
#include "mhi_umi.h"
#include "ConfigurationManager_api.h"
#include "HdkCdbManagerTask_api.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
 /*Add vap SM states*/
 typedef enum HdkCdbManagerAddVapSmStates
 {
	 ADD_VAP_SM_STATE_INIT,
	 ADD_VAP_SM_STATE_COMMON_CONFIG_IN_PROCESS,
	 ADD_VAP_SM_STATE_WAIT_FOR_ADD_VAP,
	 ADD_VAP_SM_STATE_ADDING_FIRST_VAP_IN_BAND,
	 ADD_VAP_SM_STATE_ADD_FIRST_VAP_IN_FIRST_BAND_DONE,
	 ADD_VAP_SM_STATE_ADD_FIRST_VAP_DONE,
	 ADD_VAP_SM_STATE_LAST
 }HdkCdbManagerAddVapSmStates_e;
 
 /*Add vap SM events*/
 typedef enum HdkCdbManagerAddVapSmEvents
 {
	 ADD_VAP_SM_EVENT_ADD_VAP,
	 ADD_VAP_SM_EVENT_COMMON_CONFIG_DONE,
	 ADD_VAP_SM_EVENT_BAND_CONFIG_DONE,
	 ADD_VAP_SM_EVENT_BAND_CONFIG_DONE_SINGLE_BAND,
	 ADD_VAP_SM_EVENT_REMOVE_VAP,
	 ADD_VAP_SM_EVENT_REMOVE_NON_LAST_VAP_BAND_CFM,	 
	 ADD_VAP_SM_EVENT_REMOVE_VAP_BAND_CFM,
	 ADD_VAP_SM_EVENT_REMOVE_VAP_BAND_CFM_SINGLE_BAND
 }HdkCdbManagerAddVapSmEvents_e;

typedef struct CdbManagerAddVapSmDb
{
	HdkCdbManagerAddVapSmStates_e state;
	uint8 waitForBandRspBitmap;
	uint8 bandInProecessBitmap;
	uint8 vapAddedCounter[HDK_NUM_OF_BANDS];
	uint8 vapPostActivationCounter[HDK_NUM_OF_BANDS];
	K_MSG* pAddVapMsgStored[HDK_NUM_OF_BANDS];
 
}CdbManagerAddVapSmDb_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//--------------------------------------------------------------------------------

void HdkCdbManager_SmHandlerAddVapReq(K_MSG* pMsg);
void HdkCdbManager_SmHandlerRemoveVapReq(K_MSG* pMsg);
void HdkCdbManager_SmHandlerRemoveNonLastVapReq(K_MSG* pMsg);
void HdkCdbManager_SmHandlerCommonConfigDone(K_MSG* pMsg);
void HdkCdbManager_SmHandlerAddVapBandConfigCfm(K_MSG* pMsg);
void HdkCdbManager_SmHandlerRemoveVapBandCfm(K_MSG* pMsg);
void hdkCdbManAddVapSmSendMsgToBand(K_MSG* pAddVapRemoveMsg,BandId_e band, K_MSG_TYPE reqMsgType,K_MSG_TYPE retMsg);
void HdkCdbManager_AddVapSm(uint8 eventGeneralType, K_MSG* pMsg);



#endif //__HdkCdbManager_AddVapSm_h__
